/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v11g;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.PartitionPropertyTabOraclev10g;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class PartitionPropertyTabOraclev11g
extends PartitionPropertyTabOraclev10g {
    private JComboBox cbSubpartType;
    private JComboBox cbRefConstraint;
    private JIntegerField ifSystemPartitions;
    private JPanel intervalPanel;
    private int intervalTabIndex;
    private JTextArea taInterval;
    private JScrollPane spInterval;
    private JList allIntervalTSList;
    private JList selectedIntervalTSList;
    private DefaultListModel allIntervalTSModel;
    private DefaultListModel selectedIntervalTSModel;
    private JButton bnAddIntervalTS;
    private JButton bnRemoveIntervalTS;

    public PartitionPropertyTabOraclev11g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject, AbstractOraclePropertyDialog abstractOraclePropertyDialog) {
        super(applicationView, storageDesign, storageObject, abstractOraclePropertyDialog);
    }

    @Override
    protected String[] getPartitionTypes() {
        return PartitionListOraclev11g.getPartitionTypes();
    }

    @Override
    protected void initGeneralPartitioning() {
        this.initPartType();
        this.initSubpartType(50);
        this.initUseSubpartitionsStorageTemplate(80);
        this.initRefConstraint(110);
        this.initSystemPartitions(140);
        if (this.useColumnProxies) {
            this.initAllColumnsList(174, 320);
            this.initSelectedColumnsList(174, 320);
            this.initButtons();
        } else {
            this.initColumnsTextArea(170, 325);
        }
    }

    protected void initSubpartType(int n) {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.SubpartitionType"));
        this.pnPartGeneral.add(jLabel);
        this.cbSubpartType = new JComboBox<String>(PartitionListOraclev11g.getSubpartitionTypes());
        this.setBG(this.cbSubpartType);
        this.cbSubpartType.setPreferredSize(this.cbPartType.getPreferredSize());
        this.cbSubpartType.addActionListener(new SubpartitionTypeListener());
        this.pnPartGeneral.add(this.cbSubpartType);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, n);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbSubpartType, n);
    }

    private void initRefConstraint(int n) {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.ReferenceConstraint"));
        this.pnPartGeneral.add(jLabel);
        Vector<FKProxyOracle> vector = new Vector<FKProxyOracle>();
        vector.add(null);
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            Iterator iterator = ((TableProxyOracle)this.ownerStorageObject).getFKeys().iterator();
            while (iterator.hasNext()) {
                FKProxyOracle fKProxyOracle = (FKProxyOracle)iterator.next();
                if (fKProxyOracle.getFKTable() == ((TableProxyOracle)this.ownerStorageObject).getObject()) continue;
                vector.add(fKProxyOracle);
            }
        }
        this.cbRefConstraint = new JComboBox(vector);
        this.setBG(this.cbRefConstraint);
        this.cbRefConstraint.setPreferredSize(this.cbPartType.getPreferredSize());
        this.pnPartGeneral.add(this.cbRefConstraint);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, n);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbRefConstraint, n);
    }

    private void initSystemPartitions(int n) {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.SystemPartitions"));
        this.pnPartGeneral.add(jLabel);
        this.ifSystemPartitions = new JIntegerField();
        this.ifSystemPartitions.setPreferredSize(this.cbPartType.getPreferredSize());
        this.pnPartGeneral.add(this.ifSystemPartitions);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, n);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifSystemPartitions, n);
    }

    @Override
    protected void addIntervalTab() {
        this.intervalPanel = new JPanel(new SpringLayout());
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev11g.RangeIntervalClause"), this.intervalPanel);
        this.intervalTabIndex = this.tpPartitions.indexOfComponent(this.intervalPanel);
        this.initIntervalExpression();
        this.initAllIntervalTSList();
        this.initSelectedIntervalTSList();
        this.initIntervalTSButtons();
    }

    protected SpringLayout getIntervalLayout() {
        return (SpringLayout)this.intervalPanel.getLayout();
    }

    private void initIntervalExpression() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.IntervalExpression"));
        this.intervalPanel.add(jLabel);
        this.setLabelConstraints(this.getIntervalLayout(), jLabel, 10, 15);
        this.taInterval = new JTextArea();
        this.spInterval = new JScrollPane(this.taInterval);
        this.spInterval.setPreferredSize(new Dimension(395, 200));
        this.spInterval.setBorder(BorderFactory.createEtchedBorder(0));
        this.taInterval.setLineWrap(true);
        this.intervalPanel.add(this.spInterval);
        this.setObjectConstraints(this.getIntervalLayout(), this.spInterval, 10, 35);
    }

    private void initAllIntervalTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllTableSpaces"));
        this.intervalPanel.add(jLabel);
        this.allIntervalTSModel = new DefaultListModel();
        this.allIntervalTSList = new JList(this.allIntervalTSModel);
        ListSelectionModel listSelectionModel = this.allIntervalTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIntervalTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allIntervalTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 230));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.intervalPanel.add(jScrollPane);
        this.setLabelConstraints(this.getIntervalLayout(), jLabel, 8, 264);
        this.setObjectConstraints(this.getIntervalLayout(), jScrollPane, 6, 282);
    }

    private void initSelectedIntervalTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.IntervalTableSpaces"));
        this.intervalPanel.add(jLabel);
        this.selectedIntervalTSModel = new DefaultListModel();
        this.selectedIntervalTSList = new JList(this.selectedIntervalTSModel);
        ListSelectionModel listSelectionModel = this.selectedIntervalTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIntervalTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedIntervalTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 230));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.intervalPanel.add(jScrollPane);
        this.setLabelConstraints(this.getIntervalLayout(), jLabel, 292, 264);
        this.setObjectConstraints(this.getIntervalLayout(), jScrollPane, 290, 282);
    }

    private void initIntervalTSButtons() {
        this.bnAddIntervalTS = new JButton(ADD_CAPTION);
        this.bnAddIntervalTS.addActionListener(new AddIntervalTSActionListener());
        this.bnAddIntervalTS.setEnabled(false);
        this.intervalPanel.add(this.bnAddIntervalTS);
        this.setObjectConstraints(this.getIntervalLayout(), this.bnAddIntervalTS, 175, 370);
        this.bnRemoveIntervalTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveIntervalTS.setEnabled(false);
        this.bnRemoveIntervalTS.addActionListener(new RemoveIntervalTSActionListener());
        this.intervalPanel.add(this.bnRemoveIntervalTS);
        this.setObjectConstraints(this.getIntervalLayout(), this.bnRemoveIntervalTS, 175, 400);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddIntervalTS, this.bnRemoveIntervalTS);
    }

    @Override
    protected void initProperties() {
        PartitionListOraclev11g partitionListOraclev11g = (PartitionListOraclev11g)this.partList;
        if (partitionListOraclev11g != null) {
            this.cbSubpartType.setSelectedItem(partitionListOraclev11g.getSubpartitionType());
            this.cbRefConstraint.setSelectedItem(partitionListOraclev11g.getRefConstraint());
            this.ifSystemPartitions.setValue((long)partitionListOraclev11g.getSystemPartitions());
            this.taInterval.setText(partitionListOraclev11g.getIntervalExpression());
        } else {
            this.cbRefConstraint.setSelectedItem(null);
            this.ifSystemPartitions.setValue(1L);
        }
        super.initProperties();
    }

    @Override
    protected void reinitPartitioning(boolean bl) {
        super.reinitPartitioning(bl);
        this.allIntervalTSModel.clear();
        this.selectedIntervalTSModel.clear();
        if (bl) {
            this.initIntervalTablespaces((PartitionListOraclev11g)this.partList);
        }
    }

    private void initIntervalTablespaces(PartitionListOraclev11g partitionListOraclev11g) {
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (partitionListOraclev11g != null && partitionListOraclev11g.getIntervalTablespaceSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedIntervalTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allIntervalTSModel.addElement(tableSpaceOracle);
        }
    }

    @Override
    protected void enableRelevantPartitionFields(boolean bl) {
        super.enableRelevantPartitionFields(bl);
        String string = "";
        if (bl) {
            string = (String)this.cbPartType.getSelectedItem();
        }
        this.cbSubpartType.setEnabled(string.equals("RANGE") || string.equals("LIST"));
        this.cbRefConstraint.setEnabled(string.equals("REFERENCE"));
        this.ifSystemPartitions.setEnabled(string.equals("SYSTEM"));
        if (this.intervalTabIndex > -1) {
            this.tpPartitions.setEnabledAt(this.intervalTabIndex, string.equals("RANGE"));
        }
    }

    @Override
    protected boolean isSubpartitioned(String string) {
        return !this.cbSubpartType.getSelectedItem().equals("") && (string.equals("RANGE") || string.equals("LIST"));
    }

    @Override
    protected boolean isHashSubpartitioned(String string) {
        return this.cbSubpartType.getSelectedItem().equals("HASH") && (string.equals("RANGE") || string.equals("LIST"));
    }

    @Override
    protected boolean isListSubpartitioned(String string) {
        return this.cbSubpartType.getSelectedItem().equals("LIST");
    }

    @Override
    protected void setProperties(boolean bl) {
        if (bl) {
            if (this.partList == null) {
                this.partList = (PartitionListOraclev11g)this.getStorageDesign().getPartitionListSet().createPartitionList();
            }
            PartitionListOraclev11g partitionListOraclev11g = (PartitionListOraclev11g)this.partList;
            String string = (String)this.cbPartType.getSelectedItem();
            String string2 = "";
            FKProxyOracle fKProxyOracle = null;
            int n = 1;
            String string3 = "";
            partitionListOraclev11g.getIntervalTablespaceSet().clear();
            if (string.equals("RANGE")) {
                string3 = this.taInterval.getText();
                Object[] objectArray = this.selectedIntervalTSModel.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (!(object instanceof TableSpaceOracle)) continue;
                    partitionListOraclev11g.setIntervalTablespaceSet(((TableSpaceOracle)object).getObjectID());
                }
                string2 = (String)this.cbSubpartType.getSelectedItem();
            } else if (string.equals("LIST")) {
                string2 = (String)this.cbSubpartType.getSelectedItem();
            } else if (string.equals("REFERENCE")) {
                fKProxyOracle = (FKProxyOracle)this.cbRefConstraint.getSelectedItem();
            } else if (string.equals("SYSTEM")) {
                n = this.ifSystemPartitions.getIntValue();
            }
            partitionListOraclev11g.setSubpartitionType(string2);
            partitionListOraclev11g.setRefConstraint(fKProxyOracle);
            partitionListOraclev11g.setSystemPartitions(n);
            partitionListOraclev11g.setIntervalExpression(string3);
        }
        super.setProperties(bl);
    }

    private class RemoveIntervalTSActionListener
    implements ActionListener {
        private RemoveIntervalTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev11g.this.selectedIntervalTSModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev11g.this.selectedIntervalTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev11g.this.allIntervalTSModel.contains(object)) continue;
                    PartitionPropertyTabOraclev11g.this.allIntervalTSModel.addElement(object);
                    PartitionPropertyTabOraclev11g.this.selectedIntervalTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddIntervalTSActionListener
    implements ActionListener {
        private AddIntervalTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev11g.this.allIntervalTSModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev11g.this.allIntervalTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev11g.this.selectedIntervalTSModel.contains(object)) continue;
                    PartitionPropertyTabOraclev11g.this.selectedIntervalTSModel.addElement(object);
                    PartitionPropertyTabOraclev11g.this.allIntervalTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedIntervalTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIntervalTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev11g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev11g.this.selectedIntervalTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev11g.this.bnRemoveIntervalTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev11g.this.bnRemoveIntervalTS.setEnabled(true);
                }
            }
        }
    }

    private class AllIntervalTSListSelectionHandler
    implements ListSelectionListener {
        private AllIntervalTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev11g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev11g.this.allIntervalTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev11g.this.bnAddIntervalTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev11g.this.bnAddIntervalTS.setEnabled(true);
                }
            }
        }
    }

    public class SubpartitionTypeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PartitionPropertyTabOraclev11g.this.useColumnProxies) {
                PartitionPropertyTabOraclev11g.this.allSubPartColumnsList.getSelectionModel().clearSelection();
                String string = (String)PartitionPropertyTabOraclev11g.this.cbPartType.getSelectedItem();
                if (PartitionPropertyTabOraclev11g.this.isListSubpartitioned(string) && PartitionPropertyTabOraclev11g.this.selectedSubPartColumnsModel.toArray().length > 1) {
                    PartitionPropertyTabOraclev11g.this.allSubPartColumnsModel.clear();
                    PartitionPropertyTabOraclev11g.this.selectedSubPartColumnsModel.clear();
                    PartitionPropertyTabOraclev11g.this.initSubPartColumns(PartitionPropertyTabOraclev11g.this.partList);
                }
            }
            PartitionPropertyTabOraclev11g.this.enableRelevantPartitionFields(PartitionPropertyTabOraclev11g.this.isPartitioned());
        }
    }
}

