/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.PartitionPropertyTabOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.TablePropertyDialogOraclev11g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    protected TableProxyOraclev10g table;
    protected PartitionPropertyTabOraclev10g partitionPropertyTab;
    private static final String YES_PRESERVE = Messages.getString("TablePropertyDialogOracle.YES_PRESERVE_ROWS");
    private static final String YES_DELETE = Messages.getString("TablePropertyDialogOracle.YES_DELETE_ROWS");
    private static final String[] NO_PRESERVE_DELETE = new String[]{NO, YES_PRESERVE, YES_DELETE};
    private JComboBox cbUser;
    private JComboBox cbTemporary;
    private JComboBox cbTableSpace;
    private JComboBox cbOrganization;
    private JComboBox cbCluster;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JComboBox cbCache;
    private JComboBox cbParallel;
    private JTextField tfDegree;
    private JComboBox cbRowDependency;
    private JComboBox cbPartitioned;
    private JComboBox cbPartRowMovement;
    private JComboBox cbDataSegmentCompression;
    private JIntegerField ifIotCompress;
    private JIntegerField ifIotPctThreshold;
    private JComboBox cbIotIncluding;
    private JComboBox cbIotOverflowSegment;
    private JComboBox cbIotMappingTable;
    private JPanel iotProperties;
    private JPanel supplementalLog;
    private JPanel partitioningTab;
    private JComboBox cbSnapshot;
    private JTextField tfSupplementalLogGroupName;
    private JComboBox cbSupplementalLogCondition;
    private JList allSupplementalColumnsList;
    private JList selectedSupplementalColumnsList;
    private DefaultListModel allSupplementalColumnsModel;
    private DefaultListModel selectedSupplementalColumnsModel;
    private JButton bnSupplementalAdd;
    private JButton bnSupplementalRemove;
    private JPanel clusterColumns;
    private JList allClusterColumnsList;
    private JList selectedClusterColumnsList;
    private DefaultListModel allClusterColumnsModel;
    private DefaultListModel selectedClusterColumnsModel;
    private JButton bnAddClusterColumn;
    private JButton bnRemoveClusterColumn;
    private String comment;
    private String commentInRDBMS;
    private JTextField tfBasedOnStructuredType;
    private JPanel oidProperties;
    private JTextField tfOidIndexName;
    private JComboBox cbOidIndexSegment;
    private JTextField tfOidType;
    protected JPanel xmlTypeProperties;
    protected JTextField tfXmlSchemaUrl;
    private JTextField tfXmlSchemaElement;
    private JComboBox cbStoreAs;
    protected JComboBox cbAllowAnySchema;
    protected JComboBox cbAllowNonSchema;
    protected JComboBox cbLobStorageType;
    private JTextField tfLobSegmentName;
    private JComboBox cbXmlTypeTableSpace;
    private JComboBox cbStorageInRow;
    private JComboBox cbXmlTypeLogging;
    private JComboBox cbXmlTypeCache;
    private JIntegerField ifChunk;
    private JComboBox cbOldVersions;
    private JIntegerField ifPctVersion;
    private JIntegerField ifFreePools;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public TablePropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.table = (TableProxyOraclev10g)storageObject;
        this.setHeight(620);
        this.initCommentsView(260);
        this.initCommentsInRDBMS(265);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogOracle.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.setObjectConstraints(this.tfName, 20);
        this.initUser();
        this.initTemporary();
        this.initTableSpace();
        this.initOrganization();
        this.initCluster();
        this.initLogging();
        this.initSegment();
        this.initCache();
        this.initParallel();
        this.initDegree();
        this.initRowDependency();
        this.initPartitioned();
        this.initPartRowMovement();
        this.initDataSegmentCompression();
        this.initSnapshot();
        this.initBasedOnStructuredType();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.User"));
        this.general.add(jLabel);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initTemporary() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Temporary"));
        this.general.add(jLabel);
        this.cbTemporary = new JComboBox<String>(NO_PRESERVE_DELETE);
        this.setBG(this.cbTemporary);
        this.cbTemporary.addActionListener(new TemporaryListener());
        this.cbTemporary.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTemporary);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTemporary, 80);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initOrganization() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Organization"));
        this.general.add(jLabel);
        this.cbOrganization = new JComboBox<String>(TableProxyOracle.getOrganizationChoices());
        this.setBG(this.cbOrganization);
        this.cbOrganization.setPreferredSize(this.tfName.getPreferredSize());
        this.cbOrganization.addActionListener(new OrganizationListener());
        this.general.add(this.cbOrganization);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbOrganization, 140);
    }

    private void initCluster() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Cluster"));
        this.general.add(jLabel);
        this.cbCluster = new JComboBox();
        this.setBG(this.cbCluster);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getClusterSet().toArray(), this.cbCluster);
        }
        this.cbCluster.addActionListener(new ClusterListener());
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbLogging, 200);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbSegment, 230);
    }

    private void initCache() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.general.add(jLabel);
        this.cbCache = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbCache, 260);
    }

    private void initParallel() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Parallel"));
        this.general.add(jLabel);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.addActionListener(new ParallelListener());
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbParallel, 290);
    }

    private void initDegree() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Degree"));
        this.general.add(jLabel);
        this.tfDegree = new JTextField();
        this.tfDegree.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfDegree);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.tfDegree, 320);
    }

    private void initRowDependency() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.RowDependency"));
        this.general.add(jLabel);
        this.cbRowDependency = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRowDependency);
        this.cbRowDependency.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRowDependency);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbRowDependency, 350);
    }

    private void initPartitioned() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Partitioned"));
        this.general.add(jLabel);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitioned.addActionListener(new PartitionedAction());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbPartitioned, 380);
    }

    private void initPartRowMovement() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.RowMovement"));
        this.general.add(jLabel);
        this.cbPartRowMovement = new JComboBox<String>(TableProxyOracle.getParttitionedRowMovementChoices());
        this.setBG(this.cbPartRowMovement);
        this.cbPartRowMovement.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartRowMovement);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbPartRowMovement, 410);
    }

    private void initDataSegmentCompression() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.DataCompression"));
        this.general.add(jLabel);
        this.cbDataSegmentCompression = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDataSegmentCompression);
        this.cbDataSegmentCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataSegmentCompression);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbDataSegmentCompression, 440);
    }

    private List getSnapshots() {
        ArrayList<SnapshotOracle> arrayList = new ArrayList<SnapshotOracle>();
        Iterator iterator = this.getStorageDesign().getSnapshotSet().iterator();
        while (iterator.hasNext()) {
            SnapshotOracle snapshotOracle = (SnapshotOracle)iterator.next();
            if (snapshotOracle.getImplementedTable() != null && snapshotOracle.getImplementedTable() != this.getStorageObject()) continue;
            arrayList.add(snapshotOracle);
        }
        return arrayList;
    }

    private void initBasedOnStructuredType() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.StructuredType"));
        this.general.add(jLabel);
        this.tfBasedOnStructuredType = new JTextField();
        this.setBG(this.tfBasedOnStructuredType);
        this.tfBasedOnStructuredType.setEnabled(false);
        this.tfBasedOnStructuredType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfBasedOnStructuredType);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.tfBasedOnStructuredType, 470);
    }

    private void initSnapshot() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.ImplementAsSnapshot"));
        this.general.add(jLabel);
        this.cbSnapshot = new JComboBox();
        this.cbSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TablePropertyDialogOraclev10g.this.snapshotChanged();
            }
        });
        this.setBG(this.cbSnapshot);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getSnapshots().toArray(), this.cbSnapshot);
        }
        this.cbSnapshot.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSnapshot);
        this.setLabelConstraints(jLabel, 500);
        this.setObjectConstraints(this.cbSnapshot, 500);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("TablePropertyDialogOracle.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(TablePropertyDialogOraclev10g.this.getStorageDesign().getTableProxySet().getElements());
                arrayList.remove(TablePropertyDialogOraclev10g.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogOraclev10g.this.getAppView(), TablePropertyDialogOraclev10g.this.table, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 540);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 265, 540);
    }

    protected SpringLayout getIOTPropertiesLayout() {
        return (SpringLayout)this.iotProperties.getLayout();
    }

    protected SpringLayout getSupplementalLogLayout() {
        return (SpringLayout)this.supplementalLog.getLayout();
    }

    private void initIOTCompress() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTCompress"));
        this.iotProperties.add(jLabel);
        this.ifIotCompress = new JIntegerField(0, 26);
        this.iotProperties.add(this.ifIotCompress);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 20);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotCompress, 20);
    }

    private void initIOTPCTThershold() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTPCTThreshold"));
        this.iotProperties.add(jLabel);
        this.ifIotPctThreshold = new JIntegerField(0, 26);
        this.iotProperties.add(this.ifIotPctThreshold);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 50);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotPctThreshold, 50);
    }

    private void initIOTIncluding() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTIncluding"));
        this.iotProperties.add(jLabel);
        this.cbIotIncluding = new JComboBox();
        this.setBG(this.cbIotIncluding);
        this.cbIotIncluding.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotIncluding);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 80);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotIncluding, 80);
    }

    private void initIOTOverflowSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowSegment"));
        this.iotProperties.add(jLabel);
        this.cbIotOverflowSegment = new JComboBox();
        this.setBG(this.cbIotOverflowSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIotOverflowSegment);
        }
        this.cbIotOverflowSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowSegment);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 110);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowSegment, 110);
    }

    private void initIOTMappingTable() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.MappingTable"));
        this.iotProperties.add(jLabel);
        this.cbIotMappingTable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIotMappingTable);
        this.cbIotMappingTable.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotMappingTable);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), jLabel, 140);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotMappingTable, 140);
    }

    @Override
    protected void addTabs() {
        this.initClusterColumnsView();
        this.partitioningTab = this.initPartitioningView();
        this.initIOTPropertiesView();
        this.initSupplementalLogView();
        this.initOIDView();
        this.initXMLTypeView();
    }

    private void initXMLTypeView() {
        this.xmlTypeProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.XMLTypeProperties"), this.xmlTypeProperties);
        this.initXMLTypeProperties();
    }

    private void initXMLTypeProperties() {
        this.initXMLSchemaURL(20);
        this.initXMLSchemaElement(50);
        int n = this.initAllowAnySchema(80);
        n = this.initAllowNonSchema(n);
        this.initStoreAs(n);
        n += 30;
        n = this.initLobStorageType(n);
        this.initLobSegmentName(n);
        this.initXmlTypeTableSpace(n += 30);
        this.initStorageInRow(n += 30);
        this.initXmlTypeLogging(n += 30);
        this.initXmlTypeCache(n += 30);
        this.initChunk(n += 30);
        this.initOldVersions(n += 30);
        this.initPctVersion(n += 30);
        this.initFreePools(n += 30);
    }

    private void initStoreAs(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.StoreAs"));
        this.xmlTypeProperties.add(jLabel);
        this.cbStoreAs = this.getStorageDesign() instanceof StorageDesignOraclev11g ? new JComboBox<String>(TableProxyOraclev11g.getStoreAsValues11g()) : new JComboBox<String>(TableProxyOraclev10g.getStoreAsValues());
        this.cbStoreAs.addActionListener(new StoreAsListener());
        this.setBG(this.cbStoreAs);
        this.cbStoreAs.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStoreAs);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStoreAs, n);
    }

    private void initXMLSchemaURL(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaURL"));
        this.xmlTypeProperties.add(jLabel);
        this.tfXmlSchemaUrl = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaUrl);
        this.xmlTypeProperties.add(this.tfXmlSchemaUrl);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaUrl, n);
    }

    private void initXMLSchemaElement(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaElem"));
        this.xmlTypeProperties.add(jLabel);
        this.tfXmlSchemaElement = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaElement);
        this.xmlTypeProperties.add(this.tfXmlSchemaElement);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaElement, n);
    }

    protected int initAllowAnySchema(int n) {
        return n;
    }

    protected int initAllowNonSchema(int n) {
        return n;
    }

    protected int initLobStorageType(int n) {
        return n;
    }

    private void initLobSegmentName(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.LobSegmentName"));
        this.xmlTypeProperties.add(jLabel);
        this.tfLobSegmentName = new JTextField("", 26);
        this.xmlTypeProperties.add(this.tfLobSegmentName);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfLobSegmentName, n);
    }

    private void initXmlTypeTableSpace(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.xmlTypeProperties.add(jLabel);
        this.cbXmlTypeTableSpace = new JComboBox();
        this.setBG(this.cbXmlTypeTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbXmlTypeTableSpace);
        }
        this.cbXmlTypeTableSpace.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeTableSpace);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeTableSpace, n);
    }

    private void initStorageInRow(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.StorageInRow"));
        this.xmlTypeProperties.add(jLabel);
        this.cbStorageInRow = new JComboBox<String>(TableProxyOracle.getStorageInRowValues());
        this.setBG(this.cbStorageInRow);
        this.cbStorageInRow.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStorageInRow);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStorageInRow, n);
    }

    private void initXmlTypeLogging(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.xmlTypeProperties.add(jLabel);
        this.cbXmlTypeLogging = new JComboBox<String>(this instanceof TablePropertyDialogOraclev11g ? TableProxyOraclev11g.getXmlTypeLoggingChoices11g() : EMPTY_YES_NO);
        this.setBG(this.cbXmlTypeLogging);
        this.cbXmlTypeLogging.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeLogging);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeLogging, n);
    }

    private void initXmlTypeCache(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.xmlTypeProperties.add(jLabel);
        this.cbXmlTypeCache = new JComboBox<String>(TableProxyOracle.getXmlTypeCacheValues());
        this.setBG(this.cbXmlTypeCache);
        this.cbXmlTypeCache.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeCache);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeCache, n);
    }

    private void initChunk(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Chunk"));
        this.xmlTypeProperties.add(jLabel);
        this.ifChunk = new JIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifChunk);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifChunk, n);
    }

    private void initOldVersions(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OldVersions"));
        this.xmlTypeProperties.add(jLabel);
        this.cbOldVersions = new JComboBox<String>(TableProxyOraclev10g.getOldVersionChoices());
        this.cbOldVersions.addActionListener(new VersionListener());
        this.setBG(this.cbOldVersions);
        this.cbOldVersions.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbOldVersions);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbOldVersions, n);
    }

    private void initPctVersion(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.PCTVersion"));
        this.xmlTypeProperties.add(jLabel);
        this.ifPctVersion = new JIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifPctVersion);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifPctVersion, n);
    }

    private void initFreePools(int n) {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.FreePools"));
        this.xmlTypeProperties.add(jLabel);
        this.ifFreePools = new JIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifFreePools);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), jLabel, n);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifFreePools, n);
    }

    private void enableXMLTypeClobOptions(boolean bl) {
        if (this.getStorageDesign() instanceof StorageDesignOraclev11g) {
            this.cbLobStorageType.setEnabled(bl);
        }
        this.tfLobSegmentName.setEnabled(bl);
        this.cbXmlTypeTableSpace.setEnabled(bl);
        this.cbStorageInRow.setEnabled(bl);
        this.cbXmlTypeLogging.setEnabled(bl);
        this.cbXmlTypeCache.setEnabled(bl);
        this.ifChunk.setEnabled(bl);
        this.cbOldVersions.setEnabled(bl);
        this.ifPctVersion.setEnabled(bl);
        this.ifFreePools.setEnabled(bl);
    }

    protected SpringLayout getXMLTypePropertiesLayout() {
        return (SpringLayout)this.xmlTypeProperties.getLayout();
    }

    private void initOIDView() {
        this.oidProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.OIDProperties"), this.oidProperties);
        this.initOIDProperties();
    }

    private void initOIDProperties() {
        this.initOidType();
        this.initOidIndexName();
        this.initOidIndexSegment();
    }

    private void initOidType() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDType"));
        this.oidProperties.add(jLabel);
        this.tfOidType = new JTextField();
        this.tfOidType.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.tfOidType.setEnabled(false);
        this.oidProperties.add(this.tfOidType);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), jLabel, 20);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidType, 20);
    }

    private void initOidIndexName() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexName"));
        this.oidProperties.add(jLabel);
        this.tfOidIndexName = new JTextField();
        this.tfOidIndexName.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.tfOidIndexName);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), jLabel, 50);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidIndexName, 50);
    }

    private void initOidIndexSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexSegment"));
        this.oidProperties.add(jLabel);
        this.cbOidIndexSegment = new JComboBox();
        this.setBG(this.cbOidIndexSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbOidIndexSegment);
        }
        this.cbOidIndexSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.cbOidIndexSegment);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), jLabel, 80);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.cbOidIndexSegment, 80);
    }

    protected SpringLayout getOIDPropertiesLayout() {
        return (SpringLayout)this.oidProperties.getLayout();
    }

    private void initSupplementalLogView() {
        this.supplementalLog = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.SupplementalLog"), this.supplementalLog);
        this.initSupplementalLog();
    }

    private void initSupplementalLog() {
        this.initSupplementalLogGroupName();
        this.initSupplementalLogCondition();
        this.initSupplementalLogColumns();
    }

    private void initSupplementalLogColumns() {
        this.initAllSupplementalColumnsList();
        this.initSelectedSupplementalColumnsList();
        this.initSupplementalButtons();
    }

    private void initAllSupplementalColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.supplementalLog.add(jLabel);
        this.allSupplementalColumnsModel = new DefaultListModel();
        this.allSupplementalColumnsList = new JList(this.allSupplementalColumnsModel);
        ListSelectionModel listSelectionModel = this.allSupplementalColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSupplementalSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSupplementalColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 450));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.supplementalLog.add(jScrollPane);
        this.setLabelConstraints(this.getSupplementalLogLayout(), jLabel, 8, 84);
        this.setObjectConstraints(this.getSupplementalLogLayout(), jScrollPane, 6, 112);
    }

    private void initSelectedSupplementalColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.SupplementalColumns"));
        this.supplementalLog.add(jLabel);
        this.selectedSupplementalColumnsModel = new DefaultListModel();
        this.selectedSupplementalColumnsList = new JList(this.selectedSupplementalColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedSupplementalColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSupplementalSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSupplementalColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 450));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.supplementalLog.add(jScrollPane);
        this.setLabelConstraints(this.getSupplementalLogLayout(), jLabel, 292, 84);
        this.setObjectConstraints(this.getSupplementalLogLayout(), jScrollPane, 290, 112);
    }

    private void initSupplementalButtons() {
        this.bnSupplementalAdd = new JButton(ADD_CAPTION);
        this.bnSupplementalAdd.addActionListener(new AddSupplementalColumnsActionListener());
        this.bnSupplementalAdd.setEnabled(false);
        this.supplementalLog.add(this.bnSupplementalAdd);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.bnSupplementalAdd, 175, 290);
        this.bnSupplementalRemove = new JButton(REMOVE_CAPTION);
        this.bnSupplementalRemove.setEnabled(false);
        this.bnSupplementalRemove.addActionListener(new RemoveSupplementalColumnsActionListener());
        this.supplementalLog.add(this.bnSupplementalRemove);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.bnSupplementalRemove, 175, 330);
        TablePropertyDialogOraclev10g.equalizeButtonSizes(this.bnSupplementalAdd, this.bnSupplementalRemove);
    }

    private void initSupplementalLogGroupName() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.GroupName"));
        this.supplementalLog.add(jLabel);
        this.tfSupplementalLogGroupName = new JTextField("", 26);
        this.supplementalLog.add(this.tfSupplementalLogGroupName);
        this.setLabelConstraints(this.getSupplementalLogLayout(), jLabel, 20);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.tfSupplementalLogGroupName, 20);
    }

    private void initSupplementalLogCondition() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.Condition"));
        this.supplementalLog.add(jLabel);
        this.cbSupplementalLogCondition = new JComboBox<String>(TableProxyOraclev10g.suplementalLogConditionChoices);
        this.setBG(this.cbSupplementalLogCondition);
        this.cbSupplementalLogCondition.setPreferredSize(this.tfSupplementalLogGroupName.getPreferredSize());
        this.supplementalLog.add(this.cbSupplementalLogCondition);
        this.setLabelConstraints(this.getSupplementalLogLayout(), jLabel, 50);
        this.setObjectConstraints(this.getSupplementalLogLayout(), this.cbSupplementalLogCondition, 50);
    }

    private void initIOTPropertiesView() {
        this.iotProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.IOTProperties"), this.iotProperties);
        this.initIOTProperties();
    }

    private void initIOTProperties() {
        this.initIOTCompress();
        this.initIOTPCTThershold();
        this.initIOTIncluding();
        this.initIOTOverflowSegment();
        this.initIOTMappingTable();
    }

    private void initClusterColumnsView() {
        this.clusterColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.ClusterColumns"), this.clusterColumns);
        this.initClusterColumns();
    }

    protected SpringLayout getClusterColumnsLayout() {
        return (SpringLayout)this.clusterColumns.getLayout();
    }

    private void initClusterColumns() {
        this.initAllClusterColumnsList();
        this.initSelectedClusterColumnsList();
        this.initClusterColumnsButtons();
    }

    private void initAllClusterColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.clusterColumns.add(jLabel);
        this.allClusterColumnsModel = new DefaultListModel();
        this.allClusterColumnsList = new JList(this.allClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.allClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllClusterColumnListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allClusterColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 540));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(jScrollPane);
        this.setLabelConstraints(this.getClusterColumnsLayout(), jLabel, 12, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), jScrollPane, 10, 22);
    }

    private void initSelectedClusterColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedColumns"));
        this.clusterColumns.add(jLabel);
        this.selectedClusterColumnsModel = new DefaultListModel();
        this.selectedClusterColumnsList = new JList(this.selectedClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedClusterColumnListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedClusterColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 540));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(jScrollPane);
        this.setLabelConstraints(this.getClusterColumnsLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), jScrollPane, 290, 22);
    }

    private void initClusterColumnsButtons() {
        this.bnAddClusterColumn = new JButton(ADD_CAPTION);
        this.bnAddClusterColumn.addActionListener(new AddClusterColumnsActionListener());
        this.bnAddClusterColumn.setEnabled(false);
        this.clusterColumns.add(this.bnAddClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnAddClusterColumn, 175, 240);
        this.bnRemoveClusterColumn = new JButton(REMOVE_CAPTION);
        this.bnRemoveClusterColumn.setEnabled(false);
        this.bnRemoveClusterColumn.addActionListener(new RemoveClusterColumnsActionListener());
        this.clusterColumns.add(this.bnRemoveClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnRemoveClusterColumn, 175, 270);
        TablePropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddClusterColumn, this.bnRemoveClusterColumn);
    }

    protected JPanel initPartitioningView() {
        this.partitionPropertyTab = new PartitionPropertyTabOraclev10g(this.getAppView(), this.getStorageDesign(), this.getStorageObject(), this);
        return this.partitionPropertyTab.addTab(this.getPane());
    }

    @Override
    public void initProperties() {
        ColumnProxy columnProxy;
        int n;
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        String string = this.table.getBasedOnStructuredType();
        this.tfBasedOnStructuredType.setText(string);
        this.selectObject(this.cbUser, this.table.getUser());
        this.selectObject(this.cbTableSpace, this.table.getTableSpace());
        this.cbPartitioned.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getPartitioned()));
        this.cbPartRowMovement.setSelectedItem(this.table.getParttitionedRowMovement());
        this.cbOrganization.setSelectedItem(this.table.getOrganization());
        this.selectObject(this.cbCluster, this.table.getCluster());
        this.cbLogging.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getLogging()));
        this.selectObject(this.cbSegment, this.table.getSegment());
        this.cbCache.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getCache()));
        this.cbRowDependency.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getRowDependency()));
        this.cbDataSegmentCompression.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getDataSegmentCompression()));
        this.ifIotCompress.setValue((long)this.table.getIotCompress());
        this.ifIotPctThreshold.setValue((long)this.table.getIotPctThreshold());
        this.fillComboItems(this.table.getColumnProxies(), this.cbIotIncluding);
        this.cbIotIncluding.setSelectedItem(this.table.getIotIncluding());
        this.cbIotOverflowSegment.setSelectedItem(this.table.getIotOverflowSegment());
        this.cbIotMappingTable.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getIOTMappingTable()));
        this.cbSnapshot.setSelectedItem(this.table.getSnapshot());
        ColumnProxy[] columnProxyArray = this.table.getColumnProxies();
        for (n = 0; n < columnProxyArray.length; ++n) {
            columnProxy = columnProxyArray[n];
            if (this.table.getSuplementalLogColumnSet().contains(columnProxy.getObjectID())) {
                this.selectedSupplementalColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allSupplementalColumnsModel.addElement(columnProxy);
        }
        this.tfSupplementalLogGroupName.setText(this.table.getSuplementalLogGroupName());
        this.cbSupplementalLogCondition.setSelectedItem(this.table.getSuplementalLogConditions());
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.oidProperties), !string.equals(""));
        this.tfOidType.setText(this.table.getOidType());
        this.tfOidIndexName.setText(this.table.getOidIndexName());
        this.cbOidIndexSegment.setSelectedItem(this.table.getOidIndexSegment());
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.xmlTypeProperties), string.equalsIgnoreCase("XMLTYPE"));
        this.tfXmlSchemaUrl.setText(this.table.getXmlSchemaUrl());
        this.tfXmlSchemaElement.setText(this.table.getXmlSchemaElement());
        this.cbStoreAs.setSelectedItem(this.table.getStoreAs());
        this.tfLobSegmentName.setText(this.table.getLobSegmentName());
        this.selectObject(this.cbXmlTypeTableSpace, this.table.getXmlTypeTableSpace());
        this.cbStorageInRow.setSelectedItem(this.table.getStorageInRow());
        this.cbXmlTypeLogging.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getXmlTypeLogging()));
        this.cbXmlTypeCache.setSelectedItem(this.table.getXmlTypeCache());
        this.ifChunk.setValue((long)this.table.getChunk());
        this.cbOldVersions.setSelectedItem(this.table.getOldVersions());
        this.ifPctVersion.setValue((long)this.table.getPCTVersion());
        this.ifFreePools.setValue((long)this.table.getFreepools());
        for (n = 0; n < columnProxyArray.length; ++n) {
            columnProxy = columnProxyArray[n];
            if (this.table.getClusterColumnsSet().contains(columnProxy.getObjectID())) {
                this.selectedClusterColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allClusterColumnsModel.addElement(columnProxy);
        }
        this.partitionPropertyTab.initProperties();
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        if (this.table.getTemporary().equals("NO")) {
            this.cbTemporary.setSelectedItem(NO);
        } else if (this.table.getTempPreserveRows().equals("YES")) {
            this.cbTemporary.setSelectedItem(YES_PRESERVE);
        } else {
            this.cbTemporary.setSelectedItem(YES_DELETE);
        }
        this.cbParallel.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getParallel()));
        this.tfDegree.setText(this.table.getDegree());
        if (this.cbSnapshot.getSelectedItem() != null) {
            this.snapshotChanged();
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            Object object;
            this.table.setName(this.tfName.getText());
            Object object2 = this.cbUser.getSelectedItem();
            if (object2 instanceof UserOraclev10g) {
                this.table.setUser((UserOraclev10g)object2);
            } else {
                this.table.setUser(null);
            }
            if (this.cbTemporary.getSelectedItem().equals(NO)) {
                this.table.setTemporary("NO");
            } else {
                this.table.setTemporary("YES");
                if (this.cbTemporary.getSelectedItem().equals(YES_PRESERVE)) {
                    this.table.setTempPreserveRows("YES");
                } else {
                    this.table.setTempPreserveRows("NO");
                }
            }
            object2 = this.cbTableSpace.getSelectedItem();
            if (object2 instanceof TableSpaceOraclev10g) {
                this.table.setTableSpace((TableSpaceOraclev10g)object2);
            } else {
                this.table.setTableSpace(null);
            }
            this.table.setOrganization((String)this.cbOrganization.getSelectedItem());
            object2 = this.cbCluster.getSelectedItem();
            if (object2 instanceof ClusterOraclev10g) {
                this.table.setCluster((ClusterOraclev10g)object2);
            } else {
                this.table.setCluster(null);
            }
            this.table.setLogging(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            object2 = this.cbSegment.getSelectedItem();
            if (object2 instanceof SegmentOraclev10g) {
                this.table.setSegment((SegmentOraclev10g)object2);
            } else {
                this.table.setSegment(null);
            }
            this.table.setCache(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbCache.getSelectedItem()));
            this.table.setParallel(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.table.setDegree(this.tfDegree.getText());
            this.table.setRowDependency(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbRowDependency.getSelectedItem()));
            this.table.setPartitioned(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.table.setParttitionedRowMovement((String)this.cbPartRowMovement.getSelectedItem());
            this.table.setDataSegmentCompression(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbDataSegmentCompression.getSelectedItem()));
            this.table.setOidIndexName(this.tfOidIndexName.getText());
            this.table.setOidIndexSegment((SegmentOracle)this.cbOidIndexSegment.getSelectedItem());
            this.table.setXmlSchemaUrl(this.tfXmlSchemaUrl.getText());
            this.table.setXmlSchemaElement(this.tfXmlSchemaElement.getText());
            String string = (String)this.cbStoreAs.getSelectedItem();
            this.table.setStoreAs(string);
            if (!string.equalsIgnoreCase("OBJECT RELATIONAL")) {
                this.table.setLobSegmentName(this.tfLobSegmentName.getText());
                object2 = this.cbXmlTypeTableSpace.getSelectedItem();
                if (object2 instanceof TableSpaceOraclev10g) {
                    this.table.setXmlTypeTableSpace((TableSpaceOraclev10g)object2);
                } else {
                    this.table.setXmlTypeTableSpace(null);
                }
                this.table.setStorageInRow((String)this.cbStorageInRow.getSelectedItem());
                this.table.setXmlTypeLogging(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbXmlTypeLogging.getSelectedItem()));
                this.table.setXmlTypeCache((String)this.cbXmlTypeCache.getSelectedItem());
                this.table.setChunk(this.ifChunk.getIntValue());
                this.table.setOldVersions((String)this.cbOldVersions.getSelectedItem());
                this.table.setFreepools(this.ifFreePools.getIntValue());
                this.table.setPCTVersion(this.ifPctVersion.getIntValue());
            }
            this.table.setIotCompress(this.ifIotCompress.getIntValue());
            this.table.setIotPctThreshold(this.ifIotPctThreshold.getIntValue());
            object2 = this.cbIotIncluding.getSelectedItem();
            if (object2 instanceof ColumnProxy) {
                this.table.setIotIncluding((ColumnProxy)object2);
            } else {
                this.table.setIotIncluding(null);
            }
            object2 = this.cbIotOverflowSegment.getSelectedItem();
            if (object2 instanceof SegmentOraclev10g) {
                this.table.setIotOverflowSegment((SegmentOraclev10g)object2);
            } else {
                this.table.setIotOverflowSegment(null);
            }
            this.table.setIOTMappingTable(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbIotMappingTable.getSelectedItem()));
            object2 = this.cbSnapshot.getSelectedItem();
            if (object2 instanceof SnapshotOracle) {
                this.table.setSnapshot((SnapshotOracle)object2);
            } else {
                this.table.setSnapshot(null);
            }
            Object[] objectArray = this.selectedSupplementalColumnsModel.toArray();
            this.table.clearSuplementalLogColumns();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3 = objectArray[i];
                if (!(object3 instanceof ColumnProxy)) continue;
                this.table.setSuplementalLogColumns(((ColumnProxy)object3).getObjectID());
            }
            Object[] objectArray2 = this.selectedClusterColumnsModel.toArray();
            this.table.clear();
            for (int i = 0; i < objectArray2.length; ++i) {
                object = objectArray2[i];
                if (!(object instanceof ColumnProxy)) continue;
                this.table.setClusterColumns(((ColumnProxy)object).getObjectID());
            }
            this.table.setSuplementalLogGroupName(this.tfSupplementalLogGroupName.getText());
            this.table.setSuplementalLogConditions((String)this.cbSupplementalLogCondition.getSelectedItem());
            this.partitionPropertyTab.setProperties(this.isPartitioned());
            String string2 = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string2) && !this.comment.equals(string2)) {
                this.table.setComment(string2);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equals(object)) {
                this.table.setCommentInRDBMS((String)object);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
        }
    }

    protected boolean isPartitioned() {
        return this.cbPartitioned.getSelectedItem().equals(YES);
    }

    protected boolean isIndexOrg() {
        return this.cbOrganization.getSelectedItem().equals("INDEX");
    }

    private void snapshotChanged() {
        boolean bl = this.cbSnapshot.getSelectedItem() == null;
        this.tfName.setEnabled(bl);
        this.cbUser.setEnabled(bl);
        this.cbTemporary.setEnabled(bl);
        this.cbTableSpace.setEnabled(bl);
        this.cbCluster.setEnabled(bl);
        this.cbLogging.setEnabled(bl);
        this.cbCache.setEnabled(bl);
        this.cbParallel.setEnabled(bl);
        this.tfDegree.setEnabled(bl);
        this.cbRowDependency.setEnabled(bl);
        this.cbPartRowMovement.setEnabled(bl);
        this.cbDataSegmentCompression.setEnabled(bl);
        this.bnPermissions.setEnabled(bl);
        try {
            this.getPane().setEnabledAt(1, bl);
            this.getPane().setEnabledAt(3, bl);
            this.getPane().setEnabledAt(4, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void postProcessingInApply() {
        if (this.partitionPropertyTab != null) {
            this.partitionPropertyTab.postProcessingInApply();
        }
    }

    @Override
    protected void clearOnDispose() {
        if (this.partitionPropertyTab != null) {
            this.partitionPropertyTab.clearOnDispose();
        }
    }

    private class RemoveSupplementalColumnsActionListener
    implements ActionListener {
        private RemoveSupplementalColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev10g.this.allSupplementalColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev10g.this.allSupplementalColumnsModel.addElement(object);
                    TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddSupplementalColumnsActionListener
    implements ActionListener {
        private AddSupplementalColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev10g.this.allSupplementalColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev10g.this.allSupplementalColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsModel.addElement(object);
                    TablePropertyDialogOraclev10g.this.allSupplementalColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSupplementalSelectionHandler
    implements ListSelectionListener {
        private SelectedListSupplementalSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev10g.this.selectedSupplementalColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev10g.this.bnSupplementalRemove.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev10g.this.bnSupplementalRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSupplementalSelectionHandler
    implements ListSelectionListener {
        private AllListSupplementalSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogOraclev10g.this.allSupplementalColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogOraclev10g.this.bnSupplementalAdd.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev10g.this.bnSupplementalAdd.setEnabled(true);
                }
            }
        }
    }

    private class ParallelListener
    implements ActionListener {
        private ParallelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogOraclev10g.this.tfDegree.setEnabled(TablePropertyDialogOraclev10g.this.cbParallel.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }

    private class OrganizationListener
    implements ActionListener {
        private OrganizationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)TablePropertyDialogOraclev10g.this.cbOrganization.getSelectedItem();
            if (string != null) {
                if (string.equalsIgnoreCase("HEAP")) {
                    TablePropertyDialogOraclev10g.this.cbCache.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.ifIotCompress.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.ifIotPctThreshold.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.cbIotIncluding.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.cbIotOverflowSegment.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.cbIotMappingTable.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev10g.this.cbCache.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.ifIotCompress.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.ifIotPctThreshold.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.cbIotIncluding.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.cbIotOverflowSegment.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.cbIotMappingTable.setEnabled(true);
                }
                TablePropertyDialogOraclev10g.this.partitionPropertyTab.enableRelevantPartitionFields(TablePropertyDialogOraclev10g.this.isPartitioned());
            }
        }
    }

    private class ClusterListener
    implements ActionListener {
        private ClusterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(true);
                TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(false);
                TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedIndex() != -1);
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class TemporaryListener
    implements ActionListener {
        private TemporaryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev10g.this.cbTemporary.getSelectedItem().equals(AbstractPropertyDialog.NO)) {
                TablePropertyDialogOraclev10g.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbCluster.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbPartitioned.setSelectedItem(AbstractPropertyDialog.NO);
                TablePropertyDialogOraclev10g.this.cbPartitioned.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbTableSpace.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbPartRowMovement.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbLogging.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(false);
                TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev10g.this.cbCluster.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbPartitioned.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbTableSpace.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbPartRowMovement.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbLogging.setEnabled(true);
                if (TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                    TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedIndex() != -1);
                    TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedIndex() != -1);
                }
            }
        }
    }

    private class RemoveClusterColumnsActionListener
    implements ActionListener {
        private RemoveClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev10g.this.allClusterColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev10g.this.allClusterColumnsModel.addElement(object);
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddClusterColumnsActionListener
    implements ActionListener {
        private AddClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogOraclev10g.this.allClusterColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.contains(object)) continue;
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.addElement(object);
                    TablePropertyDialogOraclev10g.this.allClusterColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private SelectedClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class AllClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private AllClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class VersionListener
    implements ActionListener {
        private VersionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogOraclev10g.this.ifPctVersion.setEnabled(TablePropertyDialogOraclev10g.this.cbOldVersions.getSelectedItem().equals("PCT_VERSION"));
        }
    }

    private class StoreAsListener
    implements ActionListener {
        private StoreAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (TablePropertyDialogOraclev10g.this.cbAllowAnySchema != null && TablePropertyDialogOraclev10g.this.cbAllowNonSchema != null) {
                bl = TablePropertyDialogOraclev10g.this.cbStoreAs.getSelectedItem().equals("BINARY XML");
                TablePropertyDialogOraclev10g.this.cbAllowAnySchema.setEnabled(bl);
                TablePropertyDialogOraclev10g.this.cbAllowNonSchema.setEnabled(bl);
            }
            TablePropertyDialogOraclev10g.this.enableXMLTypeClobOptions(!(bl = TablePropertyDialogOraclev10g.this.cbStoreAs.getSelectedItem().equals("OBJECT RELATIONAL")));
        }
    }

    private class PartitionedAction
    implements ActionListener {
        private PartitionedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = TablePropertyDialogOraclev10g.this.isPartitioned();
            int n = TablePropertyDialogOraclev10g.this.getPane().indexOfComponent(TablePropertyDialogOraclev10g.this.partitioningTab);
            if (n > -1) {
                TablePropertyDialogOraclev10g.this.getPane().setEnabledAt(n, bl);
            }
            TablePropertyDialogOraclev10g.this.partitionPropertyTab.reinitPartitioning(bl);
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogOraclev10g.this.dialog = new ObjectPermissionsDialogOracle(TablePropertyDialogOraclev10g.this.getAppView(), TablePropertyDialogOraclev10g.this.getStorageDesign(), TablePropertyDialogOraclev10g.this.table);
            TablePropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }
}

