/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StructuredTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StructuredTypeProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StructuredTypePropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private StructuredTypeProxyOraclev10g type;
    private JComboBox cbOwner;
    private JComboBox cbInvokerRights;
    private JComboBox cbMapOrderFunction;
    private JComboBox cbMapOrderType;
    private JTextField tfSuperType;
    private JComboBox cbFinal;
    private JComboBox cbInstantiable;
    private JComboBox cbMapToJavaClass;
    private JTextField tfJavaClass;
    private JComboBox cbJavaInstance;
    private JTextField tfGlobalOid;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public StructuredTypePropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.type = (StructuredTypeProxyOraclev10g)storageObject;
        this.setHeight(450);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StructuredTypePropertyDialogOracle.StructuredTypeProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initGlobalOid();
        this.initOwner();
        this.initInvokerRights();
        this.initMapOrderFunction();
        this.initMapOrderType();
        this.initSuperType();
        this.initFinal();
        this.initInstantiable();
        this.initMapToJavaClass();
        this.initJavaClass();
        this.initJavaInstance();
        this.initPermissionsButton();
    }

    private void initGlobalOid() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.GlobalOID"));
        this.general.add(jLabel);
        this.tfGlobalOid = new JTextField("", 26);
        this.general.add(this.tfGlobalOid);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfGlobalOid, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox<Object>(this.getStorageDesign().getUserSet().toArray());
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initInvokerRights() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.InvokerRights"));
        this.general.add(jLabel);
        this.cbInvokerRights = new JComboBox<String>(StructuredTypeProxyOracle.getInvokerRightChoices());
        this.setBG(this.cbInvokerRights);
        this.cbInvokerRights.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInvokerRights);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbInvokerRights, 110);
    }

    private void initMapOrderFunction() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.MapOrderFunction"));
        this.general.add(jLabel);
        this.cbMapOrderFunction = new JComboBox();
        this.fillComboItems(this.getStorageDesign().getMethodProxySet().toArray(), this.cbMapOrderFunction);
        this.setBG(this.cbMapOrderFunction);
        this.cbMapOrderFunction.setPreferredSize(this.tfName.getPreferredSize());
        this.cbMapOrderFunction.addActionListener(new MapOrderListener());
        this.general.add(this.cbMapOrderFunction);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbMapOrderFunction, 140);
    }

    private void initMapOrderType() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.MapOrderType"));
        this.general.add(jLabel);
        this.cbMapOrderType = new JComboBox<String>(StructuredTypeProxyOracle.getMapOrderChoices());
        this.setBG(this.cbMapOrderType);
        this.cbMapOrderType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbMapOrderType);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbMapOrderType, 170);
    }

    private void initSuperType() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.SuperType"));
        this.general.add(jLabel);
        this.tfSuperType = new JTextField("", 26);
        this.tfSuperType.setEnabled(false);
        this.general.add(this.tfSuperType);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfSuperType, 200);
    }

    private void initFinal() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.Final"));
        this.general.add(jLabel);
        this.cbFinal = new JComboBox<String>(YES_NO);
        this.setBG(this.cbFinal);
        this.cbFinal.setPreferredSize(this.tfName.getPreferredSize());
        this.cbFinal.setEnabled(false);
        this.general.add(this.cbFinal);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbFinal, 230);
    }

    private void initInstantiable() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.Instantiable"));
        this.general.add(jLabel);
        this.cbInstantiable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbInstantiable);
        this.cbInstantiable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbInstantiable.setEnabled(false);
        this.general.add(this.cbInstantiable);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbInstantiable, 260);
    }

    private void initMapToJavaClass() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.MapToJavaClass"));
        this.general.add(jLabel);
        this.cbMapToJavaClass = new JComboBox<String>(YES_NO);
        this.setBG(this.cbMapToJavaClass);
        this.cbMapToJavaClass.setPreferredSize(this.tfName.getPreferredSize());
        this.cbMapToJavaClass.addActionListener(new MapToJavaListener());
        this.general.add(this.cbMapToJavaClass);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbMapToJavaClass, 290);
    }

    private void initJavaClass() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.JavaClass"));
        this.general.add(jLabel);
        this.tfJavaClass = new JTextField("", 26);
        this.general.add(this.tfJavaClass);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.tfJavaClass, 320);
    }

    private void initJavaInstance() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.JavaInstance"));
        this.general.add(jLabel);
        this.cbJavaInstance = new JComboBox<String>(StructuredTypeProxyOraclev9i.JAVA_INSTANCES);
        this.setBG(this.cbJavaInstance);
        this.cbJavaInstance.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbJavaInstance);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbJavaInstance, 350);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.type.getName());
        this.tfName.setText(this.type.getName());
        this.cbOwner.setSelectedItem(this.type.getOwner());
        this.cbOwner.setEnabled(!this.type.getStructuredType().isNullInstance());
        this.cbInvokerRights.setSelectedItem(this.type.getInvokerRights());
        this.cbMapOrderFunction.setSelectedItem(this.type.getMapOrderFunction());
        this.cbMapOrderType.setSelectedItem(this.type.getMapOrderType());
        this.tfSuperType.setText(this.type.getSuperType());
        this.cbFinal.setSelectedItem(StructuredTypePropertyDialogOraclev10g.translateYesNoForDisplay(this.type.getFinal()));
        this.cbInstantiable.setSelectedItem(StructuredTypePropertyDialogOraclev10g.translateYesNoForDisplay(this.type.getInstantiable()));
        this.cbMapToJavaClass.setSelectedItem(StructuredTypePropertyDialogOraclev10g.translateYesNoForDisplay(this.type.getMapToJavaClass()));
        this.tfJavaClass.setText(this.type.getJavaClass());
        this.cbJavaInstance.setSelectedItem(this.type.getJavaInstanceUsing());
        this.tfGlobalOid.setText(this.type.getGlobalOid());
        if (((StructuredType)this.type.getObject()).getParentType() != null) {
            this.cbMapOrderFunction.setEnabled(false);
        } else {
            this.cbMapOrderFunction.setEnabled(true);
        }
        if (this.type.getMapOrderFunction() != null) {
            this.cbMapOrderType.setEnabled(true);
        } else {
            this.cbMapOrderType.setEnabled(false);
        }
        String string = this.type.getMapToJavaClass();
        if ("YES".equalsIgnoreCase(string)) {
            this.tfJavaClass.setEnabled(true);
            this.cbJavaInstance.setEnabled(true);
        } else {
            this.tfJavaClass.setEnabled(false);
            this.cbJavaInstance.setEnabled(false);
        }
        this.getCommentsList().insert(this.type.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.type != null) {
            this.type.setName(this.tfName.getText());
            this.type.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            this.type.setInvokerRights((String)this.cbInvokerRights.getSelectedItem());
            this.type.setMapOrderFunction((MethodProxyOracle)this.cbMapOrderFunction.getSelectedItem());
            this.type.setMapOrderType((String)this.cbMapOrderType.getSelectedItem());
            this.type.setMapToJavaClass(StructuredTypePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbMapToJavaClass.getSelectedItem()));
            this.type.setJavaClass(this.tfJavaClass.getText());
            this.type.setJavaInstanceUsing((String)this.cbJavaInstance.getSelectedItem());
            this.type.setGlobalOid(this.tfGlobalOid.getText());
            this.type.setComment(this.getCommentsList().getText());
        }
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("StructuredTypePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 385);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StructuredTypePropertyDialogOraclev10g.this.dialog = new ObjectPermissionsDialogOracle(StructuredTypePropertyDialogOraclev10g.this.getAppView(), StructuredTypePropertyDialogOraclev10g.this.getStorageDesign(), StructuredTypePropertyDialogOraclev10g.this.type);
            StructuredTypePropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }

    class MapToJavaListener
    implements ActionListener {
        MapToJavaListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)StructuredTypePropertyDialogOraclev10g.this.cbMapToJavaClass.getSelectedItem();
            if (AbstractPropertyDialog.YES.equalsIgnoreCase(string)) {
                StructuredTypePropertyDialogOraclev10g.this.tfJavaClass.setEnabled(true);
                StructuredTypePropertyDialogOraclev10g.this.cbJavaInstance.setEnabled(true);
            } else {
                StructuredTypePropertyDialogOraclev10g.this.tfJavaClass.setEnabled(false);
                StructuredTypePropertyDialogOraclev10g.this.cbJavaInstance.setEnabled(false);
            }
        }
    }

    class MapOrderListener
    implements ActionListener {
        MapOrderListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (StructuredTypePropertyDialogOraclev10g.this.cbMapOrderFunction.getSelectedItem() != null) {
                StructuredTypePropertyDialogOraclev10g.this.cbMapOrderType.setEnabled(true);
            } else {
                StructuredTypePropertyDialogOraclev10g.this.cbMapOrderType.setEnabled(false);
            }
        }
    }
}

