/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.PartitionPropertyTabOraclev10g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SnapshotPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private SnapshotOraclev10g snapshot;
    protected PartitionPropertyTabOraclev10g partitionPropertyTab;
    private JComboBox cbOwner;
    private JTextField tfStartDate;
    private JTextField tfNextDate;
    private JTextArea taBody;
    private JComboBox cbPartitioned;
    private JComboBox cbSegment;
    private JComboBox cbCluster;
    private JComboBox cbParalelClause;
    private JComboBox cbBuild;
    private JComboBox cbReducedPrecision;
    private JComboBox cbOnPrebuild;
    private JComboBox cbUseIndex;
    private JComboBox cbForUpdate;
    private JComboBox cbQueryRewrite;
    private JComboBox cbRefresh;
    private JComboBox cbLobStorage;
    private JComboBox cbRefreshType;
    private JComboBox cbAction;
    private JComboBox cbWith;
    private JComboBox cbDefaultSegment;
    private JComboBox cbSegmentType;
    private JComboBox cbRollbackSegment;
    private JComboBox cbTablespace;
    private JComboBox cbIndexTablespace;
    private JComboBox cbLogging;
    private JComboBox cbCache;
    private JTextArea clusterColumnsBody;
    private JPanel refreshPanel;
    private JPanel bodyPanel;
    private JPanel clusterColumnsPanel;
    private JPanel partitioningTab;
    protected JScrollPane spBody;
    private JComboBox cbUsingConstraint;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    private JTextField tfImplementedTable;

    public SnapshotPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.snapshot = (SnapshotOraclev10g)storageObject;
        this.setHeight(650);
        this.initCommentsView(280);
        this.initCommentsInRDBMS(280);
        this.initNotesView(560);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initImplementedTable();
        this.initOwner();
        this.initLobStorage();
        this.initPartitioned();
        this.initSegment();
        this.initCluster();
        this.initParalelClause();
        this.initBuild();
        this.initReducedPrecision();
        this.initOnPrebuild();
        this.initUseIndex();
        this.initForUpdate();
        this.initQueryRewrite();
        this.initTablespace();
        this.initIndexTablespace();
        this.initLogging();
        this.initCache();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    @Override
    protected void addTabs() {
        this.initBodyView();
        this.initClusterColumnsView();
        this.partitioningTab = this.initPartitioningView();
        this.initRefreshView();
    }

    private void initBodyView() {
        this.bodyPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOracle.Body"), this.bodyPanel);
        this.taBody = new JTextArea();
        this.spBody = new JScrollPane(this.taBody);
        this.spBody.setPreferredSize(new Dimension(395, 580));
        this.spBody.setBorder(BorderFactory.createEtchedBorder(0));
        this.taBody.setLineWrap(true);
        this.bodyPanel.add(this.spBody);
        this.setObjectConstraints(this.getBodyLayout(), this.spBody, 10, 12);
    }

    private void initClusterColumnsView() {
        this.clusterColumnsPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOracle.ClusterColumns"), this.clusterColumnsPanel);
        this.clusterColumnsBody = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.clusterColumnsBody);
        jScrollPane.setPreferredSize(new Dimension(395, 580));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumnsBody.setLineWrap(true);
        this.clusterColumnsPanel.add(jScrollPane);
        this.setObjectConstraints(this.getClusterColumnsLayout(), jScrollPane, 10, 12);
    }

    private void initRefreshView() {
        this.refreshPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOracle.RefreshClause"), this.refreshPanel);
        this.initRefresh();
        this.initRefreshType();
        this.initAction();
        this.initStartDate();
        this.initNextDate();
        this.initWith();
        this.initDefaultSegment();
        this.initSegmentType();
        this.initRollbackSegment();
        this.initUsingConstraint();
    }

    private void initUsingConstraint() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev10g.UsingConstraint"));
        this.refreshPanel.add(jLabel);
        this.cbUsingConstraint = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(SnapshotOraclev10g.getUsingConstraintStates(), this.cbUsingConstraint);
        }
        this.setBG(this.cbUsingConstraint);
        this.cbUsingConstraint.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbUsingConstraint);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 290);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbUsingConstraint, 290);
    }

    private void initImplementedTable() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ImplementsTable"));
        this.general.add(jLabel);
        this.tfImplementedTable = new JTextField();
        this.tfImplementedTable.setEnabled(false);
        this.setBG(this.tfImplementedTable);
        this.tfImplementedTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfImplementedTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfImplementedTable, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.User"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initLobStorage() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.LobStorage"));
        this.general.add(jLabel);
        this.cbLobStorage = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getLobStorageSet().toArray(), this.cbLobStorage);
        }
        this.setBG(this.cbLobStorage);
        this.cbLobStorage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLobStorage);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbLobStorage, 110);
    }

    private void initPartitioned() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Partitioned"));
        this.general.add(jLabel);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitioned.addActionListener(new PartitionedAction());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbPartitioned, 140);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.setBG(this.cbSegment);
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbSegment, 260);
    }

    private void clusterStateChanged() {
        boolean bl;
        boolean bl2 = bl = this.cbCluster.getSelectedItem() == null;
        if (this.cbTablespace != null) {
            this.cbTablespace.setEnabled(bl);
        }
        if (this.cbSegment != null) {
            this.cbSegment.setEnabled(bl);
        }
    }

    private void initCluster() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Cluster"));
        this.general.add(jLabel);
        this.cbCluster = new JComboBox();
        this.cbCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotPropertyDialogOraclev10g.this.clusterStateChanged();
            }
        });
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getClusterSet().toArray(), this.cbCluster);
        }
        this.setBG(this.cbCluster);
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initParalelClause() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ParalelClause"));
        this.general.add(jLabel);
        this.cbParalelClause = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParalelClause);
        this.cbParalelClause.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParalelClause);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbParalelClause, 290);
    }

    private void initBuild() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Build"));
        this.general.add(jLabel);
        this.cbBuild = new JComboBox<String>(SnapshotOracle.BUILD_STATES);
        this.setBG(this.cbBuild);
        this.cbBuild.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBuild);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbBuild, 320);
    }

    private void initReducedPrecision() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ReducedPrecision"));
        this.general.add(jLabel);
        this.cbReducedPrecision = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReducedPrecision);
        this.cbReducedPrecision.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReducedPrecision);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbReducedPrecision, 380);
    }

    private void initOnPrebuild() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.OnPrebuildTable"));
        this.general.add(jLabel);
        this.cbOnPrebuild = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().getElements().toArray(), this.cbOnPrebuild);
        }
        this.cbOnPrebuild.addItem(Messages.getString("SnapshotPropertyDialogOracle.None"));
        this.cbOnPrebuild.addActionListener(new PrebuildListener());
        this.setBG(this.cbOnPrebuild);
        this.cbOnPrebuild.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnPrebuild);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbOnPrebuild, 350);
    }

    private void initUseIndex() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.UseIndex"));
        this.general.add(jLabel);
        this.cbUseIndex = new JComboBox<String>(NONE_YES_NO);
        this.setBG(this.cbUseIndex);
        this.cbUseIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.cbUseIndex.addActionListener(new OrganizationListener());
        this.general.add(this.cbUseIndex);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.cbUseIndex, 470);
    }

    private void initForUpdate() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ForUpdate"));
        this.general.add(jLabel);
        this.cbForUpdate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForUpdate);
        this.cbForUpdate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForUpdate);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbForUpdate, 410);
    }

    private void initQueryRewrite() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.QueryRewrite"));
        this.general.add(jLabel);
        this.cbQueryRewrite = new JComboBox<String>(SnapshotOracle.QUERY_REWRITE_STATES);
        this.setBG(this.cbQueryRewrite);
        this.cbQueryRewrite.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbQueryRewrite);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbQueryRewrite, 440);
    }

    private void initTablespace() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Tablespace"));
        this.general.add(jLabel);
        this.cbTablespace = new JComboBox();
        this.setBG(this.cbTablespace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTablespace);
        }
        this.cbTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTablespace);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbTablespace, 200);
    }

    private void initIndexTablespace() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.IndexTablespace"));
        this.general.add(jLabel);
        this.cbIndexTablespace = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIndexTablespace);
        }
        this.setBG(this.cbIndexTablespace);
        this.cbIndexTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexTablespace);
        this.setLabelConstraints(jLabel, 500);
        this.setObjectConstraints(this.cbIndexTablespace, 500);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(NONE_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbLogging, 230);
    }

    private void initCache() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Cache"));
        this.general.add(jLabel);
        this.cbCache = new JComboBox<String>(NONE_YES_NO);
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(jLabel, 530);
        this.setObjectConstraints(this.cbCache, 530);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("SnapshotPropertyDialogOracle.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(SnapshotPropertyDialogOraclev10g.this.getStorageDesign().getSnapshotSet().getElementsList());
                arrayList.remove(SnapshotPropertyDialogOraclev10g.this.snapshot);
                new PropertiesPropagationDialog(SnapshotPropertyDialogOraclev10g.this.getAppView(), SnapshotPropertyDialogOraclev10g.this.snapshot, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 570);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("SnapshotPropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 570);
    }

    private void initRefresh() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Refresh"));
        this.refreshPanel.add(jLabel);
        this.cbRefresh = new JComboBox<String>(SnapshotOracle.REFRESH_STATES);
        this.setBG(this.cbRefresh);
        this.cbRefresh.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbRefresh);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 20);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbRefresh, 20);
    }

    private void initRefreshType() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.RefreshType"));
        this.refreshPanel.add(jLabel);
        this.cbRefreshType = new JComboBox<String>(SnapshotOracle.REFRESH_TYPE_STATES);
        this.setBG(this.cbRefreshType);
        this.cbRefreshType.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbRefreshType);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 50);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbRefreshType, 50);
    }

    private void updateDates() {
        this.tfStartDate.setEnabled(this.cbAction.getSelectedIndex() == 0);
        this.tfNextDate.setEnabled(this.tfStartDate.isEnabled());
    }

    private void initAction() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Action"));
        this.refreshPanel.add(jLabel);
        this.cbAction = new JComboBox<String>(SnapshotOracle.ACTION_STATES);
        this.cbAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotPropertyDialogOraclev10g.this.updateDates();
            }
        });
        this.setBG(this.cbAction);
        this.cbAction.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbAction);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 80);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbAction, 80);
    }

    private void initStartDate() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.StartDate"));
        this.refreshPanel.add(jLabel);
        this.tfStartDate = new JTextField();
        this.setBG(this.tfStartDate);
        this.tfStartDate.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.tfStartDate);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 110);
        this.setObjectConstraints(this.getRefreshLayout(), this.tfStartDate, 110);
    }

    private void initNextDate() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.NextDate"));
        this.refreshPanel.add(jLabel);
        this.tfNextDate = new JTextField();
        this.setBG(this.tfNextDate);
        this.tfNextDate.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.tfNextDate);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 140);
        this.setObjectConstraints(this.getRefreshLayout(), this.tfNextDate, 140);
    }

    private void initWith() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.With"));
        this.refreshPanel.add(jLabel);
        this.cbWith = new JComboBox<String>(SnapshotOracle.WITH_STATES);
        this.setBG(this.cbWith);
        this.cbWith.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbWith);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 170);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbWith, 170);
    }

    private void updateRollbackSegment() {
        this.cbRollbackSegment.setEnabled(!YES.equalsIgnoreCase((String)this.cbDefaultSegment.getSelectedItem()));
    }

    private void initDefaultSegment() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.DefaultSegment"));
        this.refreshPanel.add(jLabel);
        this.cbDefaultSegment = new JComboBox<String>(YES_NO);
        this.cbDefaultSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotPropertyDialogOraclev10g.this.updateRollbackSegment();
            }
        });
        this.setBG(this.cbDefaultSegment);
        this.cbDefaultSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbDefaultSegment);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 200);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbDefaultSegment, 200);
    }

    private void initSegmentType() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.SegmentType"));
        this.refreshPanel.add(jLabel);
        this.cbSegmentType = new JComboBox<String>(SnapshotOracle.SEGMENT_TYPE_STATES);
        this.setBG(this.cbSegmentType);
        this.cbSegmentType.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbSegmentType);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 230);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbSegmentType, 230);
    }

    private void initRollbackSegment() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.RollbackSegment"));
        this.refreshPanel.add(jLabel);
        this.cbRollbackSegment = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getRollbackSegmentSet().toArray(), this.cbRollbackSegment);
        }
        this.setBG(this.cbRollbackSegment);
        this.cbRollbackSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbRollbackSegment);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 260);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbRollbackSegment, 260);
    }

    protected JPanel initPartitioningView() {
        this.partitionPropertyTab = new PartitionPropertyTabOraclev10g(this.getAppView(), this.getStorageDesign(), this.getStorageObject(), this);
        return this.partitionPropertyTab.addTab(this.getPane());
    }

    protected SpringLayout getRefreshLayout() {
        return (SpringLayout)this.refreshPanel.getLayout();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.bodyPanel.getLayout();
    }

    protected SpringLayout getClusterColumnsLayout() {
        return (SpringLayout)this.clusterColumnsPanel.getLayout();
    }

    protected boolean isPartitioned() {
        return this.cbPartitioned.getSelectedItem().equals(YES);
    }

    protected boolean isIndexOrg() {
        return this.cbUseIndex.getSelectedItem().equals(YES);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.snapshot.getName());
        this.tfName.setText(this.snapshot.getName());
        this.tfImplementedTable.setText(this.snapshot.getImplementedTable() != null ? this.snapshot.getImplementedTable().getName() : "");
        this.cbOwner.setSelectedItem(this.snapshot.getUser());
        this.cbLobStorage.setSelectedItem(this.snapshot.getLobStorage());
        this.cbPartitioned.setSelectedItem(SnapshotPropertyDialogOraclev10g.translateYesNoForDisplay(this.snapshot.getPartitioned()));
        this.cbSegment.setSelectedItem(this.snapshot.getSegment());
        this.cbCluster.setSelectedItem(this.snapshot.getCluster());
        this.cbParalelClause.setSelectedItem(SnapshotPropertyDialogOraclev10g.translateYesNoForDisplay(this.snapshot.getParalelClause()));
        this.cbBuild.setSelectedItem(this.snapshot.getBuild());
        this.cbReducedPrecision.setSelectedItem(SnapshotPropertyDialogOraclev10g.translateYesNoForDisplay(this.snapshot.getReducedPrecision()));
        if (this.snapshot.getImplementedTable() != null) {
            this.cbOnPrebuild.setEnabled(false);
        } else {
            this.cbOnPrebuild.setSelectedItem(this.snapshot.getOnPrebuildTable());
        }
        this.cbUseIndex.setSelectedItem(SnapshotPropertyDialogOraclev10g.translateNoneYesNoForDisplay(this.snapshot.getUseIndex()));
        this.cbForUpdate.setSelectedItem(SnapshotPropertyDialogOraclev10g.translateYesNoForDisplay(this.snapshot.getForUpdate()));
        this.cbQueryRewrite.setSelectedItem(this.snapshot.getQueryRewrite());
        this.cbTablespace.setSelectedItem(this.snapshot.getTablespace());
        this.cbIndexTablespace.setSelectedItem(this.snapshot.getIndexTablespace());
        this.cbLogging.setSelectedItem(SnapshotPropertyDialogOraclev10g.translateNoneYesNoForDisplay(this.snapshot.getLogging()));
        this.cbCache.setSelectedItem(SnapshotPropertyDialogOraclev10g.translateNoneYesNoForDisplay(this.snapshot.getCache()));
        this.taBody.setText(this.snapshot.getSubquery());
        this.clusterColumnsBody.setText(this.snapshot.getClusterColumns());
        this.cbRefresh.setSelectedItem(this.snapshot.getRefresh());
        this.cbRefreshType.setSelectedItem(this.snapshot.getRefreshType());
        this.cbAction.setSelectedItem(this.snapshot.getAction());
        if (this.cbAction.getSelectedIndex() == 0) {
            this.tfStartDate.setText(this.snapshot.getStartDate());
            this.tfNextDate.setText(this.snapshot.getNextDate());
        }
        this.cbWith.setSelectedItem(this.snapshot.getWith());
        this.cbDefaultSegment.setSelectedItem(SnapshotPropertyDialogOraclev10g.translateYesNoForDisplay(this.snapshot.getDefaultSegment()));
        this.cbSegmentType.setSelectedItem(this.snapshot.getSegmentType());
        this.cbRollbackSegment.setSelectedItem(this.snapshot.getRollbackSegment());
        this.cbUsingConstraint.setSelectedItem(this.snapshot.getUsingConstraint());
        this.partitionPropertyTab.initProperties();
        this.getCommentsList().insert(this.snapshot.getComment(), 0);
        this.taCommentsInRDBMS.insert(this.snapshot.getCommentInRDBMS(), 0);
        this.taNotes.setText(this.snapshot.getNotes());
        this.updateDates();
        this.updateRollbackSegment();
        this.clusterStateChanged();
    }

    @Override
    protected void setProperties() {
        if (this.snapshot != null) {
            this.snapshot.setUser((UserOraclev10g)this.cbOwner.getSelectedItem());
            this.snapshot.setName(this.tfName.getText());
            this.snapshot.setLobStorage((LobStorageOraclev10g)this.cbLobStorage.getSelectedItem());
            this.snapshot.setPartitioned(SnapshotPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.snapshot.setSegment((SegmentOraclev10g)this.cbSegment.getSelectedItem());
            this.snapshot.setCluster((ClusterOraclev10g)this.cbCluster.getSelectedItem());
            this.snapshot.setParalelClause(SnapshotPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbParalelClause.getSelectedItem()));
            this.snapshot.setBuild((String)this.cbBuild.getSelectedItem());
            this.snapshot.setReducedPrecision(SnapshotPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbReducedPrecision.getSelectedItem()));
            if (this.cbOnPrebuild.getSelectedItem() instanceof String) {
                this.snapshot.setOnPrebuildTable(null);
            } else {
                this.snapshot.setOnPrebuildTable((TableProxyOraclev10g)this.cbOnPrebuild.getSelectedItem());
            }
            this.snapshot.setUseIndex(SnapshotPropertyDialogOraclev10g.translateNoneYesNoForStorage((String)this.cbUseIndex.getSelectedItem()));
            this.snapshot.setForUpdate(SnapshotPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbForUpdate.getSelectedItem()));
            this.snapshot.setQueryRewrite((String)this.cbQueryRewrite.getSelectedItem());
            this.snapshot.setTablespace((TableSpaceOraclev10g)this.cbTablespace.getSelectedItem());
            this.snapshot.setIndexTablespace((TableSpaceOraclev10g)this.cbIndexTablespace.getSelectedItem());
            this.snapshot.setLogging(SnapshotPropertyDialogOraclev10g.translateNoneYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            this.snapshot.setCache(SnapshotPropertyDialogOraclev10g.translateNoneYesNoForStorage((String)this.cbCache.getSelectedItem()));
            this.snapshot.setSubquery(this.taBody.getText());
            this.snapshot.setClusterColumns(this.clusterColumnsBody.getText());
            this.partitionPropertyTab.setProperties(this.isPartitioned());
            this.snapshot.setRefresh((String)this.cbRefresh.getSelectedItem());
            this.snapshot.setRefreshType((String)this.cbRefreshType.getSelectedItem());
            this.snapshot.setAction((String)this.cbAction.getSelectedItem());
            if (this.cbAction.getSelectedIndex() == 0) {
                this.snapshot.setStartDate(this.tfStartDate.getText());
                this.snapshot.setNextDate(this.tfNextDate.getText());
            }
            this.snapshot.setWith((String)this.cbWith.getSelectedItem());
            this.snapshot.setDefaultSegment(SnapshotPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbDefaultSegment.getSelectedItem()));
            this.snapshot.setSegmentType((String)this.cbSegmentType.getSelectedItem());
            this.snapshot.setRollbackSegment((RollbackSegmentOracle)this.cbRollbackSegment.getSelectedItem());
            this.snapshot.setUsingConstraint((String)this.cbUsingConstraint.getSelectedItem());
            this.snapshot.setComment(this.getCommentsList().getText());
            this.snapshot.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
            this.snapshot.setNotes(this.taNotes.getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbOwner.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    @Override
    protected void postProcessingInApply() {
        if (this.partitionPropertyTab != null) {
            this.partitionPropertyTab.postProcessingInApply();
        }
    }

    @Override
    protected void clearOnDispose() {
        if (this.partitionPropertyTab != null) {
            this.partitionPropertyTab.clearOnDispose();
        }
    }

    private class PartitionedAction
    implements ActionListener {
        private PartitionedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = SnapshotPropertyDialogOraclev10g.this.isPartitioned();
            int n = SnapshotPropertyDialogOraclev10g.this.getPane().indexOfComponent(SnapshotPropertyDialogOraclev10g.this.partitioningTab);
            if (n > -1) {
                SnapshotPropertyDialogOraclev10g.this.getPane().setEnabledAt(n, bl);
            }
            SnapshotPropertyDialogOraclev10g.this.partitionPropertyTab.reinitPartitioning(bl);
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SnapshotPropertyDialogOraclev10g.this.dialog = new ObjectPermissionsDialogOracle(SnapshotPropertyDialogOraclev10g.this.getAppView(), SnapshotPropertyDialogOraclev10g.this.getStorageDesign(), SnapshotPropertyDialogOraclev10g.this.snapshot);
            SnapshotPropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }

    private class OrganizationListener
    implements ActionListener {
        private OrganizationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SnapshotPropertyDialogOraclev10g.this.cbCache.setEnabled(!SnapshotPropertyDialogOraclev10g.this.isIndexOrg());
            SnapshotPropertyDialogOraclev10g.this.partitionPropertyTab.enableRelevantPartitionFields(SnapshotPropertyDialogOraclev10g.this.isPartitioned());
        }
    }

    private class PrebuildListener
    implements ActionListener {
        private PrebuildListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SnapshotPropertyDialogOraclev10g.this.cbOnPrebuild.getSelectedItem() != null && SnapshotPropertyDialogOraclev10g.this.cbOnPrebuild.getSelectedItem() instanceof TableProxyOraclev10g) {
                TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)SnapshotPropertyDialogOraclev10g.this.cbOnPrebuild.getSelectedItem();
                SnapshotPropertyDialogOraclev10g.this.tfName.setText(tableProxyOraclev10g.getName());
                SnapshotPropertyDialogOraclev10g.this.tfName.setEnabled(false);
            } else if (SnapshotPropertyDialogOraclev10g.this.cbOnPrebuild.getSelectedItem() != null && SnapshotPropertyDialogOraclev10g.this.cbOnPrebuild.getSelectedItem() instanceof String) {
                SnapshotPropertyDialogOraclev10g.this.tfName.setEnabled(true);
            } else if (SnapshotPropertyDialogOraclev10g.this.cbOnPrebuild.getSelectedItem() == null) {
                SnapshotPropertyDialogOraclev10g.this.tfName.setEnabled(true);
                SnapshotPropertyDialogOraclev10g.this.tfName.setText(SnapshotPropertyDialogOraclev10g.this.snapshot.getName());
            }
        }
    }
}

