/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractPropertyTabOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.SnapshotPropertyDialogOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TablePropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class PartitionPropertyTabOraclev10g
extends AbstractPropertyTabOracle {
    private AbstractOraclePropertyDialog parentDialog;
    protected StorageObject ownerStorageObject;
    protected PartitionListOraclev10g partList;
    protected boolean useColumnProxies = false;
    protected JTabbedPane tpPartitions;
    protected JPanel pnPartGeneral;
    protected JComboBox cbPartType;
    private JComboBox cbUseSubpartitionsStorageTemplate;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAdd;
    private JButton bnRemove;
    private JTextArea taColumns;
    private JPanel hashPTS;
    private int hashPTSTabIndex;
    private JIntegerField ifHashPQuantity;
    private JList allHashPTSList;
    private JList selectedHashPTSList;
    private DefaultListModel allHashPTSModel;
    private DefaultListModel selectedHashPTSModel;
    private JButton bnAddHashPTS;
    private JButton bnRemoveHashPTS;
    private JList allIOTOverflowHashPTSList;
    private JList selectedIOTOverflowHashPTSList;
    private DefaultListModel allIOTOverflowHashPTSModel;
    private DefaultListModel selectedIOTOverflowHashPTSModel;
    private JButton bnAddIOTOverflowHashPTS;
    private JButton bnRemoveIOTOverflowHashPTS;
    private JPanel subPartColumns;
    private int subPartColumnsTabIndex;
    protected JList allSubPartColumnsList;
    private JList selectedSubPartColumnsList;
    protected DefaultListModel allSubPartColumnsModel;
    protected DefaultListModel selectedSubPartColumnsModel;
    private JButton bnAddSubPartColumns;
    private JButton bnRemoveSubPartColumns;
    private JTextArea taSubPartColumns;
    private JPanel subPartTS;
    private int subPartTSTabIndex;
    private JIntegerField ifSubPartQuantity;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JPanel partitionsOrder;
    private JTable partitionsOrderTable;
    private List partitions;
    private DefaultListSelectionModel partSelectionModel;
    private PartitionsOrderModel partitionsOrderModel;
    private boolean ordered = false;
    private JTable subPartitionsOrderTable;
    private List subPartitions;
    private DefaultListSelectionModel subPartSelectionModel;
    private SubPartitionsOrderModel subPartitionsOrderModel;
    private boolean subPartOrdered = false;

    public PartitionPropertyTabOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject, AbstractOraclePropertyDialog abstractOraclePropertyDialog) {
        super(applicationView, storageDesign, storageObject);
        this.parentDialog = abstractOraclePropertyDialog;
        this.ownerStorageObject = storageObject;
        if (storageObject instanceof TableProxyOracle) {
            this.partList = (PartitionListOraclev10g)((TableProxyOracle)storageObject).getPartitionList();
            this.useColumnProxies = true;
        } else if (storageObject instanceof SnapshotOracle) {
            this.partList = (PartitionListOraclev10g)((SnapshotOracle)storageObject).getPartitionList();
            this.useColumnProxies = false;
        }
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    public JPanel addTab(JTabbedPane jTabbedPane) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jTabbedPane.addTab(Messages.getString("PartitionPropertyTabOraclev10g.Partitioning"), jPanel);
        this.tpPartitions = new JTabbedPane();
        jPanel.add((Component)this.tpPartitions, "Center");
        this.pnPartGeneral = new JPanel(new SpringLayout());
        this.hashPTS = new JPanel(new SpringLayout());
        this.subPartColumns = new JPanel(new SpringLayout());
        this.subPartTS = new JPanel(new SpringLayout());
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.General"), this.pnPartGeneral);
        this.addIntervalTab();
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.HashPartTableSpaces"), this.hashPTS);
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.SubPartColumns"), this.subPartColumns);
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.HashSubPartTableSpaces"), this.subPartTS);
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.PartitionsOrder"), this.partitionsOrder);
        this.hashPTSTabIndex = this.tpPartitions.indexOfComponent(this.hashPTS);
        this.subPartColumnsTabIndex = this.tpPartitions.indexOfComponent(this.subPartColumns);
        this.subPartTSTabIndex = this.tpPartitions.indexOfComponent(this.subPartTS);
        this.initPartitioning();
        return jPanel;
    }

    protected void addIntervalTab() {
    }

    protected SpringLayout getHashPTSLayout() {
        return (SpringLayout)this.hashPTS.getLayout();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    protected SpringLayout getSubPartColumnsLayout() {
        return (SpringLayout)this.subPartColumns.getLayout();
    }

    protected SpringLayout getGeneralPartitioningLayout() {
        return (SpringLayout)this.pnPartGeneral.getLayout();
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    private void initPartitioning() {
        this.initGeneralPartitioning();
        this.initHashPTS();
        this.initSubPartColumns();
        this.initSubPartTS();
        this.initPartitionsOrderPanel();
    }

    protected void initGeneralPartitioning() {
        this.initPartType();
        this.initUseSubpartitionsStorageTemplate(50);
        if (this.useColumnProxies) {
            this.initAllColumnsList(84, 410);
            this.initSelectedColumnsList(84, 410);
            this.initButtons();
        } else {
            this.initColumnsTextArea(80, 415);
        }
    }

    protected void initColumnsTextArea(int n, int n2) {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.PartitioningColumns"));
        this.pnPartGeneral.add(jLabel);
        this.taColumns = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taColumns);
        jScrollPane.setPreferredSize(new Dimension(395, n2));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(jScrollPane);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, n);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), jScrollPane, 10, n + 20);
    }

    private void initHashPTS() {
        this.initHashPQuantity();
        this.initAllHashPTSList();
        this.initSelectedHashPTSList();
        this.initHashPTSButtons();
        this.initAllIOTOverflowHashPTSList();
        this.initSelectedIOTOverflowHashPTSList();
        this.initIOTOverflowHashPTSButtons();
    }

    private void initSubPartColumns() {
        if (this.useColumnProxies) {
            this.initAllSubPartColumnsList();
            this.initSelectedSubPartColumnsList();
            this.initSubPartColumnsButtons();
        } else {
            this.taSubPartColumns = new JTextArea();
            JScrollPane jScrollPane = new JScrollPane(this.taSubPartColumns);
            jScrollPane.setPreferredSize(new Dimension(395, 505));
            jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
            this.subPartColumns.add(jScrollPane);
            this.setObjectConstraints(this.getSubPartColumnsLayout(), jScrollPane, 10, 12);
        }
    }

    private void initSubPartTS() {
        this.initSubPartQuantity();
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initPartitionsOrderPanel() {
        this.initPartitionsOrder();
        this.initSubPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.Properties"));
        jButton.addActionListener(new PartitionPropertiesAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        if (this.isEditable()) {
            jComponent = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
            jComponent.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveUp"));
            ((AbstractButton)jComponent).addActionListener(new MoveUpAction2());
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
            jButton2.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveDown"));
            jButton2.addActionListener(new MoveDownAction2());
            jToolBar.addSeparator();
            jToolBar.add(jComponent);
            jToolBar.add(jButton2);
        }
        jPanel.add(jToolBar);
        this.partitionsOrder.add(jPanel);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), jPanel, 10, 0);
        this.partitionsOrderModel = new PartitionsOrderModel();
        this.partSelectionModel = new DefaultListSelectionModel();
        this.partSelectionModel.setSelectionMode(2);
        this.partitionsOrderTable = new JTable(this.partitionsOrderModel);
        this.partitionsOrderTable.setSelectionModel(this.partSelectionModel);
        jComponent = new JScrollPane(this.partitionsOrderTable);
        jComponent.setPreferredSize(new Dimension(400, 240));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(jComponent);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), jComponent, 6, 40);
        this.getPartitions().setForbiddenCreateElement(true);
        this.partitions = new ArrayList();
        this.getPartitions().addAllElementsTo(this.partitions);
    }

    private void initSubPartitionsOrder() {
        Object object;
        JComponent jComponent;
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SubPartitionTemplates"));
        this.partitionsOrder.add(jLabel);
        this.setLabelConstraints(this.getPartitionsOrderLayout(), jLabel, 300);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.Properties"));
        jButton.addActionListener(new SubPartitionPropertiesAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        if (this.isEditable()) {
            jComponent = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
            jComponent.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveUp"));
            ((AbstractButton)jComponent).addActionListener(new SubMoveUpAction());
            object = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
            ((JComponent)object).setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveDown"));
            ((AbstractButton)object).addActionListener(new SubMoveDownAction());
            jToolBar.addSeparator();
            jToolBar.add(jComponent);
            jToolBar.add((Component)object);
        }
        jPanel.add(jToolBar);
        this.partitionsOrder.add(jPanel);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), jPanel, 10, 315);
        this.subPartitionsOrderModel = new SubPartitionsOrderModel();
        this.subPartSelectionModel = new DefaultListSelectionModel();
        this.subPartSelectionModel.setSelectionMode(2);
        this.subPartitionsOrderTable = new JTable(this.subPartitionsOrderModel);
        this.subPartitionsOrderTable.setSelectionModel(this.subPartSelectionModel);
        jComponent = new JScrollPane(this.subPartitionsOrderTable);
        jComponent.setPreferredSize(new Dimension(400, 155));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(jComponent);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), jComponent, 6, 355);
        this.subPartitions = new ArrayList();
        object = this.getSubPartitionTemplates();
        if (object != null) {
            ((StorageObjectCollection)object).setForbiddenCreateElement(true);
            ((ModelObjectSet)object).addAllElementsTo(this.subPartitions);
        }
    }

    protected void initPartType() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.PartitionType"));
        this.pnPartGeneral.add(jLabel);
        this.cbPartType = new JComboBox<String>(this.getPartitionTypes());
        this.setBG(this.cbPartType);
        this.cbPartType.addActionListener(new PartitionTypeListener());
        this.pnPartGeneral.add(this.cbPartType);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 20);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbPartType, 20);
    }

    protected String[] getPartitionTypes() {
        return PartitionListOraclev10g.getPartitionTypes();
    }

    protected void initUseSubpartitionsStorageTemplate(int n) {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.UseSPTemplate"));
        this.pnPartGeneral.add(jLabel);
        this.cbUseSubpartitionsStorageTemplate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbUseSubpartitionsStorageTemplate);
        this.cbUseSubpartitionsStorageTemplate.setPreferredSize(this.cbPartType.getPreferredSize());
        this.cbUseSubpartitionsStorageTemplate.addActionListener(new PartitionTypeListener());
        this.pnPartGeneral.add(this.cbUseSubpartitionsStorageTemplate);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, n);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbUseSubpartitionsStorageTemplate, n);
    }

    private void initHashPQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.HashPQuantity"));
        this.hashPTS.add(jLabel);
        this.ifHashPQuantity = new JIntegerField(0, 26);
        this.hashPTS.add(this.ifHashPQuantity);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 20);
        this.setObjectConstraints(this.getHashPTSLayout(), this.ifHashPQuantity, 20);
    }

    private void initAllHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllTableSpaces"));
        this.hashPTS.add(jLabel);
        this.allHashPTSModel = new DefaultListModel();
        this.allHashPTSList = new JList(this.allHashPTSModel);
        ListSelectionModel listSelectionModel = this.allHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 8, 54);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 6, 72);
    }

    private void initSelectedHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.HashPTableSpaces"));
        this.hashPTS.add(jLabel);
        this.selectedHashPTSModel = new DefaultListModel();
        this.selectedHashPTSList = new JList(this.selectedHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 292, 54);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 290, 72);
    }

    private void initHashPTSButtons() {
        this.bnAddHashPTS = new JButton(ADD_CAPTION);
        this.bnAddHashPTS.addActionListener(new AddHashPTSActionListener());
        this.bnAddHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddHashPTS, 175, 135);
        this.bnRemoveHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashPTS.setEnabled(false);
        this.bnRemoveHashPTS.addActionListener(new RemoveHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveHashPTS, 175, 165);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddHashPTS, this.bnRemoveHashPTS);
    }

    private void initAllIOTOverflowHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllTableSpaces"));
        this.hashPTS.add(jLabel);
        this.allIOTOverflowHashPTSModel = new DefaultListModel();
        this.allIOTOverflowHashPTSList = new JList(this.allIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.allIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIOTOverflowHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allIOTOverflowHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 8, 294);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 6, 312);
    }

    private void initSelectedIOTOverflowHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.IOTOverflowTS"));
        this.hashPTS.add(jLabel);
        this.selectedIOTOverflowHashPTSModel = new DefaultListModel();
        this.selectedIOTOverflowHashPTSList = new JList(this.selectedIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIOTOverflowHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedIOTOverflowHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 292, 294);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 290, 312);
    }

    private void initIOTOverflowHashPTSButtons() {
        this.bnAddIOTOverflowHashPTS = new JButton(ADD_CAPTION);
        this.bnAddIOTOverflowHashPTS.addActionListener(new AddIOTOverflowHashPTSActionListener());
        this.bnAddIOTOverflowHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddIOTOverflowHashPTS, 175, 370);
        this.bnRemoveIOTOverflowHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
        this.bnRemoveIOTOverflowHashPTS.addActionListener(new RemoveIOTOverflowHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveIOTOverflowHashPTS, 175, 400);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddIOTOverflowHashPTS, this.bnRemoveIOTOverflowHashPTS);
    }

    private ColumnProxy[] getColumnProxies() {
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            return ((TableProxyOracle)this.ownerStorageObject).getColumnProxies();
        }
        return new ColumnProxy[0];
    }

    protected void initPartColumns(PartitionListOraclev10g partitionListOraclev10g) {
        if (this.useColumnProxies) {
            ColumnProxy[] columnProxyArray = this.getColumnProxies();
            for (int i = 0; i < columnProxyArray.length; ++i) {
                ColumnProxy columnProxy = columnProxyArray[i];
                if (partitionListOraclev10g != null && partitionListOraclev10g.getColumnSet().contains(columnProxy.getObjectID())) {
                    this.selectedColumnsModel.addElement(columnProxy);
                    continue;
                }
                this.allColumnsModel.addElement(columnProxy);
            }
        } else if (this.ownerStorageObject instanceof SnapshotOracle) {
            this.taColumns.setText(((SnapshotOracle)this.ownerStorageObject).getColumns());
        }
    }

    private void initHashPTS(PartitionListOraclev10g partitionListOraclev10g) {
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (partitionListOraclev10g != null && partitionListOraclev10g.getHashPartitionsTableSpacesSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedHashPTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allHashPTSModel.addElement(tableSpaceOracle);
        }
    }

    private void initIOTOverflowHashPTS(PartitionListOraclev10g partitionListOraclev10g) {
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (partitionListOraclev10g != null && partitionListOraclev10g.getIOTOverflowHashPTSSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedIOTOverflowHashPTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allIOTOverflowHashPTSModel.addElement(tableSpaceOracle);
        }
    }

    protected void initSubPartColumns(PartitionListOraclev10g partitionListOraclev10g) {
        if (this.useColumnProxies) {
            ColumnProxy[] columnProxyArray = this.getColumnProxies();
            for (int i = 0; i < columnProxyArray.length; ++i) {
                ColumnProxy columnProxy = columnProxyArray[i];
                if (partitionListOraclev10g != null && partitionListOraclev10g.getSubPartitionsColumnsSet().contains(columnProxy.getObjectID())) {
                    this.selectedSubPartColumnsModel.addElement(columnProxy);
                    continue;
                }
                this.allSubPartColumnsModel.addElement(columnProxy);
            }
        } else if (this.ownerStorageObject instanceof SnapshotOracle) {
            this.taSubPartColumns.setText(((SnapshotOracle)this.ownerStorageObject).getSubPartColumns());
        }
    }

    private void initSubPartTS(PartitionListOraclev10g partitionListOraclev10g) {
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
            if (partitionListOraclev10g != null && partitionListOraclev10g.getSubPartitionsTableSpacesSet().contains(tableSpaceOracle.getObjectID())) {
                this.selectedSubPartTSModel.addElement(tableSpaceOracle);
                continue;
            }
            this.allSubPartTSModel.addElement(tableSpaceOracle);
        }
    }

    protected void initAllColumnsList(int n, int n2) {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllColumns"));
        this.pnPartGeneral.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, n2));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(jScrollPane);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 8, n);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), jScrollPane, 6, n + 18);
    }

    protected void initSelectedColumnsList(int n, int n2) {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SelectedColumns"));
        this.pnPartGeneral.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, n2));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(jScrollPane);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 292, n);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), jScrollPane, 290, n + 18);
    }

    protected void initButtons() {
        this.bnAdd = new JButton(ADD_CAPTION);
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.pnPartGeneral.add(this.bnAdd);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.bnAdd, 175, 265);
        this.bnRemove = new JButton(REMOVE_CAPTION);
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.pnPartGeneral.add(this.bnRemove);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.bnRemove, 175, 295);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void initAllSubPartColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllColumns"));
        this.subPartColumns.add(jLabel);
        this.allSubPartColumnsModel = new DefaultListModel();
        this.allSubPartColumnsList = new JList(this.allSubPartColumnsModel);
        ListSelectionModel listSelectionModel = this.allSubPartColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSubPartColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 490));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartColumnsLayout(), jLabel, 8, 4);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), jScrollPane, 6, 22);
    }

    private void initSelectedSubPartColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SelectedColumns"));
        this.subPartColumns.add(jLabel);
        this.selectedSubPartColumnsModel = new DefaultListModel();
        this.selectedSubPartColumnsList = new JList(this.selectedSubPartColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSubPartColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 490));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartColumnsLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), jScrollPane, 290, 22);
    }

    private void initSubPartColumnsButtons() {
        this.bnAddSubPartColumns = new JButton(ADD_CAPTION);
        this.bnAddSubPartColumns.addActionListener(new AddSubPartColumnsActionListener());
        this.bnAddSubPartColumns.setEnabled(false);
        this.subPartColumns.add(this.bnAddSubPartColumns);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), this.bnAddSubPartColumns, 175, 230);
        this.bnRemoveSubPartColumns = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartColumns.setEnabled(false);
        this.bnRemoveSubPartColumns.addActionListener(new RemoveSubPartColumnsActionListener());
        this.subPartColumns.add(this.bnRemoveSubPartColumns);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), this.bnRemoveSubPartColumns, 175, 260);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddSubPartColumns, this.bnRemoveSubPartColumns);
    }

    private void initSubPartQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SubPartQuantity"));
        this.subPartTS.add(jLabel);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.subPartTS.add(this.ifSubPartQuantity);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 20);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.ifSubPartQuantity, 20);
    }

    private void initAllSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllTableSpaces"));
        this.subPartTS.add(jLabel);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 440));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 8, 54);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 6, 72);
    }

    private void initSelectedSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SelectedTableSpaces"));
        this.subPartTS.add(jLabel);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 440));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 292, 54);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 290, 72);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(ADD_CAPTION);
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 175, 230);
        this.bnRemoveSubPartTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 175, 260);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    protected void initProperties() {
        if (this.partList != null) {
            this.cbPartType.setSelectedItem(this.partList.getPartitionType());
            this.ifHashPQuantity.setValue((long)this.partList.getHashPQuantity());
            this.ifSubPartQuantity.setValue((long)this.partList.getSubPartitionsQuantity());
            this.cbUseSubpartitionsStorageTemplate.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.partList.getUseSubpartStorageTemplate()));
            this.reinitPartitioning(true);
        } else {
            this.ifHashPQuantity.setValue(1L);
            this.ifSubPartQuantity.setValue(1L);
            this.cbUseSubpartitionsStorageTemplate.setSelectedItem(NO);
        }
    }

    protected void reinitPartitioning(boolean bl) {
        if (this.useColumnProxies) {
            this.allColumnsModel.clear();
            this.selectedColumnsModel.clear();
            this.allSubPartColumnsModel.clear();
            this.selectedSubPartColumnsModel.clear();
        }
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        this.allIOTOverflowHashPTSModel.clear();
        this.selectedIOTOverflowHashPTSModel.clear();
        this.allSubPartTSModel.clear();
        this.selectedSubPartTSModel.clear();
        this.cbPartType.setEnabled(bl);
        this.enableRelevantPartitionFields(bl);
        if (bl) {
            this.initPartColumns(this.partList);
            this.initHashPTS(this.partList);
            this.initIOTOverflowHashPTS(this.partList);
            this.initSubPartColumns(this.partList);
            this.initSubPartTS(this.partList);
        }
    }

    protected void enableRelevantPartitionFields(boolean bl) {
        boolean bl2;
        String string = "";
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (bl) {
            string = (String)this.cbPartType.getSelectedItem();
            bl3 = string.equalsIgnoreCase("HASH BY QUANTITY");
            bl4 = this.isSubpartitioned(string);
            bl5 = this.isHashSubpartitioned(string);
            bl6 = string.equalsIgnoreCase("RANGE") || string.equalsIgnoreCase("LIST") || string.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || bl3 || bl4;
        }
        this.cbUseSubpartitionsStorageTemplate.setEnabled(bl4);
        if (this.useColumnProxies) {
            this.allColumnsList.setEnabled(bl6);
            this.selectedColumnsList.setEnabled(bl6);
            this.bnAdd.setEnabled(bl6 && this.allColumnsList.getSelectedIndex() != -1);
            this.bnRemove.setEnabled(bl6 && this.selectedColumnsList.getSelectedIndex() != -1);
        } else {
            this.taColumns.setEnabled(bl6);
        }
        this.tpPartitions.setEnabledAt(this.subPartColumnsTabIndex, bl4);
        if (bl4 && this.useColumnProxies) {
            this.bnAddSubPartColumns.setEnabled(this.allSubPartColumnsList.getSelectedIndex() != -1);
            this.bnRemoveSubPartColumns.setEnabled(this.selectedSubPartColumnsList.getSelectedIndex() != -1);
        }
        this.tpPartitions.setEnabledAt(this.hashPTSTabIndex, bl3);
        if (bl3) {
            this.bnAddHashPTS.setEnabled(this.allHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveHashPTS.setEnabled(this.selectedHashPTSList.getSelectedIndex() != -1);
            bl2 = this.isIndexOrg();
            this.allIOTOverflowHashPTSList.setEnabled(bl2);
            this.selectedIOTOverflowHashPTSList.setEnabled(bl2);
            this.bnAddIOTOverflowHashPTS.setEnabled(bl2 && this.allIOTOverflowHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveIOTOverflowHashPTS.setEnabled(bl2 && this.selectedIOTOverflowHashPTSList.getSelectedIndex() != -1);
        }
        bl2 = bl5 && ((String)this.cbUseSubpartitionsStorageTemplate.getSelectedItem()).equalsIgnoreCase(NO);
        this.tpPartitions.setEnabledAt(this.subPartTSTabIndex, bl2);
        if (bl2) {
            this.bnAddSubPartTS.setEnabled(this.allSubPartTSList.getSelectedIndex() != -1);
            this.bnRemoveSubPartTS.setEnabled(this.selectedSubPartTSList.getSelectedIndex() != -1);
        }
    }

    protected boolean isSubpartitioned(String string) {
        return string.equalsIgnoreCase("COMPOSITE BY HASH") || string.equalsIgnoreCase("COMPOSITE BY LIST");
    }

    protected boolean isHashSubpartitioned(String string) {
        return string.equalsIgnoreCase("COMPOSITE BY HASH");
    }

    protected boolean isListSubpartitioned(String string) {
        return string.equalsIgnoreCase("COMPOSITE BY LIST");
    }

    protected boolean isPartitioned() {
        if (this.parentDialog instanceof TablePropertyDialogOraclev10g) {
            return ((TablePropertyDialogOraclev10g)this.parentDialog).isPartitioned();
        }
        if (this.parentDialog instanceof SnapshotPropertyDialogOraclev10g) {
            return ((SnapshotPropertyDialogOraclev10g)this.parentDialog).isPartitioned();
        }
        return false;
    }

    private boolean isIndexOrg() {
        if (this.parentDialog instanceof TablePropertyDialogOraclev10g) {
            return ((TablePropertyDialogOraclev10g)this.parentDialog).isIndexOrg();
        }
        if (this.parentDialog instanceof SnapshotPropertyDialogOraclev10g) {
            return ((SnapshotPropertyDialogOraclev10g)this.parentDialog).isIndexOrg();
        }
        return false;
    }

    protected void setProperties(boolean bl) {
        if (bl) {
            StorageObjectCollection storageObjectCollection;
            int n;
            int n2;
            StorageObjectCollection storageObjectCollection2;
            int n3;
            Object object;
            boolean bl2;
            if (this.partList == null) {
                this.partList = (PartitionListOraclev10g)this.getStorageDesign().getPartitionListSet().createPartitionList();
            }
            String string = (String)this.cbPartType.getSelectedItem();
            this.partList.setPartitionType(string);
            this.partList.setUseSubpartStorageTemplate(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbUseSubpartitionsStorageTemplate.getSelectedItem()));
            this.partList.setHashPQuantity(this.ifHashPQuantity.getIntValue());
            this.partList.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
            if (this.ownerStorageObject instanceof TableProxyOracle) {
                ((TableProxyOracle)this.ownerStorageObject).setPartitionList(this.partList);
            } else if (this.ownerStorageObject instanceof SnapshotOracle) {
                ((SnapshotOracle)this.ownerStorageObject).setPartitionList(this.partList);
            }
            this.partList.clear();
            if (this.useColumnProxies) {
                Object[] objectArray = this.selectedColumnsModel.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (!(object2 instanceof RelationalObjectProxy)) continue;
                    this.partList.setColumnIDs(((RelationalObjectProxy)object2).getObjectID());
                }
            } else if (this.ownerStorageObject instanceof SnapshotOracle) {
                ((SnapshotOracle)this.ownerStorageObject).setColumns(this.taColumns.getText());
            }
            if (bl2 = string.equalsIgnoreCase("HASH BY QUANTITY")) {
                Object[] objectArray = this.selectedHashPTSModel.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = objectArray[i];
                    if (!(object instanceof TableSpaceOracle)) continue;
                    this.partList.setHashPTableSpaces(((TableSpaceOracle)object).getObjectID());
                }
            }
            if (bl2 && this.isIndexOrg()) {
                Object[] objectArray = this.selectedIOTOverflowHashPTSModel.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = objectArray[i];
                    if (!(object instanceof TableSpaceOracle)) continue;
                    this.partList.setIOTOverflowHashPTSSet(((TableSpaceOracle)object).getObjectID());
                }
            }
            if (this.isSubpartitioned(string)) {
                if (this.useColumnProxies) {
                    if (this.isSubpartitioned(string)) {
                        Object[] objectArray = this.selectedSubPartColumnsModel.toArray();
                        for (int i = 0; i < objectArray.length; ++i) {
                            object = objectArray[i];
                            if (!(object instanceof RelationalObjectProxy)) continue;
                            this.partList.setSubPartitionsColumnIDs(((RelationalObjectProxy)object).getObjectID());
                        }
                    }
                } else if (this.ownerStorageObject instanceof SnapshotOracle) {
                    ((SnapshotOracle)this.ownerStorageObject).setSubPartColumns(this.taSubPartColumns.getText());
                }
                Object[] objectArray = this.selectedSubPartTSModel.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = objectArray[i];
                    if (!(object instanceof TableSpaceOracle)) continue;
                    this.partList.setSubPartitionsTableSpaces(((TableSpaceOracle)object).getObjectID());
                }
            }
            if (this.ordered && (n3 = (storageObjectCollection2 = this.getPartitions()).size()) == this.partitions.size()) {
                this.ordered = false;
                for (int i = 0; i < n3; ++i) {
                    storageObjectCollection2.justRemove(storageObjectCollection2.getElement(0));
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.partitions.get(n2) instanceof PartitionOracle) {
                        PartitionOracle partitionOracle = (PartitionOracle)this.partitions.get(n2);
                        partitionOracle.setParent(storageObjectCollection2);
                        storageObjectCollection2.add(partitionOracle);
                        partitionOracle.setPosition(n2 + 1);
                        continue;
                    }
                    storageObjectCollection2.add((ModelObject)this.partitions.get(n2));
                }
            }
            if (this.subPartOrdered && (n = (storageObjectCollection = this.getSubPartitionTemplates()).size()) == this.subPartitions.size()) {
                this.subPartOrdered = false;
                for (int i = 0; i < n; ++i) {
                    storageObjectCollection.justRemove(storageObjectCollection.getElement(0));
                }
                for (n2 = 0; n2 < n; ++n2) {
                    if (this.subPartitions.get(n2) instanceof PartitionOracle) {
                        PartitionOracle partitionOracle = (PartitionOracle)this.subPartitions.get(n2);
                        partitionOracle.setParent(storageObjectCollection);
                        storageObjectCollection.add(partitionOracle);
                        partitionOracle.setPosition(n2 + 1);
                        continue;
                    }
                    storageObjectCollection.add((ModelObject)this.subPartitions.get(n2));
                }
            }
        } else if (this.partList != null) {
            if (this.ownerStorageObject instanceof TableProxyOracle) {
                ((TableProxyOracle)this.ownerStorageObject).setPartitionList(null);
            } else if (this.ownerStorageObject instanceof SnapshotOracle) {
                ((SnapshotOracle)this.ownerStorageObject).setPartitionList(null);
            }
            this.partList.remove();
            this.partList = null;
        }
    }

    private StorageObjectCollection getPartitions() {
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            return ((TableProxyOracle)this.ownerStorageObject).getPartitions();
        }
        if (this.ownerStorageObject instanceof SnapshotOracle) {
            return ((SnapshotOracle)this.ownerStorageObject).getPartitionsCollection();
        }
        return null;
    }

    private boolean moveToIndex(Object object, int n) {
        if (this.partitions.contains(object) && this.partitions.size() > n && n >= 0) {
            this.partitions.remove(object);
            this.partitions.add(n, object);
            return true;
        }
        return false;
    }

    private StorageObjectCollection getSubPartitionTemplates() {
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            return ((TableProxyOracle)this.ownerStorageObject).getListStorageTemplates();
        }
        return null;
    }

    private boolean subMoveToIndex(Object object, int n) {
        if (this.subPartitions.contains(object) && this.subPartitions.size() > n && n >= 0) {
            this.subPartitions.remove(object);
            this.subPartitions.add(n, object);
            return true;
        }
        return false;
    }

    private void setSelection(DefaultListSelectionModel defaultListSelectionModel, int[] nArray) {
        defaultListSelectionModel.clearSelection();
        if (nArray.length > 0) {
            for (int i = nArray.length - 1; i > -1; --i) {
                defaultListSelectionModel.addSelectionInterval(nArray[i], nArray[i]);
            }
        }
    }

    protected void postProcessingInApply() {
        this.getPartitions().setForbiddenCreateElement(true);
        StorageObjectCollection storageObjectCollection = this.getSubPartitionTemplates();
        if (storageObjectCollection != null) {
            storageObjectCollection.setForbiddenCreateElement(true);
        }
    }

    protected void clearOnDispose() {
        ModelObject modelObject;
        boolean bl = false;
        PartitionListOracle partitionListOracle = null;
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            modelObject = (TableProxyOracle)this.ownerStorageObject;
            bl = ((TableProxyOracle)modelObject).getPartitioned().equals("YES");
            partitionListOracle = ((TableProxyOracle)modelObject).getPartitionList();
        } else if (this.ownerStorageObject instanceof SnapshotOracle) {
            modelObject = (SnapshotOracle)this.ownerStorageObject;
            bl = ((SnapshotOracle)modelObject).getPartitioned().equals("YES");
            partitionListOracle = ((SnapshotOracle)modelObject).getPartitionList();
        }
        this.getPartitions().setForbiddenCreateElement(!bl || partitionListOracle == null || "HASH BY QUANTITY".equalsIgnoreCase(partitionListOracle.getPartitionType()));
        modelObject = this.getSubPartitionTemplates();
        if (modelObject != null) {
            ((StorageObjectCollection)modelObject).setForbiddenCreateElement(!bl || partitionListOracle == null || !((PartitionListOraclev10g)partitionListOracle).getUseSubpartStorageTemplate().equalsIgnoreCase("YES"));
        }
    }

    private class SubMoveDownAction
    implements ActionListener {
        private SubMoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < PartitionPropertyTabOraclev10g.this.subPartitions.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = PartitionPropertyTabOraclev10g.this.subPartitions.get(n);
                    PartitionPropertyTabOraclev10g.this.subMoveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                PartitionPropertyTabOraclev10g.this.setSelection(PartitionPropertyTabOraclev10g.this.subPartSelectionModel, nArray);
                PartitionPropertyTabOraclev10g.this.subPartOrdered = true;
                PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubMoveUpAction
    implements ActionListener {
        private SubMoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = PartitionPropertyTabOraclev10g.this.subPartitions.get(n);
                    PartitionPropertyTabOraclev10g.this.subMoveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                PartitionPropertyTabOraclev10g.this.setSelection(PartitionPropertyTabOraclev10g.this.subPartSelectionModel, nArray);
                PartitionPropertyTabOraclev10g.this.subPartOrdered = true;
                PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubPartitionsOrderModel
    extends AbstractTableModel {
        private SubPartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (PartitionPropertyTabOraclev10g.this.subPartitions == null) {
                return 0;
            }
            return PartitionPropertyTabOraclev10g.this.subPartitions.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("PartitionPropertyTabOraclev10g.TemplateName");
            }
            if (n == 1) {
                return Messages.getString("PartitionPropertyTabOraclev10g.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StorageObject storageObject = (StorageObject)PartitionPropertyTabOraclev10g.this.subPartitions.get(n);
            if (n2 == 0) {
                return storageObject.getName();
            }
            if (n2 == 1) {
                if (storageObject instanceof PartitionOracle) {
                    return ((PartitionOracle)storageObject).getValueList();
                }
                if (storageObject instanceof ListStorageTemplatePartitionOracle) {
                    return ((ListStorageTemplatePartitionOracle)storageObject).getValueList();
                }
                return "";
            }
            return new Integer(n * n2);
        }
    }

    private class MoveDownAction2
    implements ActionListener {
        private MoveDownAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = PartitionPropertyTabOraclev10g.this.partitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < PartitionPropertyTabOraclev10g.this.partitions.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = PartitionPropertyTabOraclev10g.this.partitions.get(n);
                    PartitionPropertyTabOraclev10g.this.moveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                PartitionPropertyTabOraclev10g.this.setSelection(PartitionPropertyTabOraclev10g.this.partSelectionModel, nArray);
                PartitionPropertyTabOraclev10g.this.ordered = true;
                PartitionPropertyTabOraclev10g.this.partitionsOrderTable.updateUI();
            }
        }
    }

    private class MoveUpAction2
    implements ActionListener {
        private MoveUpAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = PartitionPropertyTabOraclev10g.this.partitionsOrderTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = PartitionPropertyTabOraclev10g.this.partitions.get(n);
                    PartitionPropertyTabOraclev10g.this.moveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                PartitionPropertyTabOraclev10g.this.setSelection(PartitionPropertyTabOraclev10g.this.partSelectionModel, nArray);
                PartitionPropertyTabOraclev10g.this.ordered = true;
                PartitionPropertyTabOraclev10g.this.partitionsOrderTable.updateUI();
            }
        }
    }

    private class PartitionsOrderModel
    extends AbstractTableModel {
        private PartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (PartitionPropertyTabOraclev10g.this.partitions == null) {
                return 0;
            }
            return PartitionPropertyTabOraclev10g.this.partitions.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("PartitionPropertyTabOraclev10g.PartitionName");
            }
            if (n == 1) {
                return Messages.getString("PartitionPropertyTabOraclev10g.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StorageObject storageObject = (StorageObject)PartitionPropertyTabOraclev10g.this.partitions.get(n);
            if (n2 == 0) {
                return storageObject.getName();
            }
            if (n2 == 1) {
                if (storageObject instanceof PartitionOracle) {
                    return ((PartitionOracle)storageObject).getValueList();
                }
                if (storageObject instanceof ListPartitionOracle) {
                    return ((ListPartitionOracle)storageObject).getColumns();
                }
                return "";
            }
            return new Integer(n * n2);
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.selectedSubPartTSModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.allSubPartTSModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.allSubPartTSModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.selectedSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.allSubPartTSModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedSubPartTSModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedSubPartTSModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.allSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.allSubPartTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class RemoveSubPartColumnsActionListener
    implements ActionListener {
        private RemoveSubPartColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddSubPartColumnsActionListener
    implements ActionListener {
        private AddSubPartColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.allSubPartColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedSubPartColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemoveSubPartColumns.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemoveSubPartColumns.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.isListSubpartitioned((String)PartitionPropertyTabOraclev10g.this.cbPartType.getSelectedItem())) {
                    if (PartitionPropertyTabOraclev10g.this.allSubPartColumnsList.getSelectedIndices().length != 1 || PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.toArray().length >= 1) {
                        PartitionPropertyTabOraclev10g.this.bnAddSubPartColumns.setEnabled(false);
                    } else {
                        PartitionPropertyTabOraclev10g.this.bnAddSubPartColumns.setEnabled(true);
                    }
                } else if (PartitionPropertyTabOraclev10g.this.allSubPartColumnsList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAddSubPartColumns.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAddSubPartColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.allColumnsModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.allColumnsModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedColumnsModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedColumnsModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedColumnsList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemove.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (((String)PartitionPropertyTabOraclev10g.this.cbPartType.getSelectedItem()).equalsIgnoreCase("LIST")) {
                    if (PartitionPropertyTabOraclev10g.this.allColumnsList.getSelectedIndices().length != 1 || PartitionPropertyTabOraclev10g.this.selectedColumnsModel.toArray().length >= 1) {
                        PartitionPropertyTabOraclev10g.this.bnAdd.setEnabled(false);
                    } else {
                        PartitionPropertyTabOraclev10g.this.bnAdd.setEnabled(true);
                    }
                } else if (PartitionPropertyTabOraclev10g.this.allColumnsList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAdd.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveIOTOverflowHashPTSActionListener
    implements ActionListener {
        private RemoveIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddIOTOverflowHashPTSActionListener
    implements ActionListener {
        private AddIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class RemoveHashPTSActionListener
    implements ActionListener {
        private RemoveHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.selectedHashPTSModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.selectedHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.allHashPTSModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.allHashPTSModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.selectedHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddHashPTSActionListener
    implements ActionListener {
        private AddHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PartitionPropertyTabOraclev10g.this.allHashPTSModel.isEmpty()) {
                Object[] objectArray = PartitionPropertyTabOraclev10g.this.allHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedHashPTSModel.contains(object)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedHashPTSModel.addElement(object);
                    PartitionPropertyTabOraclev10g.this.allHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedHashPTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemoveHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.allHashPTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAddHashPTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAddHashPTS.setEnabled(true);
                }
            }
        }
    }

    public class PartitionTypeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)PartitionPropertyTabOraclev10g.this.cbPartType.getSelectedItem();
            if (PartitionPropertyTabOraclev10g.this.useColumnProxies) {
                PartitionPropertyTabOraclev10g.this.allColumnsList.getSelectionModel().clearSelection();
                PartitionPropertyTabOraclev10g.this.allSubPartColumnsList.getSelectionModel().clearSelection();
                if (string.equalsIgnoreCase("LIST") && PartitionPropertyTabOraclev10g.this.selectedColumnsModel.toArray().length > 1) {
                    PartitionPropertyTabOraclev10g.this.allColumnsModel.clear();
                    PartitionPropertyTabOraclev10g.this.selectedColumnsModel.clear();
                    PartitionPropertyTabOraclev10g.this.initPartColumns(PartitionPropertyTabOraclev10g.this.partList);
                }
                if (PartitionPropertyTabOraclev10g.this.isListSubpartitioned(string) && PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.toArray().length > 1) {
                    PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.clear();
                    PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.clear();
                    PartitionPropertyTabOraclev10g.this.initSubPartColumns(PartitionPropertyTabOraclev10g.this.partList);
                }
            }
            PartitionPropertyTabOraclev10g.this.enableRelevantPartitionFields(PartitionPropertyTabOraclev10g.this.isPartitioned());
        }
    }

    private class SubPartitionPropertiesAction
    implements ActionListener {
        private SubPartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.getSelectedRow();
            if (n > -1 && n < PartitionPropertyTabOraclev10g.this.subPartitions.size()) {
                StorageObject storageObject = (StorageObject)PartitionPropertyTabOraclev10g.this.subPartitions.get(n);
                storageObject.showPropertyDialog();
            }
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PartitionPropertyTabOraclev10g.this.partitionsOrderTable.getSelectedRow();
            if (n > -1 && n < PartitionPropertyTabOraclev10g.this.partitions.size()) {
                StorageObject storageObject = (StorageObject)PartitionPropertyTabOraclev10g.this.partitions.get(n);
                storageObject.showPropertyDialog();
            }
        }
    }
}

