/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.LocalIndexPropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ListPartitionPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    protected ListPartitionOraclev10g listPartition;
    private JTextField tfValueList;
    private JComboBox cbCompression;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JPanel indexesButtonPanel;
    private JList list;
    private DefaultListModel listModel;
    private JButton edit;

    public ListPartitionPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.listPartition = (ListPartitionOraclev10g)storageObject;
        this.setHeight(280);
        this.initCommentsView(210);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ListPartitionPropertyDialogOracle.ListPartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initDataSegmentCompression();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
    }

    private void initValueList() {
        JLabel jLabel = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.ValueList"));
        this.general.add(jLabel);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initDataSegmentCompression() {
        JLabel jLabel = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Compression"));
        this.general.add(jLabel);
        this.cbCompression = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbCompression);
        this.cbCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompression);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbCompression, 80);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("ListPartitionPropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    @Override
    protected void addTabs() {
        this.initIndexesTab();
    }

    private void initIndexesTab() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.getList());
        jScrollPane.setPreferredSize(new Dimension(390, 180));
        jPanel.add((Component)this.getIndexesButtonPanel(), "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.getPane().addTab(Messages.getString("ListPartitionPropertyDialogOracle.LocalIndexes"), jPanel);
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.edit = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("ListPartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ListPartitionPropertyDialogOraclev10g.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.edit);
            jToolBar.addSeparator();
            this.indexesButtonPanel.add(jToolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void editSelected() {
        Object e = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev10g localIndexPropertyDialogOraclev10g = new LocalIndexPropertyDialogOraclev10g(this.listPartition.getDesign().getAppView(), this.getStorageDesign(), this.listPartition, (StorageObject)e);
        localIndexPropertyDialogOraclev10g.show();
    }

    @Override
    public void initProperties() {
        Object object;
        Object object2;
        this.initCaption(this.listPartition.getName());
        this.tfName.setText(this.listPartition.getName());
        this.tfValueList.setText(this.listPartition.getColumns());
        this.cbCompression.setSelectedItem(ListPartitionPropertyDialogOraclev10g.translateYesNoForDisplay(this.listPartition.getDataSegmentCompression()));
        this.selectObject(this.cbTableSpace, this.listPartition.getTablespace());
        this.cbLogging.setSelectedItem(ListPartitionPropertyDialogOraclev10g.translateYesNoForDisplay(this.listPartition.getLogging()));
        this.selectObject(this.cbSegment, this.listPartition.getSegment());
        PartitionListOracle partitionListOracle = this.listPartition.getPartitionList();
        if (partitionListOracle != null) {
            TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)partitionListOracle.getTable();
            if (tableProxyOraclev10g == null && (object2 = partitionListOracle.getSnapshot()) != null) {
                tableProxyOraclev10g = (TableProxyOraclev10g)((SnapshotOracle)object2).getImplementedTable();
            }
            if (tableProxyOraclev10g != null) {
                Object object3;
                Object object4;
                object2 = tableProxyOraclev10g.getIndexes().iterator();
                while (object2.hasNext()) {
                    object = (IndexProxyOraclev10g)object2.next();
                    if (!((IndexProxyOracle)object).getIndexPartitioned().equalsIgnoreCase("local")) continue;
                    this.listModel.addElement(object);
                }
                object = tableProxyOraclev10g.getBjIndexes().iterator();
                while (object.hasNext()) {
                    object4 = (BitmapJoinIndexOraclev10g)object.next();
                    if (!((BitmapJoinIndexOracle)object4).getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                    this.listModel.addElement(object4);
                }
                object4 = tableProxyOraclev10g.getUniqueKeys().iterator();
                while (object4.hasNext()) {
                    object3 = (UniqueOraclev10g)object4.next();
                    if (!((UniqueOraclev10g)object3).getUsingIndex().equalsIgnoreCase("local")) continue;
                    this.listModel.addElement(object3);
                }
                object3 = tableProxyOraclev10g.getPrimaryKeys().iterator();
                while (object3.hasNext()) {
                    PKProxyOraclev10g pKProxyOraclev10g = (PKProxyOraclev10g)object3.next();
                    if (!pKProxyOraclev10g.getUsingIndex().equalsIgnoreCase("local")) continue;
                    this.listModel.addElement(pKProxyOraclev10g);
                }
            }
        }
        for (int i = 0; i < this.listModel.size(); ++i) {
            if (this.listModel.get(i) instanceof IndexProxyOraclev10g) {
                object2 = (IndexProxyOraclev10g)this.listModel.get(i);
                object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, (StorageObject)object2);
                if (object != null) continue;
                object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                ((LocalIndexProperties)object).setPartition(this.listPartition);
                ((LocalIndexProperties)object).setIndex((StorageObject)object2);
                continue;
            }
            if (this.listModel.get(i) instanceof BitmapJoinIndexOraclev10g) {
                object2 = (BitmapJoinIndexOraclev10g)this.listModel.get(i);
                object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, (StorageObject)object2);
                if (object != null) continue;
                object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                ((LocalIndexProperties)object).setPartition(this.listPartition);
                ((LocalIndexProperties)object).setIndex((StorageObject)object2);
                continue;
            }
            if (this.listModel.get(i) instanceof UniqueOraclev10g) {
                object2 = (UniqueOraclev10g)this.listModel.get(i);
                object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, (StorageObject)object2);
                if (object != null) continue;
                object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                ((LocalIndexProperties)object).setPartition(this.listPartition);
                ((LocalIndexProperties)object).setIndex((StorageObject)object2);
                continue;
            }
            if (!(this.listModel.get(i) instanceof PKProxyOraclev10g)) continue;
            object2 = (PKProxyOraclev10g)this.listModel.get(i);
            object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.listPartition, (StorageObject)object2);
            if (object != null) continue;
            object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            ((LocalIndexProperties)object).setPartition(this.listPartition);
            ((LocalIndexProperties)object).setIndex((StorageObject)object2);
        }
        this.getCommentsList().insert(this.listPartition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.listPartition != null) {
            this.listPartition.setName(this.tfName.getText());
            this.listPartition.setColumns(this.tfValueList.getText());
            this.listPartition.setDataSegmentCompression(ListPartitionPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbCompression.getSelectedItem()));
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOraclev10g) {
                this.listPartition.setTablespace((TableSpaceOraclev10g)object);
            } else {
                this.listPartition.setTablespace(null);
            }
            this.listPartition.setLogging(ListPartitionPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            object = this.cbSegment.getSelectedItem();
            if (object instanceof SegmentOraclev10g) {
                this.listPartition.setSegment((SegmentOraclev10g)object);
            } else {
                this.listPartition.setSegment(null);
            }
            this.listPartition.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ListPartitionPropertyDialogOraclev10g.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Index) {
                this.setText(((Index)object).getName());
            } else {
                this.setText(object.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }
}

