/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class IndexHashLobItemPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private IndexHashPartitionLobItemOracle lobItem;
    private JComboBox cbLobColumn;
    private JComboBox cbTableSpace;

    public IndexHashLobItemPropertyDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.lobItem = (IndexHashPartitionLobItemOracle)storageObject;
        this.setHeight(140);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexHashLobItemPropertyDialogOracle.LobStorageProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initLobColumn();
        this.initTableSpace();
    }

    private void initLobColumn() {
        JLabel jLabel = new JLabel(Messages.getString("IndexHashLobItemPropertyDialogOracle.LobColumn"));
        this.general.add(jLabel);
        this.cbLobColumn = new JComboBox();
        this.setBG(this.cbLobColumn);
        this.cbLobColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLobColumn);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbLobColumn, 50);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("IndexHashLobItemPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.lobItem.getName());
        this.tfName.setText(this.lobItem.getName());
        try {
            this.fillComboItems(this.lobItem.getIndexHashPartition().getIndexGlobalPartList().getIndex().getTableProxy().getColumnProxies(), this.cbLobColumn);
        }
        catch (Exception exception) {
            System.out.println("Error in: IndexHashPartitionLobItemOracle.initProperties()");
        }
        this.selectObject(this.cbLobColumn, this.lobItem.getLobColumn());
        this.selectObject(this.cbTableSpace, this.lobItem.getTableSpace());
        this.getCommentsList().insert(this.lobItem.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.lobItem != null) {
            this.lobItem.setName(this.tfName.getText());
            Object object = this.cbLobColumn.getSelectedItem();
            if (object instanceof ColumnProxy) {
                this.lobItem.setLobColumn((ColumnProxy)object);
            } else {
                this.lobItem.setLobColumn(null);
            }
            object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.lobItem.setTableSpace((TableSpaceOracle)object);
            } else {
                this.lobItem.setTableSpace(null);
            }
            this.lobItem.setComment(this.getCommentsList().getText());
        }
    }
}

