/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ASMDiskOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ASMDiskPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private ASMDiskOraclev10g asmDisk;
    private JTextField tfSearchString;
    private JIntegerField ifSize;
    private JComboBox cbSizeMeasurementUnit;
    private JComboBox cbForce;

    public ASMDiskPropertyDialogOraclev10g(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.asmDisk = (ASMDiskOraclev10g)storageObject;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ASMDiskPropertyDialogOracle.ASMDisk");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initSearchString();
        this.initSize();
        this.initSizeMeasurementUnit();
        this.initForce();
    }

    private void initSearchString() {
        JLabel jLabel = new JLabel(Messages.getString("ASMDiskPropertyDialogOracle.SearchString"));
        this.general.add(jLabel);
        this.tfSearchString = new JTextField("", 26);
        this.general.add(this.tfSearchString);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfSearchString, 50);
    }

    private void initSize() {
        JLabel jLabel = new JLabel(Messages.getString("ASMDiskPropertyDialogOracle.Size"));
        this.general.add(jLabel);
        this.ifSize = new JIntegerField(0, 26);
        this.general.add(this.ifSize);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifSize, 80);
    }

    private void initSizeMeasurementUnit() {
        JLabel jLabel = new JLabel(Messages.getString("ASMDiskPropertyDialogOracle.SizeUnit"));
        this.general.add(jLabel);
        this.cbSizeMeasurementUnit = new JComboBox<String>(ASMDiskOraclev10g.getSizeMeasurementUnitStates());
        this.setBG(this.cbSizeMeasurementUnit);
        this.cbSizeMeasurementUnit.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSizeMeasurementUnit);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbSizeMeasurementUnit, 110);
    }

    private void initForce() {
        JLabel jLabel = new JLabel(Messages.getString("ASMDiskPropertyDialogOracle.Force"));
        this.general.add(jLabel);
        this.cbForce = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForce);
        this.cbForce.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForce);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbForce, 140);
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.asmDisk.getName());
        this.tfSearchString.setText(this.asmDisk.getSearchString());
        this.ifSize.setValue((long)this.asmDisk.getSize());
        this.cbSizeMeasurementUnit.setSelectedItem(this.asmDisk.getSizeMeasurementUnit());
        this.cbForce.setSelectedItem(ASMDiskPropertyDialogOraclev10g.translateYesNoForDisplay(this.asmDisk.getForce()));
        this.getCommentsList().insert(this.asmDisk.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        this.asmDisk.setName(this.tfName.getText());
        this.asmDisk.setSearchString(this.tfSearchString.getText());
        this.asmDisk.setSize(this.ifSize.getIntValue());
        this.asmDisk.setSizeMeasurementUnit((String)this.cbSizeMeasurementUnit.getSelectedItem());
        this.asmDisk.setForce(ASMDiskPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbForce.getSelectedItem()));
        this.asmDisk.setComment(this.getCommentsList().getText());
    }
}

