/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TemporaryTablespacePropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private TemporaryTablespaceOracle ts;
    private JTextField tfFilename;
    private JIntegerField ifSize;
    private JComboBox cbMeasureUnit;
    private JComboBox cbMeasureUnitUniformSize;
    private JComboBox cbReuse;
    private JComboBox cbAutoextend;
    private JIntegerField ifNextBlockSize;
    private JTextField tfMaxSize;
    private JIntegerField tfUniformSize;

    public TemporaryTablespacePropertyDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.ts = (TemporaryTablespaceOracle)storageObject;
        this.setHeight(290);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TemporaryTablespacePropertyDialogOracle.TemporaryTablespaceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initFilename();
        this.initSize();
        this.initResuse();
        this.initAutoextend();
        this.initNextBlockSize();
        this.initMaxSize();
        this.initUniformSize();
    }

    private void initFilename() {
        JLabel jLabel = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOracle.Filename"));
        this.general.add(jLabel);
        this.tfFilename = new JTextField("", 26);
        this.general.add(this.tfFilename);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfFilename, 50);
    }

    private void initSize() {
        JLabel jLabel = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOracle.Size"));
        this.general.add(jLabel);
        this.ifSize = new JIntegerField(0, 16);
        this.general.add(this.ifSize);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifSize, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.cbMeasureUnit = new JComboBox<Object>(TemporaryTablespaceOracle.getMeasureUnitValues().toArray());
        this.general.add(this.cbMeasureUnit);
        this.cbMeasureUnit.setPreferredSize(new Dimension(50, this.tfName.getPreferredSize().height));
        this.setObjectConstraints(this.cbMeasureUnit, 80);
    }

    private void initResuse() {
        JLabel jLabel = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOracle.Reuse"));
        this.general.add(jLabel);
        this.cbReuse = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReuse);
        this.cbReuse.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReuse);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbReuse, 110);
    }

    private void initAutoextend() {
        JLabel jLabel = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOracle.Autoextend"));
        this.general.add(jLabel);
        this.cbAutoextend = new JComboBox<String>(TemporaryTablespaceOracle.getSwitchChoices());
        this.setBG(this.cbAutoextend);
        this.cbAutoextend.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoextend);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbAutoextend, 140);
    }

    private void initNextBlockSize() {
        JLabel jLabel = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOracle.NextBlockSize"));
        this.general.add(jLabel);
        this.ifNextBlockSize = new JIntegerField(0, 26);
        this.general.add(this.ifNextBlockSize);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.ifNextBlockSize, 170);
    }

    private void initMaxSize() {
        JLabel jLabel = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOracle.MaxSize"));
        this.general.add(jLabel);
        this.tfMaxSize = new JTextField("UNLIMITED", 26);
        this.general.add(this.tfMaxSize);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfMaxSize, 200);
    }

    private void initUniformSize() {
        JLabel jLabel = new JLabel(Messages.getString("TemporaryTablespacePropertyDialogOracle.UniformSize"));
        this.general.add(jLabel);
        this.tfUniformSize = new JIntegerField(0, 16);
        this.general.add(this.tfUniformSize);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.tfUniformSize, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 230);
        this.cbMeasureUnitUniformSize = new JComboBox<Object>(TemporaryTablespaceOracle.getMeasureUnitValues().toArray());
        this.general.add(this.cbMeasureUnitUniformSize);
        this.cbMeasureUnitUniformSize.setPreferredSize(new Dimension(50, this.tfName.getPreferredSize().height));
        this.setObjectConstraints(this.cbMeasureUnitUniformSize, 230);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.ts.getName());
        this.tfName.setText(this.ts.getName());
        this.tfFilename.setText(this.ts.getFilename());
        this.ifSize.setValue(this.ts.getSize());
        this.cbMeasureUnit.setSelectedItem(this.ts.getMeasureUnitSize());
        this.cbMeasureUnitUniformSize.setSelectedItem(this.ts.getMeasureUnitUniformSize());
        this.cbReuse.setSelectedItem(TemporaryTablespacePropertyDialogOracle.translateYesNoForDisplay(this.ts.getReuse()));
        this.cbAutoextend.setSelectedItem(this.ts.getAutoextend());
        this.ifNextBlockSize.setValue((long)this.ts.getNextBlockSize());
        this.tfMaxSize.setText(this.ts.getMaxSize());
        this.tfUniformSize.setValue(this.ts.getUniformSize());
        this.getCommentsList().insert(this.ts.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.ts != null) {
            this.ts.setName(this.tfName.getText());
            this.ts.setFilename(this.tfFilename.getText());
            this.ts.setSize(this.ifSize.getIntValue());
            this.ts.setMeasureUnitSize((String)this.cbMeasureUnit.getSelectedItem());
            this.ts.setMeasureUnitUniformSize((String)this.cbMeasureUnitUniformSize.getSelectedItem());
            this.ts.setReuse(TemporaryTablespacePropertyDialogOracle.translateYesNoForStorage((String)this.cbReuse.getSelectedItem()));
            this.ts.setAutoextend((String)this.cbAutoextend.getSelectedItem());
            this.ts.setNextBlockSize(this.ifNextBlockSize.getIntValue());
            this.ts.setMaxSize(this.tfMaxSize.getText());
            this.tfMaxSize.setText(this.ts.getMaxSize());
            this.ts.setUniformSize(this.tfUniformSize.getIntValue());
            this.ts.setComment(this.getCommentsList().getText());
        }
    }
}

