/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class LevelPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private LevelOracle level;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JComboBox cbTables;
    private TableProxy current;
    private DimensionAttributeOracle attribute;
    private DefaultListModel allAttrColumnsModel;
    private DefaultListModel selectedAttrColumnsModel;
    private JList allAttrColumnsList;
    private JList selectedAttrColumnsList;
    private JButton bnAttrAdd;
    private JButton bnAttrRemove;
    private JPanel attrPanel;
    private JTextField tfAttrName;
    private boolean first = true;

    public LevelPropertyDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.level = (LevelOracle)storageObject;
        this.attribute = this.getAttributeForLevel(this.level, (StorageDesignOracle)storageDesign);
        if (this.attribute == null) {
            this.attribute = this.createAttribute(this.level, (StorageDesignOracle)storageDesign);
        }
        this.setHeight(310);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("LevelPropertyDialogOracle.LevelProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    @Override
    protected void addTabs() {
        this.initAttributesView();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("LevelPropertyDialogOracle.AllColumns"));
        this.general.add(jLabel);
        JLabel jLabel2 = new JLabel(Messages.getString("LevelPropertyDialogOracle.Table"));
        this.general.add(jLabel2);
        this.cbTables = new JComboBox();
        this.setBG(this.cbTables);
        this.general.add(this.cbTables);
        this.cbTables.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableProxy tableProxy = (TableProxy)LevelPropertyDialogOracle.this.cbTables.getSelectedItem();
                if (tableProxy != null && LevelPropertyDialogOracle.this.first || tableProxy != LevelPropertyDialogOracle.this.current) {
                    LevelPropertyDialogOracle.this.first = false;
                    LevelPropertyDialogOracle.this.selectedColumnsModel.clear();
                    LevelPropertyDialogOracle.this.allColumnsModel.clear();
                    LevelPropertyDialogOracle.this.selectedAttrColumnsModel.clear();
                    LevelPropertyDialogOracle.this.allAttrColumnsModel.clear();
                    if (tableProxy != null) {
                        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
                        for (int i = 0; i < columnProxyArray.length; ++i) {
                            LevelPropertyDialogOracle.this.allColumnsModel.addElement(columnProxyArray[i]);
                            LevelPropertyDialogOracle.this.allAttrColumnsModel.addElement(columnProxyArray[i]);
                        }
                    }
                    LevelPropertyDialogOracle.this.current = tableProxy;
                }
            }
        });
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel2, 10, 48);
        this.setObjectConstraints(this.cbTables, 48);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 12, 74);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 92);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("LevelPropertyDialogOracle.LevelKey"));
        this.general.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 292, 74);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 290, 92);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("LevelPropertyDialogOracle.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.general.add(this.bnAdd);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAdd, 175, 145);
        this.bnRemove = new JButton(Messages.getString("LevelPropertyDialogOracle.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.general.add(this.bnRemove);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemove, 175, 175);
        LevelPropertyDialogOracle.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.level.getName());
        this.cbTables.addItem(null);
        Iterator iterator = this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            this.cbTables.addItem(iterator.next());
        }
        this.current = this.level.getLevelTable();
        if (this.current != null) {
            int n;
            this.cbTables.setSelectedItem(this.current);
            this.selectedColumnsModel.clear();
            this.allColumnsModel.clear();
            this.selectedAttrColumnsModel.clear();
            this.allAttrColumnsModel.clear();
            ColumnProxy[] columnProxyArray = this.current.getColumnProxies();
            for (n = 0; n < columnProxyArray.length; ++n) {
                this.allColumnsModel.addElement(columnProxyArray[n]);
                this.allAttrColumnsModel.addElement(columnProxyArray[n]);
            }
            for (n = 0; n < columnProxyArray.length; ++n) {
                ColumnProxy columnProxy = columnProxyArray[n];
                if (!this.level.getColumnSet().contains(columnProxy.getName()) && !this.level.getColumnSet().contains(columnProxy.getObjectID())) continue;
                this.selectedColumnsModel.addElement(columnProxy);
                this.allColumnsModel.removeElement(columnProxy);
            }
            this.initAttrProperties();
        }
        this.tfName.setText(this.level.getName());
        this.getCommentsList().insert(this.level.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.level != null) {
            this.level.setName(this.tfName.getText());
            Object[] objectArray = this.selectedColumnsModel.toArray();
            this.level.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof ColumnProxyOracle)) continue;
                this.level.setColumns(((ColumnProxyOracle)object).getObjectID());
            }
            this.level.setComment(this.getCommentsList().getText());
            this.level.setLevelTable(this.current);
            this.setAttrProperties();
        }
    }

    private void initAttributesView() {
        this.attrPanel = new JPanel(new SpringLayout());
        JLabel jLabel = new JLabel(Messages.getString("LevelPropertyDialogOracle.AttributeName"));
        this.attrPanel.add(jLabel);
        this.tfAttrName = new JTextField("", 26);
        this.attrPanel.add(this.tfAttrName);
        this.setLabelConstraints(this.getAttrColumnsLayout(), jLabel, 12, 20);
        this.setObjectConstraints(this.getAttrColumnsLayout(), this.tfAttrName, 20);
        this.initAttrAllColumnsList();
        this.initAttrSelectedColumnsList();
        this.initAttrButtons();
        this.tpane.add(Messages.getString("LevelPropertyDialogOracle.LevelAttributes"), this.attrPanel);
    }

    private void initAttrAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("LevelPropertyDialogOracle.AllColumns"));
        this.attrPanel.add(jLabel);
        this.allAttrColumnsModel = new DefaultListModel();
        this.allAttrColumnsList = new JList(this.allAttrColumnsModel);
        ListSelectionModel listSelectionModel = this.allAttrColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AttrAllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allAttrColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 202));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.attrPanel.add(jScrollPane);
        this.setLabelConstraints(this.getAttrColumnsLayout(), jLabel, 12, 50);
        this.setObjectConstraints(this.getAttrColumnsLayout(), jScrollPane, 10, 70);
    }

    private void initAttrSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("LevelPropertyDialogOracle.DeterminedColumns"));
        this.attrPanel.add(jLabel);
        this.selectedAttrColumnsModel = new DefaultListModel();
        this.selectedAttrColumnsList = new JList(this.selectedAttrColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedAttrColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AttrSelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedAttrColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 202));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.attrPanel.add(jScrollPane);
        this.setLabelConstraints(this.getAttrColumnsLayout(), jLabel, 292, 50);
        this.setObjectConstraints(this.getAttrColumnsLayout(), jScrollPane, 290, 70);
    }

    private void initAttrButtons() {
        this.bnAttrAdd = new JButton(Messages.getString("LevelPropertyDialogOracle.Add"));
        this.bnAttrAdd.addActionListener(new AttrAddColumnsActionListener());
        this.bnAttrAdd.setEnabled(false);
        this.attrPanel.add(this.bnAttrAdd);
        this.setObjectConstraints(this.getAttrColumnsLayout(), this.bnAttrAdd, 175, 145);
        this.bnAttrRemove = new JButton(Messages.getString("LevelPropertyDialogOracle.Remove"));
        this.bnAttrRemove.setEnabled(false);
        this.bnAttrRemove.addActionListener(new AttrRemoveColumnsActionListener());
        this.attrPanel.add(this.bnAttrRemove);
        this.setObjectConstraints(this.getAttrColumnsLayout(), this.bnAttrRemove, 175, 175);
        LevelPropertyDialogOracle.equalizeButtonSizes(this.bnAttrAdd, this.bnAttrRemove);
    }

    private SpringLayout getAttrColumnsLayout() {
        return (SpringLayout)this.attrPanel.getLayout();
    }

    public void initAttrProperties() {
        ColumnProxy[] columnProxyArray = this.current.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxyArray[i];
            if (!this.attribute.getColumnSet().contains(columnProxyOracle.getName()) && !this.attribute.getColumnSet().contains(columnProxyOracle.getObjectID())) continue;
            this.selectedAttrColumnsModel.addElement(columnProxyOracle);
            this.allAttrColumnsModel.removeElement(columnProxyOracle);
        }
        this.tfAttrName.setText(this.attribute.getName());
    }

    protected void setAttrProperties() {
        if (this.attribute != null) {
            this.attribute.setName(this.tfAttrName.getText());
            Object[] objectArray = this.selectedAttrColumnsModel.toArray();
            this.attribute.clearColumns();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof ColumnProxyOracle)) continue;
                this.attribute.setColumns(((ColumnProxyOracle)object).getObjectID());
            }
            this.attribute.setComment(this.getCommentsList().getText());
        }
    }

    private DimensionAttributeOracle getAttributeForLevel(LevelOracle levelOracle, StorageDesignOracle storageDesignOracle) {
        Iterator iterator = storageDesignOracle.getDimensionAttributeSet().iterator();
        while (iterator.hasNext()) {
            DimensionAttributeOracle dimensionAttributeOracle = (DimensionAttributeOracle)iterator.next();
            if (dimensionAttributeOracle.getLevel() != levelOracle) continue;
            return dimensionAttributeOracle;
        }
        return null;
    }

    private DimensionAttributeOracle createAttribute(LevelOracle levelOracle, StorageDesignOracle storageDesignOracle) {
        DimensionAttributeOracle dimensionAttributeOracle = storageDesignOracle.getDimensionAttributeSet().createDimensionAttribute();
        dimensionAttributeOracle.setLevel(levelOracle);
        return dimensionAttributeOracle;
    }

    private class AttrSelectedListSelectionHandler
    implements ListSelectionListener {
        private AttrSelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (LevelPropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (LevelPropertyDialogOracle.this.selectedAttrColumnsList.getSelectedIndex() == -1) {
                    LevelPropertyDialogOracle.this.bnAttrRemove.setEnabled(false);
                } else {
                    LevelPropertyDialogOracle.this.bnAttrRemove.setEnabled(true);
                }
            }
        }
    }

    private class AttrAllListSelectionHandler
    implements ListSelectionListener {
        private AttrAllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (LevelPropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (LevelPropertyDialogOracle.this.allAttrColumnsList.getSelectedIndex() == -1) {
                    LevelPropertyDialogOracle.this.bnAttrAdd.setEnabled(false);
                } else {
                    LevelPropertyDialogOracle.this.bnAttrAdd.setEnabled(true);
                }
            }
        }
    }

    private class AttrRemoveColumnsActionListener
    implements ActionListener {
        private AttrRemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!LevelPropertyDialogOracle.this.selectedAttrColumnsModel.isEmpty()) {
                Object[] objectArray = LevelPropertyDialogOracle.this.selectedAttrColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (LevelPropertyDialogOracle.this.allAttrColumnsModel.contains(object)) continue;
                    LevelPropertyDialogOracle.this.allAttrColumnsModel.addElement(object);
                    LevelPropertyDialogOracle.this.selectedAttrColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AttrAddColumnsActionListener
    implements ActionListener {
        private AttrAddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!LevelPropertyDialogOracle.this.allAttrColumnsModel.isEmpty()) {
                Object[] objectArray = LevelPropertyDialogOracle.this.allAttrColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (LevelPropertyDialogOracle.this.selectedAttrColumnsModel.contains(object)) continue;
                    LevelPropertyDialogOracle.this.selectedAttrColumnsModel.addElement(object);
                    LevelPropertyDialogOracle.this.allAttrColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (LevelPropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (LevelPropertyDialogOracle.this.selectedColumnsList.getSelectedIndex() == -1) {
                    LevelPropertyDialogOracle.this.bnRemove.setEnabled(false);
                } else {
                    LevelPropertyDialogOracle.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (LevelPropertyDialogOracle.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (LevelPropertyDialogOracle.this.allColumnsList.getSelectedIndex() == -1) {
                    LevelPropertyDialogOracle.this.bnAdd.setEnabled(false);
                } else {
                    LevelPropertyDialogOracle.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!LevelPropertyDialogOracle.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = LevelPropertyDialogOracle.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (LevelPropertyDialogOracle.this.allColumnsModel.contains(object)) continue;
                    LevelPropertyDialogOracle.this.allColumnsModel.addElement(object);
                    LevelPropertyDialogOracle.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!LevelPropertyDialogOracle.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = LevelPropertyDialogOracle.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (LevelPropertyDialogOracle.this.selectedColumnsModel.contains(object)) continue;
                    LevelPropertyDialogOracle.this.selectedColumnsModel.addElement(object);
                    LevelPropertyDialogOracle.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }
}

