/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DefaultPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private JComboBox cbOwner;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    private boolean propertiesSet;

    public DefaultPropertyDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.setHeight(280);
        if (this.showCommentsTab()) {
            this.initCommentsView();
        }
        if (this.showNotesTab()) {
            this.initNotesView();
        }
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    protected boolean showCommentsTab() {
        return true;
    }

    protected boolean showNotesTab() {
        return true;
    }

    @Override
    public String getCaption() {
        String string = this.getStorageObject().getObjectTypeName();
        if (string.equals("Package")) {
            return Messages.getString("DefaultPropertyDialogOracle.PackageProperties");
        }
        return string + " " + Messages.getString("DefaultPropertyDialogOracle.Properties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("DefaultPropertyDialogOracle.User"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("DefaultPropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 220);
    }

    @Override
    public void initProperties() {
        PlSqlSourceStorageObjectOracle plSqlSourceStorageObjectOracle = (PlSqlSourceStorageObjectOracle)this.getStorageObject();
        this.initCaption(plSqlSourceStorageObjectOracle.getName());
        this.tfName.setText(plSqlSourceStorageObjectOracle.getName());
        if (this.showCommentsTab()) {
            this.taComments.setText(plSqlSourceStorageObjectOracle.getComment());
        }
        if (this.showNotesTab()) {
            this.taNotes.setText(plSqlSourceStorageObjectOracle.getNotes());
        }
        this.cbOwner.setSelectedItem(plSqlSourceStorageObjectOracle.getOwner());
    }

    @Override
    protected void setProperties() {
        PlSqlSourceStorageObjectOracle plSqlSourceStorageObjectOracle = (PlSqlSourceStorageObjectOracle)this.getStorageObject();
        if (plSqlSourceStorageObjectOracle != null) {
            plSqlSourceStorageObjectOracle.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            plSqlSourceStorageObjectOracle.setName(this.tfName.getText());
            if (this.showCommentsTab()) {
                plSqlSourceStorageObjectOracle.setComment(this.taComments.getText());
            }
            if (this.showNotesTab()) {
                plSqlSourceStorageObjectOracle.setNotes(this.taNotes.getText());
            }
        }
        this.propertiesSet = true;
    }

    public boolean isPropertiesSet() {
        return this.propertiesSet;
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbOwner.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultPropertyDialogOracle.this.dialog = new ObjectPermissionsDialogOracle(DefaultPropertyDialogOracle.this.getAppView(), DefaultPropertyDialogOracle.this.getStorageDesign(), DefaultPropertyDialogOracle.this.getStorageObject());
            DefaultPropertyDialogOracle.this.dialog.showDialog();
        }
    }
}

