/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ColumnsPermissionsDialogOracle
extends CustomDialog {
    private StorageDesignOracle storageDesign;
    private Object userRole;
    private JButton bnOK;
    private JButton bnApply;
    private JButton bnCancel;
    private JButton buttonColumnAdd;
    private JButton buttonColumnRemove;
    private JButton buttonPrivilegeAdd;
    private JButton buttonPrivilegeRemove;
    private final JPanel generalPanel;
    private JPanel allColumnsPanel;
    private JPanel privilegedColumnsPanel;
    private JPanel userRolePrivilegesListPanel;
    private JPanel privilegesPanel;
    private JPanel grantedUserRolePrivilegesPanel;
    private JDialog dialog;
    private List<Object> privilegedColumnsContainerList;
    private List<Privilege> containerListPrivileges;
    private JTable privilegedColumnsTable;
    private JTable privilegedUserRolePrivilegesTable;
    private PrivilegedObject currentPrivilegedObject;
    private JScrollPane availablePrivilegesScrollPane;
    private DefaultListModel availablePrivilegesModel;
    private DefaultListModel allColumnsPanelListModel;
    private JList availablePrivilegesList;
    private JList allColumnsPanelList;
    private Privilege currentPrivilege;
    private GrantedPrivilegessModel grantedPrivilegessModel;
    private ArrayList objWithRevokedPrivs = new ArrayList();
    private TableProxyOracle table;

    public ColumnsPermissionsDialogOracle(ApplicationView applicationView, StorageDesign storageDesign, Object object, TableProxyOracle tableProxyOracle) {
        super(applicationView);
        this.storageDesign = (StorageDesignOracle)storageDesign;
        this.userRole = object;
        this.table = tableProxyOracle;
        this.generalPanel = new JPanel(new BorderLayout());
        this.initLeftPanel(this.generalPanel);
        this.initColumnsAddRemoveButtons(this.generalPanel);
        this.initRightPanel(this.generalPanel);
        this.initBottomPanel(this.generalPanel);
        this.add((Component)this.generalPanel, "Center");
        this.generalPanel.setPreferredSize(new Dimension(600, 500));
    }

    private void initLeftPanel(JPanel jPanel) {
        this.allColumnsPanel = new JPanel(new BorderLayout());
        this.allColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ColumnsPermissionsDialogOracle.AllColumns")));
        this.allColumnsPanelListModel = new DefaultListModel();
        this.allColumnsPanelList = new JList(this.allColumnsPanelListModel);
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsPanelList);
        jScrollPane.setPreferredSize(new Dimension(180, 432));
        this.allColumnsPanel.add(jScrollPane);
        this.allColumnsPanelList.getSelectionModel().addListSelectionListener(new allColumnsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ColumnsPermissionsDialogOracle.this.allColumnsPanelList.getSelectedIndex() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonColumnAdd.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonColumnAdd.setEnabled(true);
                }
            }
        });
        jPanel.add((Component)this.allColumnsPanel, "West");
    }

    private void initRightPanel(JPanel jPanel) {
        this.privilegedColumnsPanel = new JPanel(new BorderLayout());
        this.privilegedColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ColumnsPermissionsDialogOracle.PrivilegedColumns")));
        this.privilegedColumnsPanel.setPreferredSize(new Dimension(370, 400));
        this.initPrivilegedColumns();
        this.initAvailablePrivileges();
        this.initGrantedUserRoleProvileges();
        this.loadAllColumns();
        jPanel.add((Component)this.privilegedColumnsPanel, "East");
    }

    private void loadAllColumns() {
        Iterator<ColumnProxy> iterator = Arrays.asList(this.table.getColumnProxies()).iterator();
        while (iterator.hasNext()) {
            this.checkPermissions(iterator.next());
        }
    }

    private void refreshGrantedUserRoleProvileges() {
        if (this.userRole instanceof RoleOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = false;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn tableColumn = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() == 1) {
                tableColumn.setWidth(214);
                tableColumn.setMaxWidth(214);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 1) {
                tableColumn.setWidth(162);
                tableColumn.setMaxWidth(162);
                TableColumn tableColumn2 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
                tableColumn2.setWidth(52);
                tableColumn2.setMaxWidth(52);
            }
        } else if (this.userRole instanceof UserOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = true;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn tableColumn = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            TableColumn tableColumn3 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() <= 2) {
                tableColumn.setWidth(152);
                tableColumn.setMaxWidth(152);
                tableColumn3.setWidth(40);
                tableColumn3.setMaxWidth(40);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 2) {
                tableColumn.setWidth(100);
                tableColumn.setMaxWidth(100);
            }
        }
        this.grantedUserRolePrivilegesPanel.updateUI();
    }

    private void initGrantedUserRoleProvileges() {
        this.grantedUserRolePrivilegesPanel = new JPanel(new BorderLayout());
        this.grantedUserRolePrivilegesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.GrantedPrivileges")));
        this.containerListPrivileges = new ArrayList<Privilege>();
        this.grantedPrivilegessModel = new GrantedPrivilegessModel();
        this.privilegedUserRolePrivilegesTable = new JTable(this.grantedPrivilegessModel);
        this.privilegedUserRolePrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(true);
                    ColumnsPermissionsDialogOracle.this.currentPrivilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.privilegedUserRolePrivilegesTable);
        jScrollPane.setPreferredSize(new Dimension(192, 100));
        this.grantedUserRolePrivilegesPanel.add(jScrollPane, "East", 0);
        this.userRolePrivilegesListPanel.add((Component)this.grantedUserRolePrivilegesPanel, "East");
        this.privilegedColumnsPanel.add((Component)this.userRolePrivilegesListPanel, "Center");
    }

    private void initAvailablePrivileges() {
        this.userRolePrivilegesListPanel = new JPanel(new BorderLayout());
        this.userRolePrivilegesListPanel.setPreferredSize(new Dimension(100, 400));
        this.privilegesPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.AvailablePrivileges")));
        this.availablePrivilegesModel = new DefaultListModel();
        this.availablePrivilegesList = new JList(this.availablePrivilegesModel);
        this.availablePrivilegesScrollPane = new JScrollPane(this.availablePrivilegesList);
        this.availablePrivilegesScrollPane.setPreferredSize(new Dimension(110, 200));
        jPanel.add(this.availablePrivilegesScrollPane);
        this.privilegesPanel.add((Component)jPanel, "West");
        this.userRolePrivilegesListPanel.add((Component)this.privilegesPanel, "West");
        this.initPrivilegesAddRemoveButtons();
        this.availablePrivilegesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ColumnsPermissionsDialogOracle.this.availablePrivilegesList.getSelectedIndex() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(true);
                }
            }
        });
        this.sort(this.availablePrivilegesModel);
    }

    private void initPrivilegedColumns() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.privilegedColumnsContainerList = new ArrayList<Object>();
        this.privilegedColumnsTable = new JTable(new PriviligedColumnsModel());
        this.privilegedColumnsTable.setSelectionMode(0);
        TableColumn tableColumn = this.privilegedColumnsTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(148);
        tableColumn.setMaxWidth(148);
        TableColumn tableColumn2 = this.privilegedColumnsTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(210);
        tableColumn2.setMaxWidth(210);
        this.privilegedColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectedRow() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonColumnRemove.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonColumnRemove.setEnabled(true);
                    PrivilegedObject privilegedObject = (PrivilegedObject)ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.get(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectedRow());
                    ColumnsPermissionsDialogOracle.this.containerListPrivileges = new ArrayList();
                    ColumnsPermissionsDialogOracle.this.currentPrivilegedObject = privilegedObject;
                    ColumnsPermissionsDialogOracle.this.refreshGrantedUserRoleProvileges();
                    ColumnsPermissionsDialogOracle.this.containerListPrivileges.clear();
                    ArrayList arrayList = ColumnsPermissionsDialogOracle.this.loadGrantedObjectProvileges(privilegedObject);
                    ColumnsPermissionsDialogOracle.this.loadAvailableObjectPrivileges(arrayList);
                    ColumnsPermissionsDialogOracle.this.availablePrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
                    ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
                    ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.privilegedColumnsTable);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        jPanel.add((Component)jScrollPane, "North");
        this.privilegedColumnsPanel.add((Component)jPanel, "North");
    }

    private ArrayList<Object> loadGrantedObjectProvileges(PrivilegedObject privilegedObject) {
        this.containerListPrivileges.clear();
        ArrayList<Privilege> arrayList = privilegedObject.getPrivileges();
        Iterator<Privilege> iterator = arrayList.iterator();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Privilege privilege = iterator.next();
            this.containerListPrivileges.add(privilege);
            arrayList2.add(privilege.getObject());
        }
        return arrayList2;
    }

    private void loadAvailableObjectPrivileges(ArrayList<Object> arrayList) {
        String[] stringArray = null;
        stringArray = PermissionsOracle.getColumnPermissionsValues();
        this.availablePrivilegesModel.clear();
        if (stringArray != null) {
            Iterator<String> iterator = Arrays.asList(stringArray).iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().trim();
                if (arrayList.size() != 0 && arrayList.contains(string)) continue;
                this.availablePrivilegesModel.addElement(string);
            }
        }
    }

    private void initPrivilegesAddRemoveButtons() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonPrivilegeAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonPrivilegeAdd.addActionListener(new AddPrivilegeActionListener());
        this.buttonPrivilegeAdd.setEnabled(false);
        this.buttonPrivilegeAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonPrivilegeRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonPrivilegeRemove.setEnabled(false);
        this.buttonPrivilegeRemove.addActionListener(new RemovePrivilegeActionListener());
        this.buttonPrivilegeRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonPrivilegeAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonPrivilegeRemove.setPreferredSize(this.buttonPrivilegeAdd.getPreferredSize());
        jPanel3.add((Component)this.buttonPrivilegeAdd, "North");
        jPanel3.add((Component)this.buttonPrivilegeRemove, "Center");
        jPanel2.add(jPanel3);
        jPanel.add(new JPanel());
        jPanel.add(jPanel2);
        jPanel.add(new JPanel());
        this.privilegesPanel.add((Component)jPanel, "East");
    }

    private void checkPermissions(Object object) {
        PermissionsOracle permissionsOracle = this.getPermissionPerObject((StorageObject)this.userRole, (ColumnProxyOracle)object);
        if (permissionsOracle == null) {
            this.allColumnsPanelListModel.addElement(object);
        } else if (permissionsOracle != null) {
            Object object2;
            Object object3;
            this.privilegedUserRolePrivilegesTable.updateUI();
            PrivilegedObject privilegedObject = new PrivilegedObject(object);
            ArrayList<Privilege> arrayList = new ArrayList<Privilege>();
            StringTokenizer stringTokenizer = new StringTokenizer(permissionsOracle.getPrivs((ColumnProxyOracle)object), ",");
            while (stringTokenizer.hasMoreTokens()) {
                object3 = stringTokenizer.nextToken().trim();
                object2 = new Privilege(((String)object3).trim());
                ((Privilege)object2).setName((String)object3);
                arrayList.add((Privilege)object2);
            }
            object3 = new StringTokenizer(permissionsOracle.getPrivsWithGrantOption((ColumnProxyOracle)object), ",");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken().trim();
                Privilege privilege = new Privilege(((String)object2).trim());
                privilege.setName((String)object2);
                privilege.setGrantOption(true);
                arrayList.add(privilege);
            }
            privilegedObject.setPrivileges(arrayList);
            this.privilegedColumnsContainerList.add(privilegedObject);
        }
    }

    private PermissionsOracle getPermissionPerObject(StorageObject storageObject, ColumnProxyOracle columnProxyOracle) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (permissionsOracle.getUser() != storageObject && permissionsOracle.getRole() != storageObject || permissionsOracle.getColumnsTable() == null || !permissionsOracle.getColumnsTable().getObjectID().equals(columnProxyOracle.getTableProxy().getObjectID()) || !permissionsOracle.getColumns().contains(columnProxyOracle.getName()) && !permissionsOracle.getColumnsWithGrantOption().contains(columnProxyOracle.getName())) continue;
            return permissionsOracle;
        }
        return null;
    }

    private void initBottomPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.bnOK = new JButton(Messages.getString("ObjectPermissionsDialogOracle.OK"));
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnOK);
        this.bnApply = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Apply"));
        this.bnApply.addActionListener(new ApplyAction());
        this.bnApply.setMnemonic(65);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnApply);
        this.bnCancel = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel2.add(this.bnCancel);
        jPanel.add((Component)jPanel2, "South");
    }

    private void initColumnsAddRemoveButtons(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        jPanel2.setPreferredSize(new Dimension(35, 500));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.buttonColumnAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonColumnAdd.addActionListener(new AddColumnActionListener());
        this.buttonColumnAdd.setEnabled(false);
        this.buttonColumnAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonColumnRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonColumnRemove.setEnabled(false);
        this.buttonColumnRemove.addActionListener(new RemoveColumnsActionActionListener());
        this.buttonColumnRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonColumnAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonColumnRemove.setPreferredSize(this.buttonColumnAdd.getPreferredSize());
        jPanel4.add((Component)this.buttonColumnAdd, "North");
        jPanel4.add((Component)this.buttonColumnRemove, "Center");
        jPanel3.add(jPanel4);
        jPanel2.add(new JPanel());
        jPanel2.add(jPanel3);
        jPanel2.add(new JPanel());
        jPanel2.add(new JPanel());
        jPanel.add((Component)jPanel2, "Center");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ColumnsPermissionsDialogOracle.ColumnsPermissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public DefaultListModel sort(DefaultListModel defaultListModel) {
        for (int i = 0; i < defaultListModel.size() - 1; ++i) {
            boolean bl = true;
            for (int j = 1; j < defaultListModel.size() - i; ++j) {
                if (defaultListModel.get(j).toString().compareTo(defaultListModel.get(j - 1).toString()) >= 0) continue;
                Object e = defaultListModel.get(j);
                defaultListModel.remove(j);
                defaultListModel.add(j, defaultListModel.get(j - 1));
                defaultListModel.remove(j - 1);
                defaultListModel.add(j - 1, e);
                bl = false;
            }
            if (bl) break;
        }
        return defaultListModel;
    }

    protected void savePermissions() {
        StorageObject storageObject;
        Object object;
        PermissionsOracle permissionsOracle = null;
        PermissionsSetOracle permissionsSetOracle = this.storageDesign.getPermissionsSet();
        for (int i = 0; i < this.privilegedColumnsTable.getRowCount(); ++i) {
            object = (PrivilegedObject)this.privilegedColumnsContainerList.get(i);
            storageObject = (ColumnProxyOracle)((PrivilegedObject)object).getObject();
            permissionsOracle = this.getPermissionPerObject((StorageObject)this.userRole, (ColumnProxyOracle)storageObject);
            if (permissionsOracle == null) {
                permissionsOracle = permissionsSetOracle.createPermissions();
                permissionsOracle.setColumnsTable(((ColumnProxyOracle)storageObject).getTableProxy());
                if (this.userRole instanceof UserOracle) {
                    permissionsOracle.setUser((UserOracle)this.userRole);
                } else if (this.userRole instanceof RoleOracle) {
                    permissionsOracle.setRole((RoleOracle)this.userRole);
                }
            } else if (permissionsOracle != null) {
                permissionsOracle.clearColPermissions();
            }
            String string = "";
            string = string.concat(((RelationalObjectProxy)storageObject).getName());
            String string2 = "";
            string2 = string2.concat(((RelationalObjectProxy)storageObject).getName());
            for (Privilege privilege : ((PrivilegedObject)object).getPrivileges()) {
                if (privilege.getGrantOption()) {
                    string2 = string2.concat(", ").concat((String)privilege.getObject());
                    continue;
                }
                string = string.concat(", ").concat((String)privilege.getObject());
            }
            if (string.indexOf(",") > -1) {
                permissionsOracle.setColumnList(string);
            }
            if (string2.indexOf(",") <= -1) continue;
            permissionsOracle.setColumnListWithGrantOption(string2);
        }
        Iterator iterator = this.objWithRevokedPrivs.iterator();
        while (iterator.hasNext()) {
            object = (ColumnProxyOracle)((PrivilegedObject)iterator.next()).getObject();
            storageObject = this.getPermissionPerObject((StorageObject)this.userRole, (ColumnProxyOracle)object);
            permissionsSetOracle.remove(storageObject);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogOracle.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogOracle.this.savePermissions();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogOracle.this.savePermissions();
            ColumnsPermissionsDialogOracle.this.close();
        }
    }

    class PrivilegedObject {
        Object obj = null;
        ArrayList<Privilege> privileges = new ArrayList();
        ArrayList<Privilege> privilegesWithGrantOption = new ArrayList();

        PrivilegedObject(Object object) {
            this.obj = object;
        }

        void addPrivilege(Privilege privilege) {
            this.privileges.add(privilege);
        }

        void removePrivilege(Privilege privilege) {
            this.privileges.remove(privilege);
        }

        Object getObject() {
            return this.obj;
        }

        ArrayList<Privilege> getPrivileges() {
            return this.privileges;
        }

        void setPrivileges(ArrayList<Privilege> arrayList) {
            this.privileges = arrayList;
        }

        void addPrivilegeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.add(privilege);
        }

        void removeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.remove(privilege);
        }

        ArrayList<Privilege> getPrivilegeWithGrantOption() {
            return this.privilegesWithGrantOption;
        }
    }

    class Privilege {
        Object obj = null;
        String name = "";
        boolean grantOption = false;
        boolean hierarchy = false;

        Privilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        void setGrantOption(boolean bl) {
            this.grantOption = bl;
        }

        boolean getGrantOption() {
            return this.grantOption;
        }

        void setHierarchy(boolean bl) {
            this.hierarchy = bl;
        }

        boolean getHierarchy() {
            return this.hierarchy;
        }
    }

    private class RemovePrivilegeActionListener
    implements ActionListener {
        private RemovePrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRows();
            ArrayList<Privilege> arrayList = new ArrayList<Privilege>();
            for (int i = 0; i < nArray.length; ++i) {
                Privilege privilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(nArray[i]);
                Object object = privilege.getObject();
                arrayList.add(privilege);
                if (ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.contains(object)) continue;
                ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.addElement(object);
                ColumnsPermissionsDialogOracle.this.currentPrivilegedObject.removePrivilege(privilege);
                ColumnsPermissionsDialogOracle.this.sort(ColumnsPermissionsDialogOracle.this.availablePrivilegesModel);
                ColumnsPermissionsDialogOracle.this.availablePrivilegesList.setSelectedValue(object, true);
            }
            ColumnsPermissionsDialogOracle.this.containerListPrivileges.removeAll(arrayList);
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
        }
    }

    private class AddPrivilegeActionListener
    implements ActionListener {
        private AddPrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ColumnsPermissionsDialogOracle.this.availablePrivilegesList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Privilege privilege = new Privilege(objectArray[i]);
                if (ColumnsPermissionsDialogOracle.this.containerListPrivileges.contains(privilege)) continue;
                ColumnsPermissionsDialogOracle.this.containerListPrivileges.add(privilege);
                ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.removeElement(objectArray[i]);
                ColumnsPermissionsDialogOracle.this.currentPrivilegedObject.addPrivilege(privilege);
            }
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectionModel().setSelectionInterval(ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1, ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1);
        }
    }

    private class RemoveColumnsActionActionListener
    implements ActionListener {
        private RemoveColumnsActionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogOracle.this.objWithRevokedPrivs.clear();
            int[] nArray = ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                PrivilegedObject privilegedObject = (PrivilegedObject)ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.get(nArray[i]);
                Object object = privilegedObject.getObject();
                ColumnsPermissionsDialogOracle.this.objWithRevokedPrivs.add(privilegedObject);
                if (ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel.contains(object)) continue;
                ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel.addElement(object);
                ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.remove(privilegedObject);
                ColumnsPermissionsDialogOracle.this.sort(ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel);
                ColumnsPermissionsDialogOracle.this.allColumnsPanelList.setSelectedValue(object, true);
            }
            ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.clear();
            ColumnsPermissionsDialogOracle.this.containerListPrivileges.clear();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.clearSelection();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
        }
    }

    private class AddColumnActionListener
    implements ActionListener {
        private AddColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ColumnsPermissionsDialogOracle.this.allColumnsPanelList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                PrivilegedObject privilegedObject = new PrivilegedObject(objectArray[i]);
                if (ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.contains(privilegedObject)) continue;
                ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.add(privilegedObject);
                ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel.removeElement(objectArray[i]);
            }
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectionModel().setSelectionInterval(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowCount() - 1, ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowCount() - 1);
        }
    }

    private class allColumnsPanelSelectionListener
    implements ListSelectionListener {
        private allColumnsPanelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private class PriviligedColumnsModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ColumnsPermissionsDialogOracle.Column"), Messages.getString("ColumnsPermissionsDialogOracle.Privilegepermission")};

        private PriviligedColumnsModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PrivilegedObject privilegedObject = (PrivilegedObject)ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.get(n);
            if (n2 == 0) {
                return privilegedObject.getObject();
            }
            if (n2 == 1) {
                String string = "";
                ArrayList<Privilege> arrayList = privilegedObject.getPrivileges();
                Iterator<Privilege> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = string + "," + iterator.next().getObject();
                }
                return privilegedObject.getPrivileges().size() == 0 ? "" : string.substring(1, string.length());
            }
            return "";
        }
    }

    private class GrantedPrivilegessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2441829494099422701L;
        final String[] COL_NAMES = new String[]{Messages.getString("ObjectPermissionsDialogOracle.Privilege"), Messages.getString("ObjectPermissionsDialogOracle.Grant")};
        boolean[] columnsVisible = new boolean[3];

        public GrantedPrivilegessModel() {
            this.columnsVisible[0] = true;
            this.columnsVisible[1] = false;
        }

        @Override
        public int getColumnCount() {
            int n = 0;
            for (int i = 0; i < this.COL_NAMES.length; ++i) {
                if (!this.columnsVisible[i]) continue;
                ++n;
            }
            return n;
        }

        protected int getNumber(int n) {
            int n2 = n;
            int n3 = 0;
            do {
                if (this.columnsVisible[n3]) continue;
                ++n2;
            } while (++n3 < n2);
            while (!this.columnsVisible[n2]) {
                ++n2;
            }
            return n2;
        }

        @Override
        public int getRowCount() {
            return ColumnsPermissionsDialogOracle.this.containerListPrivileges.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[this.getNumber(n)];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            Object var3_3 = null;
            int n3 = this.getNumber(n2);
            if (n3 == 0) {
                return false;
            }
            return n3 == 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            int n3 = this.getNumber(n2);
            Privilege privilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(n);
            if (object instanceof Boolean && n3 == 1) {
                privilege.setGrantOption((Boolean)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = this.getNumber(n2);
            Privilege privilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(n);
            if (n3 == 0) {
                return ((String)privilege.getObject()).trim();
            }
            if (n3 == 1) {
                return new Boolean(privilege.grantOption);
            }
            return "";
        }
    }
}

