/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2.v80;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TablePartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.InstanceDescriptorColumnPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.PermissionsPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.TablePartitionPropertyDialogDB2v80;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JDecimalField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogDB2v80
extends AbstractDB2PropertyDialog {
    protected TableProxyDB2v80 table;
    protected JComboBox cbOwner;
    protected JComboBox cbTableSpace;
    protected JComboBox cbDataBase;
    protected JIntegerField ifObid;
    protected JTextField tfEditProc;
    protected JTextField tfValidProc;
    protected JComboBox cbAudit;
    protected JComboBox cbDataCapture;
    protected JComboBox cbRestrictOnDrop;
    protected JComboBox cbCCSID;
    protected JTextField tfLabel;
    protected JPanel columns;
    protected JPanel indices;
    protected JPanel catalogStats;
    protected JPanel designStats;
    protected JList columnList;
    protected JList indexList;
    protected DefaultListModel columnListModel;
    protected DefaultListModel indexListModel;
    protected JIntegerField ifCARDF;
    protected JTextField tfCreatedBy;
    protected JIntegerField ifRecLength;
    protected JIntegerField ifNPAGES;
    protected JIntegerField ifPCTPAGES;
    protected JIntegerField ifMaxRows;
    protected JIntegerField ifInitialRows;
    protected JDecimalField dfAURInsert;
    protected JDecimalField dfAURDelete;
    protected JDecimalField dfAURNetGrowth;
    protected JDecimalField dfAGInsert;
    protected JDecimalField dfAGDelete;
    protected JDecimalField dfAGData;
    protected JIntegerField ifGrowthHorizon;
    protected JIntegerField ifPCTFilling;
    protected JComboBox cbGrowthMethod;
    protected JComboBox cbInsertMethod;
    protected JTextPane taSpaceCalcs;
    protected JPanel spaceCalcs;
    protected JCheckBox chbUsePCTFilling;
    protected JScrollPane spSpaceCalcs;
    protected JScrollPane spColumns;
    protected JScrollPane spIndices;
    protected JIntegerField ifNumParts;
    protected JComboBox cbPartitioned;
    protected JComboBox cbMaterializedQuery;
    protected JComboBox cbTableAccess;
    protected JComboBox cbMQStatus;
    protected JComboBox cbMQMaintenance;
    protected JComboBox cbMQQueryOptimization;
    protected JComboBox cbMQIdentityColumnAttr;
    protected JComboBox cbMQColumnDefaults;
    protected JPanel materializedQuery;
    protected JPanel partitioningKey;
    protected JTextArea queryArea;
    private DefaultListModel allColumnsModel;
    private JList allColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JTable selectedColumnsTable;
    private IndexTableModel selectedColumnsModel;
    private String comment;
    private String commentInRDBMS;
    private JPanel partitionsOrder;
    private DefaultListModel partitionsModel;
    private JList partitionsList;
    private JButton bnPermissions;
    private PermissionsPropertyDialogDB2 dialog;
    private JPanel instDescriptorPanel;
    private List eList;
    private JTable etable;
    private int attrCounter = 0;

    public TablePropertyDialogDB2v80(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.table = (TableProxyDB2v80)storageObject;
        this.setHeight(620);
        this.initCommentsView(245);
        this.initCommentsInRDBMS(250);
        this.initSpaceCalcsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogDB2v80.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initTableSpace();
        this.initDataBase();
        this.initOBID();
        this.initEditProc();
        this.initValidProc();
        this.initAudit();
        this.initDataCapture();
        this.initRestrictOnDrop();
        this.initCCSID();
        this.initLabel();
        this.initSpaceCalcs();
        this.initPartitioned();
        this.initNumParts();
        this.initHasMaterializedQuery();
        this.initTableAccess();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    protected void initOwner() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.OwnerProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 50);
        this.setObjectConstraints(jButton, 50);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TablePropertyDialogDB2v80.this.cbOwner.getSelectedItem();
                if (object != null && object instanceof Owner) {
                    Owner owner = (Owner)object;
                    owner.showPropertyDialog();
                }
            }
        });
    }

    protected void initTableSpace() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.TablespaceProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.cbTableSpace.addActionListener(new ComboListener());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTableSpace, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.setObjectConstraints(jButton, 80);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TablePropertyDialogDB2v80.this.cbTableSpace.getSelectedItem();
                if (object != null && object instanceof TableSpaceDB2) {
                    TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)object;
                    tableSpaceDB2.showPropertyDialog();
                }
            }
        });
    }

    protected void initDataBase() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.DataBaseProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.DataBase"));
        this.general.add(jLabel);
        this.cbDataBase = new JComboBox();
        this.setBG(this.cbDataBase);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getDataBaseSet().toArray(), this.cbDataBase);
        }
        this.cbDataBase.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.cbDataBase.setEnabled(false);
        this.general.add(this.cbDataBase);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbDataBase, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 110);
        this.setObjectConstraints(jButton, 110);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TablePropertyDialogDB2v80.this.cbDataBase.getSelectedItem();
                if (object != null && object instanceof DataBaseDB2) {
                    DataBaseDB2 dataBaseDB2 = (DataBaseDB2)object;
                    dataBaseDB2.showPropertyDialog();
                }
            }
        });
    }

    protected void initOBID() {
        JLabel jLabel = new JLabel("OBID");
        this.general.add(jLabel);
        this.ifObid = new JIntegerField(0, 26);
        this.general.add(this.ifObid);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.ifObid, 140);
    }

    protected void initEditProc() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.EditProc"));
        this.general.add(jLabel);
        this.tfEditProc = new JTextField("", 26);
        this.general.add(this.tfEditProc);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfEditProc, 170);
    }

    protected void initValidProc() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.ValidProc"));
        this.general.add(jLabel);
        this.tfValidProc = new JTextField("", 26);
        this.general.add(this.tfValidProc);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfValidProc, 200);
    }

    protected void initAudit() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Audit"));
        this.general.add(jLabel);
        this.cbAudit = new JComboBox<String>(TableProxyDB2.getAuditChoices());
        this.setBG(this.cbAudit);
        this.cbAudit.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAudit);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbAudit, 230);
    }

    protected void initDataCapture() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.DataCapture"));
        this.general.add(jLabel);
        this.cbDataCapture = new JComboBox<String>(TableProxyDB2.getDataCaptureValues());
        this.setBG(this.cbDataCapture);
        this.cbDataCapture.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataCapture);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbDataCapture, 260);
    }

    protected void initRestrictOnDrop() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.DropRestrict"));
        this.general.add(jLabel);
        this.cbRestrictOnDrop = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRestrictOnDrop);
        this.cbRestrictOnDrop.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRestrictOnDrop);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbRestrictOnDrop, 290);
    }

    protected void initCCSID() {
        JLabel jLabel = new JLabel("CCSID");
        this.general.add(jLabel);
        this.cbCCSID = new JComboBox<String>(TableProxyDB2.getCcsidValues());
        this.setBG(this.cbCCSID);
        this.cbCCSID.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCCSID);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbCCSID, 320);
    }

    protected void initLabel() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Label"));
        this.general.add(jLabel);
        this.tfLabel = new JTextField("", 26);
        this.general.add(this.tfLabel);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.tfLabel, 350);
    }

    @Override
    protected void addTabs() {
        this.initCatalogStatsView();
        this.initDesignStatsView();
        this.initMaterializedQueryView();
        this.initPartitioningKeyView();
        this.initPartitionsOrderView();
        this.initInstanceDescriptorView();
    }

    private void initInstanceDescriptorView() {
        this.instDescriptorPanel = new JPanel();
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.InstanceDescriptor"), this.instDescriptorPanel);
        this.initInstanceDescriptor();
    }

    private void initInstanceDescriptor() {
        ElementModel elementModel = new ElementModel();
        this.eList = new ArrayList();
        this.etable = new JTable(elementModel);
        this.etable.setSelectionMode(0);
        this.etable.setFocusTraversalKeysEnabled(false);
        TableColumn tableColumn = this.etable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(400);
        tableColumn = this.etable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        this.etable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2;
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = TablePropertyDialogDB2v80.this.etable.getSelectedRow()) != -1 && TablePropertyDialogDB2v80.this.eList.size() > 0 && n < TablePropertyDialogDB2v80.this.eList.size() && !(instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(n)).isDialogVisible()) {
                    InstanceDescriptorColumnPropertyDialogDB2 instanceDescriptorColumnPropertyDialogDB2 = new InstanceDescriptorColumnPropertyDialogDB2(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.table.getStorageDesign(), instanceDescriptorColumnDB2);
                    instanceDescriptorColumnPropertyDialogDB2.initProperties();
                    instanceDescriptorColumnPropertyDialogDB2.show();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.etable);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.Properties"));
        jButton.addActionListener(new PropertiesAction());
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", 16));
        jButton2.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.Add"));
        jButton2.addActionListener(new AddAction());
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        jButton3.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.Remove"));
        jButton3.addActionListener(new RemoveAction());
        JButton jButton4 = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
        jButton4.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.MoveUp"));
        jButton4.addActionListener(new MoveUpColAction());
        JButton jButton5 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
        jButton5.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.MoveDown"));
        jButton5.addActionListener(new MoveDownColAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jToolBar.add(jButton4);
        jToolBar.add(jButton5);
        jPanel.add(jToolBar);
        jPanel.setPreferredSize(new Dimension(395, 30));
        jScrollPane.setPreferredSize(new Dimension(395, 490));
        this.instDescriptorPanel.add((Component)jPanel, "North");
        this.instDescriptorPanel.add(jScrollPane);
    }

    protected String generateName() {
        String string = "InstanceDescriptorCol";
        int n = 0;
        int n2 = this.eList.size();
        if (n2 != 0) {
            n = this.attrCounter = n2 + 1;
        } else {
            ++this.attrCounter;
            n = this.attrCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.instDescrExists(string2)) {
            n = ++this.attrCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean instDescrExists(String string) {
        for (int i = 0; i < this.eList.size(); ++i) {
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)this.eList.get(i);
            if (!string.equalsIgnoreCase(instanceDescriptorColumnDB2.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean moveElementToIndex(InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2, int n) {
        if (this.eList.contains(instanceDescriptorColumnDB2) && this.eList.size() > n && n >= 0) {
            this.eList.remove(instanceDescriptorColumnDB2);
            this.eList.add(n, instanceDescriptorColumnDB2);
            return true;
        }
        return false;
    }

    protected void initMaterializedQueryView() {
        this.materializedQuery = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.MaterializedQuery"), this.materializedQuery);
        this.initMaterializedQuery();
    }

    private void initMaterializedQuery() {
        this.initMQQueryDefinition();
        this.initMQStatus();
        this.initMQMaintenance();
        this.initMQQueryOptimization();
        this.initMQIdentityColumnAttr();
        this.initMQColumnDefaults();
    }

    private void initMQQueryDefinition() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Query"));
        this.materializedQuery.add(jLabel);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), jLabel, 10);
        this.queryArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.queryArea);
        jScrollPane.setPreferredSize(new Dimension(395, 340));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.queryArea.setLineWrap(true);
        this.materializedQuery.add(jScrollPane);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), jScrollPane, 10, 30);
    }

    protected SpringLayout getMaterializedQueryLayout() {
        return (SpringLayout)this.materializedQuery.getLayout();
    }

    private void initMQStatus() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Status"));
        this.materializedQuery.add(jLabel);
        this.cbMQStatus = new JComboBox<String>(TableProxyDB2v80.MQ_STATUS_STATES);
        this.setBG(this.cbMQStatus);
        this.cbMQStatus.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQStatus);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), jLabel, 390);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQStatus, 390);
    }

    private void initMQMaintenance() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Maintenance"));
        this.materializedQuery.add(jLabel);
        this.cbMQMaintenance = new JComboBox<String>(TableProxyDB2v80.MQ_MAINTENANCE_STATES);
        this.setBG(this.cbMQMaintenance);
        this.cbMQMaintenance.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQMaintenance);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), jLabel, 420);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQMaintenance, 420);
    }

    private void initMQQueryOptimization() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.QueryOptimization"));
        this.materializedQuery.add(jLabel);
        this.cbMQQueryOptimization = new JComboBox<String>(TableProxyDB2v80.MQ_QUERY_OPTIMIZATION_STATES);
        this.setBG(this.cbMQQueryOptimization);
        this.cbMQQueryOptimization.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQQueryOptimization);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), jLabel, 450);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQQueryOptimization, 450);
    }

    private void initMQIdentityColumnAttr() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.IdentityColumnAttr"));
        this.materializedQuery.add(jLabel);
        this.cbMQIdentityColumnAttr = new JComboBox<String>(TableProxyDB2v80.MQ_IDENTITY_COLUMN_ATTR_STATES);
        this.setBG(this.cbMQIdentityColumnAttr);
        this.cbMQIdentityColumnAttr.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQIdentityColumnAttr);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), jLabel, 480);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQIdentityColumnAttr, 480);
    }

    private void initMQColumnDefaults() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.ColumnDefaults"));
        this.materializedQuery.add(jLabel);
        this.cbMQColumnDefaults = new JComboBox<String>(TableProxyDB2v80.MQ_COLUMN_DEFAULTS_STATES);
        this.setBG(this.cbMQColumnDefaults);
        this.cbMQColumnDefaults.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQColumnDefaults);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), jLabel, 510);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQColumnDefaults, 510);
    }

    protected void initPartitioningKeyView() {
        this.partitioningKey = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.PartitioningKey"), this.partitioningKey);
        this.initPartitioningKey();
    }

    private void initPartitionsOrderView() {
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.PartitionsOrder"), this.partitionsOrder);
        this.initPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.Properties"));
        jButton.addActionListener(new PartitionPropertiesAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        if (this.isEditable()) {
            jComponent = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
            jComponent.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.MoveUp"));
            ((AbstractButton)jComponent).addActionListener(new MoveUpAction());
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
            jButton2.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.MoveDown"));
            jButton2.addActionListener(new MoveDownAction());
            jToolBar.addSeparator();
            jToolBar.add(jComponent);
            jToolBar.add(jButton2);
        }
        jPanel.add(jToolBar);
        this.partitionsOrder.add((Component)jPanel, "North");
        this.partitionsModel = new DefaultListModel();
        this.partitionsList = new JList(this.partitionsModel);
        jComponent = new JScrollPane(this.partitionsList);
        jComponent.setPreferredSize(new Dimension(400, 490));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(jComponent);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), jComponent, 6, 40);
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    private void initPartitioningKey() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AllColumns"));
        this.partitioningKey.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setCellRenderer(new AllListColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(395, 210));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioningKey.add(jScrollPane);
        this.setLabelConstraints(this.getPartitioningKeyLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getPartitioningKeyLayout(), jScrollPane, 10, 38);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.SelectedColumns"));
        this.partitioningKey.add(jLabel);
        this.selectedColumnsTable = new JTable(new IndexTableModel());
        this.selectedColumnsModel = (IndexTableModel)this.selectedColumnsTable.getModel();
        this.setUpSortOrderColumn(this.selectedColumnsTable.getColumnModel().getColumn(1));
        ListSelectionModel listSelectionModel = this.selectedColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, 200));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioningKey.add(jScrollPane);
        this.setLabelConstraints(this.getPartitioningKeyLayout(), jLabel, 12, 298);
        this.setObjectConstraints(this.getPartitioningKeyLayout(), jScrollPane, 10, 322);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("TablePropertyDialogDB2v80.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.partitioningKey.add(this.bnAdd);
        this.setObjectConstraints(this.getPartitioningKeyLayout(), this.bnAdd, 150, 260);
        this.bnRemove = new JButton(Messages.getString("TablePropertyDialogDB2v80.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.partitioningKey.add(this.bnRemove);
        this.setObjectConstraints(this.getPartitioningKeyLayout(), this.bnRemove, 210, 260);
        TablePropertyDialogDB2v80.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getPartitioningKeyLayout() {
        return (SpringLayout)this.partitioningKey.getLayout();
    }

    protected void initPartitioned() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Partitioned"));
        this.general.add(jLabel);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbPartitioned, 380);
    }

    protected void initNumParts() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.NumParts"));
        this.general.add(jLabel);
        this.ifNumParts = new JIntegerField(0, 26);
        this.ifNumParts.setEditable(false);
        this.general.add(this.ifNumParts);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.ifNumParts, 410);
    }

    protected void initHasMaterializedQuery() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.MaterializedQueryL"));
        this.general.add(jLabel);
        this.cbMaterializedQuery = new JComboBox<String>(YES_NO);
        this.setBG(this.cbMaterializedQuery);
        this.cbMaterializedQuery.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbMaterializedQuery);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbMaterializedQuery, 440);
    }

    protected void initTableAccess() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.TableAccess"));
        this.general.add(jLabel);
        this.cbTableAccess = new JComboBox<String>(TableProxyDB2v80.TABLE_ACCESS_STATES);
        this.setBG(this.cbTableAccess);
        this.cbTableAccess.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableAccess);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.cbTableAccess, 470);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("TablePropertyDialogDB2v80.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(TablePropertyDialogDB2v80.this.getStorageDesign().getTableProxySet().getElements());
                arrayList.remove(TablePropertyDialogDB2v80.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.table, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 515);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogDB2v80.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 265, 515);
    }

    public void setUpSortOrderColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("ASC");
        jComboBox.addItem("DESC");
        jComboBox.setSelectedItem("ASC");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.ClickForComboBox"));
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText(Messages.getString("TablePropertyDialogDB2v80.ClickSortOrder"));
        }
    }

    private void initCatalogStatsView() {
        this.catalogStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.CatalogStats"), this.catalogStats);
        this.initCatalogStats();
    }

    private void initDesignStatsView() {
        this.designStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.DesignStats"), this.designStats);
        this.initDesignStats();
    }

    private void initCatalogStats() {
        this.initCARDF();
        this.initCreatedBy();
        this.initRecLength();
        this.initNPAGES();
        this.initPCTPAGES();
    }

    private void initDesignStats() {
        this.initMaxRows();
        this.initInitialRows();
        this.initAURInsert();
        this.initAURDelete();
        this.initAURNetGrowth();
        this.initAGInsert();
        this.initAGDelete();
        this.initAGData();
        this.initGrowthHorizon();
        this.initGrowthMethod();
        this.initInsertMethod();
        this.initUsePCTFilling();
    }

    protected SpringLayout getCatalogStatsLayout() {
        return (SpringLayout)this.catalogStats.getLayout();
    }

    protected SpringLayout getDesignStatsLayout() {
        return (SpringLayout)this.designStats.getLayout();
    }

    private void initCARDF() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.NumberOfRows"));
        this.catalogStats.add(jLabel);
        this.ifCARDF = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifCARDF);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifCARDF, 20);
    }

    private void initCreatedBy() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.CreatedBy"));
        this.catalogStats.add(jLabel);
        this.tfCreatedBy = new JTextField("", 26);
        this.catalogStats.add(this.tfCreatedBy);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.tfCreatedBy, 50);
    }

    private void initRecLength() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.RecordLength"));
        this.catalogStats.add(jLabel);
        this.ifRecLength = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifRecLength);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 80);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifRecLength, 80);
    }

    private void initNPAGES() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.NumberOfPages"));
        this.catalogStats.add(jLabel);
        this.ifNPAGES = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifNPAGES);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 110);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifNPAGES, 110);
    }

    private void initPCTPAGES() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.PCTPages"));
        this.catalogStats.add(jLabel);
        this.ifPCTPAGES = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifPCTPAGES);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 140);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifPCTPAGES, 140);
    }

    private void initMaxRows() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.MaxRows"));
        this.designStats.add(jLabel);
        this.ifMaxRows = new JIntegerField(0, 26);
        this.designStats.add(this.ifMaxRows);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifMaxRows, 20);
    }

    private void initInitialRows() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.InitialRows"));
        this.designStats.add(jLabel);
        this.ifInitialRows = new JIntegerField(0, 26);
        this.designStats.add(this.ifInitialRows);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifInitialRows, 50);
    }

    private void initAURInsert() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AURInsert"));
        this.designStats.add(jLabel);
        this.dfAURInsert = new JDecimalField(0.0, 26);
        this.dfAURInsert.addActionListener(new AURFieldListener());
        this.designStats.add(this.dfAURInsert);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 80);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAURInsert, 80);
    }

    private void initAURDelete() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AURDelete"));
        this.designStats.add(jLabel);
        this.dfAURDelete = new JDecimalField(0.0, 26);
        this.dfAURDelete.addActionListener(new AURFieldListener());
        this.designStats.add(this.dfAURDelete);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 110);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAURDelete, 110);
    }

    private void initAURNetGrowth() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AURNetGrowth"));
        this.designStats.add(jLabel);
        this.dfAURNetGrowth = new JDecimalField(0.0, 26);
        this.dfAURNetGrowth.setEditable(false);
        this.designStats.add(this.dfAURNetGrowth);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 140);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAURNetGrowth, 140);
    }

    private void initAGInsert() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AGInsert"));
        this.designStats.add(jLabel);
        this.dfAGInsert = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAGInsert);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 170);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAGInsert, 170);
    }

    private void initAGDelete() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AGDelete"));
        this.designStats.add(jLabel);
        this.dfAGDelete = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAGDelete);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 200);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAGDelete, 200);
    }

    private void initAGData() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AGData"));
        this.designStats.add(jLabel);
        this.dfAGData = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAGData);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 230);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAGData, 230);
    }

    private void initGrowthHorizon() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.GrowthHorizon"));
        this.designStats.add(jLabel);
        this.ifGrowthHorizon = new JIntegerField(0, 26);
        this.designStats.add(this.ifGrowthHorizon);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 260);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifGrowthHorizon, 260);
    }

    private void initGrowthMethod() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.GrowthMethod"));
        this.designStats.add(jLabel);
        this.cbGrowthMethod = new JComboBox<String>(TableProxyDB2.getGrowthMethodChoices());
        this.setBG(this.cbGrowthMethod);
        this.cbGrowthMethod.setPreferredSize(this.tfName.getPreferredSize());
        this.designStats.add(this.cbGrowthMethod);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 290);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.cbGrowthMethod, 290);
    }

    protected void initSpaceCalcsView() {
        this.spaceCalcs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.SpaceCalcs"), this.spaceCalcs);
        this.taSpaceCalcs = new JTextPane();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.taSpaceCalcs.setParagraphAttributes(simpleAttributeSet, true);
        this.spSpaceCalcs = new JScrollPane(this.taSpaceCalcs);
        this.spSpaceCalcs.setPreferredSize(new Dimension(395, 520));
        this.spSpaceCalcs.setBorder(BorderFactory.createEtchedBorder(0));
        this.spaceCalcs.add(this.spSpaceCalcs);
        this.setObjectConstraints(this.getSpaceCalcsLayout(), this.spSpaceCalcs, 10, 12);
        this.taSpaceCalcs.setEditable(false);
    }

    protected SpringLayout getSpaceCalcsLayout() {
        return (SpringLayout)this.spaceCalcs.getLayout();
    }

    private void initInsertMethod() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.InsertMethod"));
        this.designStats.add(jLabel);
        this.cbInsertMethod = new JComboBox<String>(TableProxyDB2.getInsertMethodChoices());
        this.setBG(this.cbInsertMethod);
        this.cbInsertMethod.setPreferredSize(this.tfName.getPreferredSize());
        this.designStats.add(this.cbInsertMethod);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 320);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.cbInsertMethod, 320);
    }

    private String formatText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        while (stringBuffer.length() < 30) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("\t");
        return stringBuffer.toString();
    }

    private String formatInt(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toString(n);
        for (int i = 0; i < 15 - string.length(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected void initSpaceCalcs() {
        if (this.table != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.InitialPagesUsed"))).append(this.formatInt(this.table.getInitialNumberUsedPages())).append("\n");
            stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.MaxPagesUsed"))).append(this.formatInt(this.table.getMaxNumberUsedPages())).append("\n\n");
            if (this.table.getTableSpace() != null) {
                String string;
                stringBuffer.append(Messages.getString("TablePropertyDialogDB2v80.ForTablespace")).append(this.table.getTableSpace().getName());
                stringBuffer.append('\n');
                if (this.table.getTableSpace().getStorageTemplate() != null) {
                    stringBuffer.append("(" + Messages.getString("TablePropertyDialogDB2v80.StorageTemplate")).append(this.table.getTableSpace().getStorageTemplate().getName());
                    stringBuffer.append(")\n");
                }
                stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.ProposedPRIQTY"))).append(this.formatInt(this.table.getTableSpace().getProposedPRIQTY())).append("\n");
                stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.ProposedSECQTY"))).append(this.formatInt(this.table.getTableSpace().getProposedSECQTY())).append("\n");
                if (this.table.getTableSpace().getStorageTemplate() != null) {
                    stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.CurrentPRIQTY"))).append(this.formatInt(this.table.getTableSpace().getStorageTemplate().getSgPriqty())).append("\n");
                    stringBuffer.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.CurrentSECQTY"))).append(this.formatInt(this.table.getTableSpace().getStorageTemplate().getSgSeqty())).append("\n");
                }
                if (!(string = this.table.getTableSpace().getProposedQTYRemarks()).equals("")) {
                    stringBuffer.append(Messages.getString("TablePropertyDialogDB2v80.RemarksOnProposedPRIQTYAndSECQTY")).append(string);
                }
            }
            this.taSpaceCalcs.setText(stringBuffer.toString());
        }
    }

    private void initUsePCTFilling() {
        JLabel jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.UsePCTFillingForVarTypes"));
        this.designStats.add(jLabel);
        this.chbUsePCTFilling = new JCheckBox("");
        this.chbUsePCTFilling.addActionListener(new CheckBoxListener());
        this.designStats.add(this.chbUsePCTFilling);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 350);
        SpringLayout.Constraints constraints = this.getDesignStatsLayout().getConstraints(this.chbUsePCTFilling);
        constraints.setX(Spring.constant(175));
        constraints.setY(Spring.constant(350));
        jLabel = new JLabel(Messages.getString("TablePropertyDialogDB2v80.PCTFilling"));
        constraints = this.getDesignStatsLayout().getConstraints(jLabel);
        constraints.setX(Spring.constant(220));
        constraints.setY(Spring.constant(350));
        this.designStats.add(jLabel);
        this.ifPCTFilling = new JIntegerField(0, 3);
        this.setBG(this.ifPCTFilling);
        this.designStats.add(this.ifPCTFilling);
        constraints = this.getDesignStatsLayout().getConstraints(this.ifPCTFilling);
        constraints.setX(Spring.constant(290));
        constraints.setY(Spring.constant(350));
        this.setPCTFillingUse(false);
    }

    protected void setPCTFillingUse(boolean bl) {
        this.ifPCTFilling.setEditable(bl);
        this.ifPCTFilling.setEnabled(bl);
    }

    @Override
    public void initProperties() {
        int n;
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        this.selectObject(this.cbOwner, this.table.getOwner());
        this.selectObject(this.cbTableSpace, this.table.getTableSpace());
        this.selectObject(this.cbDataBase, this.table.getDataBase());
        this.ifObid.setValue((long)this.table.getObid());
        this.tfEditProc.setText(this.table.getEditProc());
        this.tfValidProc.setText(this.table.getValidProc());
        this.cbAudit.setSelectedItem(this.table.getAudit());
        this.cbDataCapture.setSelectedItem(this.table.getDataCapture() ? TableProxyDB2.getDataCaptureValues()[1] : TableProxyDB2.getDataCaptureValues()[0]);
        this.cbRestrictOnDrop.setSelectedItem(this.table.getDropRestrict() ? YES_NO[0] : YES_NO[1]);
        this.cbCCSID.setSelectedItem(this.table.getCcsid());
        this.tfLabel.setText(this.table.getLabel());
        this.ifNumParts.setValue((long)this.table.getNumParts());
        this.cbPartitioned.setSelectedItem(TablePropertyDialogDB2v80.translateYesNoForDisplay(this.table.getPartitioned()));
        this.cbMaterializedQuery.setSelectedItem(TablePropertyDialogDB2v80.translateYesNoForDisplay(this.table.getMaterializedQuery()));
        this.cbTableAccess.setSelectedItem(this.table.getTableAccess());
        this.ifCARDF.setValue(this.table.getNumberOfRows());
        this.tfCreatedBy.setText(this.table.getCreatedBy());
        this.ifRecLength.setValue((long)this.table.getRecordLength());
        this.ifNPAGES.setValue((long)this.table.getNumberOfPages());
        this.ifPCTPAGES.setValue((long)this.table.getPercentageOfPages());
        this.ifMaxRows.setValue(this.table.getMaxRowNumber());
        this.ifInitialRows.setValue(this.table.getInitialRowNumber());
        this.dfAURInsert.setValue(this.table.getAnnualUpdateRateInsert());
        this.dfAURDelete.setValue(this.table.getAnnualUpdateRateDelete());
        this.dfAURNetGrowth.setValue(this.table.getAnnualUpdateRateNetGrowth());
        this.dfAGInsert.setValue(this.table.getActiveGroupInsert());
        this.dfAGDelete.setValue(this.table.getActiveGroupDelete());
        this.dfAGData.setValue(this.table.getActiveGroupData());
        this.ifGrowthHorizon.setValue((long)this.table.getGrowthHorizon());
        this.cbGrowthMethod.setSelectedItem(this.table.getGrowthMethod());
        this.cbInsertMethod.setSelectedItem(this.table.getInsertMethod());
        this.ifPCTFilling.setValue((long)this.table.getPctFilling());
        this.chbUsePCTFilling.setSelected(this.table.isUsePCTFilling());
        this.setPCTFillingUse(this.table.isUsePCTFilling());
        this.queryArea.setText(this.table.getMqQueryDefinition());
        this.cbMQStatus.setSelectedItem(this.table.getMqStatus());
        this.cbMQMaintenance.setSelectedItem(this.table.getMqMaintenance());
        this.cbMQQueryOptimization.setSelectedItem(this.table.getMqQueryOptimization());
        this.cbMQIdentityColumnAttr.setSelectedItem(this.table.getMqIdentityColumnAttr());
        this.cbMQColumnDefaults.setSelectedItem(this.table.getMqColumnDefaults());
        Table table = (Table)this.table.getObject();
        if (table.isRoot() && table.isBST()) {
            n = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (n > -1) {
                this.getPane().setEnabledAt(n, true);
            }
            this.eList.addAll(this.table.getInstDescriptorCols().getElementsList());
        } else {
            n = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (n > -1) {
                this.getPane().setEnabledAt(n, false);
            }
        }
        this.allColumnsModel.clear();
        ColumnProxy[] columnProxyArray = this.table.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (this.table.getPartitioningKeySet().contains(columnProxyArray[i].getObjectID())) {
                this.selectedColumnsModel.addRow(new Object[]{columnProxyArray[i].getName(), this.table.getPartKeySortOrder(columnProxyArray[i].getObjectID())});
                continue;
            }
            this.allColumnsModel.addElement(columnProxyArray[i]);
        }
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initSpaceCalcs();
        this.partitionsModel.clear();
        Iterator iterator = this.table.getTablePartitions().iterator();
        while (iterator.hasNext()) {
            try {
                TablePartitionDB2 tablePartitionDB2 = (TablePartitionDB2)iterator.next();
                this.partitionsModel.addElement(tablePartitionDB2);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            String string;
            int n;
            this.table.setName(this.tfName.getText());
            Object object = this.cbOwner.getSelectedItem();
            if (object instanceof Owner) {
                this.table.setOwner((Owner)object);
            } else {
                this.table.setOwner(null);
            }
            object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceDB2v80) {
                this.table.setTableSpace((TableSpaceDB2v80)object);
            } else {
                this.table.setTableSpace(null);
            }
            this.table.setObid(this.ifObid.getIntValue());
            this.table.setEditProc(this.tfEditProc.getText());
            this.table.setValidProc(this.tfValidProc.getText());
            object = this.cbAudit.getSelectedItem();
            this.table.setAudit(String.valueOf(object));
            object = this.cbDataCapture.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(TableProxyDB2.getDataCaptureValues()[1]);
            this.table.setDataCapture(bl);
            object = this.cbRestrictOnDrop.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.table.setDropRestrict(bl);
            this.table.setCcsid(String.valueOf(this.cbCCSID.getSelectedItem()));
            this.table.setLabel(this.tfLabel.getText());
            this.table.setPartitioned(TablePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.table.setMaterializedQuery(TablePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbMaterializedQuery.getSelectedItem()));
            this.table.setTableAccess((String)this.cbTableAccess.getSelectedItem());
            this.table.setNumberOfRows(this.ifCARDF.getIntValue());
            this.table.setCreatedBy(this.tfCreatedBy.getText());
            this.table.setRecordLength(this.ifRecLength.getIntValue());
            this.table.setNumberOfPages(this.ifNPAGES.getIntValue());
            this.table.setPercentageOfPages(this.ifPCTPAGES.getIntValue());
            this.table.setMaxRowNumber(this.ifMaxRows.getIntValue());
            this.table.setInitialRowNumber(this.ifInitialRows.getIntValue());
            this.table.setAnnualUpdateRateInsert(this.dfAURInsert.getFloatValue());
            this.table.setAnnualUpdateRateDelete(this.dfAURDelete.getFloatValue());
            this.table.setActiveGroupInsert(this.dfAGInsert.getFloatValue());
            this.table.setActiveGroupDelete(this.dfAGDelete.getFloatValue());
            this.table.setActiveGroupData(this.dfAGData.getFloatValue());
            this.table.setGrowthHorizon(this.ifGrowthHorizon.getIntValue());
            this.table.setGrowthMethod((String)this.cbGrowthMethod.getSelectedItem());
            this.table.setInsertMethod((String)this.cbInsertMethod.getSelectedItem());
            this.table.setPctFilling(this.ifPCTFilling.getIntValue());
            this.table.setUsePCTFilling(this.chbUsePCTFilling.isSelected());
            this.table.setMqQueryDefinition(this.queryArea.getText());
            this.table.setMqStatus((String)this.cbMQStatus.getSelectedItem());
            this.table.setMqMaintenance((String)this.cbMQMaintenance.getSelectedItem());
            this.table.setMqQueryOptimization((String)this.cbMQQueryOptimization.getSelectedItem());
            this.table.setMqIdentityColumnAttr((String)this.cbMQIdentityColumnAttr.getSelectedItem());
            this.table.setMqColumnDefaults((String)this.cbMQColumnDefaults.getSelectedItem());
            Object[] objectArray = this.selectedColumnsModel.getRows();
            this.table.clear();
            String string2 = null;
            String string3 = null;
            for (n = 0; n < objectArray.length; ++n) {
                Object object2 = objectArray[n];
                if (!(object2 instanceof String)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(object2.toString(), ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken().trim();
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string3 = stringTokenizer.nextToken().trim();
                ColumnProxy columnProxy = this.table.getColumnProxyByName(string2);
                if (columnProxy == null) continue;
                this.table.setPartitioningKey(columnProxy.getObjectID());
                this.table.setPartitioningKey(string3);
            }
            if (((String)this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(YES)) {
                n = this.table.getTablePartitions().size();
                for (int i = 0; i < n; ++i) {
                    this.table.getTablePartitions().justRemove(this.table.getTablePartitions().getElement(0));
                }
                for (int i = 0; i < this.partitionsModel.toArray().length; ++i) {
                    if (!(this.partitionsModel.get(i) instanceof TablePartitionDB2)) continue;
                    TablePartitionDB2 tablePartitionDB2 = (TablePartitionDB2)this.partitionsModel.get(i);
                    tablePartitionDB2.addObjectListener(this.table);
                    tablePartitionDB2.setPartNumber(i + 1);
                    tablePartitionDB2.setParent(this.table.getTablePartitions());
                    this.table.getTablePartitions().add(tablePartitionDB2);
                }
            }
            if (StringUtilities.isNotEmpty(string = this.getCommentsList().getText()) && !this.comment.equalsIgnoreCase(string)) {
                this.table.setComment(string);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            String string4 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string4) && !this.commentInRDBMS.equalsIgnoreCase(string4)) {
                this.table.setCommentInRDBMS(string4);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
            this.initSpaceCalcs();
            Object[] objectArray2 = this.table.getInstDescriptorCols().toArray();
            for (int i = objectArray2.length - 1; i >= 0; --i) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)objectArray2[i];
                if (this.eList.contains(instanceDescriptorColumnDB2)) continue;
                instanceDescriptorColumnDB2.remove();
            }
            Object[] objectArray3 = this.eList.toArray();
            for (int i = 0; i < objectArray3.length; ++i) {
                Object object3 = objectArray3[i];
                if (!(object3 instanceof InstanceDescriptorColumnDB2)) continue;
                if (!this.table.getInstDescriptorCols().contains((InstanceDescriptorColumnDB2)object3)) {
                    this.getStorageDesign().getInstanceDescriptorColumnSet().addInstanceDescriptorColumn((InstanceDescriptorColumnDB2)object3);
                    ((InstanceDescriptorColumnDB2)object3).setTable(this.table);
                    continue;
                }
                this.table.getInstDescriptorCols().moveElementToIndex((InstanceDescriptorColumnDB2)object3, i);
            }
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogDB2v80.this.setPCTFillingUse(TablePropertyDialogDB2v80.this.chbUsePCTFilling.isSelected());
        }
    }

    private class AURFieldListener
    implements ActionListener {
        private AURFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePropertyDialogDB2v80.this.dfAURNetGrowth.setValue(TablePropertyDialogDB2v80.this.dfAURInsert.getFloatValue() - TablePropertyDialogDB2v80.this.dfAURDelete.getFloatValue());
        }
    }

    private class ComboListener
    implements ActionListener {
        private ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            Object object = jComboBox.getSelectedItem();
            if (object != null && object instanceof TableSpaceDB2) {
                TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)object;
                TablePropertyDialogDB2v80.this.cbDataBase.setSelectedItem(tableSpaceDB2.getDataBase());
            }
        }
    }

    class IndexTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("TablePropertyDialogDB2v80.ColumnName"), Messages.getString("TablePropertyDialogDB2v80.SortOrder")};

        IndexTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return TablePropertyDialogDB2v80.this.isEditable();
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = TablePropertyDialogDB2v80.this.selectedColumnsModel.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getRows() {
            int n = TablePropertyDialogDB2v80.this.selectedColumnsModel.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = this.getValueAt(i, 1) == null || ((String)this.getValueAt(i, 1)).equalsIgnoreCase("") ? (String)this.getValueAt(i, 0) + "," + "ASC" : (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TablePropertyDialogDB2v80.this.dialog == null) {
                TablePropertyDialogDB2v80.this.dialog = new PermissionsPropertyDialogDB2(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.getStorageDesign(), TablePropertyDialogDB2v80.this.table);
            }
            TablePropertyDialogDB2v80.this.dialog.show();
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogDB2v80.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogDB2v80.this.selectedColumnsTable.getSelectedRowCount() == -1) {
                    TablePropertyDialogDB2v80.this.bnRemove.setEnabled(false);
                } else {
                    TablePropertyDialogDB2v80.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TablePropertyDialogDB2v80.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TablePropertyDialogDB2v80.this.allColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogDB2v80.this.bnAdd.setEnabled(false);
                } else {
                    TablePropertyDialogDB2v80.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TablePropertyDialogDB2v80.this.selectedColumnsModel.getRowCount() > 0) {
                int[] nArray = TablePropertyDialogDB2v80.this.selectedColumnsTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    String string = (String)TablePropertyDialogDB2v80.this.selectedColumnsModel.getValueAt(nArray[i], 0);
                    TablePropertyDialogDB2v80.this.allColumnsModel.addElement(TablePropertyDialogDB2v80.this.table.getColumn(string));
                    TablePropertyDialogDB2v80.this.selectedColumnsModel.removeRow(nArray[i]);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TablePropertyDialogDB2v80.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = TablePropertyDialogDB2v80.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ColumnProxy columnProxy = (ColumnProxy)objectArray[i];
                    TablePropertyDialogDB2v80.this.allColumnsModel.removeElement(columnProxy);
                    TablePropertyDialogDB2v80.this.selectedColumnsModel.addRow(new String[]{columnProxy.getName(), ""});
                }
            }
        }
    }

    class AllListColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ColumnProxy columnProxy = (ColumnProxy)object;
            this.setText(" " + columnProxy.getName());
            this.setOpaque(true);
            if (bl) {
                this.setBackground(TablePropertyDialogDB2v80.this.selectedColumnsTable.getSelectionBackground());
            } else {
                this.setBackground(TablePropertyDialogDB2v80.this.selectedColumnsTable.getBackground());
            }
            return this;
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TablePropertyDialogDB2v80.this.partitionsList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] == -1 || TablePropertyDialogDB2v80.this.partitionsModel.size() - 1 <= nArray[i]) continue;
                TablePartitionDB2 tablePartitionDB2 = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsModel.get(nArray[i]);
                TablePartitionDB2 tablePartitionDB22 = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsModel.get(nArray[i] + 1);
                TablePropertyDialogDB2v80.this.partitionsModel.setElementAt(tablePartitionDB2, nArray[i] + 1);
                TablePropertyDialogDB2v80.this.partitionsModel.setElementAt(tablePartitionDB22, nArray[i]);
            }
            TablePropertyDialogDB2v80.this.partitionsList.clearSelection();
            TablePropertyDialogDB2v80.this.partitionsList.updateUI();
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TablePropertyDialogDB2v80.this.partitionsList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1 || nArray[i] <= 0) continue;
                TablePartitionDB2 tablePartitionDB2 = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsModel.get(nArray[i]);
                TablePartitionDB2 tablePartitionDB22 = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsModel.get(nArray[i] - 1);
                TablePropertyDialogDB2v80.this.partitionsModel.setElementAt(tablePartitionDB2, nArray[i] - 1);
                TablePropertyDialogDB2v80.this.partitionsModel.setElementAt(tablePartitionDB22, nArray[i]);
            }
            TablePropertyDialogDB2v80.this.partitionsList.clearSelection();
            TablePropertyDialogDB2v80.this.partitionsList.updateUI();
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TablePartitionDB2 tablePartitionDB2 = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsList.getSelectedValue();
            if (tablePartitionDB2 != null && !tablePartitionDB2.isDialogVisible()) {
                TablePartitionPropertyDialogDB2v80 tablePartitionPropertyDialogDB2v80 = new TablePartitionPropertyDialogDB2v80(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.getStorageDesign(), tablePartitionDB2);
                tablePartitionPropertyDialogDB2v80.show();
            }
        }
    }

    public class ElementModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TablePropertyDialogDB2v80.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TablePropertyDialogDB2v80.Name");
            }
            if (n == 1) {
                return Messages.getString("TablePropertyDialogDB2v80.Datatype");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(n);
            if (n2 == 0) {
                return instanceDescriptorColumnDB2.getName();
            }
            if (n2 == 1) {
                return instanceDescriptorColumnDB2.getDataType();
            }
            return new Integer(n * n2);
        }
    }

    private class MoveDownColAction
    implements ActionListener {
        private MoveDownColAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogDB2v80.this.etable.getSelectedRow();
            if (n > -1 && n < TablePropertyDialogDB2v80.this.eList.size()) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(n);
                TablePropertyDialogDB2v80.this.moveElementToIndex(instanceDescriptorColumnDB2, n + 1);
                TablePropertyDialogDB2v80.this.etable.changeSelection(n + 1, 0, false, false);
                TablePropertyDialogDB2v80.this.etable.updateUI();
            }
        }
    }

    private class MoveUpColAction
    implements ActionListener {
        private MoveUpColAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogDB2v80.this.etable.getSelectedRow();
            if (n > -1 && n < TablePropertyDialogDB2v80.this.eList.size()) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(n);
                TablePropertyDialogDB2v80.this.moveElementToIndex(instanceDescriptorColumnDB2, n - 1);
                TablePropertyDialogDB2v80.this.etable.changeSelection(n - 1, 0, false, false);
                TablePropertyDialogDB2v80.this.etable.updateUI();
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePropertyDialogDB2v80.this.etable.getSelectedRow();
            if (n != -1 && TablePropertyDialogDB2v80.this.eList.size() > 0 && n < TablePropertyDialogDB2v80.this.eList.size()) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(n);
                TablePropertyDialogDB2v80.this.eList.remove(instanceDescriptorColumnDB2);
                TablePropertyDialogDB2v80.this.etable.updateUI();
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = new InstanceDescriptorColumnDB2();
            instanceDescriptorColumnDB2.setName(TablePropertyDialogDB2v80.this.generateName());
            instanceDescriptorColumnDB2.setDesign(TablePropertyDialogDB2v80.this.table.getDesign());
            TablePropertyDialogDB2v80.this.eList.add(instanceDescriptorColumnDB2);
            TablePropertyDialogDB2v80.this.etable.updateUI();
        }
    }

    private class PropertiesAction
    implements ActionListener {
        private PropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2;
            int n = TablePropertyDialogDB2v80.this.etable.getSelectedRow();
            if (n != -1 && TablePropertyDialogDB2v80.this.eList.size() > 0 && n < TablePropertyDialogDB2v80.this.eList.size() && !(instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(n)).isDialogVisible()) {
                InstanceDescriptorColumnPropertyDialogDB2 instanceDescriptorColumnPropertyDialogDB2 = new InstanceDescriptorColumnPropertyDialogDB2(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.table.getStorageDesign(), instanceDescriptorColumnDB2);
                instanceDescriptorColumnPropertyDialogDB2.initProperties();
                instanceDescriptorColumnPropertyDialogDB2.show();
            }
        }
    }
}

