/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.StorageGroupPropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class VolumesPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private VolumesDB2 volumes;
    private JPanel storageGroups;
    private DefaultListModel sgListModel;
    private JList sgList;
    private JScrollPane spSG;

    public VolumesPropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.volumes = (VolumesDB2)storageObject;
        this.setHeight(250);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("VolumesPropertyDialogDB2.VolumesProperties");
    }

    @Override
    protected void addTabs() {
        this.initStorageGroupsView();
    }

    private void initStorageGroupsView() {
        this.storageGroups = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("VolumesPropertyDialogDB2.StorageGroups"), this.storageGroups);
        this.initStorageGroups();
    }

    private void initStorageGroups() {
        this.sgListModel = new DefaultListModel();
        this.sgList = new JList(this.sgListModel);
        this.sgList.addMouseListener(new listMouseListenerSG());
        this.spSG = new JScrollPane(this.sgList);
        this.spSG.setPreferredSize(new Dimension(395, 200));
        this.spSG.setBorder(BorderFactory.createEtchedBorder(0));
        this.storageGroups.add(this.spSG);
        this.setObjectConstraints(this.getSGLayout(), this.spSG, 10, 12);
    }

    private SpringLayout getSGLayout() {
        return (SpringLayout)this.storageGroups.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.volumes.getName());
        this.tfName.setText(this.volumes.getName());
        this.getCommentsList().insert(this.volumes.getComment(), 0);
        StorageGroupDB2[] storageGroupDB2Array = (StorageGroupDB2[])this.getStorageDesign().getStorageGroupSet().toArray();
        for (int i = 0; i < storageGroupDB2Array.length; ++i) {
            StorageGroupDB2 storageGroupDB2 = storageGroupDB2Array[i];
            if (storageGroupDB2.getVolumes() == null || storageGroupDB2.getVolumes().indexOf(this.volumes.getName()) <= -1) continue;
            this.sgListModel.addElement(storageGroupDB2);
        }
    }

    @Override
    protected void setProperties() {
        if (this.volumes != null) {
            this.volumes.setName(this.tfName.getText());
            this.volumes.setComment(this.getCommentsList().getText());
        }
    }

    private class listMouseListenerSG
    extends MouseAdapter {
        private listMouseListenerSG() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            StorageGroupDB2 storageGroupDB2;
            if (mouseEvent.getClickCount() == 2 && (storageGroupDB2 = (StorageGroupDB2)VolumesPropertyDialogDB2.this.sgList.getSelectedValue()) != null && !storageGroupDB2.isDialogVisible()) {
                StorageGroupPropertyDialogDB2 storageGroupPropertyDialogDB2 = new StorageGroupPropertyDialogDB2(VolumesPropertyDialogDB2.this.volumes.getDesign().getAppView(), VolumesPropertyDialogDB2.this.getStorageDesign(), storageGroupDB2);
                storageGroupPropertyDialogDB2.show();
            }
        }
    }
}

