/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxySetDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserPermissionsDialogDB2
extends CustomDialog
implements AbstractEditorConstants {
    private static final long serialVersionUID = -1498723237225563023L;
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("UserPermissionsDialogDB2.Edit");
    private StorageObject storageObject;
    private TableProxySetDB2 tablesSet;
    private TableViewProxySetDB2 viewSet;
    private AUXTableSetDB2 auxTableSet;
    private AbstractStorageDesignDB2 storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private JPanel objectsPanel;
    private TableTable tablesTable;
    private ViewsTable viewsTable;
    private AuxTableTable auxTableTable;
    private JDialog dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserPermissionsDialogDB2.this.bnCancel.doClick();
        }
    };

    public UserPermissionsDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView);
        this.storageDesign = (AbstractStorageDesignDB2)storageDesign;
        this.storageObject = storageObject;
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        JPanel jPanel = new JPanel();
        if (this.isEditable()) {
            JButton jButton = new JButton(Messages.getString("UserPermissionsDialogDB2.OK"));
            jButton.addActionListener(new OKAction());
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setMnemonic(79);
            jPanel.add(jButton);
            JButton jButton2 = new JButton(Messages.getString("UserPermissionsDialogDB2.Apply"));
            jButton2.addActionListener(new ApplyAction());
            jButton2.setCursor(Cursor.getPredefinedCursor(12));
            jButton2.setMnemonic(65);
            jPanel.add(jButton2);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("UserPermissionsDialogDB2.Cancel") : Messages.getString("UserPermissionsDialogDB2.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        boolean bl = true;
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.addTabs();
        this.initProperties();
        this.add((Component)this.jpanel, "Center");
    }

    @Override
    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    protected void addTabs() {
        this.initTables();
        this.initViews();
        this.initAuxTables();
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initTables() {
        this.tablesSet = (TableProxySetDB2)this.storageDesign.getTableProxySet();
        this.tablesTable = new TableTable();
        JScrollPane jScrollPane = new JScrollPane(this.tablesTable);
        jScrollPane.setPreferredSize(new Dimension(800, 320));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("UserPermissionsDialogDB2.Tables"), this.objectsPanel);
        this.tablesTable.updateUI();
        TablesModel tablesModel = (TablesModel)this.tablesTable.getModel();
        Iterator iterator = this.tablesSet.iterator();
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            String[] stringArray = PermissionsDB2.getTablePrivilegesValues();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(tableProxyDB2);
            for (int i = 0; i < stringArray.length; ++i) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            tablesModel.addRow(objectArray);
        }
    }

    private void initViews() {
        this.viewSet = (TableViewProxySetDB2)this.storageDesign.getTableViewProxySet();
        this.viewsTable = new ViewsTable();
        this.viewsTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.viewsTable);
        jScrollPane.setPreferredSize(new Dimension(800, 320));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("UserPermissionsDialogDB2.Views"), this.objectsPanel);
        this.viewsTable.updateUI();
        ViewsModel viewsModel = (ViewsModel)this.viewsTable.getModel();
        Iterator iterator = this.viewSet.iterator();
        while (iterator.hasNext()) {
            TableViewProxyDB2 tableViewProxyDB2 = (TableViewProxyDB2)iterator.next();
            String[] stringArray = PermissionsDB2.getViewPrivilegesValues();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(tableViewProxyDB2);
            for (int i = 0; i < stringArray.length; ++i) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            viewsModel.addRow(objectArray);
        }
    }

    private void initAuxTables() {
        this.auxTableSet = this.storageDesign.getAUXTableSet();
        this.auxTableTable = new AuxTableTable();
        this.auxTableTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.auxTableTable);
        jScrollPane.setPreferredSize(new Dimension(800, 320));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("UserPermissionsDialogDB2.AuxTables"), this.objectsPanel);
        this.auxTableTable.updateUI();
        AuxTablesModel auxTablesModel = (AuxTablesModel)this.auxTableTable.getModel();
        Iterator iterator = this.auxTableSet.iterator();
        while (iterator.hasNext()) {
            AUXTableDB2 aUXTableDB2 = (AUXTableDB2)iterator.next();
            String[] stringArray = PermissionsDB2.getAuxTablePrivilegesValues();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(aUXTableDB2);
            for (int i = 0; i < stringArray.length; ++i) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            auxTablesModel.addRow(objectArray);
        }
    }

    private boolean hasSelectedTablePrivileges(int n) {
        for (int i = 1; i < this.tablesTable.getColumnCount(); ++i) {
            if (!(this.tablesTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.tablesTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedAuxTablePrivileges(int n) {
        for (int i = 1; i < this.auxTableTable.getColumnCount(); ++i) {
            if (!(this.auxTableTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.auxTableTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedViewPrivileges(int n) {
        for (int i = 1; i < this.viewsTable.getColumnCount(); ++i) {
            if (!(this.viewsTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.viewsTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    public String getCaption() {
        return Messages.getString("UserPermissionsDialogDB2.Permissions");
    }

    private PermissionsDB2 getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsDB2 permissionsDB2 = (PermissionsDB2)iterator.next();
            if (permissionsDB2.getUser() != storageObject || permissionsDB2.getTable() != storageObject2 && permissionsDB2.getView() != storageObject2 && permissionsDB2.getAuxTable() != storageObject2) continue;
            return permissionsDB2;
        }
        return null;
    }

    public void initProperties() {
        JButton jButton;
        int n;
        PermissionsDB2 permissionsDB2;
        StorageObject storageObject;
        int n2;
        for (n2 = 0; n2 < this.tablesTable.getRowCount(); ++n2) {
            storageObject = (TableProxyDB2)this.tablesTable.getValueAt(n2, 0);
            permissionsDB2 = this.getPermission(this.storageObject, storageObject);
            for (n = 0; n < this.tablesTable.getColumnCount(); ++n) {
                if (!(this.tablesTable.getValueAt(n2, n) instanceof JButton)) continue;
                JButton jButton2 = (JButton)this.tablesTable.getValueAt(n2, n);
                if (permissionsDB2 != null) {
                    if (permissionsDB2.getPrivileges().indexOf(this.tablesTable.getColumnName(n)) > -1) {
                        jButton2.setText(CHECKED);
                        jButton2.updateUI();
                        continue;
                    }
                    if (permissionsDB2.getPrivilegesWithGrantOption().indexOf(this.tablesTable.getColumnName(n)) > -1) {
                        jButton2.setText(CHECKED_WITH_GRANT_OPTION);
                        jButton2.updateUI();
                        continue;
                    }
                    jButton2.setText(EMPTY_VALUE);
                    jButton2.updateUI();
                    continue;
                }
                jButton2.setText(EMPTY_VALUE);
                jButton2.updateUI();
            }
        }
        for (n2 = 0; n2 < this.viewsTable.getRowCount(); ++n2) {
            storageObject = (TableViewProxyDB2)this.viewsTable.getValueAt(n2, 0);
            permissionsDB2 = this.getPermission(this.storageObject, storageObject);
            for (n = 0; n < this.viewsTable.getColumnCount(); ++n) {
                if (!(this.viewsTable.getValueAt(n2, n) instanceof JButton)) continue;
                jButton = (JButton)this.viewsTable.getValueAt(n2, n);
                if (permissionsDB2 != null) {
                    if (permissionsDB2.getPrivileges().indexOf(this.viewsTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    if (permissionsDB2.getPrivilegesWithGrantOption().indexOf(this.viewsTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED_WITH_GRANT_OPTION);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.updateUI();
            }
        }
        for (n2 = 0; n2 < this.auxTableTable.getRowCount(); ++n2) {
            storageObject = (AUXTableDB2)this.auxTableTable.getValueAt(n2, 0);
            permissionsDB2 = this.getPermission(this.storageObject, storageObject);
            for (n = 0; n < this.auxTableTable.getColumnCount(); ++n) {
                if (!(this.auxTableTable.getValueAt(n2, n) instanceof JButton)) continue;
                jButton = (JButton)this.auxTableTable.getValueAt(n2, n);
                if (permissionsDB2 != null) {
                    if (permissionsDB2.getPrivileges().indexOf(this.auxTableTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    if (permissionsDB2.getPrivilegesWithGrantOption().indexOf(this.viewsTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED_WITH_GRANT_OPTION);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.updateUI();
            }
        }
    }

    protected void setProperties() {
        JButton jButton;
        int n;
        PermissionsDB2 permissionsDB2;
        StorageObject storageObject;
        int n2;
        for (n2 = 0; n2 < this.tablesTable.getRowCount(); ++n2) {
            storageObject = (TableProxyDB2)this.tablesTable.getValueAt(n2, 0);
            permissionsDB2 = this.getPermission(this.storageObject, storageObject);
            if (this.hasSelectedTablePrivileges(n2)) {
                if (permissionsDB2 == null) {
                    permissionsDB2 = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsDB2.setTable((TableProxyDB2)storageObject);
                    if (this.storageObject instanceof Owner) {
                        permissionsDB2.setUser((Owner)this.storageObject);
                    }
                }
                permissionsDB2.clear();
                for (n = 0; n < this.tablesTable.getColumnCount(); ++n) {
                    if (!(this.tablesTable.getValueAt(n2, n) instanceof JButton)) continue;
                    jButton = (JButton)this.tablesTable.getValueAt(n2, n);
                    if (jButton.getText().equals(CHECKED)) {
                        permissionsDB2.setPrivileges(this.tablesTable.getColumnName(n));
                        continue;
                    }
                    if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    permissionsDB2.setPrivilegesWithGrantOption(this.tablesTable.getColumnName(n));
                }
                continue;
            }
            if (permissionsDB2 == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsDB2);
        }
        for (n2 = 0; n2 < this.viewsTable.getRowCount(); ++n2) {
            storageObject = (TableViewProxyDB2)this.viewsTable.getValueAt(n2, 0);
            permissionsDB2 = this.getPermission(this.storageObject, storageObject);
            if (this.hasSelectedViewPrivileges(n2)) {
                if (permissionsDB2 == null) {
                    permissionsDB2 = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsDB2.setView((TableViewProxyDB2)storageObject);
                    if (this.storageObject instanceof Owner) {
                        permissionsDB2.setUser((Owner)this.storageObject);
                    }
                }
                permissionsDB2.clear();
                for (n = 0; n < this.viewsTable.getColumnCount(); ++n) {
                    if (!(this.viewsTable.getValueAt(n2, n) instanceof JButton)) continue;
                    jButton = (JButton)this.viewsTable.getValueAt(n2, n);
                    if (jButton.getText().equals(CHECKED)) {
                        permissionsDB2.setPrivileges(this.viewsTable.getColumnName(n));
                        continue;
                    }
                    if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    permissionsDB2.setPrivilegesWithGrantOption(this.viewsTable.getColumnName(n));
                }
                continue;
            }
            if (permissionsDB2 == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsDB2);
        }
        for (n2 = 0; n2 < this.auxTableTable.getRowCount(); ++n2) {
            storageObject = (AUXTableDB2)this.auxTableTable.getValueAt(n2, 0);
            permissionsDB2 = this.getPermission(this.storageObject, storageObject);
            if (this.hasSelectedAuxTablePrivileges(n2)) {
                if (permissionsDB2 == null) {
                    permissionsDB2 = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsDB2.setAuxTable((AUXTableDB2)storageObject);
                    if (this.storageObject instanceof Owner) {
                        permissionsDB2.setUser((Owner)this.storageObject);
                    }
                }
                permissionsDB2.clear();
                for (n = 0; n < this.auxTableTable.getColumnCount(); ++n) {
                    if (!(this.auxTableTable.getValueAt(n2, n) instanceof JButton)) continue;
                    jButton = (JButton)this.auxTableTable.getValueAt(n2, n);
                    if (jButton.getText().equals(CHECKED)) {
                        permissionsDB2.setPrivileges(this.auxTableTable.getColumnName(n));
                        continue;
                    }
                    if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    permissionsDB2.setPrivilegesWithGrantOption(this.auxTableTable.getColumnName(n));
                }
                continue;
            }
            if (permissionsDB2 == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsDB2);
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("UserPermissionsDialogDB2.Permissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            this.button.setOpaque(true);
            this.button.setBackground(jTable.getBackground());
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            return this.button;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserPermissionsDialogDB2.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserPermissionsDialogDB2.this.setProperties();
            UserPermissionsDialogDB2.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserPermissionsDialogDB2.this.setProperties();
            UserPermissionsDialogDB2.this.storageObject.setDirty(true);
            UserPermissionsDialogDB2.this.close();
        }
    }

    class AuxTableTable
    extends JTable {
        AuxTablesModel dataModel;

        public AuxTableTable() {
            this.dataModel = new AuxTablesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class AuxTablesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsDB2.getAuxTablePrivilegesValues().length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            String[] stringArray = PermissionsDB2.getAuxTablePrivilegesValues();
            if (n == 0) {
                return Messages.getString("UserPermissionsDialogDB2.AuxTable");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return stringArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!UserPermissionsDialogDB2.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    public class ViewsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsDB2.getViewPrivilegesValues().length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            String[] stringArray = PermissionsDB2.getViewPrivilegesValues();
            if (n == 0) {
                return Messages.getString("UserPermissionsDialogDB2.View");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return stringArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!UserPermissionsDialogDB2.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class ViewsTable
    extends JTable {
        ViewsModel dataModel;

        public ViewsTable() {
            this.dataModel = new ViewsModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    class TableTable
    extends JTable {
        TablesModel dataModel;

        public TableTable() {
            this.dataModel = new TablesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class TablesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsDB2.getTablePrivilegesValues().length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            String[] stringArray = PermissionsDB2.getTablePrivilegesValues();
            if (n == 0) {
                return Messages.getString("UserPermissionsDialogDB2.Table");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return stringArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!UserPermissionsDialogDB2.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

