/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.PermissionsPropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TableViewPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private TableViewProxyDB2 view;
    private JComboBox cbOwner;
    private JComboBox cbCheckOption;
    private JComboBox cbCheckOptionScope;
    private JTextArea definitionArea;
    private JTextField tfLabelOn;
    private String comment;
    private String commentInRDBMS;
    private JButton bnPermissions;
    private PermissionsPropertyDialogDB2 dialog;

    public TableViewPropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.view = (TableViewProxyDB2)storageObject;
        this.setHeight(440);
        this.initCommentsView(180);
        this.initCommentsInRDBMS(180);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableViewPropertyDialogDB2.ViewProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initCheckOption();
        this.initCheckOptionScope();
        this.initDefinition();
        this.initLabelOn();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogDB2.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initCheckOption() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogDB2.CheckOption"));
        this.general.add(jLabel);
        this.cbCheckOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCheckOption);
        this.cbCheckOption.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOption);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbCheckOption, 80);
    }

    private void initCheckOptionScope() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogDB2.CheckScope"));
        this.general.add(jLabel);
        this.cbCheckOptionScope = new JComboBox<String>(TableViewProxyDB2.getAvailableCheckOptionScopes());
        this.setBG(this.cbCheckOptionScope);
        this.cbCheckOptionScope.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOptionScope);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbCheckOptionScope, 110);
    }

    private void initDefinition() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogDB2.Definition"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 140);
        this.definitionArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.definitionArea);
        jScrollPane.setPreferredSize(new Dimension(395, 170));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.definitionArea.setLineWrap(true);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 160);
    }

    private void initLabelOn() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogDB2.LabelOn"));
        this.general.add(jLabel);
        this.tfLabelOn = new JTextField("", 26);
        this.general.add(this.tfLabelOn);
        this.setLabelConstraints(jLabel, 340);
        this.setObjectConstraints(this.tfLabelOn, 340);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TableViewPropertyDialogDB2.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 380);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.view.getName());
        this.tfName.setText(this.view.getName());
        this.cbOwner.setSelectedItem(this.view.getOwner());
        if (this.view.getCheckOption()) {
            this.cbCheckOption.setSelectedItem(YES_NO[0]);
        } else {
            this.cbCheckOption.setSelectedItem(YES_NO[1]);
        }
        this.cbCheckOptionScope.setSelectedItem(this.view.getCheckOptionScope());
        this.definitionArea.setText(this.view.getDefinition());
        this.tfLabelOn.setText(this.view.getLabelOn());
        this.comment = ((TableView)this.view.getObject()).getComment();
        this.commentInRDBMS = ((TableView)this.view.getObject()).getCommentInRDBMS();
        if (this.view.isCommentChanged()) {
            this.getCommentsList().insert(this.view.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.view.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.view.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.view != null) {
            this.view.setName(this.tfName.getText());
            this.view.setOwner((Owner)this.cbOwner.getSelectedItem());
            if (((String)this.cbCheckOption.getSelectedItem()).equalsIgnoreCase(YES_NO[0])) {
                this.view.setCheckOption(true);
            } else {
                this.view.setCheckOption(false);
            }
            this.view.setCheckOptionScope((String)this.cbCheckOptionScope.getSelectedItem());
            this.view.setDefinition(this.definitionArea.getText());
            this.view.setLabelOn(this.tfLabelOn.getText());
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
                this.view.setComment(string);
                this.view.setCommentChanged(true);
            } else {
                this.view.setComment("");
                this.view.setCommentChanged(false);
            }
            String string2 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string2) && !this.commentInRDBMS.equalsIgnoreCase(string2)) {
                this.view.setCommentInRDBMS(string2);
                this.view.setCommentInRDBMSChanged(true);
            } else {
                this.view.setCommentInRDBMS("");
                this.view.setCommentInRDBMSChanged(false);
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TableViewPropertyDialogDB2.this.dialog == null) {
                TableViewPropertyDialogDB2.this.dialog = new PermissionsPropertyDialogDB2(TableViewPropertyDialogDB2.this.getAppView(), TableViewPropertyDialogDB2.this.getStorageDesign(), TableViewPropertyDialogDB2.this.view);
            }
            TableViewPropertyDialogDB2.this.dialog.show();
        }
    }
}

