/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TSPartitionPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.TablePropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TableSpacePropertyDialogDB2
extends AbstractDB2PropertyDialog {
    protected TableSpaceDB2 tableSpace;
    protected JComboBox cbType;
    protected JComboBox cbClustered;
    protected JComboBox cbDB;
    protected JComboBox cbStorageTemplate;
    protected JComboBox cbLobLogging;
    protected JComboBox cbDSSize;
    protected JComboBox cbSegSize;
    private JComboBox cbPartIndex;
    protected JIntegerField ifNumParts;
    protected JComboBox cbBufferPool;
    protected JComboBox cbLockSize;
    protected JTextField tfLockMax;
    protected JComboBox cbClose;
    protected JComboBox cbCompress;
    protected JComboBox cbCCSID;
    protected JComboBox cbLockPart;
    protected JIntegerField ifMaxRows;
    protected JPanel catalogStats;
    protected JPanel designStats;
    protected JIntegerField ifOBID;
    protected JIntegerField ifPSID;
    protected JIntegerField ifNactive;
    protected JTextField tfCreatedBy;
    protected JIntegerField ifSpace;
    protected JIntegerField ifPageSave;
    protected JIntegerField ifMaintenanceInterval;
    protected JIntegerField ifSpaceAllocInterval;
    protected JIntegerField ifCompRatio;
    protected JIntegerField ifPCTFragmentation;
    protected JTextPane taSpaceCalcs;
    protected JPanel spaceCalcs;
    private JLabel partIndexLabel;
    protected JPanel tables;
    protected DefaultListModel tablesListModel;
    protected JList tablesList;
    private JPanel usePrivilegesPanel;
    protected DefaultListModel allUsersModel;
    protected DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAddUser;
    private JButton bnRemoveUser;
    protected JPanel partitionsOrder;
    protected DefaultListModel partitionsModel;
    protected JList partitionsList;
    protected JComboBox cbGrantOption;

    public TableSpacePropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.tableSpace = (TableSpaceDB2)storageObject;
        this.setHeight(650);
        this.initCommentsView(this.getPane().getPreferredSize().height - 70);
        this.initSpaceCalcsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableSpacePropertyDialogDB2.TableSpaceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initType();
        this.initClustered();
        this.initDataBase();
        this.initStorageTemplate();
        this.initLobLogging();
        this.initDSSize();
        this.initSegSize();
        this.initPartIndex();
        this.initNumParts();
        this.initBufferPool();
        this.initLockSize();
        this.initLockMax();
        this.initClose();
        this.initCompress();
        this.initCCSID();
        this.initLockPart();
        this.initMaxRows();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initType() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Type"));
        this.general.add(jLabel);
        this.cbType = new JComboBox<String>(TableSpaceDB2.getTypeValues());
        this.setBG(this.cbType);
        this.cbType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbType);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbType, 50);
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSpacePropertyDialogDB2.this.enableMaxRows();
                TableSpacePropertyDialogDB2.this.enableLog();
            }
        });
    }

    protected void enableMaxRows() {
        Object object = this.cbType.getSelectedItem();
        Object object2 = this.cbDB.getSelectedItem();
        if (object != null && object instanceof String) {
            String string = (String)object;
            if (object2 != null && object2 instanceof DataBaseDB2) {
                DataBaseDB2 dataBaseDB2 = (DataBaseDB2)object2;
                this.ifMaxRows.setEnabled(!string.equalsIgnoreCase("LOB") && !dataBaseDB2.getType().equalsIgnoreCase("WORKFILE"));
            } else {
                this.ifMaxRows.setEnabled(!string.equalsIgnoreCase("LOB"));
            }
        } else if (object2 != null && object2 instanceof DataBaseDB2) {
            DataBaseDB2 dataBaseDB2 = (DataBaseDB2)object2;
            this.ifMaxRows.setEnabled(!dataBaseDB2.getType().equalsIgnoreCase("WORKFILE"));
        }
    }

    protected void enableLog() {
        Object object = this.cbType.getSelectedItem();
        if (object != null && object instanceof String) {
            String string = (String)object;
            this.cbLobLogging.setEnabled(string.equalsIgnoreCase("LOB"));
        }
    }

    private void initClustered() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Clustered"));
        this.general.add(jLabel);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbClustered, 80);
    }

    private void initDataBase() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.DataBaseProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.DataBase"));
        this.general.add(jLabel);
        this.cbDB = new JComboBox();
        this.setBG(this.cbDB);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getDataBaseSet().toArray(), this.cbDB);
        }
        this.cbDB.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbDB);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbDB, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 110);
        this.setObjectConstraints(jButton, 110);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TableSpacePropertyDialogDB2.this.cbDB.getSelectedItem();
                if (object != null && object instanceof DataBaseDB2) {
                    DataBaseDB2 dataBaseDB2 = (DataBaseDB2)object;
                    dataBaseDB2.showPropertyDialog();
                    TableSpacePropertyDialogDB2.this.enableMaxRows();
                    TableSpacePropertyDialogDB2.this.enableLog();
                }
            }
        });
        this.cbDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSpacePropertyDialogDB2.this.enableMaxRows();
                TableSpacePropertyDialogDB2.this.enableLog();
            }
        });
    }

    private void initStorageTemplate() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.StorageTemplateProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.StorageTemplate"));
        this.general.add(jLabel);
        this.cbStorageTemplate = new JComboBox();
        this.setBG(this.cbStorageTemplate);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageTemplateSet().toArray(), this.cbStorageTemplate);
        }
        this.cbStorageTemplate.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbStorageTemplate);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(jButton, 140);
        this.setObjectConstraints(this.cbStorageTemplate, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 140);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TableSpacePropertyDialogDB2.this.cbStorageTemplate.getSelectedItem();
                if (object != null && object instanceof StorageTemplateDB2) {
                    StorageTemplateDB2 storageTemplateDB2 = (StorageTemplateDB2)object;
                    storageTemplateDB2.showPropertyDialog();
                }
            }
        });
    }

    private void initLobLogging() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.LobLogging"));
        this.general.add(jLabel);
        this.cbLobLogging = new JComboBox<String>(YES_NO);
        this.setBG(this.cbLobLogging);
        this.cbLobLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLobLogging);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbLobLogging, 170);
        this.cbLobLogging.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.LOGIsPermittedOnlyForLOBTablespaces"));
    }

    private void initDSSize() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.DSSize"));
        this.general.add(jLabel);
        this.cbDSSize = new JComboBox<String>(TableSpaceDB2.getDSSizeValues());
        this.setBG(this.cbDSSize);
        this.cbDSSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDSSize);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbDSSize, 200);
    }

    private void initSegSize() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.SegSize"));
        this.general.add(jLabel);
        this.cbSegSize = new JComboBox<String>(TableSpaceDB2.getSegSizeValues());
        this.setBG(this.cbSegSize);
        this.cbSegSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegSize);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbSegSize, 230);
    }

    private void initPartIndex() {
        this.partIndexLabel = new JLabel();
        this.general.add(this.partIndexLabel);
        this.cbPartIndex = new JComboBox();
        this.setBG(this.cbPartIndex);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getIndexProxySet().toArray(), this.cbPartIndex);
        }
        this.cbPartIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartIndex.setEnabled(false);
        this.setLabelConstraints(this.partIndexLabel, 260);
    }

    protected void initNumParts() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.NumParts"));
        this.general.add(jLabel);
        this.ifNumParts = new JIntegerField(0, 26);
        this.ifNumParts.setEnabled(false);
        this.general.add(this.ifNumParts);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.ifNumParts, 290);
    }

    private void initBufferPool() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.BufferPool"));
        this.general.add(jLabel);
        this.cbBufferPool = new JComboBox();
        this.setBG(this.cbBufferPool);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbBufferPool);
        }
        this.cbBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBufferPool);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbBufferPool, 320);
    }

    private void initLockSize() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.LockSize"));
        this.general.add(jLabel);
        this.cbLockSize = new JComboBox<String>(TableSpaceDB2.getLockSizeValues());
        this.setBG(this.cbLockSize);
        this.cbLockSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLockSize);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbLockSize, 350);
    }

    private void initLockMax() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.LockMax"));
        this.general.add(jLabel);
        this.tfLockMax = new JTextField("", 26);
        this.general.add(this.tfLockMax);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.tfLockMax, 380);
    }

    private void initClose() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Close"));
        this.general.add(jLabel);
        this.cbClose = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClose);
        this.cbClose.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClose);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbClose, 410);
    }

    private void initCompress() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Compress"));
        this.general.add(jLabel);
        this.cbCompress = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCompress);
        this.cbCompress.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompress);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbCompress, 440);
    }

    private void initCCSID() {
        JLabel jLabel = new JLabel("CCSID");
        this.general.add(jLabel);
        this.cbCCSID = new JComboBox<String>(TableSpaceDB2.getCCSIDValues());
        this.setBG(this.cbCCSID);
        this.cbCCSID.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCCSID);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.cbCCSID, 470);
    }

    private void initLockPart() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.LockPart"));
        this.general.add(jLabel);
        this.cbLockPart = new JComboBox<String>(YES_NO);
        this.setBG(this.cbLockPart);
        this.cbLockPart.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLockPart);
        this.setLabelConstraints(jLabel, 500);
        this.setObjectConstraints(this.cbLockPart, 500);
    }

    private void initMaxRows() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.MaxRows"));
        this.general.add(jLabel);
        this.ifMaxRows = new JIntegerField(0, 26);
        this.general.add(this.ifMaxRows);
        this.setLabelConstraints(jLabel, 530);
        this.setObjectConstraints(this.ifMaxRows, 530);
        this.ifMaxRows.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.MAXROWSNnotPermitted"));
    }

    @Override
    public void initProperties() {
        Object object;
        this.initCaption(this.tableSpace.getName());
        this.tfName.setText(this.tableSpace.getName());
        this.cbType.setSelectedItem(this.tableSpace.getType());
        this.cbClustered.setSelectedItem(TableSpacePropertyDialogDB2.translateYesNoForDisplay(this.tableSpace.getClustered()));
        this.partIndexLabel.setText(Messages.getString("TableSpacePropertyDialogDB2.PartitionIndex"));
        this.general.add(this.cbPartIndex);
        this.setObjectConstraints(this.cbPartIndex, 260);
        this.selectObject(this.cbDB, this.tableSpace.getDataBase());
        this.selectObject(this.cbStorageTemplate, this.tableSpace.getStorageTemplate());
        this.cbLobLogging.setSelectedItem(this.tableSpace.isLobLogging() ? YES_NO[0] : YES_NO[1]);
        this.cbDSSize.setSelectedItem(this.tableSpace.getDsSize());
        this.cbSegSize.setSelectedItem(this.tableSpace.getSegSize());
        this.cbPartIndex.setSelectedItem(this.tableSpace.getPartIndex());
        this.ifNumParts.setValue((long)this.tableSpace.getNumParts());
        this.selectObject(this.cbBufferPool, this.tableSpace.getBufferPool());
        this.cbLockSize.setSelectedItem(this.tableSpace.getLockSize());
        String string = this.tableSpace.getLockMax() == -1 ? "SYSTEM" : String.valueOf(this.tableSpace.getLockMax());
        this.tfLockMax.setText(string);
        this.cbClose.setSelectedItem(this.tableSpace.isClose() ? YES_NO[0] : YES_NO[1]);
        this.cbCompress.setSelectedItem(this.tableSpace.isCompress() ? YES_NO[0] : YES_NO[1]);
        this.cbCCSID.setSelectedItem(this.tableSpace.getCcsid());
        this.cbLockPart.setSelectedItem(this.tableSpace.isLockPart() ? YES_NO[0] : YES_NO[1]);
        if (this.tableSpace.getMaxRows() != 0) {
            this.ifMaxRows.setValue((long)this.tableSpace.getMaxRows());
        } else {
            this.ifMaxRows.setText("");
        }
        this.ifOBID.setValue((long)this.tableSpace.getObid());
        this.ifPSID.setValue((long)this.tableSpace.getPsid());
        this.ifNactive.setValue((long)this.tableSpace.getNactive());
        this.tfCreatedBy.setText(this.tableSpace.getCreatedBy());
        this.ifSpace.setValue((long)this.tableSpace.getSpace());
        this.ifPageSave.setValue((long)this.tableSpace.getPageSave());
        this.ifMaintenanceInterval.setValue((long)this.tableSpace.getMaintenanceInterval());
        this.ifSpaceAllocInterval.setValue((long)this.tableSpace.getSpaceAllocationInterval());
        this.ifCompRatio.setValue((long)this.tableSpace.getCompressionRatio());
        this.ifPCTFragmentation.setValue((long)this.tableSpace.getFragmentationPCT());
        Owner[] ownerArray = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < ownerArray.length; ++i) {
            Owner owner = ownerArray[i];
            if (owner.getName().equalsIgnoreCase("[Implicit]")) continue;
            if (this.tableSpace.getUserSet().contains(owner.getName())) {
                this.selectedUsersModel.addElement(owner);
                continue;
            }
            this.allUsersModel.addElement(owner);
        }
        this.cbGrantOption.setSelectedItem(TableSpacePropertyDialogDB2.translateYesNoForDisplay(this.tableSpace.getGrantOption()));
        this.tablesListModel.clear();
        Object[] objectArray = this.tableSpace.getTables().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            object = (TableProxyDB2)objectArray[i];
            this.tablesListModel.addElement(object);
        }
        this.partitionsModel.clear();
        object = this.tableSpace.getTSPartitions().iterator();
        while (object.hasNext()) {
            try {
                PartitionDB2 partitionDB2 = (PartitionDB2)object.next();
                this.partitionsModel.addElement(partitionDB2);
            }
            catch (ClassCastException classCastException) {}
        }
        this.getCommentsList().insert(this.tableSpace.getComment(), 0);
        this.initSpaceCalcs();
        this.cbType.setEnabled(this.tableSpace.getPartIndex() == null);
        this.enableMaxRows();
        this.enableLog();
        if (this.tableSpace.isNullInstance()) {
            this.tfName.setEditable(false);
            this.cbDB.setEnabled(false);
            this.cbStorageTemplate.setEnabled(false);
            this.cbLobLogging.setEnabled(false);
            this.cbDSSize.setEnabled(false);
            this.cbSegSize.setEnabled(false);
            this.cbPartIndex.setEnabled(false);
            this.ifNumParts.setEditable(false);
            this.cbBufferPool.setEnabled(false);
            this.cbLockSize.setEnabled(false);
            this.tfLockMax.setEditable(false);
            this.cbClose.setEnabled(false);
            this.cbCompress.setEnabled(false);
            this.cbCCSID.setEnabled(false);
            this.cbLockPart.setEnabled(false);
            this.ifMaxRows.setEditable(false);
            this.ifOBID.setEditable(false);
            this.ifPSID.setEditable(false);
            this.ifNactive.setEditable(false);
            this.tfCreatedBy.setEditable(false);
            this.ifSpace.setEditable(false);
            this.ifPageSave.setEditable(false);
            this.ifMaintenanceInterval.setEditable(false);
            this.ifSpaceAllocInterval.setEditable(false);
            this.ifCompRatio.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
    }

    @Override
    protected void setProperties() {
        if (this.tableSpace != null && !this.tableSpace.isNullInstance()) {
            int n;
            int n2;
            this.tableSpace.setName(this.tfName.getText());
            this.tableSpace.setType((String)this.cbType.getSelectedItem());
            this.tableSpace.setClustered(TableSpacePropertyDialogDB2.translateYesNoForStorage((String)this.cbClustered.getSelectedItem()));
            Object object = this.cbDB.getSelectedItem();
            if (object instanceof DataBaseDB2) {
                this.tableSpace.setDataBase((DataBaseDB2)object);
            } else {
                this.tableSpace.setDataBase(null);
            }
            object = this.cbStorageTemplate.getSelectedItem();
            if (object instanceof StorageTemplateDB2) {
                this.tableSpace.setStorageTemplate((StorageTemplateDB2)object);
            } else {
                this.tableSpace.setStorageTemplate(null);
            }
            object = this.cbLobLogging.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setLobLogging(bl);
            this.tableSpace.setDsSize((String)this.cbDSSize.getSelectedItem());
            this.tableSpace.setSegSize((String)this.cbSegSize.getSelectedItem());
            if (this.tableSpace.getPartIndex() == null) {
                this.tableSpace.setNumParts(this.ifNumParts.getIntValue());
            }
            if ((object = this.cbBufferPool.getSelectedItem()) instanceof BufferPoolDB2) {
                this.tableSpace.setBufferPool((BufferPoolDB2)object);
            } else {
                this.tableSpace.setBufferPool(null);
            }
            this.tableSpace.setLockSize((String)this.cbLockSize.getSelectedItem());
            if ("SYSTEM".equalsIgnoreCase(this.tfLockMax.getText())) {
                n2 = -1;
            } else {
                try {
                    n2 = Integer.parseInt(this.tfLockMax.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
            }
            this.tableSpace.setLockMax(n2);
            object = this.cbClose.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setClose(bl);
            object = this.cbCompress.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setCompress(bl);
            this.tableSpace.setCcsid((String)this.cbCCSID.getSelectedItem());
            object = this.cbLockPart.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.tableSpace.setLockPart(bl);
            this.tableSpace.setMaxRows(this.ifMaxRows.getIntValue());
            this.tableSpace.setObid(this.ifOBID.getIntValue());
            this.tableSpace.setPsid(this.ifPSID.getIntValue());
            this.tableSpace.setNactive(this.ifNactive.getIntValue());
            this.tableSpace.setCreatedBy(this.tfCreatedBy.getText());
            this.tableSpace.setSpace(this.ifSpace.getIntValue());
            this.tableSpace.setPageSave(this.ifPageSave.getIntValue());
            this.tableSpace.setMaintenanceInterval(this.ifMaintenanceInterval.getIntValue());
            this.tableSpace.setSpaceAllocationInterval(this.ifSpaceAllocInterval.getIntValue());
            this.tableSpace.setCompressionRatio(this.ifCompRatio.getIntValue());
            this.tableSpace.setFragmentationPCT(this.ifPCTFragmentation.getIntValue());
            Object[] objectArray = this.selectedUsersModel.toArray();
            this.tableSpace.clear();
            for (n = 0; n < objectArray.length; ++n) {
                Object object2 = objectArray[n];
                if (!(object2 instanceof Owner)) continue;
                this.tableSpace.setUsers(((Owner)object2).getName());
            }
            this.tableSpace.setGrantOption(TableSpacePropertyDialogDB2.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            if (((String)this.cbType.getSelectedItem()).equalsIgnoreCase("PARTITIONED")) {
                n = this.tableSpace.getTSPartitions().size();
                for (int i = 0; i < n; ++i) {
                    this.tableSpace.getTSPartitions().justRemove(this.tableSpace.getTSPartitions().getElement(0));
                }
                for (int i = 0; i < this.partitionsModel.toArray().length; ++i) {
                    if (!(this.partitionsModel.get(i) instanceof PartitionDB2)) continue;
                    PartitionDB2 partitionDB2 = (PartitionDB2)this.partitionsModel.get(i);
                    partitionDB2.addObjectListener(this.tableSpace);
                    partitionDB2.setPartNumber(i + 1);
                    partitionDB2.setParent(this.tableSpace.getTSPartitions());
                    this.tableSpace.getTSPartitions().add(partitionDB2);
                }
            }
            this.tableSpace.setComment(this.getCommentsList().getText());
            this.initSpaceCalcs();
        }
    }

    @Override
    protected void addTabs() {
        this.initCatalogStatsView();
        this.initDesignStatsView();
        this.initUsePrivilegesView();
        this.initTablesView();
        this.initPartitionsOrderView();
    }

    private void initPartitionsOrderView() {
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.PartitionsOrder"), this.partitionsOrder);
        this.initPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.Properties"));
        jButton.addActionListener(new PartitionPropertiesAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        if (this.isEditable()) {
            jComponent = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
            jComponent.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.MoveUp"));
            ((AbstractButton)jComponent).addActionListener(new MoveUpAction());
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
            jButton2.setToolTipText(Messages.getString("TableSpacePropertyDialogDB2.MoveDown"));
            jButton2.addActionListener(new MoveDownAction());
            jToolBar.addSeparator();
            jToolBar.add(jComponent);
            jToolBar.add(jButton2);
        }
        jPanel.add(jToolBar);
        this.partitionsOrder.add((Component)jPanel, "North");
        this.partitionsModel = new DefaultListModel();
        this.partitionsList = new JList(this.partitionsModel);
        jComponent = new JScrollPane(this.partitionsList);
        jComponent.setPreferredSize(new Dimension(400, 510));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(jComponent);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), jComponent, 6, 40);
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    protected void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.UsePrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    protected void initUsePrivileges() {
        this.initToUsers();
        this.initGrantOption();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initUserButtons();
    }

    private void initAllUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.AllUsers"));
        this.usePrivilegesPanel.add(jLabel);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUserListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allUsersList);
        jScrollPane.setPreferredSize(new Dimension(144, 480));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.SelectedUsers"));
        this.usePrivilegesPanel.add(jLabel);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedUserListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedUsersList);
        jScrollPane.setPreferredSize(new Dimension(145, 480));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 292, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 290, 32);
    }

    private void initUserButtons() {
        this.bnAddUser = new JButton(Messages.getString("TableSpacePropertyDialogDB2.Add"));
        this.bnAddUser.addActionListener(new AddColumnsActionListener());
        this.bnAddUser.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddUser, 175, 215);
        this.bnRemoveUser = new JButton(Messages.getString("TableSpacePropertyDialogDB2.Remove"));
        this.bnRemoveUser.setEnabled(false);
        this.bnRemoveUser.addActionListener(new RemoveColumnsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveUser, 175, 245);
        TableSpacePropertyDialogDB2.equalizeButtonSizes(this.bnAddUser, this.bnRemoveUser);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initGrantOption() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.GrantOption"));
        this.usePrivilegesPanel.add(jLabel);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbGrantOption);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 530);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbGrantOption, 530);
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tablesListModel = new DefaultListModel();
        this.tablesList = new JList(this.tablesListModel);
        this.tablesList.addMouseListener(new TablesListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.tablesList);
        jScrollPane.setPreferredSize(new Dimension(395, 540));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jScrollPane);
        this.setObjectConstraints(this.getTSLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    protected void initCatalogStatsView() {
        this.catalogStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.CatalogStats"), this.catalogStats);
        this.initCatalogStats();
    }

    protected void initDesignStatsView() {
        this.designStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.DesignStats"), this.designStats);
        this.initDesignStats();
    }

    protected void initSpaceCalcsView(int n) {
        this.spaceCalcs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TableSpacePropertyDialogDB2.SpaceCalcs"), this.spaceCalcs);
        this.taSpaceCalcs = new JTextPane();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.taSpaceCalcs.setParagraphAttributes(simpleAttributeSet, true);
        JScrollPane jScrollPane = new JScrollPane(this.taSpaceCalcs);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.spaceCalcs.add(jScrollPane);
        this.setObjectConstraints(this.getSpaceCalcsLayout(), jScrollPane, 10, 12);
        this.taSpaceCalcs.setEditable(false);
    }

    protected SpringLayout getSpaceCalcsLayout() {
        return (SpringLayout)this.spaceCalcs.getLayout();
    }

    private void initCatalogStats() {
        this.initOBID();
        this.initPSID();
        this.initNactive();
        this.initCreatedBy();
        this.initSpace();
        this.initPageSave();
    }

    private void initDesignStats() {
        this.initMaintenanceInterval();
        this.initSpaceAllocInterval();
        this.initCompRatio();
        this.initPctFragmentation();
    }

    protected SpringLayout getCatalogStatsLayout() {
        return (SpringLayout)this.catalogStats.getLayout();
    }

    protected SpringLayout getDesignStatsLayout() {
        return (SpringLayout)this.designStats.getLayout();
    }

    private void initOBID() {
        JLabel jLabel = new JLabel("OBID");
        this.catalogStats.add(jLabel);
        this.ifOBID = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifOBID);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifOBID, 20);
    }

    private void initPSID() {
        JLabel jLabel = new JLabel("PSID");
        this.catalogStats.add(jLabel);
        this.ifPSID = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifPSID);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifPSID, 50);
    }

    private void initNactive() {
        JLabel jLabel = new JLabel("NACTIVE");
        this.catalogStats.add(jLabel);
        this.ifNactive = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifNactive);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 80);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifNactive, 80);
    }

    private void initCreatedBy() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.CreatedBy"));
        this.catalogStats.add(jLabel);
        this.tfCreatedBy = new JTextField("", 26);
        this.catalogStats.add(this.tfCreatedBy);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 110);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.tfCreatedBy, 110);
    }

    private void initSpace() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.Space"));
        this.catalogStats.add(jLabel);
        this.ifSpace = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifSpace);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 140);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifSpace, 140);
    }

    private void initPageSave() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.PageSave"));
        this.catalogStats.add(jLabel);
        this.ifPageSave = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifPageSave);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 170);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifPageSave, 170);
    }

    private void initMaintenanceInterval() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.MaintInterval"));
        this.designStats.add(jLabel);
        this.ifMaintenanceInterval = new JIntegerField(0, 26);
        this.designStats.add(this.ifMaintenanceInterval);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifMaintenanceInterval, 20);
    }

    private void initSpaceAllocInterval() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.SpaceAllocInterval"));
        this.designStats.add(jLabel);
        this.ifSpaceAllocInterval = new JIntegerField(0, 26);
        this.designStats.add(this.ifSpaceAllocInterval);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifSpaceAllocInterval, 50);
    }

    private void initCompRatio() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.CompRatio"));
        this.designStats.add(jLabel);
        this.ifCompRatio = new JIntegerField(0, 26);
        this.designStats.add(this.ifCompRatio);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 80);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifCompRatio, 80);
    }

    private void initPctFragmentation() {
        JLabel jLabel = new JLabel(Messages.getString("TableSpacePropertyDialogDB2.FragmentationForSimpleTablespaces"));
        this.designStats.add(jLabel);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 110);
        this.ifPCTFragmentation = new JIntegerField(0, 3);
        this.setBG(this.ifPCTFragmentation);
        this.designStats.add(this.ifPCTFragmentation);
        SpringLayout.Constraints constraints = this.getDesignStatsLayout().getConstraints(this.ifPCTFragmentation);
        constraints.setX(Spring.constant(260));
        constraints.setY(Spring.constant(110));
    }

    private String formatText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        while (stringBuffer.length() < 30) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("\t");
        return stringBuffer.toString();
    }

    private String formatInt(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toString(n);
        for (int i = 0; i < 15 - string.length(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected void initSpaceCalcs() {
        if (this.tableSpace != null && !this.tableSpace.isNullInstance()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.ProposedPRIQTY"))).append(this.formatInt(this.tableSpace.getProposedPRIQTY())).append("\n");
            stringBuffer.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.ProposedSECQTY"))).append(this.formatInt(this.tableSpace.getProposedSECQTY())).append("\n");
            if (this.tableSpace.getStorageTemplate() != null) {
                stringBuffer.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.CurrentPRIQTY"))).append(this.formatInt(this.tableSpace.getStorageTemplate().getSgPriqty())).append("\n");
                stringBuffer.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.CurrentSECQTY"))).append(this.formatInt(this.tableSpace.getStorageTemplate().getSgSeqty())).append("\n\n");
            }
            Object[] objectArray = this.tableSpace.getTables().toArray();
            stringBuffer.append(Messages.getString("TableSpacePropertyDialogDB2.EstimatedSpaceUsedForTables"));
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("\t\t" + Messages.getString("TableSpacePropertyDialogDB2.Table")).append(((TableProxyDB2)objectArray[i]).getName()).append("\n\n");
                stringBuffer.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.InitialPagesUsed"))).append(this.formatInt(((TableProxyDB2)objectArray[i]).getInitialNumberUsedPages())).append("\n");
                stringBuffer.append(this.formatText(Messages.getString("TableSpacePropertyDialogDB2.MaxPagesUsed"))).append(this.formatInt(((TableProxyDB2)objectArray[i]).getMaxNumberUsedPages())).append("\n\n");
            }
            String string = this.tableSpace.getProposedQTYRemarks();
            if (!string.equals("")) {
                stringBuffer.append(Messages.getString("TableSpacePropertyDialogDB2.RemarksOnProposedPRIQTYAndSECQTY")).append(string);
            }
            this.taSpaceCalcs.setText(stringBuffer.toString());
        } else {
            this.taSpaceCalcs.setText("");
        }
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("TableSpacePropertyDialogDB2.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(TableSpacePropertyDialogDB2.this.getStorageDesign().getTableSpaceSet().getElementsList());
                arrayList.remove(TableSpacePropertyDialogDB2.this.tableSpace);
                new PropertiesPropagationDialog(TableSpacePropertyDialogDB2.this.getAppView(), TableSpacePropertyDialogDB2.this.tableSpace, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 570);
    }

    private class TablesListMouseListener
    extends MouseAdapter {
        private TablesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyDB2 tableProxyDB2;
            if (mouseEvent.getClickCount() == 2 && (tableProxyDB2 = (TableProxyDB2)TableSpacePropertyDialogDB2.this.tablesList.getSelectedValue()) != null) {
                TablePropertyDialogDB2 tablePropertyDialogDB2 = new TablePropertyDialogDB2(TableSpacePropertyDialogDB2.this.tableSpace.getDesign().getAppView(), TableSpacePropertyDialogDB2.this.getStorageDesign(), tableProxyDB2);
                tablePropertyDialogDB2.show();
            }
        }
    }

    private class SelectedUserListSelectionHandler
    implements ListSelectionListener {
        private SelectedUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TableSpacePropertyDialogDB2.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogDB2.this.selectedUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogDB2.this.bnRemoveUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogDB2.this.bnRemoveUser.setEnabled(true);
                }
            }
        }
    }

    private class AllUserListSelectionHandler
    implements ListSelectionListener {
        private AllUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TableSpacePropertyDialogDB2.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TableSpacePropertyDialogDB2.this.allUsersList.getSelectedIndex() == -1) {
                    TableSpacePropertyDialogDB2.this.bnAddUser.setEnabled(false);
                } else {
                    TableSpacePropertyDialogDB2.this.bnAddUser.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TableSpacePropertyDialogDB2.this.selectedUsersModel.isEmpty()) {
                Object[] objectArray = TableSpacePropertyDialogDB2.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TableSpacePropertyDialogDB2.this.allUsersModel.contains(object)) continue;
                    TableSpacePropertyDialogDB2.this.allUsersModel.addElement(object);
                    TableSpacePropertyDialogDB2.this.selectedUsersModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TableSpacePropertyDialogDB2.this.allUsersModel.isEmpty()) {
                Object[] objectArray = TableSpacePropertyDialogDB2.this.allUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TableSpacePropertyDialogDB2.this.selectedUsersModel.contains(object)) continue;
                    TableSpacePropertyDialogDB2.this.selectedUsersModel.addElement(object);
                    TableSpacePropertyDialogDB2.this.allUsersModel.removeElement(object);
                }
            }
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableSpacePropertyDialogDB2.this.partitionsList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] == -1 || TableSpacePropertyDialogDB2.this.partitionsModel.size() - 1 <= nArray[i]) continue;
                PartitionDB2 partitionDB2 = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsModel.get(nArray[i]);
                PartitionDB2 partitionDB22 = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsModel.get(nArray[i] + 1);
                TableSpacePropertyDialogDB2.this.partitionsModel.setElementAt(partitionDB2, nArray[i] + 1);
                TableSpacePropertyDialogDB2.this.partitionsModel.setElementAt(partitionDB22, nArray[i]);
            }
            TableSpacePropertyDialogDB2.this.partitionsList.clearSelection();
            TableSpacePropertyDialogDB2.this.partitionsList.updateUI();
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableSpacePropertyDialogDB2.this.partitionsList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1 || nArray[i] <= 0) continue;
                PartitionDB2 partitionDB2 = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsModel.get(nArray[i]);
                PartitionDB2 partitionDB22 = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsModel.get(nArray[i] - 1);
                TableSpacePropertyDialogDB2.this.partitionsModel.setElementAt(partitionDB2, nArray[i] - 1);
                TableSpacePropertyDialogDB2.this.partitionsModel.setElementAt(partitionDB22, nArray[i]);
            }
            TableSpacePropertyDialogDB2.this.partitionsList.clearSelection();
            TableSpacePropertyDialogDB2.this.partitionsList.updateUI();
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PartitionDB2 partitionDB2 = (PartitionDB2)TableSpacePropertyDialogDB2.this.partitionsList.getSelectedValue();
            if (partitionDB2 != null && !partitionDB2.isDialogVisible()) {
                TSPartitionPropertyDialogDB2 tSPartitionPropertyDialogDB2 = new TSPartitionPropertyDialogDB2(TableSpacePropertyDialogDB2.this.getAppView(), TableSpacePropertyDialogDB2.this.getStorageDesign(), partitionDB2);
                tSPartitionPropertyDialogDB2.show();
            }
        }
    }
}

