/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TSPartitionPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private PartitionDB2 partition;
    private JTextField tfTableSpace;
    private JIntegerField ifPartNumber;
    private JComboBox cbStorageTemplate;
    private JComboBox cbCompress;

    public TSPartitionPropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.partition = (PartitionDB2)storageObject;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TSPartitionPropertyDialogDB2.TableSpacePartitionProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.tfTableSpace.setText(this.partition.getTableSpace().toString());
        this.ifPartNumber.setValue((long)this.partition.getPartNumber());
        this.cbCompress.setSelectedItem(this.partition.isCompress() ? YES_NO[0] : YES_NO[1]);
        this.selectObject(this.cbStorageTemplate, this.partition.getStorageTemplate());
        this.getCommentsList().insert(this.partition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            this.partition.setName(this.tfName.getText());
            Object object = this.cbCompress.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.partition.setCompress(bl);
            object = this.cbStorageTemplate.getSelectedItem();
            if (object instanceof StorageTemplateDB2) {
                this.partition.setStorageTemplate((StorageTemplateDB2)object);
            } else {
                this.partition.setStorageTemplate(null);
            }
            this.partition.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTableSpace();
        this.initPartNumber();
        this.initCompress();
        this.initStorageTemplate();
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("TSPartitionPropertyDialogDB2.TableSpace"));
        this.general.add(jLabel);
        this.tfTableSpace = new JTextField("", 26);
        this.tfTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.tfTableSpace.setEnabled(false);
        this.general.add(this.tfTableSpace);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTableSpace, 50);
    }

    private void initPartNumber() {
        JLabel jLabel = new JLabel(Messages.getString("TSPartitionPropertyDialogDB2.PartNumber"));
        this.general.add(jLabel);
        this.ifPartNumber = new JIntegerField(0, 26);
        this.general.add(this.ifPartNumber);
        this.ifPartNumber.setEnabled(false);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifPartNumber, 80);
    }

    private void initCompress() {
        JLabel jLabel = new JLabel(Messages.getString("TSPartitionPropertyDialogDB2.Compress"));
        this.general.add(jLabel);
        this.cbCompress = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCompress);
        this.cbCompress.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompress);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbCompress, 110);
    }

    private void initStorageTemplate() {
        JLabel jLabel = new JLabel(Messages.getString("TSPartitionPropertyDialogDB2.StorageTemplate"));
        this.general.add(jLabel);
        this.cbStorageTemplate = new JComboBox();
        this.setBG(this.cbStorageTemplate);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageTemplateSet().toArray(), this.cbStorageTemplate);
        }
        this.cbStorageTemplate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStorageTemplate);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbStorageTemplate, 140);
    }
}

