/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SynonymPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private JComboBox cbOwner;
    private SynonymDB2 synonym;

    public SynonymPropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.synonym = (SynonymDB2)storageObject;
        this.setHeight(120);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SynonymPropertyDialogDB2.SynonymProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.synonym.getName());
        this.tfName.setText(this.synonym.getName());
        this.selectObject(this.cbOwner, this.synonym.getOwner());
        this.getCommentsList().insert(this.synonym.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.synonym != null) {
            this.synonym.setName(this.tfName.getText());
            Object object = this.cbOwner.getSelectedItem();
            if (object instanceof Owner) {
                this.synonym.setOwner((Owner)object);
            } else {
                this.synonym.setOwner(null);
            }
            this.synonym.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("SynonymPropertyDialogDB2.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }
}

