/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AUXTableIndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TSPartitionPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class StorageTemplatePropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private StorageTemplateDB2 template;
    private JIntegerField ifSGPRIQTY;
    private JIntegerField ifSGSECQTY;
    private JComboBox cbSGErase;
    private JIntegerField ifFreePage;
    private JIntegerField ifPCTFREE;
    private JComboBox cbGBCACHE;
    private JComboBox cbTrackMode;
    private JComboBox cbDefine;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;
    private JScrollPane spTS;
    private JPanel indexes;
    private DefaultListModel indexesListModel;
    private JList indexesList;
    private JScrollPane spIndexes;
    private JPanel tsPartitions;
    private DefaultListModel tsPartListModel;
    private JList tsPartList;
    private JScrollPane spTSPart;
    private JPanel auxTableIndexes;
    private DefaultListModel auxTableIndexesListModel;
    private JList auxTableIndexesList;
    private JScrollPane spAUXTableIndexes;
    private JComboBox cbVcat;
    private JComboBox cbStorageGroup;

    public StorageTemplatePropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.template = (StorageTemplateDB2)storageObject;
        this.setHeight(400);
        this.initCommentsView(355);
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 520;
    }

    @Override
    public String getCaption() {
        return Messages.getString("StorageTemplatePropertyDialogDB2.StorageTemplateProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initVcat();
        this.initStorageGroup();
        this.initSGPIQTY();
        this.initSGSECQTY();
        this.initSGErase();
        this.initFreePage();
        this.initPCTFREE();
        this.initGBCACHE();
        this.initTrackMode();
        this.initDefine();
    }

    @Override
    protected void addTabs() {
        this.initTSView();
        this.initTSPartitionsView();
        this.initIndexesView();
        this.initAUXTableIndexesView();
    }

    private void initAUXTableIndexesView() {
        this.auxTableIndexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageTemplatePropertyDialogDB2.AUXTableIndexes"), this.auxTableIndexes);
        this.initAUXTableIndexes();
    }

    private void initAUXTableIndexes() {
        this.auxTableIndexesListModel = new DefaultListModel();
        this.auxTableIndexesList = new JList(this.auxTableIndexesListModel);
        this.auxTableIndexesList.addMouseListener(new listMouseListenerAUXTableIndexes());
        this.spAUXTableIndexes = new JScrollPane(this.auxTableIndexesList);
        this.spAUXTableIndexes.setPreferredSize(new Dimension(504, 357));
        this.spAUXTableIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.auxTableIndexes.add(this.spAUXTableIndexes);
        this.setObjectConstraints(this.getAUXTableIndexesLayout(), this.spAUXTableIndexes, 10, 12);
    }

    private SpringLayout getAUXTableIndexesLayout() {
        return (SpringLayout)this.auxTableIndexes.getLayout();
    }

    private void initTSPartitionsView() {
        this.tsPartitions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageTemplatePropertyDialogDB2.TableSpacePartitions"), this.tsPartitions);
        this.initTSPartitions();
    }

    private void initTSPartitions() {
        this.tsPartListModel = new DefaultListModel();
        this.tsPartList = new JList(this.tsPartListModel);
        this.tsPartList.addMouseListener(new listMouseListenerTSPart());
        this.spTSPart = new JScrollPane(this.tsPartList);
        this.spTSPart.setPreferredSize(new Dimension(504, 357));
        this.spTSPart.setBorder(BorderFactory.createEtchedBorder(0));
        this.tsPartitions.add(this.spTSPart);
        this.setObjectConstraints(this.getTSPartLayout(), this.spTSPart, 10, 12);
    }

    private SpringLayout getTSPartLayout() {
        return (SpringLayout)this.tsPartitions.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageTemplatePropertyDialogDB2.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexesListModel = new DefaultListModel();
        this.indexesList = new JList(this.indexesListModel);
        this.indexesList.addMouseListener(new listMouseListenerIndex());
        this.spIndexes = new JScrollPane(this.indexesList);
        this.spIndexes.setPreferredSize(new Dimension(504, 357));
        this.spIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(this.spIndexes);
        this.setObjectConstraints(this.getIndexesLayout(), this.spIndexes, 10, 12);
    }

    private SpringLayout getIndexesLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initTSView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("StorageTemplatePropertyDialogDB2.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new listMouseListenerTS());
        this.spTS = new JScrollPane(this.tsList);
        this.spTS.setPreferredSize(new Dimension(504, 357));
        this.spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(this.spTS);
        this.setObjectConstraints(this.getTSLayout(), this.spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    private void initVcat() {
        JLabel jLabel = new JLabel("VCAT");
        this.general.add(jLabel);
        this.cbVcat = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getVCatSet().toArray(), this.cbVcat);
        }
        this.setBG(this.cbVcat);
        this.cbVcat.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbVcat);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbVcat, 50);
    }

    private void initStorageGroup() {
        JLabel jLabel = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.StorageGroup"));
        this.general.add(jLabel);
        this.cbStorageGroup = new JComboBox();
        this.setBG(this.cbStorageGroup);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageGroupSet().toArray(), this.cbStorageGroup);
        }
        this.cbStorageGroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStorageGroup);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbStorageGroup, 80);
    }

    private void initSGPIQTY() {
        JLabel jLabel = new JLabel("SGPRIQTY");
        this.general.add(jLabel);
        this.ifSGPRIQTY = new JIntegerField(0, 26);
        this.general.add(this.ifSGPRIQTY);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.ifSGPRIQTY, 110);
    }

    private void initSGSECQTY() {
        JLabel jLabel = new JLabel("SGSECQTY");
        this.general.add(jLabel);
        this.ifSGSECQTY = new JIntegerField(0, 26);
        this.general.add(this.ifSGSECQTY);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.ifSGSECQTY, 140);
    }

    private void initSGErase() {
        JLabel jLabel = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.SGErase"));
        this.general.add(jLabel);
        this.cbSGErase = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSGErase);
        this.cbSGErase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSGErase);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbSGErase, 170);
    }

    private void initFreePage() {
        JLabel jLabel = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.FreePage"));
        this.general.add(jLabel);
        this.ifFreePage = new JIntegerField(0, 26);
        this.general.add(this.ifFreePage);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifFreePage, 200);
    }

    private void initPCTFREE() {
        JLabel jLabel = new JLabel("PCTFREE");
        this.general.add(jLabel);
        this.ifPCTFREE = new JIntegerField(0, 26);
        this.general.add(this.ifPCTFREE);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifPCTFREE, 230);
    }

    private void initGBCACHE() {
        JLabel jLabel = new JLabel("GBCACHE");
        this.general.add(jLabel);
        this.cbGBCACHE = new JComboBox<String>(StorageTemplateDB2.getGBCacheValues());
        this.setBG(this.cbGBCACHE);
        this.cbGBCACHE.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbGBCACHE);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbGBCACHE, 260);
    }

    private void initTrackMode() {
        JLabel jLabel = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.TrackMode"));
        this.general.add(jLabel);
        this.cbTrackMode = new JComboBox<String>(YES_NO);
        this.setBG(this.cbTrackMode);
        this.cbTrackMode.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTrackMode);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbTrackMode, 290);
    }

    private void initDefine() {
        JLabel jLabel = new JLabel(Messages.getString("StorageTemplatePropertyDialogDB2.Define"));
        this.general.add(jLabel);
        this.cbDefine = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDefine);
        this.cbDefine.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefine);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbDefine, 320);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.template.getName());
        this.tfName.setText(this.template.getName());
        this.cbVcat.setSelectedItem(this.template.getVCat());
        this.cbStorageGroup.setSelectedItem(this.template.getStorageGroup());
        this.ifSGPRIQTY.setValue((long)this.template.getSgPriqty());
        this.ifSGSECQTY.setValue((long)this.template.getSgSeqty());
        this.cbSGErase.setSelectedItem(this.template.isSgErase() ? YES_NO[0] : YES_NO[1]);
        this.ifFreePage.setValue((long)this.template.getFreePage());
        this.ifPCTFREE.setValue((long)this.template.getPctFree());
        this.cbGBCACHE.setSelectedItem(this.template.getGbCache());
        this.cbTrackMode.setSelectedItem(this.template.isTrackMode() ? YES_NO[0] : YES_NO[1]);
        this.cbDefine.setSelectedItem(this.template.isDefine() ? YES_NO[0] : YES_NO[1]);
        this.getCommentsList().insert(this.template.getComment(), 0);
        TableSpaceDB2[] tableSpaceDB2Array = (TableSpaceDB2[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceDB2Array.length; ++i) {
            TableSpaceDB2 tableSpaceDB2 = tableSpaceDB2Array[i];
            if (tableSpaceDB2.getStorageTemplate() == null || tableSpaceDB2.getStorageTemplate() != this.template) continue;
            this.tsListModel.addElement(tableSpaceDB2);
        }
        Object[] objectArray = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            IndexProxyDB2 indexProxyDB2;
            if (!(objectArray[i] instanceof IndexProxyDB2) || (indexProxyDB2 = (IndexProxyDB2)objectArray[i]).getStorageTemplate() == null || indexProxyDB2.getStorageTemplate() != this.template) continue;
            this.indexesListModel.addElement(indexProxyDB2);
        }
        PartitionDB2[] partitionDB2Array = (PartitionDB2[])this.getStorageDesign().getPartitionSet().toArray();
        for (int i = 0; i < partitionDB2Array.length; ++i) {
            PartitionDB2 partitionDB2 = partitionDB2Array[i];
            if (partitionDB2.getStorageTemplate() == null || partitionDB2.getStorageTemplate() != this.template) continue;
            this.tsPartListModel.addElement(partitionDB2);
        }
        AUXTableIndexDB2[] aUXTableIndexDB2Array = (AUXTableIndexDB2[])this.getStorageDesign().getAUXTableIndexSet().toArray();
        for (int i = 0; i < aUXTableIndexDB2Array.length; ++i) {
            AUXTableIndexDB2 aUXTableIndexDB2 = aUXTableIndexDB2Array[i];
            if (aUXTableIndexDB2.getStorageTemplate() == null || aUXTableIndexDB2.getStorageTemplate() != this.template) continue;
            this.auxTableIndexesListModel.addElement(aUXTableIndexDB2);
        }
    }

    @Override
    protected void setProperties() {
        if (this.template != null) {
            this.template.setName(this.tfName.getText());
            this.template.setVCat((VCatDB2)this.cbVcat.getSelectedItem());
            this.template.setStorageGroup((StorageGroupDB2)this.cbStorageGroup.getSelectedItem());
            this.template.setSgPriqty(this.ifSGPRIQTY.getIntValue());
            this.template.setSgSeqty(this.ifSGSECQTY.getIntValue());
            Object object = this.cbSGErase.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.template.setSgErase(bl);
            this.template.setFreePage(this.ifFreePage.getIntValue());
            this.template.setPctFree(this.ifPCTFREE.getIntValue());
            object = this.cbGBCACHE.getSelectedItem();
            this.template.setGbCache((String)object);
            object = this.cbTrackMode.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.template.setTrackMode(bl);
            object = this.cbDefine.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.template.setDefine(bl);
            this.template.setComment(this.getCommentsList().getText());
        }
    }

    private class listMouseListenerAUXTableIndexes
    extends MouseAdapter {
        private listMouseListenerAUXTableIndexes() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            AUXTableIndexDB2 aUXTableIndexDB2;
            if (mouseEvent.getClickCount() == 2 && (aUXTableIndexDB2 = (AUXTableIndexDB2)StorageTemplatePropertyDialogDB2.this.auxTableIndexesList.getSelectedValue()) != null && !aUXTableIndexDB2.isDialogVisible()) {
                AUXTableIndexPropertyDialogDB2 aUXTableIndexPropertyDialogDB2 = new AUXTableIndexPropertyDialogDB2(StorageTemplatePropertyDialogDB2.this.template.getDesign().getAppView(), StorageTemplatePropertyDialogDB2.this.getStorageDesign(), aUXTableIndexDB2);
                aUXTableIndexPropertyDialogDB2.show();
            }
        }
    }

    private class listMouseListenerTSPart
    extends MouseAdapter {
        private listMouseListenerTSPart() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            PartitionDB2 partitionDB2;
            if (mouseEvent.getClickCount() == 2 && (partitionDB2 = (PartitionDB2)StorageTemplatePropertyDialogDB2.this.tsPartList.getSelectedValue()) != null && !partitionDB2.isDialogVisible()) {
                TSPartitionPropertyDialogDB2 tSPartitionPropertyDialogDB2 = new TSPartitionPropertyDialogDB2(StorageTemplatePropertyDialogDB2.this.template.getDesign().getAppView(), StorageTemplatePropertyDialogDB2.this.getStorageDesign(), partitionDB2);
                tSPartitionPropertyDialogDB2.show();
            }
        }
    }

    private class listMouseListenerIndex
    extends MouseAdapter {
        private listMouseListenerIndex() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            IndexProxyDB2 indexProxyDB2;
            if (mouseEvent.getClickCount() == 2 && (indexProxyDB2 = (IndexProxyDB2)StorageTemplatePropertyDialogDB2.this.indexesList.getSelectedValue()) != null && !indexProxyDB2.isDialogVisible()) {
                IndexPropertyDialogDB2 indexPropertyDialogDB2 = new IndexPropertyDialogDB2(StorageTemplatePropertyDialogDB2.this.template.getDesign().getAppView(), StorageTemplatePropertyDialogDB2.this.getStorageDesign(), indexProxyDB2);
                indexPropertyDialogDB2.show();
            }
        }
    }

    private class listMouseListenerTS
    extends MouseAdapter {
        private listMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableSpaceDB2 tableSpaceDB2;
            if (mouseEvent.getClickCount() == 2 && (tableSpaceDB2 = (TableSpaceDB2)StorageTemplatePropertyDialogDB2.this.tsList.getSelectedValue()) != null && !tableSpaceDB2.isDialogVisible()) {
                TableSpacePropertyDialogDB2 tableSpacePropertyDialogDB2 = new TableSpacePropertyDialogDB2(StorageTemplatePropertyDialogDB2.this.template.getDesign().getAppView(), StorageTemplatePropertyDialogDB2.this.getStorageDesign(), tableSpaceDB2);
                tableSpacePropertyDialogDB2.show();
            }
        }
    }
}

