/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPartitionPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JDecimalField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private IndexProxyDB2 index;
    protected JTextField cbTable;
    protected JTextField cbUnique;
    protected JComboBox cbOwner;
    protected JComboBox cbWhereNotNull;
    protected JComboBox cbStorageTemplate;
    protected JComboBox cbClusterType;
    protected JIntegerField ifNumParts;
    protected JComboBox cbPieceSize;
    protected JComboBox cbBufferPool;
    protected JComboBox cbClose;
    protected JComboBox cbDefer;
    protected JComboBox cbCopy;
    protected JPanel catalogStats;
    protected JPanel designStats;
    private JPanel partitionsOrder;
    private DefaultListModel partitionsModel;
    private JList partitionsList;
    protected JIntegerField ifISOBIT;
    protected JTextField tfCreatedBy;
    protected JIntegerField ifFirstKeyCard;
    protected JIntegerField ifFullKeyCard;
    protected JIntegerField ifNumberLeaf;
    protected JIntegerField ifNumberLevels;
    protected JIntegerField ifCatalogSpace;
    protected JIntegerField ifClusterRatio;
    protected JComboBox cbClustered;
    protected JIntegerField ifMaintenanceInterval;
    protected JIntegerField ifSpaceAllocInterval;
    protected JIntegerField ifInitial;
    protected JIntegerField ifFrequencyCount;
    protected JDecimalField dfFrequencyPercent;
    protected JDecimalField dfUpdateRatePercent;
    protected JTextPane taSpaceCalcs;
    protected JPanel spaceCalcs;
    protected JPanel columnsView;
    protected JTable columnsTable;
    protected ColumnsSortOrderModel sortModel;
    private String comment;
    private String commentInRDBMS;

    public IndexPropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.index = (IndexProxyDB2)storageObject;
        this.setHeight(500);
        this.initCommentsView(185);
        this.initCommentsInRDBMS(185);
        this.initSpaceCalcsView(this.getPane().getPreferredSize().height - 70);
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPropertyDialogDB2.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initUnique();
        this.initOwner();
        this.initWhereNotNull();
        this.initStorageTemplate();
        this.initPieceSize();
        this.initBufferPool();
        this.initClose();
        this.initDefer();
        this.initCopy();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    protected void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.RelationalIndex"));
        this.general.add(jLabel);
        this.cbTable = new JTextField();
        this.setBG(this.cbTable);
        this.cbTable.setEnabled(false);
        this.cbTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbTable, 50);
    }

    protected void initUnique() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.RelIndexStatus"));
        this.general.add(jLabel);
        this.cbUnique = new JTextField();
        this.setBG(this.cbUnique);
        this.cbUnique.setEnabled(false);
        this.cbUnique.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUnique);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbUnique, 80);
    }

    protected void initOwner() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("IndexPropertyDialogDB2.OwnerProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbOwner, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 110);
        this.setObjectConstraints(jButton, 110);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = IndexPropertyDialogDB2.this.cbOwner.getSelectedItem();
                if (object != null && object instanceof Owner) {
                    Owner owner = (Owner)object;
                    owner.showPropertyDialog();
                }
            }
        });
    }

    protected void initWhereNotNull() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.WhereNotNull"));
        this.general.add(jLabel);
        this.cbWhereNotNull = new JComboBox<String>(YES_NO);
        this.setBG(this.cbWhereNotNull);
        this.cbWhereNotNull.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbWhereNotNull);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbWhereNotNull, 140);
    }

    protected void initStorageTemplate() {
        JButton jButton = new JButton("...");
        jButton.setPreferredSize(new Dimension(30, 20));
        jButton.setToolTipText(Messages.getString("IndexPropertyDialogDB2.StorageTemplateProperties"));
        jButton.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(jButton);
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.StorageTemplate"));
        this.general.add(jLabel);
        this.cbStorageTemplate = new JComboBox();
        this.setBG(this.cbStorageTemplate);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageTemplateSet().toArray(), this.cbStorageTemplate);
        }
        this.cbStorageTemplate.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbStorageTemplate);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(jButton, 170);
        this.setObjectConstraints(this.cbStorageTemplate, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 170);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = IndexPropertyDialogDB2.this.cbStorageTemplate.getSelectedItem();
                if (object != null && object instanceof StorageTemplateDB2) {
                    StorageTemplateDB2 storageTemplateDB2 = (StorageTemplateDB2)object;
                    storageTemplateDB2.showPropertyDialog();
                }
            }
        });
    }

    protected void initClusterType() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.ClusterType"));
        this.general.add(jLabel);
        this.cbClusterType = new JComboBox<String>(IndexProxyDB2.getClusterTypeValues());
        this.setBG(this.cbClusterType);
        this.cbClusterType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClusterType);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbClusterType, 200);
        this.cbClusterType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndexPropertyDialogDB2.this.enablePieceSize();
            }
        });
    }

    protected void initNumParts() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.NumParts"));
        this.general.add(jLabel);
        this.ifNumParts = new JIntegerField(0, 26);
        this.ifNumParts.setEditable(false);
        this.general.add(this.ifNumParts);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifNumParts, 230);
    }

    protected void initPieceSize() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.PieceSize"));
        this.general.add(jLabel);
        this.cbPieceSize = new JComboBox<String>(IndexProxyDB2.getPieceSizesValues());
        this.setBG(this.cbPieceSize);
        this.cbPieceSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPieceSize);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbPieceSize, 260);
    }

    protected void initBufferPool() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.BufferPool"));
        this.general.add(jLabel);
        this.cbBufferPool = new JComboBox();
        this.setBG(this.cbBufferPool);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbBufferPool);
        }
        this.cbBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBufferPool);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbBufferPool, 290);
    }

    protected void initClose() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.Close"));
        this.general.add(jLabel);
        this.cbClose = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClose);
        this.cbClose.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClose);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbClose, 320);
    }

    protected void initDefer() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.Defer"));
        this.general.add(jLabel);
        this.cbDefer = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDefer);
        this.cbDefer.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefer);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbDefer, 350);
    }

    protected void initCopy() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.Copy"));
        this.general.add(jLabel);
        this.cbCopy = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCopy);
        this.cbCopy.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCopy);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbCopy, 380);
    }

    @Override
    protected void addTabs() {
        this.initCatalogStatsView();
        this.initDesignStatsView();
        this.initPartitionsOrderView();
    }

    protected void initCatalogStatsView() {
        this.catalogStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.CatalogStats"), this.catalogStats);
        this.initCatalogStats();
    }

    protected void initDesignStatsView() {
        this.designStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.DesignStats"), this.designStats);
        this.initDesignStats();
    }

    private void initPartitionsOrderView() {
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.PartitionsOrder"), this.partitionsOrder);
        this.initPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", 16));
        jButton.setToolTipText(Messages.getString("IndexPropertyDialogDB2.Properties"));
        jButton.addActionListener(new PartitionPropertiesAction());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        if (this.isEditable()) {
            jComponent = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", 16));
            jComponent.setToolTipText(Messages.getString("IndexPropertyDialogDB2.MoveUp"));
            ((AbstractButton)jComponent).addActionListener(new MoveUpAction());
            JButton jButton2 = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", 16));
            jButton2.setToolTipText(Messages.getString("IndexPropertyDialogDB2.MoveDown"));
            jButton2.addActionListener(new MoveDownAction());
            jToolBar.addSeparator();
            jToolBar.add(jComponent);
            jToolBar.add(jButton2);
        }
        jPanel.add(jToolBar);
        this.partitionsOrder.add((Component)jPanel, "North");
        this.partitionsModel = new DefaultListModel();
        this.partitionsList = new JList(this.partitionsModel);
        jComponent = new JScrollPane(this.partitionsList);
        jComponent.setPreferredSize(new Dimension(400, 360));
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(jComponent);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), jComponent, 6, 40);
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    protected void initCatalogStats() {
        this.initISOBID();
        this.initCreatedBy();
        this.initFirstKeyCard();
        this.initFullKeyCard();
        this.initNumberLeaf();
        this.initNumberLevels();
        this.initCatalogSpace();
        this.initClusterRatio();
        this.initClustered();
    }

    protected void initDesignStats() {
        this.initMaintenanceInterval();
        this.initSpaceAllocInterval();
        this.initInitial();
        this.initFrequencyCount();
        this.initFrequencyPercent();
        this.initUpdateRatePercent();
    }

    protected SpringLayout getCatalogStatsLayout() {
        return (SpringLayout)this.catalogStats.getLayout();
    }

    protected SpringLayout getDesignStatsLayout() {
        return (SpringLayout)this.designStats.getLayout();
    }

    private void initISOBID() {
        JLabel jLabel = new JLabel("ISOBID");
        this.catalogStats.add(jLabel);
        this.ifISOBIT = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifISOBIT);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifISOBIT, 20);
    }

    protected void initCreatedBy() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.CreatedBy"));
        this.catalogStats.add(jLabel);
        this.tfCreatedBy = new JTextField("", 26);
        this.catalogStats.add(this.tfCreatedBy);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.tfCreatedBy, 50);
    }

    protected void initFirstKeyCard() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.FirstKeyCard"));
        this.catalogStats.add(jLabel);
        this.ifFirstKeyCard = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifFirstKeyCard);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 80);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifFirstKeyCard, 80);
    }

    protected void initFullKeyCard() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.FullKeyCard"));
        this.catalogStats.add(jLabel);
        this.ifFullKeyCard = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifFullKeyCard);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 110);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifFullKeyCard, 110);
    }

    protected void initNumberLeaf() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.NumberLeaf"));
        this.catalogStats.add(jLabel);
        this.ifNumberLeaf = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifNumberLeaf);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 140);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifNumberLeaf, 140);
    }

    protected void initNumberLevels() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.NumberLevels"));
        this.catalogStats.add(jLabel);
        this.ifNumberLevels = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifNumberLevels);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 170);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifNumberLevels, 170);
    }

    protected void initCatalogSpace() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.CatalogSpace"));
        this.catalogStats.add(jLabel);
        this.ifCatalogSpace = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifCatalogSpace);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 200);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifCatalogSpace, 200);
    }

    protected void initClusterRatio() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.ClusterRatio"));
        this.catalogStats.add(jLabel);
        this.ifClusterRatio = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifClusterRatio);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 230);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifClusterRatio, 230);
    }

    private void initClustered() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.Clustered"));
        this.catalogStats.add(jLabel);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.catalogStats.add(this.cbClustered);
        this.setLabelConstraints(this.getCatalogStatsLayout(), jLabel, 260);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.cbClustered, 260);
    }

    protected void initMaintenanceInterval() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.MaintInterval"));
        this.designStats.add(jLabel);
        this.ifMaintenanceInterval = new JIntegerField(0, 26);
        this.designStats.add(this.ifMaintenanceInterval);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifMaintenanceInterval, 20);
    }

    protected void initSpaceAllocInterval() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.SpaceAllocInterval"));
        this.designStats.add(jLabel);
        this.ifSpaceAllocInterval = new JIntegerField(0, 26);
        this.designStats.add(this.ifSpaceAllocInterval);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifSpaceAllocInterval, 50);
    }

    protected void initInitial() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.Initial"));
        this.designStats.add(jLabel);
        this.ifInitial = new JIntegerField(0, 26);
        this.designStats.add(this.ifInitial);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 80);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifInitial, 80);
    }

    protected void initFrequencyCount() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.FrequencyCount"));
        this.designStats.add(jLabel);
        this.ifFrequencyCount = new JIntegerField(0, 26);
        this.designStats.add(this.ifFrequencyCount);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 110);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifFrequencyCount, 110);
    }

    protected void initFrequencyPercent() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.FrequencyPercent"));
        this.designStats.add(jLabel);
        this.dfFrequencyPercent = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfFrequencyPercent);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 140);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfFrequencyPercent, 140);
    }

    protected void initUpdateRatePercent() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogDB2.UpdRatePercent"));
        this.designStats.add(jLabel);
        this.dfUpdateRatePercent = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfUpdateRatePercent);
        this.setLabelConstraints(this.getDesignStatsLayout(), jLabel, 170);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfUpdateRatePercent, 170);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        this.cbTable.setText(this.index.getIndex().getName());
        this.initNumParts();
        this.initClusterType();
        this.cbUnique.setText(this.index.getIndex().getIndexState());
        this.selectObject(this.cbOwner, this.index.getOwner());
        this.cbWhereNotNull.setSelectedItem(this.index.isWhereNotNull() ? YES_NO[0] : YES_NO[1]);
        this.selectObject(this.cbStorageTemplate, this.index.getStorageTemplate());
        this.cbClusterType.setSelectedItem(this.index.getClusterType());
        this.ifNumParts.setValue((long)this.index.getNumParts());
        this.cbPieceSize.setSelectedItem(this.index.getPieceSize());
        this.selectObject(this.cbBufferPool, this.index.getBufferPool());
        this.cbClose.setSelectedItem(this.index.isClose() ? YES_NO[0] : YES_NO[1]);
        this.cbDefer.setSelectedItem(this.index.isDefer() ? YES_NO[0] : YES_NO[1]);
        this.cbCopy.setSelectedItem(this.index.isCopy() ? YES_NO[0] : YES_NO[1]);
        this.ifISOBIT.setValue((long)this.index.getIsobid());
        this.tfCreatedBy.setText(this.index.getCreatedBy());
        this.ifFirstKeyCard.setValue((long)this.index.getFirstKeyCard());
        this.ifFullKeyCard.setValue((long)this.index.getFullKeyCard());
        this.ifNumberLeaf.setValue((long)this.index.getNumberLeaf());
        this.ifNumberLevels.setValue((long)this.index.getNumberLevels());
        this.ifCatalogSpace.setValue((long)this.index.getCatalogSpace());
        this.ifClusterRatio.setValue((long)this.index.getClusterRatio());
        this.cbClustered.setSelectedItem(this.index.isClustered() ? YES_NO[0] : YES_NO[1]);
        this.ifMaintenanceInterval.setValue((long)this.index.getMaintenanceInterval());
        this.ifSpaceAllocInterval.setValue((long)this.index.getSpaceAllocationInterval());
        this.ifInitial.setValue(this.index.getInitial());
        this.ifFrequencyCount.setValue(this.index.getFrequencyCount());
        this.dfFrequencyPercent.setValue(this.index.getFrequencyPercent());
        this.dfUpdateRatePercent.setValue(this.index.getUpdateRatePercent());
        this.comment = this.index.getObject().getComment();
        this.commentInRDBMS = this.index.getObject().getCommentInRDBMS();
        if (this.index.isCommentChanged()) {
            this.getCommentsList().insert(this.index.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.index.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.index.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initSpaceCalcs();
        this.initColumnsSortOrder();
        this.enablePieceSize();
        this.partitionsModel.clear();
        Iterator iterator = this.index.getIndexPartitions().iterator();
        while (iterator.hasNext()) {
            try {
                IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)iterator.next();
                this.partitionsModel.addElement(indexPartitionDB2);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            this.index.setName(this.tfName.getText());
            Object object = this.cbOwner.getSelectedItem();
            if (object instanceof Owner) {
                this.index.setOwner((Owner)object);
            } else {
                this.index.setOwner(null);
            }
            object = this.cbWhereNotNull.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.index.setWhereNotNull(bl);
            object = this.cbStorageTemplate.getSelectedItem();
            if (object instanceof StorageTemplateDB2) {
                this.index.setStorageTemplate((StorageTemplateDB2)object);
            } else {
                this.index.setStorageTemplate(null);
            }
            this.index.setClusterType((String)this.cbClusterType.getSelectedItem());
            this.index.setPieceSize((String)this.cbPieceSize.getSelectedItem());
            object = this.cbBufferPool.getSelectedItem();
            if (object instanceof BufferPoolDB2) {
                this.index.setBufferPool((BufferPoolDB2)object);
            } else {
                this.index.setBufferPool(null);
            }
            object = this.cbClose.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.index.setClose(bl);
            object = this.cbDefer.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.index.setDefer(bl);
            object = this.cbCopy.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.index.setCopy(bl);
            this.index.setIsobid(this.ifISOBIT.getIntValue());
            this.index.setCreatedBy(this.tfCreatedBy.getText());
            this.index.setFirstKeyCard(this.ifFirstKeyCard.getIntValue());
            this.index.setFullKeyCard(this.ifFullKeyCard.getIntValue());
            this.index.setNumberLeaf(this.ifNumberLeaf.getIntValue());
            this.index.setNumberLevels(this.ifNumberLevels.getIntValue());
            this.index.setCatalogSpace(this.ifCatalogSpace.getIntValue());
            this.index.setClusterRatio(this.ifClusterRatio.getIntValue());
            object = this.cbClustered.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.index.setClustered(bl);
            this.index.setMaintenanceInterval(this.ifMaintenanceInterval.getIntValue());
            this.index.setSpaceAllocationInterval(this.ifSpaceAllocInterval.getIntValue());
            this.index.setInitial(this.ifInitial.getIntValue());
            this.index.setFrequencyCount(this.ifFrequencyCount.getIntValue());
            this.index.setFrequencyPercent(this.dfFrequencyPercent.getFloatValue());
            this.index.setUpdateRatePercent(this.dfUpdateRatePercent.getFloatValue());
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
                this.index.setComment(string);
                this.index.setCommentChanged(true);
            } else {
                this.index.setComment("");
                this.index.setCommentChanged(false);
            }
            String string2 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string2) && !this.commentInRDBMS.equalsIgnoreCase(string2)) {
                this.index.setCommentInRDBMS(string2);
                this.index.setCommentInRDBMSChanged(true);
            } else {
                this.index.setCommentInRDBMS("");
                this.index.setCommentInRDBMSChanged(false);
            }
            this.initSpaceCalcs();
            this.applyColumnsSortOrder();
            if (((String)this.cbClusterType.getSelectedItem()).equalsIgnoreCase("CLUSTERED_PARTITIONED")) {
                int n = this.index.getIndexPartitions().size();
                for (int i = 0; i < n; ++i) {
                    this.index.getIndexPartitions().justRemove(this.index.getIndexPartitions().getElement(0));
                }
                for (int i = 0; i < this.partitionsModel.toArray().length; ++i) {
                    if (!(this.partitionsModel.get(i) instanceof IndexPartitionDB2)) continue;
                    IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)this.partitionsModel.get(i);
                    indexPartitionDB2.addObjectListener(this.index);
                    indexPartitionDB2.setPartNumber(i + 1);
                    indexPartitionDB2.setParent(this.index.getIndexPartitions());
                    this.index.getIndexPartitions().add(indexPartitionDB2);
                }
            }
        }
    }

    protected void initSpaceCalcsView(int n) {
        this.spaceCalcs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.SpaceCalcs"), this.spaceCalcs);
        this.taSpaceCalcs = new JTextPane();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.taSpaceCalcs.setParagraphAttributes(simpleAttributeSet, true);
        JScrollPane jScrollPane = new JScrollPane(this.taSpaceCalcs);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.spaceCalcs.add(jScrollPane);
        this.setObjectConstraints(this.getSpaceCalcsLayout(), jScrollPane, 10, 12);
        this.taSpaceCalcs.setEditable(false);
    }

    protected SpringLayout getSpaceCalcsLayout() {
        return (SpringLayout)this.spaceCalcs.getLayout();
    }

    private String formatText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        while (stringBuffer.length() < 30) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("\t");
        return stringBuffer.toString();
    }

    private String formatInt(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toString(n);
        for (int i = 0; i < 15 - string.length(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected void initSpaceCalcs() {
        if (this.index != null) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.InitNumberOfUsedPages"))).append(this.formatInt(this.index.getInitialNumberUsedPages())).append("\n");
            stringBuffer.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.MaxNumberOfUsedPages"))).append(this.formatInt(this.index.getMaxNumberUsedPages())).append("\n\n");
            stringBuffer.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.ProposedPRIQTY"))).append(this.formatInt(this.index.getProposedPRIQTY())).append("\n");
            stringBuffer.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.ProposedSECQTY"))).append(this.formatInt(this.index.getProposedSECQTY())).append("\n");
            if (this.index.getStorageTemplate() != null) {
                stringBuffer.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.CurrentPRIQTY"))).append(this.formatInt(this.index.getStorageTemplate().getSgPriqty())).append("\n");
                stringBuffer.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.CurrentSECQTY"))).append(this.formatInt(this.index.getStorageTemplate().getSgSeqty())).append("\n\n");
            }
            if (!(string = this.index.getProposedQTYRemarks()).equals("")) {
                stringBuffer.append(Messages.getString("IndexPropertyDialogDB2.RemarksOnProposedPRIQTYAndSECQTY")).append(string);
            }
            this.taSpaceCalcs.setText(stringBuffer.toString());
        } else {
            this.taSpaceCalcs.setText("");
        }
    }

    protected void initColumnsView(int n) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(jScrollPane);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.index.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection collection = this.sortModel.getColumnsSortOrederColl();
        Iterator iterator = collection.iterator();
        Index index = (Index)this.index.getObject();
        while (iterator.hasNext()) {
            ColumnsSortOrderModel.ColumnNode columnNode = (ColumnsSortOrderModel.ColumnNode)iterator.next();
            Column column = (Column)index.getElementByID(columnNode.objectId);
            if (column == null) continue;
            index.setColumnSortOrder(column, columnNode.sortOrder);
        }
    }

    private void enablePieceSize() {
        String string = (String)this.cbClusterType.getSelectedItem();
        this.cbPieceSize.setEnabled(!string.equalsIgnoreCase("CLUSTERED_PARTITIONED"));
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("IndexPropertyDialogDB2.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(IndexPropertyDialogDB2.this.getStorageDesign().getIndexProxySet().getElements());
                arrayList.remove(IndexPropertyDialogDB2.this.index);
                new PropertiesPropagationDialog(IndexPropertyDialogDB2.this.getAppView(), IndexPropertyDialogDB2.this.index, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 420);
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = IndexPropertyDialogDB2.this.partitionsList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] == -1 || IndexPropertyDialogDB2.this.partitionsModel.size() - 1 <= nArray[i]) continue;
                IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsModel.get(nArray[i]);
                IndexPartitionDB2 indexPartitionDB22 = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsModel.get(nArray[i] + 1);
                IndexPropertyDialogDB2.this.partitionsModel.setElementAt(indexPartitionDB2, nArray[i] + 1);
                IndexPropertyDialogDB2.this.partitionsModel.setElementAt(indexPartitionDB22, nArray[i]);
            }
            IndexPropertyDialogDB2.this.partitionsList.clearSelection();
            IndexPropertyDialogDB2.this.partitionsList.updateUI();
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = IndexPropertyDialogDB2.this.partitionsList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1 || nArray[i] <= 0) continue;
                IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsModel.get(nArray[i]);
                IndexPartitionDB2 indexPartitionDB22 = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsModel.get(nArray[i] - 1);
                IndexPropertyDialogDB2.this.partitionsModel.setElementAt(indexPartitionDB2, nArray[i] - 1);
                IndexPropertyDialogDB2.this.partitionsModel.setElementAt(indexPartitionDB22, nArray[i]);
            }
            IndexPropertyDialogDB2.this.partitionsList.clearSelection();
            IndexPropertyDialogDB2.this.partitionsList.updateUI();
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsList.getSelectedValue();
            if (indexPartitionDB2 != null && !indexPartitionDB2.isDialogVisible()) {
                IndexPartitionPropertyDialogDB2 indexPartitionPropertyDialogDB2 = new IndexPartitionPropertyDialogDB2(IndexPropertyDialogDB2.this.getAppView(), IndexPropertyDialogDB2.this.getStorageDesign(), indexPartitionDB2);
                indexPartitionPropertyDialogDB2.show();
            }
        }
    }
}

