/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.IndexProxyDB2v70;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.DataBasePropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class BufferPoolPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private JIntegerField ifMinBuffers;
    private JIntegerField ifMaxBuffers;
    private BufferPoolDB2 bufferPool;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;
    private JScrollPane spTS;
    private JPanel indexes;
    private DefaultListModel indexesListModel;
    private JList indexesList;
    private JScrollPane spIndexes;
    private JPanel databases;
    private DefaultListModel dbListModel;
    private JList dbList;
    private JScrollPane spDB;
    private JPanel usePrivilegesPanel;
    private DefaultListModel allUsersModel;
    private DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JComboBox cbAllBufferpools;
    private JComboBox cbGrantOption;

    public BufferPoolPropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.bufferPool = (BufferPoolDB2)storageObject;
        this.setHeight(250);
        this.initCommentsView(180);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("BufferPoolPropertyDialogDB2.BufferPoolProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.tfName.setEditable(false);
        this.initMinBuffers();
        this.initMaxBuffers();
    }

    @Override
    protected void addTabs() {
        this.initUsePrivilegesView();
        this.initTableSpacesView();
        this.initIndexesView();
        this.initDatabaseView();
    }

    private void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogDB2.UsePrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    private void initUsePrivileges() {
        this.initToUsers();
        this.initAllBufferpools();
        this.initGrantOption();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initButtons();
    }

    private void initAllUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.AllUsers"));
        this.usePrivilegesPanel.add(jLabel);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allUsersList);
        jScrollPane.setPreferredSize(new Dimension(144, 90));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.SelectedUsers"));
        this.usePrivilegesPanel.add(jLabel);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedUsersList);
        jScrollPane.setPreferredSize(new Dimension(145, 90));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 292, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 290, 32);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("BufferPoolPropertyDialogDB2.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAdd);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAdd, 175, 55);
        this.bnRemove = new JButton(Messages.getString("BufferPoolPropertyDialogDB2.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.usePrivilegesPanel.add(this.bnRemove);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemove, 175, 85);
        BufferPoolPropertyDialogDB2.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initAllBufferpools() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.AllBufferpools"));
        this.usePrivilegesPanel.add(jLabel);
        this.cbAllBufferpools = new JComboBox<String>(YES_NO);
        this.setBG(this.cbAllBufferpools);
        this.cbAllBufferpools.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbAllBufferpools);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 140);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbAllBufferpools, 140);
    }

    private void initGrantOption() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.GrantOption"));
        this.usePrivilegesPanel.add(jLabel);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbGrantOption);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 170);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbGrantOption, 170);
    }

    private void initDatabaseView() {
        this.databases = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogDB2.Databases"), this.databases);
        this.initDatabase();
    }

    private void initDatabase() {
        this.dbListModel = new DefaultListModel();
        this.dbList = new JList(this.dbListModel);
        this.dbList.addMouseListener(new listMouseListenerDB());
        this.spDB = new JScrollPane(this.dbList);
        this.spDB.setPreferredSize(new Dimension(395, 180));
        this.spDB.setBorder(BorderFactory.createEtchedBorder(0));
        this.databases.add(this.spDB);
        this.setObjectConstraints(this.getDBLayout(), this.spDB, 10, 12);
    }

    private SpringLayout getDBLayout() {
        return (SpringLayout)this.databases.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogDB2.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexesListModel = new DefaultListModel();
        this.indexesList = new JList(this.indexesListModel);
        this.indexesList.addMouseListener(new listMouseListenerIndex());
        this.spIndexes = new JScrollPane(this.indexesList);
        this.spIndexes.setPreferredSize(new Dimension(395, 180));
        this.spIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(this.spIndexes);
        this.setObjectConstraints(this.getIndexesLayout(), this.spIndexes, 10, 12);
    }

    private SpringLayout getIndexesLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initTableSpacesView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogDB2.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new listMouseListenerTS());
        this.spTS = new JScrollPane(this.tsList);
        this.spTS.setPreferredSize(new Dimension(395, 180));
        this.spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(this.spTS);
        this.setObjectConstraints(this.getTSLayout(), this.spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    private void initMinBuffers() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.MinBuffers"));
        this.general.add(jLabel);
        this.ifMinBuffers = new JIntegerField(0, 26);
        this.general.add(this.ifMinBuffers);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.ifMinBuffers, 50);
    }

    private void initMaxBuffers() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.MaxBuffers"));
        this.general.add(jLabel);
        this.ifMaxBuffers = new JIntegerField(0, 26);
        this.general.add(this.ifMaxBuffers);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifMaxBuffers, 80);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.bufferPool.getName());
        this.tfName.setText(this.bufferPool.getName());
        this.ifMinBuffers.setValue((long)this.bufferPool.getMinBuffers());
        this.ifMaxBuffers.setValue((long)this.bufferPool.getMaxBuffers());
        Owner[] ownerArray = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < ownerArray.length; ++i) {
            Owner owner = ownerArray[i];
            if (owner.getName().equalsIgnoreCase("[Implicit]")) continue;
            if (this.bufferPool.getUserSet().contains(owner.getName())) {
                this.selectedUsersModel.addElement(owner);
                continue;
            }
            this.allUsersModel.addElement(owner);
        }
        this.cbAllBufferpools.setSelectedItem(BufferPoolPropertyDialogDB2.translateYesNoForDisplay(this.bufferPool.getAllBufferpools()));
        this.cbGrantOption.setSelectedItem(BufferPoolPropertyDialogDB2.translateYesNoForDisplay(this.bufferPool.getGrantOption()));
        this.getCommentsList().insert(this.bufferPool.getComment(), 0);
        TableSpaceDB2[] tableSpaceDB2Array = (TableSpaceDB2[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceDB2Array.length; ++i) {
            TableSpaceDB2 tableSpaceDB2 = tableSpaceDB2Array[i];
            if (tableSpaceDB2.getBufferPool() == null || !tableSpaceDB2.getBufferPool().equals(this.bufferPool)) continue;
            this.tsListModel.addElement(tableSpaceDB2);
        }
        Object[] objectArray = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            IndexProxyDB2 indexProxyDB2;
            if (!(objectArray[i] instanceof IndexProxyDB2) || (indexProxyDB2 = (IndexProxyDB2)objectArray[i]).getBufferPool() == null || !indexProxyDB2.getBufferPool().equals(this.bufferPool)) continue;
            this.indexesListModel.addElement(indexProxyDB2);
        }
        DataBaseDB2[] dataBaseDB2Array = (DataBaseDB2[])this.getStorageDesign().getDataBaseSet().toArray();
        for (int i = 0; i < dataBaseDB2Array.length; ++i) {
            DataBaseDB2 dataBaseDB2 = dataBaseDB2Array[i];
            if (dataBaseDB2.getBufferPool() == null || !dataBaseDB2.getBufferPool().equals(this.bufferPool)) continue;
            this.dbListModel.addElement(dataBaseDB2);
        }
    }

    @Override
    protected void setProperties() {
        if (this.bufferPool != null) {
            this.bufferPool.setMinBuffers(this.ifMinBuffers.getIntValue());
            this.bufferPool.setMaxBuffers(this.ifMaxBuffers.getIntValue());
            Object[] objectArray = this.selectedUsersModel.toArray();
            this.bufferPool.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof Owner)) continue;
                this.bufferPool.setUsers(((Owner)object).getName());
            }
            this.bufferPool.setAllBufferpools(BufferPoolPropertyDialogDB2.translateYesNoForStorage((String)this.cbAllBufferpools.getSelectedItem()));
            this.bufferPool.setGrantOption(BufferPoolPropertyDialogDB2.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.bufferPool.setComment(this.getCommentsList().getText());
        }
    }

    private class listMouseListenerDB
    extends MouseAdapter {
        private listMouseListenerDB() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            DataBaseDB2 dataBaseDB2;
            if (mouseEvent.getClickCount() == 2 && (dataBaseDB2 = (DataBaseDB2)BufferPoolPropertyDialogDB2.this.dbList.getSelectedValue()) != null && !dataBaseDB2.isDialogVisible()) {
                DataBasePropertyDialogDB2 dataBasePropertyDialogDB2 = new DataBasePropertyDialogDB2(BufferPoolPropertyDialogDB2.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogDB2.this.getStorageDesign(), dataBaseDB2);
                dataBasePropertyDialogDB2.show();
            }
        }
    }

    private class listMouseListenerIndex
    extends MouseAdapter {
        private listMouseListenerIndex() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            IndexProxyDB2v70 indexProxyDB2v70;
            if (mouseEvent.getClickCount() == 2 && (indexProxyDB2v70 = (IndexProxyDB2v70)BufferPoolPropertyDialogDB2.this.indexesList.getSelectedValue()) != null && !indexProxyDB2v70.isDialogVisible()) {
                IndexPropertyDialogDB2 indexPropertyDialogDB2 = new IndexPropertyDialogDB2(BufferPoolPropertyDialogDB2.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogDB2.this.getStorageDesign(), indexProxyDB2v70);
                indexPropertyDialogDB2.show();
            }
        }
    }

    private class listMouseListenerTS
    extends MouseAdapter {
        private listMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableSpaceDB2 tableSpaceDB2;
            if (mouseEvent.getClickCount() == 2 && (tableSpaceDB2 = (TableSpaceDB2)BufferPoolPropertyDialogDB2.this.tsList.getSelectedValue()) != null && !tableSpaceDB2.isDialogVisible()) {
                TableSpacePropertyDialogDB2 tableSpacePropertyDialogDB2 = new TableSpacePropertyDialogDB2(BufferPoolPropertyDialogDB2.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogDB2.this.getStorageDesign(), tableSpaceDB2);
                tableSpacePropertyDialogDB2.show();
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BufferPoolPropertyDialogDB2.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogDB2.this.selectedUsersList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogDB2.this.bnRemove.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogDB2.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BufferPoolPropertyDialogDB2.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogDB2.this.allUsersList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogDB2.this.bnAdd.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogDB2.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BufferPoolPropertyDialogDB2.this.selectedUsersModel.isEmpty()) {
                Object[] objectArray = BufferPoolPropertyDialogDB2.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BufferPoolPropertyDialogDB2.this.allUsersModel.contains(object)) continue;
                    BufferPoolPropertyDialogDB2.this.allUsersModel.addElement(object);
                    BufferPoolPropertyDialogDB2.this.selectedUsersModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BufferPoolPropertyDialogDB2.this.allUsersModel.isEmpty()) {
                Object[] objectArray = BufferPoolPropertyDialogDB2.this.allUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BufferPoolPropertyDialogDB2.this.selectedUsersModel.contains(object)) continue;
                    BufferPoolPropertyDialogDB2.this.selectedUsersModel.addElement(object);
                    BufferPoolPropertyDialogDB2.this.allUsersModel.removeElement(object);
                }
            }
        }
    }
}

