/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AliasPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private JComboBox cbOwner;
    private JComboBox cbView;
    private JComboBox cbTable;
    private JComboBox cbAnotherAlias;
    private AliasDB2 alias;

    public AliasPropertyDialogDB2(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.alias = (AliasDB2)storageObject;
        this.setHeight(200);
        this.initCommentsView(65);
        this.initCommentsInRDBMS(65);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("AliasPropertyDialogDB2.AliasProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.alias.getName());
        this.tfName.setText(this.alias.getName());
        this.selectObject(this.cbOwner, this.alias.getOwner());
        this.selectObject(this.cbView, this.alias.getView());
        this.selectObject(this.cbTable, this.alias.getTable());
        this.cbAnotherAlias.removeItem(this.alias);
        this.selectObject(this.cbAnotherAlias, this.alias.getAnotherAlias());
        this.getCommentsList().insert(this.alias.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.alias.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.alias != null) {
            Object object = this.cbOwner.getSelectedItem();
            if (object instanceof Owner) {
                this.alias.setOwner((Owner)object);
            } else {
                this.alias.setOwner(null);
            }
            this.alias.setName(this.tfName.getText());
            object = this.cbView.getSelectedItem();
            if (object instanceof StorageObject) {
                this.alias.setView((TableViewProxyDB2)object);
            } else {
                object = this.cbTable.getSelectedItem();
                if (object instanceof StorageObject) {
                    this.alias.setTable((TableProxyDB2)object);
                } else {
                    object = this.cbAnotherAlias.getSelectedItem();
                    if (object instanceof StorageObject) {
                        this.alias.setAnotherAlias((AliasDB2)object);
                    }
                }
            }
            this.alias.setComment(this.getCommentsList().getText());
            this.alias.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initView();
        this.initTable();
        this.initAnotherAlias();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("AliasPropertyDialogDB2.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initView() {
        JLabel jLabel = new JLabel(Messages.getString("AliasPropertyDialogDB2.View"));
        this.general.add(jLabel);
        this.cbView = new JComboBox();
        this.setBG(this.cbView);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableViewProxySet().toArray(), this.cbView);
        }
        this.cbView.setPreferredSize(this.tfName.getPreferredSize());
        this.cbView.addActionListener(new ComboListener());
        this.general.add(this.cbView);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbView, 80);
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("AliasPropertyDialogDB2.Table"));
        this.general.add(jLabel);
        this.cbTable = new JComboBox();
        this.setBG(this.cbTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbTable);
        }
        this.cbTable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTable.addActionListener(new ComboListener());
        this.general.add(this.cbTable);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbTable, 110);
    }

    private void initAnotherAlias() {
        JLabel jLabel = new JLabel(Messages.getString("AliasPropertyDialogDB2.AnotherAlias"));
        this.general.add(jLabel);
        this.cbAnotherAlias = new JComboBox();
        this.setBG(this.cbAnotherAlias);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getAliasSet().toArray(), this.cbAnotherAlias);
        }
        this.cbAnotherAlias.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAnotherAlias.addActionListener(new ComboListener());
        this.general.add(this.cbAnotherAlias);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbAnotherAlias, 140);
    }

    @Override
    protected boolean allowName(String string) {
        Owner owner;
        Object object = this.cbOwner.getSelectedItem();
        if (object instanceof Owner && !(owner = (Owner)object).isNullInstance()) {
            string = owner.getSchemaObject() != null ? owner.getSchemaObject().getName() + '.' + string : owner.getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            Object object = jComboBox.getSelectedItem();
            if (object instanceof StorageObject) {
                if (AliasPropertyDialogDB2.this.cbView.equals(jComboBox)) {
                    AliasPropertyDialogDB2.this.cbTable.setSelectedIndex(0);
                    AliasPropertyDialogDB2.this.cbAnotherAlias.setSelectedIndex(0);
                } else if (AliasPropertyDialogDB2.this.cbTable.equals(jComboBox)) {
                    AliasPropertyDialogDB2.this.cbView.setSelectedIndex(0);
                    AliasPropertyDialogDB2.this.cbAnotherAlias.setSelectedIndex(0);
                } else if (AliasPropertyDialogDB2.this.cbAnotherAlias.equals(jComboBox)) {
                    AliasPropertyDialogDB2.this.cbView.setSelectedIndex(0);
                    AliasPropertyDialogDB2.this.cbTable.setSelectedIndex(0);
                }
            }
        }
    }
}

