/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_TableView;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.designrules.DRViewCaseType;
import oracle.dbtools.crest.model.designrules.DRViewMaxNameLength;
import oracle.dbtools.crest.model.designrules.DRViewValidCharacters;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QueryBuilderPanel;
import oracle.dbtools.crest.swingui.editor.viewbuilder.ViewBuilder;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.DMSQLQueryTester;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.ResultTesterComponent;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;
import oracle.dbtools.crest.util.gui.swing.LNComboTableCellRenderer;

public class TableViewPropertiesDialogEx
extends AbstractPropertiesDialog {
    private TableView tableView;
    private JButton btnQueryBuilder;
    private JComboBox cbBaseOnStructuredType;
    private JDialog builder;
    private StructuredType st_type;
    protected JTextArea userDefinedSQL;
    private JPanel pnReferenceElements;
    private JPanel pnUserDefinedSQL;
    private JPanel pnElementComments;
    private ColumnTable sTable;
    private JTable tbElements;
    private JTextArea taElementComments;
    private List lsElements;
    private List sList;
    private JCheckBox chTypeSubst;
    private JTextField tfOIDColumns;
    private JTree tree;
    private JComboBox cbSchemaObject;
    private JCheckBox chIncludeSchemaNameInQuery;
    private JComboBox cbSubViews;
    private JButton btnTestQuery;
    private int currentElement;

    public TableViewPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    protected int getMinimumHeight() {
        return 425;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableViewPropertiesDialogEx.ViewProperties");
    }

    private List getStructuredTypes() {
        ArrayList<StructuredType> arrayList = new ArrayList<StructuredType>();
        Iterator iterator = this.tableView.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (!structuredType.isInstantiable()) continue;
            arrayList.add(structuredType);
        }
        return arrayList;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof TableView) {
            Object object;
            Object object2;
            this.tableView = (TableView)designObject;
            this.initDefaults();
            this.fillComboItems(this.getStructuredTypes().toArray(), this.cbBaseOnStructuredType, true);
            this.cbBaseOnStructuredType.setSelectedItem(this.tableView.getBasedOnStructuredType());
            if (this.tableView.isBST()) {
                this.st_type = this.tableView.getBasedOnStructuredType();
                this.tfOIDColumns.setText(this.tableView.getOidText());
            }
            this.chTypeSubst.setSelected(this.tableView.isAllowTypeSubstitution());
            if (!this.tableView.isBST() || this.tableView.isBST() && this.tableView.getSubTypeSubstitutions().size() > 0) {
                this.chTypeSubst.setEnabled(false);
            }
            if (this.btnQueryBuilder != null) {
                this.btnQueryBuilder.setEnabled(this.isEditable());
            }
            this.enablePanels(this.st_type != null);
            this.chIncludeSchemaNameInQuery.setSelected(this.tableView.includeSchemaNameInQuery());
            this.updateElementsList();
            this.updateColumnList();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.taBeforeDrop.setText(this.tableView.getBeforeDrop());
            this.taBeforeCreate.setText(this.tableView.getBeforeCreate());
            this.taAfterCreate.setText(this.tableView.getAfterCreate());
            this.taEndOfScript.setText(this.tableView.getEndOfScript());
            this.chGenerateScript.setSelected(this.tableView.getShouldGenerateScript());
            this.fillComboItems(((RelationalDesign)this.tableView.getDesignPart()).getSchemaObjectSet().toArray(), this.cbSchemaObject, true);
            this.cbSchemaObject.setSelectedItem(this.tableView.getSchemaObject());
            String string = this.tableView.getUseObjectsOnlyFrom();
            Object object3 = null;
            this.cbSubViews.addItem(this.tableView.getDesignPart().getMainView());
            Iterator iterator = this.tableView.getDesignPart().getDesignSubviews().iterator();
            while (iterator.hasNext()) {
                object2 = (DesignPartViewPlaceHolder)iterator.next();
                object = ((DesignPartViewPlaceHolder)object2).getDesignPartView();
                this.cbSubViews.addItem(object);
                if (string.length() <= 0 || !((DesignPartView)object).getDPVId().equalsIgnoreCase(string)) continue;
                object3 = object;
            }
            if (object3 != null) {
                this.cbSubViews.setSelectedItem(object3);
            }
            object2 = new CompareTreeNavigationDesign(new ImpA_TableView(this.tableView, null));
            object = new ImpactTreeRenderer();
            this.tree.setModel((TreeModel)object2);
            this.tree.setCellRenderer((TreeCellRenderer)object);
            this.dynamicPropertiesList.clear();
            Iterator iterator2 = this.tableView.getPropertyNames();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                String string3 = this.tableView.getProperty(string2);
                DynamicProperty dynamicProperty = new DynamicProperty(string2, string3);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private void updateColumnList() {
        this.sList.clear();
        this.sTable.clearTable();
        for (ColumnView columnView : this.tableView.getRefColumns()) {
            if (this.sList.contains(columnView)) continue;
            this.sList.add(columnView);
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(columnView);
            JLNComboBox jLNComboBox = new JLNComboBox(this.getScopeTables(columnView));
            jLNComboBox.setSelectedItem(columnView.getScope());
            vector.addElement(jLNComboBox);
            Object[] objectArray = vector.toArray();
            ((ComboModel)this.sTable.getModel()).addRow(objectArray);
        }
        this.sTable.updateUI();
    }

    private void updateElementsList() {
        this.currentElement = -1;
        this.taElementComments.setText("");
        this.taElementComments.setEnabled(false);
        ContainedObject[] containedObjectArray = this.tableView.getElements();
        List<ContainedObject> list = Arrays.asList(containedObjectArray);
        for (int i = this.lsElements.size() - 1; i >= 0; --i) {
            ElementHelper object = (ElementHelper)this.lsElements.get(i);
            if (list.contains(object.getElement())) continue;
            this.lsElements.remove(i);
        }
        for (AbstractViewElement abstractViewElement : list) {
            if (this.listContainsElement(abstractViewElement)) continue;
            ElementHelper elementHelper = new ElementHelper(abstractViewElement);
            this.lsElements.add(elementHelper);
        }
        this.tbElements.updateUI();
        this.tbElements.clearSelection();
    }

    @Override
    protected void showComponent(Component component) {
        this.setPreviousSelectedElement();
        super.showComponent(component);
    }

    private boolean listContainsElement(AbstractViewElement abstractViewElement) {
        for (ElementHelper elementHelper : this.lsElements) {
            if (elementHelper.getElement() != abstractViewElement) continue;
            return true;
        }
        return false;
    }

    private Object[] getScopeTables(ColumnView columnView) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        arrayList.add(null);
        if (columnView.getStructuredType() != null) {
            Iterator iterator = ((RelationalDesign)this.tableView.getDesignPart()).getTableSet().iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                if (!table.isBST() || !columnView.getStructuredType().isParentOf(table.getBasedOnStructuredType())) continue;
                arrayList.add(table);
            }
        }
        return arrayList.toArray();
    }

    @Override
    protected void setProperties() {
        this.tableView.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
        this.tableView.setName(this.tfName.getText());
        this.tableView.setComment(this.taComments.getText());
        this.tableView.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.tableView.setNotes(this.taNotes.getText());
        this.tableView.setBasedOnStructuredType((StructuredType)this.cbBaseOnStructuredType.getSelectedItem());
        if (this.tableView.isBST()) {
            this.tableView.setOidText(this.tfOIDColumns.getText().trim());
        }
        for (int i = 0; i < this.sTable.getRowCount(); ++i) {
            Object object = (ColumnView)this.sTable.getModel().getValueAt(i, 0);
            Table table = (Table)((JLNComboBox)this.sTable.getModel().getValueAt(i, 1)).getSelectedItem();
            if (table != null) {
                ((ContainedObject)object).setScopeId(table.getObjectID());
                continue;
            }
            ((ContainedObject)object).setScopeId(null);
        }
        this.tableView.setAllowTypeSubstitution(this.chTypeSubst.isSelected());
        this.tableView.setIncludeSchemaNameInQuery(this.chIncludeSchemaNameInQuery.isSelected());
        if (this.cbSubViews.getSelectedIndex() > 0) {
            this.tableView.setUseObjectsOnlyFrom(((DesignPartView)this.cbSubViews.getSelectedItem()).getDPVId());
        } else {
            this.tableView.setUseObjectsOnlyFrom("");
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.tableView.setBeforeDrop(this.taBeforeDrop.getText());
        this.tableView.setBeforeCreate(this.taBeforeCreate.getText());
        this.tableView.setAfterCreate(this.taAfterCreate.getText());
        this.tableView.setEndOfScript(this.taEndOfScript.getText());
        this.tableView.setShouldGenerateScript(this.chGenerateScript.isSelected());
        this.checkNamingOptions();
        TableViewPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.tableView.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.tableView.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
        this.applyElementsComments();
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRViewMaxNameLength(), this.tableView);
        this.checkDesignRule(new DRViewCaseType(), this.tableView);
        this.checkDesignRule(new DRViewValidCharacters(), this.tableView);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getElementCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getReferenceElementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getScriptPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "VIEW_PROPERTIES_DIALOG";
    }

    public JDialog getBuilder() {
        if (this.builder == null) {
            this.builder = new ViewBuilder(this.tableView).getDialog(this.getAppView());
            return this.builder;
        }
        return this.builder;
    }

    private void enablePanels(boolean bl) {
        this.sTable.setEnabled(bl);
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 210;
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertiesDialogEx.QueryBuilder"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.btnQueryBuilder = new JButton(BTN_QUERY);
        this.btnQueryBuilder.setHorizontalAlignment(2);
        this.btnQueryBuilder.setPreferredSize(this.getDefaultSize());
        this.btnQueryBuilder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryBuilderPanel queryBuilderPanel = new QueryBuilderPanel(TableViewPropertiesDialogEx.this.tableView);
                DesignPartView designPartView = null;
                if (TableViewPropertiesDialogEx.this.cbSubViews.getSelectedIndex() > 0) {
                    designPartView = (DesignPartView)TableViewPropertiesDialogEx.this.cbSubViews.getSelectedItem();
                }
                queryBuilderPanel.getDialog(TableViewPropertiesDialogEx.this.getAppView(), TableViewPropertiesDialogEx.this.chIncludeSchemaNameInQuery.isSelected() && TableViewPropertiesDialogEx.this.tableView.getSchemaObject() != null, designPartView).setVisible(true);
                TableViewPropertiesDialogEx.this.updateElementsList();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel, this.btnQueryBuilder));
        JLabel jLabel2 = new JLabel(LB_BASED_ON_STRUCTURED_TYPE);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType = new JComboBox();
        this.cbBaseOnStructuredType.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType.setMaximumRowCount(8);
        this.cbBaseOnStructuredType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TableViewPropertiesDialogEx.this.cbBaseOnStructuredType.getSelectedItem();
                TableViewPropertiesDialogEx.this.st_type = (StructuredType)object;
                if (TableViewPropertiesDialogEx.this.btnQueryBuilder != null) {
                    TableViewPropertiesDialogEx.this.btnQueryBuilder.setEnabled(TableViewPropertiesDialogEx.this.isEditable());
                }
                TableViewPropertiesDialogEx.this.enablePanels(TableViewPropertiesDialogEx.this.st_type != null);
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.cbBaseOnStructuredType));
        JLabel jLabel3 = new JLabel(LB_OID_COLUMNS);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.tfOIDColumns = new JTextField();
        this.tfOIDColumns.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.tfOIDColumns));
        JLabel jLabel4 = new JLabel(SCHEMA);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.cbSchemaObject = new JComboBox();
        this.cbSchemaObject.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.cbSchemaObject));
        JLabel jLabel5 = new JLabel(Messages.getString("TableViewPropertiesDialogEx.IncludeSchemaNameInQuery"));
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.chIncludeSchemaNameInQuery = new JCheckBox();
        this.chIncludeSchemaNameInQuery.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.chIncludeSchemaNameInQuery));
        this.cbSchemaObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableViewPropertiesDialogEx.this.chIncludeSchemaNameInQuery.setEnabled(TableViewPropertiesDialogEx.this.cbSchemaObject.getSelectedItem() != null);
            }
        });
        JLabel jLabel6 = new JLabel(Messages.getString("TableViewPropertiesDialogEx.UseObjectsFrom"));
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.cbSubViews = new JComboBox();
        this.cbSubViews.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.cbSubViews));
        JLabel jLabel7 = new JLabel(Messages.getString("TableViewPropertiesDialogEx.AllowTypeSubstitution"));
        jLabel7.setPreferredSize(this.getDefaultSize());
        this.chTypeSubst = new JCheckBox();
        this.chTypeSubst.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.chTypeSubst));
        JLabel jLabel8 = new JLabel("");
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.btnTestQuery = new JButton(Messages.getString("TableViewPropertiesDialogEx.TestQuery"));
        this.btnTestQuery.setHorizontalAlignment(2);
        this.btnTestQuery.setPreferredSize(this.getDefaultSize());
        this.btnTestQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DMSQLQueryTester.registerComponent(ResultTesterComponent.class);
                DMSQLQueryTester dMSQLQueryTester = new DMSQLQueryTester(null);
                dMSQLQueryTester.showDialog(TableViewPropertiesDialogEx.this, TableViewPropertiesDialogEx.this.tableView.getUserDefinedSQL());
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.btnTestQuery));
    }

    protected JPanel getReferenceElementsPanel() {
        if (this.pnReferenceElements == null) {
            this.pnReferenceElements = this.createPage(PANEL_REFERENCE_ELEMENTS);
            this.sTable = new ColumnTable();
            this.sList = new ArrayList();
            this.sTable.setSelectionMode(0);
            this.pnReferenceElements.add(new JScrollPane(this.sTable));
        }
        return this.pnReferenceElements;
    }

    private void setElementSelected() {
        int n;
        if (this.currentElement > -1) {
            this.setPreviousSelectedElement();
        }
        if ((n = this.tbElements.getSelectedRow()) != -1 && this.lsElements.size() > 0 && n < this.lsElements.size()) {
            this.currentElement = n;
            ElementHelper elementHelper = (ElementHelper)this.lsElements.get(n);
            this.taElementComments.setEnabled(true);
            this.taElementComments.setText(elementHelper.getComments());
        }
    }

    protected JPanel getElementCommentsPanel() {
        if (this.pnElementComments == null) {
            this.currentElement = -1;
            this.pnElementComments = this.createPage(PANEL_COLUMN_COMMENTS);
            this.tbElements = new JTable(new ElementsModel());
            this.tbElements.setSelectionMode(0);
            this.tbElements.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    TableViewPropertiesDialogEx.this.setElementSelected();
                }
            });
            this.tbElements.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (TableViewPropertiesDialogEx.this.lsElements.isEmpty()) {
                        TableViewPropertiesDialogEx.this.taElementComments.setText("");
                        TableViewPropertiesDialogEx.this.taElementComments.setEnabled(false);
                    } else {
                        TableViewPropertiesDialogEx.this.taElementComments.setEnabled(true);
                        TableViewPropertiesDialogEx.this.setElementSelected();
                    }
                }
            });
            this.lsElements = new ArrayList();
            this.pnElementComments.add((Component)new JScrollPane(this.tbElements), "Center");
            this.taElementComments = new JTextArea();
            this.taElementComments.setLineWrap(true);
            this.taElementComments.setWrapStyleWord(true);
            this.taElementComments.setPreferredSize(new Dimension(300, 100));
            this.pnElementComments.add((Component)new JScrollPane(this.taElementComments), "South");
        }
        return this.pnElementComments;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(Messages.getString("TableViewPropertiesDialogEx.ImpactAnalysis"));
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = TableViewPropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (TableViewPropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            TableViewPropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            TableViewPropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private void setPreviousSelectedElement() {
        if (this.currentElement > -1) {
            ElementHelper elementHelper = (ElementHelper)this.lsElements.get(this.currentElement);
            elementHelper.setComments(this.taElementComments.getText());
        }
    }

    private void applyElementsComments() {
        this.setPreviousSelectedElement();
        for (ElementHelper elementHelper : this.lsElements) {
            elementHelper.applyComments();
        }
    }

    public class ElementHelper {
        AbstractViewElement element;
        String comments;

        public ElementHelper(AbstractViewElement abstractViewElement) {
            this.element = abstractViewElement;
            this.comments = abstractViewElement.getCommentInRDBMS();
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String string) {
            this.comments = string;
        }

        public AbstractViewElement getElement() {
            return this.element;
        }

        public String getName() {
            return this.element.getName();
        }

        public String getRefContainerName() {
            if (this.element.getReferencedContainer() != null) {
                return this.element.getReferencedContainer().getName();
            }
            return "";
        }

        public void applyComments() {
            this.element.setCommentInRDBMS(this.comments);
        }
    }

    public class ComboModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TableViewPropertiesDialogEx.Column");
            }
            if (n == 1) {
                return Messages.getString("TableViewPropertiesDialogEx.Table");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!TableViewPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class ComboTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox combo;

        ComboTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.combo = (JComboBox)object;
            this.combo.setOpaque(true);
            return this.combo;
        }
    }

    public class ElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TableViewPropertiesDialogEx.this.lsElements.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TableViewPropertiesDialogEx.Column");
            }
            if (n == 1) {
                return Messages.getString("TableViewPropertiesDialogEx.ReferencedContainer");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ElementHelper elementHelper = (ElementHelper)TableViewPropertiesDialogEx.this.lsElements.get(n);
            if (n2 == 0) {
                return elementHelper.getName();
            }
            if (n2 == 1) {
                return elementHelper.getRefContainerName();
            }
            return new Integer(n * n2);
        }
    }

    class ColumnTable
    extends JTable {
        ComboModel dataModel;

        public ColumnTable() {
            this.dataModel = new ComboModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return super.getCellRenderer(n, n2);
            }
            return new LNComboTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ComboTableCellEditor();
        }
    }
}

