/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.DDLFileStamp;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.DefaultMaxNameLength;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.NamingOptionsHolderPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;

public class RelationalModelDialogEx
extends ModelPropertiesDialogEx
implements DefaultMaxNameLength {
    private JPanel pnTable;
    private JPanel pnColumn;
    private JPanel pnView;
    private JPanel pnIndex;
    private JPanel pnConstraint;
    private JPanel pnGeneral;
    private JPanel pnGeneralGrid;
    private JPanel pane;
    private JTree tree;
    private JComboBox cbRDBMSType;
    private JComboBox cbRDBMSSite;
    private NamingOptionsHolderPanel tblOptionsPanel;
    private NamingOptionsHolderPanel clmOptionsPanel;
    private NamingOptionsHolderPanel viewOptionsPanel;
    private NamingOptionsHolderPanel indexOptionsPanel;
    private NamingOptionsHolderPanel constraintOptionsPanel;

    public RelationalModelDialogEx(ApplicationView applicationView, ModelIDObject modelIDObject) {
        super(applicationView, modelIDObject);
    }

    @Override
    protected String getHelpIndex() {
        return "RELATIONAL_MODEL_PROPERTIES_DIALOG";
    }

    @Override
    protected int getMinimumWidth() {
        return 960;
    }

    @Override
    public void initProperties(ModelIDObject modelIDObject) {
        this.model = modelIDObject;
        this.tfName.setText(this.model.getName());
        this.taComments.setText(this.model.getComment());
        this.taNotes.setText(this.model.getNotes());
        this.tfObjectID.setText(this.model.getObjectID());
        this.tfCreationTime.setText(this.model.getCreationTime());
        this.tfCreator.setText(this.model.getCreator().getName());
        this.tfLastChangedBy.setText(this.model.getChanger().getName());
        this.tfLastChangedTime.setText(this.model.getChangeTime());
        this.cbRDBMSType.removeAllItems();
        Iterator iterator = this.model.getDesign().getDefaultRDBMSTypeSet().iterator();
        while (iterator.hasNext()) {
            RDBMSType rDBMSType = (RDBMSType)iterator.next();
            this.cbRDBMSType.addItem(rDBMSType);
        }
        this.cbRDBMSType.setSelectedItem(this.model.getSelectedRDBMSType());
        this.cbRDBMSSite.setSelectedItem(((RelationalDesign)this.model).getSelectedRDBMSSite());
        this.tblOptionsPanel.init();
        this.clmOptionsPanel.init();
        this.viewOptionsPanel.init();
        this.indexOptionsPanel.init();
        this.constraintOptionsPanel.init();
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
            this.initResponsibleParties();
            this.initDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            this.chbVisible.setSelected(((DesignPartViewPlaceHolder)this.model).getVisible());
        } else {
            this.chbVisible.setEnabled(false);
        }
        this.initSummaryExtras();
    }

    protected void initSummaryExtras() {
        if (this.model instanceof RelationalDesign) {
            String string;
            RelationalDesign relationalDesign = (RelationalDesign)this.model;
            for (int i = this.pnSummaryGrid.getComponentCount(); i > this.summaryCount; --i) {
                this.pnSummaryGrid.remove(i - 1);
            }
            if (!relationalDesign.getImportConnectionStamps().isEmpty()) {
                if (relationalDesign.getImportConnectionStamps().size() == 1) {
                    this.pnSummaryGrid.add(this.pnDataDictConnection);
                    DBConnectionStamp dBConnectionStamp = relationalDesign.getImportConnectionStamp(0);
                    String object2 = MessageFormat.format(oracle.dbtools.crest.swingui.editor.Messages.getString("AbstractPropertiesDialog.DBConnectionDetails"), dBConnectionStamp.getConnName(), dBConnectionStamp.getConnUrl(), dBConnectionStamp.getConnTypeDisplay());
                    this.tfDataDictConnection.setText(object2);
                } else {
                    this.pnSummaryGrid.add(this.pnDataDictConnections);
                    this.cbDataDictConnections.removeAllItems();
                    for (DBConnectionStamp dBConnectionStamp : relationalDesign.getImportConnectionStamps()) {
                        string = MessageFormat.format(oracle.dbtools.crest.swingui.editor.Messages.getString("AbstractPropertiesDialog.DBConnectionDetails"), dBConnectionStamp.getConnName(), dBConnectionStamp.getConnUrl(), dBConnectionStamp.getConnTypeDisplay());
                        this.cbDataDictConnections.addItem(string);
                    }
                }
            }
            if (!relationalDesign.getImportDDLFileStamps().isEmpty()) {
                if (relationalDesign.getImportDDLFileStamps().size() == 1) {
                    this.pnSummaryGrid.add(this.pnDDLFileName);
                    DDLFileStamp dDLFileStamp = relationalDesign.getImportDDLFileStamp(0);
                    String string2 = MessageFormat.format(oracle.dbtools.crest.swingui.editor.Messages.getString("AbstractPropertiesDialog.DDLFileDetails"), dDLFileStamp.getFileName(), dDLFileStamp.getPathName(), dDLFileStamp.getDBTypeDisplay());
                    this.tfDDLFileName.setText(string2);
                } else {
                    this.pnSummaryGrid.add(this.pnDDLFileNames);
                    this.cbDDLFileNames.removeAllItems();
                    for (DDLFileStamp dDLFileStamp : relationalDesign.getImportDDLFileStamps()) {
                        string = MessageFormat.format(oracle.dbtools.crest.swingui.editor.Messages.getString("AbstractPropertiesDialog.DDLFileDetails"), dDLFileStamp.getFileName(), dDLFileStamp.getPathName(), dDLFileStamp.getDBTypeDisplay());
                        this.cbDDLFileNames.addItem(string);
                    }
                }
            }
            this.pnSummaryGrid.validate();
        }
    }

    @Override
    protected void setProperties() throws EmptyFieldException {
        if (!this.readonlyName) {
            if (!"".equalsIgnoreCase(this.tfName.getText())) {
                this.checkNameExists(this.tfName.getText());
                this.model.setName(this.tfName.getText());
            } else {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("RelationalModelDialogEx.NameCanNotBeEmpty"));
            }
        }
        this.model.setComment(this.taComments.getText());
        this.model.setNotes(this.taNotes.getText());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            ((DesignPart)this.model).setMainViewVisible(this.chbVisible.isSelected());
            this.setResponsibleParties();
            this.setDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            ((DesignPartViewPlaceHolder)this.model).setVisible(this.chbVisible.isSelected());
        }
        ((RelationalDesign)this.model).getNamingOptionsHolderList().clear();
        this.tblOptionsPanel.setHolderValues();
        this.clmOptionsPanel.setHolderValues();
        this.viewOptionsPanel.setHolderValues();
        this.indexOptionsPanel.setHolderValues();
        this.constraintOptionsPanel.setHolderValues();
        List list = ((RelationalDesign)this.model).getNamingOptionsHolderList();
        list.add(this.tblOptionsPanel.getNamingOptionsHolder().copy());
        list.add(this.clmOptionsPanel.getNamingOptionsHolder().copy());
        list.add(this.viewOptionsPanel.getNamingOptionsHolder().copy());
        list.add(this.indexOptionsPanel.getNamingOptionsHolder().copy());
        list.add(this.constraintOptionsPanel.getNamingOptionsHolder().copy());
        ((RelationalDesign)this.model).setSelectedRDBMSSite((RDBMSSite)this.cbRDBMSSite.getSelectedItem());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null && ((DesignPart)this.model).getMainView().isVisible()) {
            ((DesignPart)this.model).getMainView().getWorkSpace().repaint();
        }
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("RelationalModelDialogEx.General"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_NAME);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.tfName.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(jLabel, this.tfName));
            JLabel jLabel2 = new JLabel(LB_VISIBLE);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.chbVisible = new JCheckBox();
            this.chbVisible.setPreferredSize(this.getDefaultSize());
            this.chbVisible.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(jLabel2, this.chbVisible));
            JLabel jLabel3 = new JLabel(Messages.getString("RelationalModelDialogEx.RDBMSType"));
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.cbRDBMSType = new JComboBox();
            this.cbRDBMSType.setPreferredSize(this.getDefaultSize());
            this.cbRDBMSType.setMaximumRowCount(20);
            this.cbRDBMSType.setEnabled(this.isEditable());
            this.cbRDBMSType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RelationalModelDialogEx.this.updateSites();
                    RelationalModelDialogEx.this.setDefaultValues();
                }
            });
            this.pnGeneralGrid.add(this.createRow(jLabel3, this.cbRDBMSType));
            JLabel jLabel4 = new JLabel(Messages.getString("RelationalModelDialogEx.RDBMSSite"));
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.cbRDBMSSite = new JComboBox();
            this.cbRDBMSSite.setPreferredSize(this.getDefaultSize());
            this.cbRDBMSSite.setMaximumRowCount(20);
            this.cbRDBMSSite.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(jLabel4, this.cbRDBMSSite));
            jPanel.add((Component)this.pnGeneralGrid, "North");
            this.pnGeneral.add((Component)jPanel, "Center");
        }
        return this.pnGeneral;
    }

    public JPanel getPane() {
        if (this.pane == null) {
            this.pane = new JPanel(this.cardLayout);
            this.pane.setMinimumSize(new Dimension(400, 0));
        }
        return this.pane;
    }

    private JPanel getTblOptionsPanel() {
        if (this.pnTable == null) {
            this.pnTable = this.createPage(Messages.getString("RelationalModelDialogEx.Table"));
            this.tblOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(Table.class), false);
            this.pnTable.add((Component)this.tblOptionsPanel, "West");
        }
        return this.pnTable;
    }

    private JPanel getClmOptionsPanel() {
        if (this.pnColumn == null) {
            this.pnColumn = this.createPage(Messages.getString("RelationalModelDialogEx.Column"));
            this.clmOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(Column.class), false);
            this.pnColumn.add((Component)this.clmOptionsPanel, "West");
        }
        return this.pnColumn;
    }

    private JPanel getViewOptionsPanel() {
        if (this.pnView == null) {
            this.pnView = this.createPage(Messages.getString("RelationalModelDialogEx.View"));
            this.viewOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(TableView.class), false);
            this.pnView.add((Component)this.viewOptionsPanel, "West");
        }
        return this.pnView;
    }

    private JPanel getIndexOptionsPanel() {
        if (this.pnIndex == null) {
            this.pnIndex = this.createPage(Messages.getString("RelationalModelDialogEx.Index"));
            this.indexOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(Index.class), false);
            this.pnIndex.add((Component)this.indexOptionsPanel, "West");
        }
        return this.pnIndex;
    }

    private JPanel getConstraintOptionsPanel() {
        if (this.pnConstraint == null) {
            this.pnConstraint = this.createPage(Messages.getString("RelationalModelDialogEx.Constraint"));
            this.constraintOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(TableLevelConstraint.class), false);
            this.pnConstraint.add((Component)this.constraintOptionsPanel, "West");
        }
        return this.pnConstraint;
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 160;
    }

    @Override
    public JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
            this.tree = new JTree(defaultMutableTreeNode);
            this.tree.setCellRenderer(new ModelPropertiesDialogEx.TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(Messages.getString("RelationalModelDialogEx.NamingOptions"));
            this.addToTree(defaultMutableTreeNode2, this.getTblOptionsPanel());
            this.addToTree(defaultMutableTreeNode2, this.getClmOptionsPanel());
            this.addToTree(defaultMutableTreeNode2, this.getViewOptionsPanel());
            this.addToTree(defaultMutableTreeNode2, this.getIndexOptionsPanel());
            this.addToTree(defaultMutableTreeNode2, this.getConstraintOptionsPanel());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
            this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
            if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
                this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
                this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
                this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
            }
            this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    private NamingOptionsHolder getNamingOptionsHolderFor(Class clazz) {
        for (NamingOptionsHolder namingOptionsHolder : ((RelationalDesign)this.model).getNamingOptionsHolderList()) {
            if (!namingOptionsHolder.getClassName().equals(clazz)) continue;
            return namingOptionsHolder.copy();
        }
        return new NamingOptionsHolder(clazz);
    }

    public String getSelectedRDBMSType() {
        return this.cbRDBMSType.getSelectedItem().toString();
    }

    public void fillComboItems(Object[] objectArray, JComboBox jComboBox) {
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
    }

    private void updateSites() {
        if (this.cbRDBMSType.getSelectedItem() != null) {
            RDBMSSite[] rDBMSSiteArray = (RDBMSSite[])this.model.getDesign().getRDBMSSiteSet().toArray();
            this.cbRDBMSSite.removeAllItems();
            for (int i = 0; i < rDBMSSiteArray.length; ++i) {
                RDBMSSite rDBMSSite = rDBMSSiteArray[i];
                if (rDBMSSite.getType() == null || !rDBMSSite.getType().equals(this.cbRDBMSType.getSelectedItem())) continue;
                this.cbRDBMSSite.addItem(rDBMSSite);
            }
        }
    }

    private void setDefaultValues() {
        RDBMSType rDBMSType = (RDBMSType)this.cbRDBMSType.getSelectedItem();
        if (rDBMSType != null) {
            if (rDBMSType.equals(StorageDesignDB2v70.RDBMS_TYPE)) {
                this.setMaxNameLength(18, 18, 18, 18, 18);
            } else if (rDBMSType.equals(StorageDesignDB2v80.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 30, 128, 30, 30);
            } else if (rDBMSType.equals(StorageDesignOraclev9i.RDBMS_TYPE)) {
                this.setMaxNameLength(30, 30, 30, 30, 30);
            } else if (rDBMSType.equals(StorageDesignOraclev10g.RDBMS_TYPE)) {
                this.setMaxNameLength(30, 30, 30, 30, 30);
            } else if (rDBMSType.equals(StorageDesignOraclev11g.RDBMS_TYPE)) {
                this.setMaxNameLength(30, 30, 30, 30, 30);
            } else if (rDBMSType.equals(StorageDesignSqlServerv2k.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 128, 128, 128, 128);
            } else if (rDBMSType.equals(StorageDesignSqlServerv2k5.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 128, 128, 128, 128);
            } else if (rDBMSType.equals(StorageDesignUDBv71.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 30, 128, 128, 128);
            } else if (rDBMSType.equals(StorageDesignUDBv81.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 128, 128, 128, 128);
            }
        }
    }

    private void setMaxNameLength(int n, int n2, int n3, int n4, int n5) {
        this.tblOptionsPanel.setNameLength(n);
        this.clmOptionsPanel.setNameLength(n2);
        this.viewOptionsPanel.setNameLength(n3);
        this.indexOptionsPanel.setNameLength(n4);
        this.constraintOptionsPanel.setNameLength(n5);
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)RelationalModelDialogEx.this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof Component) {
                RelationalModelDialogEx.this.cardLayout.show(RelationalModelDialogEx.this.getMainPanel(), ((Component)object).getName());
            } else if (defaultMutableTreeNode.getFirstLeaf() != null && (object = defaultMutableTreeNode.getFirstLeaf().getUserObject()) instanceof Component) {
                RelationalModelDialogEx.this.cardLayout.show(RelationalModelDialogEx.this.getMainPanel(), ((Component)object).getName());
            }
        }
    }
}

