/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class IndexesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 9153673050664757933L;
    protected static final String[] COLUMN_NAMES = new String[]{" ", Messages.getString("IndexesTable.Name"), Messages.getString("IndexesTable.Unique"), Messages.getString("IndexesTable.Generate"), Messages.getString("IndexesTable.Engineer"), Messages.getString("IndexesTable.Spatial")};
    protected List<Index> indexesList;
    protected Component parent;

    public IndexesTableModel(List<Index> list, Component component) {
        this.indexesList = list;
        this.parent = component;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.indexesList.size();
    }

    public String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnNames()[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        Index index = this.indexesList.get(n);
        return !index.isDialogVisible() && (n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4);
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        IndexMemento indexMemento = this.indexesList.get(n).getIndexMemento();
        if (n2 == 0) {
            return new Integer(n + 1);
        }
        if (n2 == 1) {
            return indexMemento.name;
        }
        if (n2 == 2) {
            return "Unique Plain Index".equals(indexMemento.index_state);
        }
        if (n2 == 3) {
            return indexMemento.generate_in_DDL;
        }
        if (n2 == 4) {
            return indexMemento.engineer;
        }
        if (n2 == 5) {
            return indexMemento.spatial;
        }
        return new Integer(n * n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        IndexMemento indexMemento = this.indexesList.get(n).getIndexMemento();
        if (n2 == 1) {
            indexMemento.name = (String)object;
        } else if (n2 == 2) {
            Boolean bl = (Boolean)object;
            indexMemento.index_state = bl != false ? "Unique Plain Index" : "Plain Index";
        } else if (n2 == 3) {
            indexMemento.generate_in_DDL = (Boolean)object;
        } else if (n2 == 4) {
            indexMemento.engineer = (Boolean)object;
        }
    }
}

