/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.impact.ImpA_PK_UK;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.IndexUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.IndexExpressionPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;

public class IndexPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final long serialVersionUID = 7429391886536213361L;
    private Index index;
    private JTextField tfLongName;
    private JCheckBox chbEngineer;
    private JTextField tfTable;
    private JComboBox cbSchemaObject;
    private JComboBox cbState;
    private JCheckBox chIndexExpression;
    private List columnsList;
    private JCheckBox chSpatialIndex;
    private JPanel pnSpatialProp;
    private JComboBox cbLayerType;
    private JComboBox cbGeodetic;
    private JIntegerField ifDimensions;
    private int dimensionsSize = 0;
    private JCheckBox chMarkGenerate;
    private JTree tree;
    private IndexMemento mem;
    private IndexExpressionPanel indexExpressionPanel;
    String[] STATES_DISPLAY = new String[]{UNIQUE_KEY, PRIMARY_KEY, PLAIN_INDEX, UNIQUE_PLAIN_INDEX};
    String[] STATES_INTERNAL = new String[]{"Unique Key", "Primary Key", "Plain Index", "Unique Plain Index"};

    public IndexPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public IndexPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        Index index = (Index)this.getDesignObject();
        if (index.isPK()) {
            return MessageFormat.format(Messages.getString("IndexPropertiesDialogEx.Properties"), PRIMARY_KEY);
        }
        if (index.isUnique()) {
            return MessageFormat.format(Messages.getString("IndexPropertiesDialogEx.Properties"), UNIQUE_KEY);
        }
        return MessageFormat.format(Messages.getString("IndexPropertiesDialogEx.Properties"), PLAIN_INDEX);
    }

    @Override
    protected int getMinimumWidth() {
        return 630;
    }

    @Override
    protected int getMinimumHeight() {
        return 510;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Index) {
            this.index = (Index)designObject;
            this.initDefaults(false);
            this.indexExpressionPanel.init(this.index, this.index.getTable().getElementsCollection());
            if (this.index.isSpatialIndex() && this.index.getSpatialColumnDefiniton() != null) {
                this.dimensionsSize = this.index.getSpatialColumnDefiniton().getTableDimensions().size();
            }
            this.tfLongName.setText(this.index.getLongName());
            this.chbEngineer.setSelected(this.index.getShouldEngineer());
            this.tfTable.setText(this.index.getTopLevelContainer().getName());
            this.cbState.setSelectedItem(this.translate(this.index.getIndexState(), this.STATES_INTERNAL, this.STATES_DISPLAY));
            if (this.chIndexExpression != null && this.index.hasIndexExpression()) {
                this.chIndexExpression.setSelected(true);
                this.chIndexExpression.setText(this.index.getIndexExpression());
            }
            if (!this.index.isPK() && !this.index.isUnique()) {
                this.chSpatialIndex.setSelected(this.index.isSpatialIndex());
            }
            this.chMarkGenerate.setSelected(this.index.isMarkedGenerate());
            this.cbLayerType.setSelectedItem(this.index.getLayerType());
            this.cbGeodetic.setSelectedItem(this.index.getGeodetic());
            this.ifDimensions.setValue((long)this.index.getDimensionsNumber());
            this.cbSchemaObject.setSelectedItem(this.index.getSchemaObject());
            this.enableComponents(this.index.isSpatialIndex());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.index.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.index.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    public void initProperties(IndexMemento indexMemento) {
        this.index = indexMemento.index;
        this.mem = indexMemento;
        this.initDefaults(false);
        this.indexExpressionPanel.init(this.index, this.columnsList);
        if (this.index.isSpatialIndex() && this.index.getSpatialColumnDefiniton() != null) {
            this.dimensionsSize = this.index.getSpatialColumnDefiniton().getTableDimensions().size();
        }
        this.tfName.setText(indexMemento.name);
        this.taComments.setText(indexMemento.comments);
        this.taCommentsInRDBMS.setText(indexMemento.comments_in_rdbms);
        this.taNotes.setText(indexMemento.notes);
        this.tfLongName.setText(indexMemento.table.getName() + "." + indexMemento.name);
        this.chbEngineer.setSelected(indexMemento.engineer);
        this.tfTable.setText(indexMemento.table.getName());
        this.cbState.setSelectedItem(this.translate(indexMemento.index_state, this.STATES_INTERNAL, this.STATES_DISPLAY));
        if (this.chIndexExpression != null && indexMemento.expression.length() > 0) {
            this.chIndexExpression.setSelected(true);
        }
        if (!this.index.isPK() && !this.index.isUnique()) {
            this.chSpatialIndex.setSelected(indexMemento.spatial);
            this.cbLayerType.setSelectedItem(indexMemento.layer_type);
            this.cbGeodetic.setSelectedItem(indexMemento.is_geodetic);
            this.ifDimensions.setValue((long)indexMemento.dimensionsNumber);
        }
        this.chMarkGenerate.setSelected(indexMemento.generate_in_DDL);
        this.cbSchemaObject.setSelectedItem(indexMemento.schemaObject);
        this.enableComponents(indexMemento.spatial);
        this.fillComboItems(((RelationalDesign)this.index.getDesignPart()).getSchemaObjectSet().toArray(), this.cbSchemaObject, true);
        this.cbSchemaObject.setSelectedItem(indexMemento.schemaObject);
        this.initMeasurements();
        this.initChangeRequests();
        this.initResponsibleParties();
        this.initDocuments();
        this.dynamicPropertiesList.clear();
        Iterator iterator = indexMemento.index.getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = indexMemento.index.getProperty(string);
            DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
            this.dynamicPropertiesList.add(dynamicProperty);
        }
        this.dynamicPropertiesTable.updateUI();
    }

    private void enableComponents(boolean bl) {
        this.chbEngineer.setEnabled(!bl);
        if (!this.index.isPK() && !this.index.isUnique()) {
            this.cbState.setEnabled(!bl);
            this.cbLayerType.setEnabled(bl);
            this.cbGeodetic.setEnabled(bl);
            this.ifDimensions.setEnabled(bl);
        }
    }

    @Override
    protected boolean canExit() {
        if (super.canExit()) {
            String string = this.translate((String)this.cbState.getSelectedItem(), this.STATES_DISPLAY, this.STATES_INTERNAL);
            if (!("Primary Constraint".equalsIgnoreCase(string) || "Unique Constraint".equalsIgnoreCase(string) || this.index.isPK() || this.index.isUnique() || !this.index.hasFKAssociations())) {
                JOptionPane.showMessageDialog(null, Messages.getString("IndexPropertiesDialogEx.ForeignKeyOnThisKey"), Messages.getString("IndexPropertiesDialogEx.PKUKStatusChange"), 0);
                return false;
            }
            if (!this.index.isPK() && "Primary Constraint".equalsIgnoreCase(string)) {
                int n;
                List<Column> list = this.indexExpressionPanel.getIndexColumnsPanel().getSelectedColumns();
                if (this.hasColumnInFKinArc(list)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("IndexPropertiesDialogEx.TheIndexHasColumnBelongingToFKInARC"), Messages.getString("IndexPropertiesDialogEx.ColumnInFKInArc"), 0);
                    return false;
                }
                if (this.hasColumnInOptionalFK(list) && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("IndexPropertiesDialogEx.TheIndexHasColumnBelongingToOptionalFK"), Messages.getString("IndexPropertiesDialogEx.ColumnInOptionalFK"), 0)) != 0) {
                    return false;
                }
            }
            return this.checkRequiredProperties();
        }
        return false;
    }

    protected boolean checkRequiredProperties() {
        boolean bl = false;
        if (this.chIndexExpression != null && this.chIndexExpression.isSelected()) {
            if (StringUtilities.isNotEmpty(this.indexExpressionPanel.getIndexExpressionText())) {
                bl = true;
            }
        } else if (!this.indexExpressionPanel.getSelectedColumns().isEmpty()) {
            bl = true;
        }
        if (!bl) {
            String string = Messages.getString("IndexPropertiesDialogEx.IncompleteIxDefinition");
            String string2 = Messages.getString("IndexPropertiesDialogEx.IxColumnsAssignment");
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(string, this.index.getName()), string2, 0);
        }
        return bl;
    }

    public boolean hasColumnInOptionalFK(List<Column> list) {
        for (Column column : list) {
            if (!column.isInOptionalFK()) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumnInFKinArc(List<Column> list) {
        for (Column column : list) {
            if (!column.isInFKinArc()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setProperties() {
        this.mem.name = this.tfName.getText();
        this.mem.comments = this.taComments.getText();
        this.mem.comments_in_rdbms = this.taCommentsInRDBMS.getText();
        this.mem.notes = this.taNotes.getText();
        this.mem.engineer = this.chbEngineer.isSelected();
        if (this.chIndexExpression != null && this.chIndexExpression.isSelected()) {
            this.mem.columns.clear();
            this.mem.expression = this.indexExpressionPanel.getIndexExpressionText();
        } else {
            this.mem.columns.clear();
            for (Column object2 : this.indexExpressionPanel.getSelectedColumns()) {
                String string = this.index.getColumnSortOrder(object2);
                Object object = this.mem.new IndexMemento.ColWr();
                ((IndexMemento.ColWr)object).col_id = object2.getObjectID();
                ((IndexMemento.ColWr)object).sort_order = string;
                this.mem.columns.add((IndexMemento.ColWr)object);
            }
            this.mem.expression = "";
        }
        this.mem.index_state = this.translate((String)this.cbState.getSelectedItem(), this.STATES_DISPLAY, this.STATES_INTERNAL);
        this.mem.generate_in_DDL = this.chMarkGenerate.isSelected();
        if (this.cbLayerType != null) {
            this.mem.layer_type = (String)this.cbLayerType.getSelectedItem();
            this.mem.is_geodetic = (String)this.cbGeodetic.getSelectedItem();
            this.mem.dimensionsNumber = this.ifDimensions.getIntValue();
        }
        this.mem.schemaObject = (SchemaObject)this.cbSchemaObject.getSelectedItem();
        this.setMeasurements(this.mem.index);
        this.setChangeRequests(this.mem.index);
        this.setResponsibleParties(this.mem.index);
        this.setDocuments(this.mem.index);
        IndexUpdateEdit indexUpdateEdit = new IndexUpdateEdit(this.mem.index, this.mem);
        indexUpdateEdit.end();
        indexUpdateEdit.applyUpdates();
        String string = this.mem.index.getObjectID();
        if (string != null && this.mem.index.getContainerWithKeyObject().getKeySet().getObjectByID(string) != null) {
            this.mem.index.getDesignPart().postUndoableEdit(indexUpdateEdit);
        }
        this.tfLongName.setText(this.mem.table.getName() + "." + this.mem.name);
        IndexPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.mem.index.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.mem.index.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = ((Index)this.getDesignObject()).isPK() || ((Index)this.getDesignObject()).isUnique();
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        if (!bl) {
            this.addToTree(defaultMutableTreeNode, this.getSpatialPanel());
        }
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        if (bl) {
            this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        }
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "INDEX_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel;
        this.index = (Index)this.getDesignObject();
        boolean bl = this.index.isPK() || this.index.isUnique();
        this.indexExpressionPanel = new IndexExpressionPanel(this.index, this.isEditable(), this.getPreferredIconSize(), !bl);
        JLabel jLabel2 = new JLabel(LB_LONG_NAME);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfLongName));
        JLabel jLabel3 = new JLabel(LB_ENGINEER);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.chbEngineer = new JCheckBox();
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.chbEngineer));
        JLabel jLabel4 = new JLabel(LB_TABLE);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.tfTable = new JTextField();
        this.tfTable.setPreferredSize(this.getDefaultSize());
        this.tfTable.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.tfTable));
        JLabel jLabel5 = new JLabel(LB_STATE);
        jLabel5.setPreferredSize(this.getDefaultSize());
        if (this.index.isPK()) {
            this.cbState = new JComboBox<String>(new String[]{PRIMARY_KEY});
            this.cbState.setEnabled(false);
        } else if (this.index.isUnique()) {
            this.cbState = new JComboBox<String>(new String[]{UNIQUE_KEY});
            this.cbState.setEnabled(false);
        } else {
            this.cbState = new JComboBox<String>(INDEX_STATES_NOPK_NOUK_DISPLAY);
        }
        this.cbState.setPreferredSize(this.getDefaultSize());
        this.cbState.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.cbState));
        JLabel jLabel6 = new JLabel(SCHEMA);
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.cbSchemaObject = new JComboBox();
        this.cbSchemaObject.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.cbSchemaObject));
        if (!bl) {
            jLabel = new JLabel(LB_INDEX_EXPRESSION);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.chIndexExpression = new JCheckBox();
            this.chIndexExpression.setPreferredSize(this.getDefaultSize());
            this.chIndexExpression.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IndexPropertiesDialogEx.this.indexExpressionPanel.showExpressionPanel(IndexPropertiesDialogEx.this.chIndexExpression.isSelected());
                }
            });
            this.addRowToGeneralPanel(this.createRow(jLabel, this.chIndexExpression));
            JLabel jLabel7 = new JLabel(Messages.getString("IndexPropertiesDialogEx.SpatialIndex"));
            jLabel7.setPreferredSize(this.getDefaultSize());
            this.chSpatialIndex = new JCheckBox();
            this.chSpatialIndex.setSelected(false);
            this.chSpatialIndex.setEnabled(false);
            this.chSpatialIndex.setPreferredSize(this.getDefaultSize());
            this.addRowToGeneralPanel(this.createRow(jLabel7, this.chSpatialIndex));
        }
        jLabel = new JLabel(Messages.getString("IndexPropertiesDialogEx.GenerateInDDL"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.chMarkGenerate = new JCheckBox();
        this.chMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.chMarkGenerate));
        this.pnAdditionalPanel.add(this.indexExpressionPanel);
    }

    public List getColumnsList() {
        return this.columnsList;
    }

    public void setColumnsList(List list) {
        this.columnsList = list;
    }

    private JPanel getSpatialPanel() {
        if (this.pnSpatialProp == null) {
            this.pnSpatialProp = this.createPage(Messages.getString("IndexPropertiesDialogEx.SpatialProperties"));
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(Messages.getString("IndexPropertiesDialogEx.ConstrainToLayerType"));
            jLabel.setPreferredSize(this.getDefaultSize());
            this.cbLayerType = new JComboBox<String>(Index.getConstrainLayerTypeChoices());
            this.cbLayerType.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel, this.cbLayerType));
            JLabel jLabel2 = new JLabel(Messages.getString("IndexPropertiesDialogEx.GeodeticIndex"));
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.cbGeodetic = new JComboBox<String>(Index.getGeodeticChoices());
            this.cbGeodetic.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel2, this.cbGeodetic));
            JLabel jLabel3 = new JLabel(Messages.getString("IndexPropertiesDialogEx.NumberOfDimensions"));
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.ifDimensions = new JIntegerField();
            this.ifDimensions.setDocument(new IntegerSizeDocument());
            this.ifDimensions.setToolTipText(Messages.getString("IndexPropertiesDialogEx.ShouldBeLessOrEqual"));
            this.ifDimensions.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel3, this.ifDimensions));
            jPanel.add((Component)jPanel2, "North");
            this.pnSpatialProp.add(jPanel);
        }
        return this.pnSpatialProp;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = IndexPropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (IndexPropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            IndexPropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            IndexPropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        if (this.index.isPK() || this.index.isUnique()) {
            this.tree.addTreeWillExpandListener(this);
            CompareTreeNavigationDesign compareTreeNavigationDesign = new CompareTreeNavigationDesign(new ImpA_PK_UK(this.getIndexForIA(), null, true), false);
            ImpactTreeRenderer impactTreeRenderer = new ImpactTreeRenderer();
            this.tree.setModel(compareTreeNavigationDesign);
            this.tree.setCellRenderer(impactTreeRenderer);
        }
        return this.tree;
    }

    private Index getIndexForIA() {
        Index index;
        String string = this.index.getContainerWithKeyObject().getObjectID();
        Table table = (Table)((RelationalDesign)this.index.getDesignPart()).getTableSet().getObjectByID(string);
        if (table == null) {
            table = (Table)this.index.getContainerWithKeyObject();
        }
        if ((index = (Index)table.getKeySet().getObjectByID(this.index.getObjectID())) != null) {
            return index;
        }
        return this.index;
    }

    public IndexMemento getIndexMemento() {
        return this.mem;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    class IntegerSizeDocument
    extends PlainDocument {
        private static final long serialVersionUID = 3211590025851616007L;

        IntegerSizeDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            if (string == null) {
                return;
            }
            int n2 = this.getLength();
            if (n2 == 0) {
                string2 = string;
            } else {
                String string3 = this.getText(0, n2);
                StringBuffer stringBuffer = new StringBuffer(string3);
                stringBuffer.insert(n, string);
                string2 = stringBuffer.toString();
            }
            if (n2 == 0 && ("-".equals(string) || "+".equals(string))) {
                super.insertString(n, string, attributeSet);
            } else {
                try {
                    if (Integer.parseInt(string2) == 2 || Integer.parseInt(string2) <= IndexPropertiesDialogEx.this.dimensionsSize) {
                        super.insertString(n, string, attributeSet);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

