/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.relational.AbstractIndexPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class IndexColumnsPanel
extends AbstractIndexPanel {
    private static final long serialVersionUID = 5771060872641952722L;
    private static final int PREFERRED_HEIGHT = 145;
    private static final int PREFERRED_WIDTH = 145;
    private static final String COLUMNS = Messages.getString("IndexColumnsPanel.Columns");
    private JPanel mainPanel;
    private JButton btnAddColumns;
    private JButton btnRemoveColumns;
    private JButton btnUp;
    private JButton btnDown;
    private JList allColumnsList;
    private JPanel buttonsPanel;
    private JToolBar toolBar;
    private DefaultListModel allColumnsModel;
    private List<Column> selectedColumnsList;
    private JPanel pnSelected;
    private JTable selectedColumnsTable;
    private JScrollPane selectedColumnsScrollPane;
    private JScrollPane allColumnsScrollPane;
    private JPanel pnAttributes;
    private Collection<Column> tableColumns;

    public IndexColumnsPanel(Index index, boolean bl, int n, boolean bl2) {
        super(index, bl, n, bl2);
    }

    @Override
    protected void init(Collection<Column> collection) {
        this.tableColumns = collection;
        this.allColumnsModel.clear();
        for (Column column : collection) {
            if (this.selectedColumnsList.contains(column) || !this.canBeUsed(column)) continue;
            this.allColumnsModel.addElement(column);
        }
    }

    public void refresh() {
        if (this.tableColumns != null) {
            this.init(this.tableColumns);
        }
        this.allColumnsList.updateUI();
        this.selectedColumnsTable.updateUI();
    }

    public void removeSelectedColumn(Column column) {
        this.selectedColumnsList.remove(column);
        this.selectedColumnsTable.updateUI();
    }

    protected boolean canBeUsed(Column column) {
        Datatype datatype = column.getDataType();
        String string = datatype.getName();
        return !column.isReference() && (!(datatype instanceof StructuredType) || this.index != null && this.index.isSpatialIndex() && "SDO_GEOMETRY".equals(string)) && !(datatype instanceof CollectionType) && !column.isOid() && !string.equalsIgnoreCase("BLOB") && !string.equalsIgnoreCase("CLOB");
    }

    @Override
    public void init(Index index, Collection<Column> collection) {
        super.init(index, collection);
        this.selectedColumnsList.clear();
        if (index != null) {
            if (index.isPK()) {
                for (Column column : (Column[])index.getElements()) {
                    this.selectedColumnsList.add(column);
                }
            } else {
                IndexMemento indexMemento = index.getIndexMemento(false);
                Table table = indexMemento.table;
                if (table != null) {
                    for (IndexMemento.ColWr colWr : indexMemento.columns) {
                        Column column = this.findColumnByID(colWr.col_id, collection);
                        if (column == null) continue;
                        this.selectedColumnsList.add(column);
                    }
                }
            }
        }
        this.init(collection);
        this.enableComponents(index != null && this.editable);
        ((SelectedColumnsModel)this.selectedColumnsTable.getModel()).fireTableDataChanged();
    }

    private Column findColumnByID(String string, Collection<Column> collection) {
        for (Column column : collection) {
            if (!column.getObjectID().equals(string)) continue;
            return column;
        }
        return null;
    }

    public List<Column> getSelectedColumns() {
        return this.selectedColumnsList;
    }

    @Override
    protected void createUIComponents() {
        this.setLayout(new BorderLayout(0, 10));
        this.setName(COLUMNS);
        this.setBorder(BorderFactory.createTitledBorder(COLUMNS));
        this.selectedColumnsList = new ArrayList<Column>();
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddColumns = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.buttonsSize));
        this.btnRemoveColumns = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.buttonsSize));
        this.btnUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.buttonsSize));
        this.btnDown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.buttonsSize));
        this.buttonsPanel = new JPanel();
        this.toolBar = new JToolBar(1);
        this.toolBar.add(this.btnAddColumns);
        this.toolBar.add(this.btnRemoveColumns);
        this.toolBar.add(this.btnUp);
        this.toolBar.add(this.btnDown);
        this.buttonsPanel.add(this.toolBar);
        this.selectedColumnsTable = new JTable(new SelectedColumnsModel(this.showDesc));
        if (!this.isEditable()) {
            this.selectedColumnsTable.setEnabled(false);
        }
        this.selectedColumnsScrollPane = new JScrollPane(this.selectedColumnsTable);
        this.selectedColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnSelected = new JPanel(new BorderLayout());
        this.pnSelected.add(this.selectedColumnsScrollPane);
        this.allColumnsScrollPane = new JScrollPane(this.allColumnsList);
        this.allColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnAttributes = new JPanel(new BorderLayout());
        this.pnAttributes.add(this.allColumnsScrollPane);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 2));
        this.mainPanel.add(this.pnAttributes);
        this.mainPanel.add(this.buttonsPanel);
        this.mainPanel.add(this.pnSelected);
        this.add(this.mainPanel);
    }

    @Override
    protected void initUIComponents() {
        this.allColumnsList.getSelectionModel().addListSelectionListener(new AllColumnsListSelectionListener());
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new SelectedColumnsListSelectionListener());
        this.initColumnsButtons(this.mainPanel);
        this.initSelectedColumnsList(this.mainPanel);
    }

    private void enableComponents(boolean bl) {
        this.allColumnsList.setEnabled(bl);
    }

    private void initSelectedColumnsList(JPanel jPanel) {
        TableColumn tableColumn = this.selectedColumnsTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(220);
        if (this.showDesc) {
            TableColumn tableColumn2 = this.selectedColumnsTable.getColumnModel().getColumn(1);
            tableColumn2.setWidth(40);
            tableColumn2.setMaxWidth(40);
            tableColumn2.setCellRenderer(new ColumnOrderRenderer());
        }
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (IndexColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    IndexColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                } else {
                    IndexColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                }
            }
        });
    }

    private void initColumnsButtons(JPanel jPanel) {
        this.toolBar.setFloatable(false);
        this.btnAddColumns.addActionListener(new AddColumnsActionListener());
        this.btnAddColumns.setEnabled(false);
        this.btnAddColumns.setToolTipText(Messages.getString("IndexPropertiesDialogEx.Add"));
        this.btnRemoveColumns.setEnabled(false);
        this.btnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveColumns.setToolTipText(Messages.getString("IndexPropertiesDialogEx.Remove"));
        this.btnUp.setToolTipText(Messages.getString("IndexPropertiesDialogEx.MoveUp"));
        this.btnUp.addActionListener(new MoveUpAction());
        this.btnDown.setToolTipText(Messages.getString("IndexPropertiesDialogEx.MoveDown"));
        this.btnDown.addActionListener(new MoveDownAction());
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
    }

    public void onAddColumn(Column column) {
    }

    public void onRemoveColumn(Column column) {
    }

    private boolean moveToIndex(Object object, int n) {
        if (this.selectedColumnsList.contains(object) && this.selectedColumnsList.size() > n && n >= 0) {
            this.selectedColumnsList.remove(object);
            this.selectedColumnsList.add(n, (Column)object);
            return true;
        }
        return false;
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = IndexColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < IndexColumnsPanel.this.selectedColumnsList.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = IndexColumnsPanel.this.selectedColumnsList.get(n);
                    IndexColumnsPanel.this.moveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                IndexColumnsPanel.this.selectedColumnsTable.updateUI();
                IndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = IndexColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = IndexColumnsPanel.this.selectedColumnsList.get(n);
                    IndexColumnsPanel.this.moveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                IndexColumnsPanel.this.selectedColumnsTable.updateUI();
                IndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        }
    }

    private class ColumnOrderRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -2118305663241552544L;

        private ColumnOrderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(bl3);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class SelectedColumnsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8480891404209029651L;
        private String[] COL_NAMES = new String[]{Messages.getString("IndexColumnsPanel.Column"), Messages.getString("IndexColumnsPanel.Desc")};
        private boolean showDesc;

        public SelectedColumnsModel(boolean bl) {
            this.showDesc = bl;
        }

        @Override
        public int getColumnCount() {
            return this.showDesc ? 2 : 1;
        }

        @Override
        public int getRowCount() {
            return IndexColumnsPanel.this.selectedColumnsList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Column column = (Column)IndexColumnsPanel.this.selectedColumnsList.get(n);
            if (object instanceof Boolean) {
                IndexColumnsPanel.this.index.setColumnSortOrder(column, (Boolean)object != false ? "DESC" : "ASC");
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Column column = (Column)IndexColumnsPanel.this.selectedColumnsList.get(n);
            if (n2 == 0) {
                return column.getName();
            }
            if (n2 == 1) {
                return new Boolean("DESC".equals(IndexColumnsPanel.this.index.getColumnSortOrder(column)));
            }
            return "";
        }
    }

    private class SelectedColumnsListSelectionListener
    implements ListSelectionListener {
        private SelectedColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexColumnsPanel.this.editable && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    IndexColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                    IndexColumnsPanel.this.btnUp.setEnabled(false);
                    IndexColumnsPanel.this.btnDown.setEnabled(false);
                } else {
                    IndexColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                    IndexColumnsPanel.this.btnUp.setEnabled(true);
                    IndexColumnsPanel.this.btnDown.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionListener
    implements ListSelectionListener {
        private AllColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexColumnsPanel.this.editable && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexColumnsPanel.this.allColumnsList.getSelectedIndex() == -1) {
                    IndexColumnsPanel.this.btnAddColumns.setEnabled(false);
                } else {
                    IndexColumnsPanel.this.btnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = IndexColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            for (n = 0; n < nArray.length; ++n) {
                Column column = (Column)IndexColumnsPanel.this.selectedColumnsList.get(nArray[n]);
                if (IndexColumnsPanel.this.allColumnsModel.contains(column) || !IndexColumnsPanel.this.canBeUsed(column)) continue;
                IndexColumnsPanel.this.allColumnsModel.addElement(column);
                IndexColumnsPanel.this.allColumnsList.setSelectedValue(column, true);
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                IndexColumnsPanel.this.onRemoveColumn((Column)IndexColumnsPanel.this.selectedColumnsList.remove(nArray[n]));
            }
            IndexColumnsPanel.this.selectedColumnsTable.updateUI();
            IndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().clearSelection();
        }
    }

    public class AddColumnsActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexColumnsPanel.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = IndexColumnsPanel.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Column column = (Column)objectArray[i];
                    if (IndexColumnsPanel.this.selectedColumnsList.contains(column)) continue;
                    IndexColumnsPanel.this.selectedColumnsList.add(column);
                    IndexColumnsPanel.this.allColumnsModel.removeElement(column);
                    IndexColumnsPanel.this.onAddColumn(column);
                }
            }
            IndexColumnsPanel.this.allColumnsList.getSelectionModel().clearSelection();
            IndexColumnsPanel.this.selectedColumnsTable.updateUI();
            IndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(IndexColumnsPanel.this.selectedColumnsTable.getRowCount() - 1, IndexColumnsPanel.this.selectedColumnsTable.getRowCount() - 1);
        }
    }
}

