/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class FKTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1305973212393023369L;
    private List<FKIndexAssociation.FKMemento> fkList;

    public FKTableModel(List<FKIndexAssociation.FKMemento> list) {
        this.fkList = list;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.fkList.size();
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return " ";
        }
        if (n == 1) {
            return Messages.getString("FKTableModel.Name");
        }
        if (n == 2) {
            return Messages.getString("FKTableModel.ReferencedTable");
        }
        if (n == 3) {
            return Messages.getString("FKTableModel.DeleteRule");
        }
        if (n == 4) {
            return Messages.getString("FKTableModel.Generate");
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        FKIndexAssociation.FKMemento fKMemento = this.fkList.get(n);
        boolean bl = fKMemento.fk.isDialogVisible();
        return !bl && (n2 == 4 || n2 == 1 || n2 == 3);
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        FKIndexAssociation.FKMemento fKMemento = this.fkList.get(n);
        if (n2 == 0) {
            return new Integer(n + 1);
        }
        if (n2 == 1) {
            return fKMemento.name;
        }
        if (n2 == 2) {
            return fKMemento.remoteTable != null ? fKMemento.remoteTable.getName() : "";
        }
        if (n2 == 3) {
            return fKMemento.deleteRule;
        }
        if (n2 == 4) {
            return new Boolean(fKMemento.generate_in_DDL);
        }
        return new Integer(n * n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.fkList.size() > n) {
            FKIndexAssociation.FKMemento fKMemento = this.fkList.get(n);
            if (n2 == 1) {
                String string = (String)object;
                if (!"".equals(string)) {
                    fKMemento.name = string;
                }
            } else if (n2 == 4) {
                fKMemento.generate_in_DDL = (Boolean)object;
            } else if (n2 == 3) {
                fKMemento.deleteRule = (String)object;
            }
        }
    }
}

