/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKDiscoverer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FKDiscovererDialog
extends CustomDialog {
    private JDialog dialog;
    private JPanel generalPanel;
    private String title = "Create discovered foreign keys";
    private boolean cancelled = true;
    private FKDiscoverer fkDiscoverer;
    private JTable fkTable;
    private FKmodel model;
    private Dimension dimension = new Dimension(800, 550);
    private static String REFERRED_TABLE = "Referred Table";
    private static String REFERRED_KEY = "Referred Key";
    private static String TABLE = "Table";
    private static String COLUMNS = "Columns";
    private static String[] COLUMN_CHOICES = new String[]{REFERRED_TABLE, REFERRED_KEY, TABLE, COLUMNS};
    private static String NP_REFERRED = "Referred Column";
    private static String NP_TEMPLATE = "FK Column Template";
    private static String NP_REF_AND_TEMPLATE = "Referred and Template";
    private static String NP_TEMPLATE_AND_REF = "Template and Referred";
    private static String[] POLICY_CHOICES = new String[]{NP_REFERRED, NP_TEMPLATE, NP_REF_AND_TEMPLATE, NP_TEMPLATE_AND_REF};
    private static String SCAN_AGAIN = "Scan Again";
    private static String COLUMN_TO_ONEFK_LABEL = " Single use of FK column:";
    private static String COLUMN_TO_ONEFK_HINT = "Restricts column to be bound to maximum one foreign key";
    private static String NAME_POLICY_LABEL = "   FK Column name policy:";
    private static String NAME_POLICY_HINT = "Set how name of column from referred key is matched to column in child table";
    private static String SCAN_AGAIN_HINT = "Clears current result and discover foreign keys using current settings";
    private JComboBox cbChoices;
    private JComboBox cbNameMatch;
    private JTextField filterText;
    private JCheckBox chbOneFK;

    public FKDiscovererDialog(ApplicationView applicationView, FKDiscoverer fKDiscoverer) {
        super(applicationView);
        this.generalPanel = new JPanel(new BorderLayout());
        this.generalPanel.setPreferredSize(this.dimension);
        this.generalPanel.setMinimumSize(this.dimension);
        this.fkDiscoverer = fKDiscoverer;
        this.init();
        this.add((Component)this.generalPanel, "Center");
        this.generalPanel.add((Component)this.getToolbar(), "North");
        this.generalPanel.add((Component)this.getOptionsPanel(), "South");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private JToolBar getToolbar() {
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        JButton jButton = new JButton(gUIConfiguration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        jButton.addActionListener(new SelectAllAction());
        jButton.setToolTipText("Select All");
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        jButton2.addActionListener(new DeselectAllAction());
        jButton2.setToolTipText("Deselect All");
        JLabel jLabel = new JLabel("  " + Messages.getString("FKDiscovererDialog.ColumnToFilter"), 11);
        jLabel.setLabelFor(this.cbChoices);
        this.cbChoices = new JComboBox<String>(new DefaultComboBoxModel<String>(COLUMN_CHOICES));
        this.cbChoices.setSelectedItem(TABLE);
        this.cbChoices.setPreferredSize(new Dimension(125, MessageDialogs.BUTTON_SIZE_EX.height));
        this.cbChoices.setMaximumSize(new Dimension(125, MessageDialogs.BUTTON_SIZE_EX.height));
        JLabel jLabel2 = new JLabel("   " + Messages.getString("FKDiscovererDialog.Filter"), 11);
        this.filterText = new JTextField();
        this.filterText.setPreferredSize(new Dimension(200, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.setMaximumSize(new Dimension(200, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FKDiscovererDialog.this.newFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FKDiscovererDialog.this.newFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FKDiscovererDialog.this.newFilter();
            }
        });
        jLabel2.setLabelFor(this.filterText);
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        jToolBar.add(jLabel);
        jToolBar.add(this.cbChoices);
        jToolBar.add(jLabel2);
        jToolBar.add(this.filterText);
        return jToolBar;
    }

    private JPanel getOptionsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(COLUMN_TO_ONEFK_LABEL);
        this.chbOneFK = new JCheckBox();
        jLabel.setLabelFor(this.chbOneFK);
        this.chbOneFK.setSelected(FKDiscoverer.IN_ONE_FK_ONLY);
        this.chbOneFK.setToolTipText(COLUMN_TO_ONEFK_HINT);
        jLabel.setToolTipText(COLUMN_TO_ONEFK_HINT);
        JLabel jLabel2 = new JLabel(NAME_POLICY_LABEL);
        jLabel2.setToolTipText(NAME_POLICY_HINT);
        this.cbNameMatch = new JComboBox<String>(new DefaultComboBoxModel<String>(POLICY_CHOICES));
        jLabel2.setLabelFor(this.cbNameMatch);
        this.cbNameMatch.setSelectedIndex(FKDiscoverer.NAME_POLICY);
        this.cbNameMatch.setToolTipText(NAME_POLICY_HINT);
        JLabel jLabel3 = new JLabel("     ");
        JButton jButton = new JButton(SCAN_AGAIN);
        jButton.setToolTipText(SCAN_AGAIN_HINT);
        jPanel.add(jLabel);
        jPanel.add(this.chbOneFK);
        jPanel.add(jLabel2);
        jPanel.add(this.cbNameMatch);
        jPanel.add(jLabel3);
        jPanel.add(jButton);
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.chbOneFK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FKDiscoverer.IN_ONE_FK_ONLY = FKDiscovererDialog.this.chbOneFK.isSelected();
            }
        });
        this.cbNameMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FKDiscoverer.NAME_POLICY = FKDiscovererDialog.this.cbNameMatch.getSelectedIndex();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FKDiscovererDialog.this.fkDiscoverer.rescane();
                FKDiscovererDialog.this.model.fireTableDataChanged();
            }
        });
        return jPanel;
    }

    private void init() {
        this.model = new FKmodel(this.fkDiscoverer);
        this.fkTable = new JTable(this.model);
        TableColumn tableColumn = this.fkTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(40);
        tableColumn.setMaxWidth(40);
        tableColumn = this.fkTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(40);
        tableColumn.setMaxWidth(40);
        this.fkTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.fkTable, 4);
        JScrollPane jScrollPane = new JScrollPane(this.fkTable);
        this.generalPanel.add(jScrollPane);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return !this.cancelled;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(true);
            this.dialog.setMinimumSize(this.dimension);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "FK_DISCOVERER_DIALOG";
    }

    private void setProperties() {
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Messages.getString("FKDiscovererDialog.OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FKDiscovererDialog.this.setProperties();
                FKDiscovererDialog.this.cancelled = false;
                FKDiscovererDialog.this.close();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("FKDiscovererDialog.Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FKDiscovererDialog.this.cancelled = true;
                FKDiscovererDialog.this.close();
            }
        });
        JButton jButton3 = new JButton(this.getHelpAction());
        jButton3.setMnemonic(72);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    private void newFilter() {
        RowFilter rowFilter = null;
        JTable jTable = this.fkTable;
        if (jTable != null) {
            if (!"".equals(this.filterText.getText())) {
                try {
                    int n = this.cbChoices.getSelectedIndex();
                    rowFilter = RowFilter.regexFilter("(?i)" + this.filterText.getText(), n + 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return;
                }
                ((DefaultRowSorter)jTable.getRowSorter()).setRowFilter(rowFilter);
            } else {
                jTable.clearSelection();
                ((DefaultRowSorter)jTable.getRowSorter()).setRowFilter(null);
            }
        }
    }

    static /* synthetic */ String access$900() {
        return REFERRED_TABLE;
    }

    static /* synthetic */ String access$1000() {
        return REFERRED_KEY;
    }

    static /* synthetic */ String access$1100() {
        return TABLE;
    }

    static /* synthetic */ String access$1200() {
        return COLUMNS;
    }

    private class SelectAllAction
    implements ActionListener {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = FKDiscovererDialog.this.fkTable;
            if (jTable != null) {
                if (jTable.getRowCount() != jTable.getModel().getRowCount()) {
                    int n = jTable.getRowCount();
                    List list = FKDiscovererDialog.this.fkDiscoverer.getPrepareList();
                    for (int i = 0; i < n; ++i) {
                        int n2 = jTable.convertRowIndexToModel(i);
                        if (n2 <= -1 || n2 >= list.size()) continue;
                        FKDiscoverer.FKPrepare fKPrepare = (FKDiscoverer.FKPrepare)list.get(n2);
                        fKPrepare.selected = true;
                    }
                } else {
                    for (FKDiscoverer.FKPrepare fKPrepare : FKDiscovererDialog.this.fkDiscoverer.getPrepareList()) {
                        fKPrepare.selected = true;
                    }
                }
                jTable.updateUI();
            }
        }
    }

    private class DeselectAllAction
    implements ActionListener {
        private DeselectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = FKDiscovererDialog.this.fkTable;
            if (jTable != null) {
                if (jTable.getRowCount() != jTable.getModel().getRowCount()) {
                    int n = jTable.getRowCount();
                    List list = FKDiscovererDialog.this.fkDiscoverer.getPrepareList();
                    for (int i = 0; i < n; ++i) {
                        int n2 = jTable.convertRowIndexToModel(i);
                        if (n2 <= -1 || n2 >= list.size()) continue;
                        FKDiscoverer.FKPrepare fKPrepare = (FKDiscoverer.FKPrepare)list.get(n2);
                        fKPrepare.selected = false;
                    }
                } else {
                    for (FKDiscoverer.FKPrepare fKPrepare : FKDiscovererDialog.this.fkDiscoverer.getPrepareList()) {
                        fKPrepare.selected = false;
                    }
                }
                jTable.updateUI();
            }
        }
    }

    class FKmodel
    extends DefaultTableModel {
        final String[] columns = new String[]{"", "", FKDiscovererDialog.access$900(), FKDiscovererDialog.access$1000(), FKDiscovererDialog.access$1100(), FKDiscovererDialog.access$1200()};
        FKDiscoverer fkd;

        FKmodel(FKDiscoverer fKDiscoverer) {
            this.fkd = fKDiscoverer;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < this.fkd.getPrepareList().size()) {
                FKDiscoverer.FKPrepare fKPrepare = (FKDiscoverer.FKPrepare)this.fkd.getPrepareList().get(n);
                if (n2 == 0) {
                    int n3 = FKDiscovererDialog.this.fkTable.convertRowIndexToView(n);
                    return n3 + 1;
                }
                if (n2 == 1) {
                    return fKPrepare.selected;
                }
                if (n2 == 2) {
                    return fKPrepare.parentTable.getLongName();
                }
                if (n2 == 3) {
                    return fKPrepare.referredKey.getName();
                }
                if (n2 == 4) {
                    return fKPrepare.childTable.getLongName();
                }
                if (n2 == 5) {
                    String string = "";
                    for (Column column : fKPrepare.childColumns) {
                        if ("".equals(string)) {
                            string = string + column.getName();
                            continue;
                        }
                        string = string + ", " + column.getName();
                    }
                    return string;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1 && n < this.fkd.getPrepareList().size()) {
                FKDiscoverer.FKPrepare fKPrepare = (FKDiscoverer.FKPrepare)this.fkd.getPrepareList().get(n);
                fKPrepare.selected = (Boolean)object;
            }
        }

        @Override
        public int getRowCount() {
            if (this.fkd == null) {
                return 0;
            }
            return this.fkd.getPrepareList().size();
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Integer.class;
            }
            if (n == 1) {
                return Boolean.class;
            }
            return String.class;
        }
    }
}

