/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_Column;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.relational.DRColumnCaseType;
import oracle.dbtools.crest.model.designrules.relational.DRColumnMaxNameLength;
import oracle.dbtools.crest.model.designrules.relational.DRColumnValidCharacters;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.domains.AVTEditor;
import oracle.dbtools.crest.swingui.admin.domains.CECheckConstraint;
import oracle.dbtools.crest.swingui.admin.domains.ValueListEditorEx;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DatatypeDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.LogicalTypeDialog;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;

public class ColumnPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final int MAX_DIGITS = 28;
    private static final String EMPTY_VALUE = "";
    private static final String VIEW_EDIT = Messages.getString("ColumnPropertiesDialogEx.ViewEdit");
    private static final String FORM_MAXIMUM_WIDTH = Messages.getString("ColumnPropertiesDialogEx.FormMaximumWidth");
    private static final String FORM_DISPLAY_WIDTH = Messages.getString("ColumnPropertiesDialogEx.FormDisplayWidth");
    private static final String FORM_HEIGHT = Messages.getString("ColumnPropertiesDialogEx.FormHeight");
    private static final String HELP_TEXT = Messages.getString("ColumnPropertiesDialogEx.HelpText");
    private static final String READ_ONLY = Messages.getString("ColumnPropertiesDialogEx.ReadOnly");
    private static final String DISPLAYED_ON_REPORTS = Messages.getString("ColumnPropertiesDialogEx.DisplayedOnReports");
    private static final String DISPLAYED_ON_FORMS = Messages.getString("ColumnPropertiesDialogEx.DisplayedOnForms");
    private static final String DISPLAY_AS = Messages.getString("ColumnPropertiesDialogEx.DisplayAs");
    private static final String FORMAT_MASK = Messages.getString("ColumnPropertiesDialogEx.FormatMask");
    private static final String LABEL = Messages.getString("ColumnPropertiesDialogEx.Label");
    public static final String SECURITY = Messages.getString("ColumnPropertiesDialogEx.Security");
    public static final String MASK_DATA = Messages.getString("ColumnPropertiesDialogEx.MaskData");
    public static final String MASK_DATA_SHORT = Messages.getString("ColumnPropertiesDialogEx.MaskData_short");
    public static final String MASK_DATA_MINIMAL = Messages.getString("ColumnPropertiesDialogEx.MaskData_minimal");
    public static final String CONTAINS_SENSITIVE_INFORMATION = Messages.getString("ColumnPropertiesDialogEx.ContainsSensitiveInformation");
    public static final String CONTAINS_SENSITIVE_INFORMATION_SHORT = Messages.getString("ColumnPropertiesDialogEx.ContainsSensitiveInformation_short");
    public static final String CONTAINS_SENSITIVE_INFORMATION_MINIMAL = Messages.getString("ColumnPropertiesDialogEx.ContainsSensitiveInformation_minimal");
    public static final String CONTAINS_PII = Messages.getString("ColumnPropertiesDialogEx.ContainsPII");
    public static final String CONTAINS_PII_SHORT = Messages.getString("ColumnPropertiesDialogEx.ContainsPII_short");
    private static final String AUTO_INCREMENT_PANEL_CAPTION = Messages.getString("ColumnPropertiesDialogEx.AutoIncrement");
    private static final String AUTO_INCREMENT_GENERATE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementGenerate");
    private static final String AUTO_INCREMENT_START_WITH = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementStartWith");
    private static final String AUTO_INCREMENT_INCREMENT_BY = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementIncrementBy");
    private static final String AUTO_INCREMENT_MIN_VALUE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementMinValue");
    private static final String AUTO_INCREMENT_MAX_VALUE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementMaxValue");
    private static final String AUTO_INCREMENT_CYCLE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementCycle");
    private static final String AUTO_INCREMENT_DISABLE_CACHE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementDisableCache");
    private static final String AUTO_INCREMENT_CACHE = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementCache");
    private static final String AUTO_INCREMENT_ORDER = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementOrder");
    private static final String AUTO_INCREMENT_SEQUENCE_NAME = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementSequenceName");
    private static final String AUTO_INCREMENT_TRIGGER_NAME = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementTriggerName");
    private static final String AUTO_INCREMENT_GENERATE_TRIGGER = Messages.getString("ColumnPropertiesDialogEx.AutoIncrementGenerateTrigger");
    private static final String AUTO_INCREMENT_GENERATE_ALWAYS = Messages.getString("ColumnPropertiesDialogEx.ALWAYS");
    private static final String AUTO_INCREMENT_GENERATE_WHEN_NULL = Messages.getString("ColumnPropertiesDialogEx.WHEN_NULL");
    private static final String[] AUTO_INCREMENT_GENERATE_OPTIONS = new String[]{AUTO_INCREMENT_GENERATE_ALWAYS, AUTO_INCREMENT_GENERATE_WHEN_NULL};
    private Column column;
    private JTextField tfAbbreviation;
    private JCheckBox chEngineer;
    private JCheckBox chAllowNulls;
    private JTextField tfTable;
    private JButton bnDataType;
    private JComboBox cbSourceType;
    private JCheckBox chComputed;
    private JTextField tfFormulaDesc;
    private JComboBox cbScope;
    private JComboBox cbTypeSubstitution;
    private DatatypeDialog datatypeDialog = null;
    private JPanel pnConstraint;
    private JCheckBox chUsesDefault;
    private JTextField tfConstraintName;
    private JTextField tfNotNullConstraintName;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultValue;
    private JCheckBox chUseDomainConstraints;
    private JButton btnConstraint;
    private JButton btnAVT;
    private JButton btnValueList;
    private CECheckConstraint checkEditor = null;
    private ValueListEditorEx valuesEditor = null;
    private List permittedTypes;
    private StructuredType currentST = null;
    private List subTypes;
    private JPanel pnLevels;
    private JTable lTable;
    private JTree tree;
    private JPanel pnUIDefaults;
    private JTextField tfDefaultLabel;
    private JTextField tfDefaultFormatMask;
    private JIntegerField tfDefaultFormDisplayWidth;
    private JIntegerField tfDefaultFormMaximumWidth;
    private JIntegerField tfDefaultFormHeight;
    private JTextArea taDefaultHelpText;
    private JCheckBox chDefaultReadOnly;
    private JCheckBox chDefaultDisplayedOnReports;
    private JCheckBox chDefaultDisplayedOnForms;
    private JComboBox cbDefaultDisplayAs;
    private JPanel pnSecurity;
    private JComboBox cbContainsPII;
    private JComboBox cbContainsSensitiveInformation;
    private JComboBox cbMaskData;
    private boolean oldUseDomainConstraint;
    private boolean usePreferredList = false;
    private JButton btnProperties;
    private JCheckBox chAutoIncrementColumn;
    private JCheckBox chIdentityColumn;
    private JPanel pnAutoIncrement;
    private JComboBox cbAutoIncrementGenerate;
    private JIntegerField ifAutoIncrementStartWith;
    private JIntegerField ifAutoIncrementIncrementBy;
    private JIntegerField ifAutoIncrementMinValue;
    private JIntegerField ifAutoIncrementMaxValue;
    private JComboBox cbAutoIncrementCycle;
    private JComboBox cbAutoIncrementDisableCache;
    private JIntegerField ifAutoIncrementCache;
    private JComboBox cbAutoIncrementOrder;
    private JTextField tfAutoIncrementSequenceName;
    private JTextField tfAutoIncrementTriggerName;
    private JCheckBox chAutoIncrementGenerateTrigger;
    private Dimension labelSize = null;

    public ColumnPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject, boolean bl) {
        super(applicationView, designObject);
        this.usePreferredList = bl;
        this.initGeneral();
    }

    public ColumnPropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject, boolean bl) {
        super(dialog, applicationView, designObject);
        this.usePreferredList = bl;
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ColumnPropertiesDialogEx.ColumnProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return OSEnvironment.isMacOS() ? 680 : 630;
    }

    @Override
    protected int getMinimumHeight() {
        return OSEnvironment.isMacOS() ? 560 : 500;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Column) {
            Boolean bl;
            Boolean bl2;
            Boolean bl3;
            Integer n;
            Integer n2;
            Object object;
            Object object2;
            this.column = (Column)designObject;
            this.oldUseDomainConstraint = this.column.getUseDomainConstraints();
            this.initDefaults();
            this.tfAbbreviation.setText(this.column.getAbbreviation());
            this.chEngineer.setSelected(this.column.getShouldEngineer());
            this.chAllowNulls.setSelected(this.column.getNullsAllowed());
            if (this.column.isPKElement() || this.column.isFKColumn()) {
                this.chAllowNulls.setEnabled(false);
            }
            this.tfTable.setText(this.column.getContainer().getName());
            this.bnDataType.setEnabled(this.isEditable() && !this.column.getContainer().isBST());
            this.bnDataType.setText(this.column.getDatatypeText());
            this.fillComboItems(ContainedObject.SOURCE_TYPE_STATES_DISPLAY, this.cbSourceType, false);
            String string = this.translate(this.column.getSourceType(), ContainedObject.SOURCE_TYPE_STATES_INTERNAL, ContainedObject.SOURCE_TYPE_STATES_DISPLAY);
            this.cbSourceType.setSelectedItem(string);
            this.chComputed.setSelected(this.column.isComputed());
            if (this.column.isComputed().booleanValue() || string != null && (string.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || string.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE))) {
                this.tfFormulaDesc.setEnabled(true);
                this.tfFormulaDesc.setText(this.column.getFormulaDesc());
            } else {
                this.tfFormulaDesc.setEnabled(false);
                this.tfFormulaDesc.setText(EMPTY_VALUE);
            }
            if (this.column.isReference()) {
                this.cbScope.addItem(null);
                object2 = ((RelationalDesign)this.column.getDesignPart()).getTableSet().iterator();
                while (object2.hasNext()) {
                    object = (Table)object2.next();
                    if (!((ContainerObject)object).isBST() || !this.column.getStructuredType().isParentOf(((ContainerObject)object).getBasedOnStructuredType())) continue;
                    this.cbScope.addItem(object);
                }
                this.cbScope.setSelectedItem(this.column.getScope());
            }
            this.cbScope.setEnabled(this.column.isReference());
            if (this.column.isAllowSubtypeSubstitution()) {
                if (this.column.isRestrictedTypeSubstitution()) {
                    this.cbTypeSubstitution.setSelectedItem("RESTRICTED");
                } else {
                    this.cbTypeSubstitution.setSelectedItem("ALL");
                }
            } else {
                this.cbTypeSubstitution.setSelectedItem("NONE");
            }
            if (this.column.getDataType() instanceof StructuredType) {
                this.cbTypeSubstitution.setEnabled(true);
                this.currentST = (StructuredType)this.column.getDataType();
                this.permittedTypes.addAll(this.column.getPermittedSubTypes());
                this.subTypes = this.currentST.getAllInstantiableSubTypes(true);
            } else {
                this.cbTypeSubstitution.setEnabled(false);
            }
            this.tfConstraintName.setText(this.column.getConstraintName());
            this.tfNotNullConstraintName.setText(this.column.getNotNullConstraintName());
            this.chUsesDefault.setSelected(this.column.getUsesDefaultValue());
            this.setDefaultValueUI();
            this.chUseDomainConstraints.setSelected(this.column.getUseDomainConstraints());
            object2 = "NONE";
            if (this.column.getCheck() != null) {
                object2 = this.isEditable() ? VIEW_EDIT : Messages.getString("ColumnPropertiesDialogEx.View");
            }
            this.btnConstraint.setText((String)object2);
            this.btnConstraint.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.btnAVT.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.btnValueList.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            if (this.column.isFKColumn()) {
                this.bnDataType.setEnabled(false);
            }
            if (this.column.isInFKinArc()) {
                this.chAllowNulls.setEnabled(false);
                this.chAllowNulls.setToolTipText(Messages.getString("ColumnPropertiesDialogEx.ColumnBelongsToFKInArc"));
            }
            if (this.column.isPKElement()) {
                this.chAllowNulls.setEnabled(false);
                this.chAllowNulls.setToolTipText(Messages.getString("ColumnPropertiesDialogEx.ColumnBelongsToPK"));
            }
            this.tfDefaultLabel.setText(this.column.getDefaultLabel());
            this.tfDefaultFormatMask.setText(this.column.getDefaultFormatMask());
            object = this.column.getDefaultFormDisplayWidth();
            if (object != null) {
                this.tfDefaultFormDisplayWidth.setText(String.valueOf(object));
            }
            if ((n2 = this.column.getDefaultFormMaximumWidth()) != null) {
                this.tfDefaultFormMaximumWidth.setText(String.valueOf(n2));
            }
            if ((n = this.column.getDefaultFormHeight()) != null) {
                this.tfDefaultFormHeight.setText(String.valueOf(n));
            }
            this.taDefaultHelpText.setText(this.column.getDefaultHelpText());
            this.chDefaultReadOnly.setSelected(this.column.isDefaultReadOnly());
            this.chDefaultDisplayedOnReports.setSelected(this.column.isDefaultDisplayedOnReports());
            this.chDefaultDisplayedOnForms.setSelected(this.column.isDefaultDisplayedOnForms());
            String string2 = this.column.getDefaultDisplayAs();
            if (string2 != null) {
                this.cbDefaultDisplayAs.setSelectedItem(this.translate(string2, Column.DISPLAY_AS_INTERNAL, Column.DISPLAY_AS_DISPLAY));
            }
            if ((bl3 = this.column.isContainsPII()) != null) {
                this.cbContainsPII.setSelectedItem(bl3 != false ? YES : NO);
            }
            if ((bl2 = this.column.isContainsSensitiveInformation()) != null) {
                this.cbContainsSensitiveInformation.setSelectedItem(bl2 != false ? YES : NO);
            }
            if ((bl = this.column.isMaskData()) != null) {
                this.cbMaskData.setSelectedItem(bl != false ? YES : NO);
            }
            this.initAutoIncrementProperties();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.column.getPropertyNames();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = this.column.getProperty(string3);
                DynamicProperty dynamicProperty = new DynamicProperty(string3, string4);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private void initAutoIncrementProperties() {
        this.chAutoIncrementColumn.setSelected(this.column.isAutoIncrementColumn());
        this.updateIdentityColumnState();
        this.chIdentityColumn.setSelected(this.column.isIdentityColumn());
        this.cbAutoIncrementGenerate.setSelectedItem(this.column.isAutoIncrementGenerateAlways() ? AUTO_INCREMENT_GENERATE_ALWAYS : AUTO_INCREMENT_GENERATE_WHEN_NULL);
        try {
            this.ifAutoIncrementStartWith.setValue(Integer.valueOf(this.column.getAutoIncrementStartWith()));
        }
        catch (NumberFormatException numberFormatException) {
            this.ifAutoIncrementStartWith.setValue(1L);
        }
        this.ifAutoIncrementIncrementBy.setValue(this.column.getAutoIncrementIncrementBy());
        try {
            this.ifAutoIncrementMinValue.setValue(Integer.valueOf(this.column.getAutoIncrementMinValue()));
        }
        catch (NumberFormatException numberFormatException) {
            this.ifAutoIncrementMinValue.setValue(null);
        }
        try {
            this.ifAutoIncrementMaxValue.setValue(Integer.valueOf(this.column.getAutoIncrementMaxValue()));
        }
        catch (NumberFormatException numberFormatException) {
            this.ifAutoIncrementMaxValue.setValue(null);
        }
        this.cbAutoIncrementCycle.setSelectedItem(this.column.isAutoIncrementCycle() ? YES : NO);
        this.cbAutoIncrementDisableCache.setSelectedItem(this.column.isAutoIncrementDisableCache() ? YES : NO);
        this.ifAutoIncrementCache.setEnabled(!this.column.isAutoIncrementDisableCache());
        this.ifAutoIncrementCache.setValue(this.column.getAutoIncrementCache());
        this.cbAutoIncrementOrder.setSelectedItem(this.column.isAutoIncrementOrder() ? YES : NO);
        this.tfAutoIncrementSequenceName.setText(this.column.getAutoIncrementSequenceName());
        this.tfAutoIncrementTriggerName.setText(this.column.getAutoIncrementTriggerName());
        this.chAutoIncrementGenerateTrigger.setSelected(this.column.isAutoIncrementGenerateTrigger());
    }

    @Override
    protected void setProperties() {
        Object object4;
        Object object22;
        List list;
        Object object32;
        this.column.setName(this.tfName.getText());
        this.column.setAbbreviation(this.tfAbbreviation.getText());
        this.column.setComment(this.taComments.getText());
        this.column.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.column.setNotes(this.taNotes.getText());
        if (this.cbDefaultValue.isVisible()) {
            this.column.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
        } else {
            this.column.setDefaultValue(this.tfDefaultValue.getText());
        }
        this.column.setShouldEngineer(this.chEngineer.isSelected());
        boolean bl = !this.chAllowNulls.isSelected();
        boolean bl2 = this.column.getNullsAllowed();
        this.column.setNullsAllowed(!bl);
        ColumnPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.column.clearProperties();
        for (Object object32 : this.dynamicPropertiesList) {
            this.column.setProperty(((DynamicProperty)object32).getName(), ((DynamicProperty)object32).getValue());
        }
        if (bl2 && bl) {
            object32 = ((Table)this.column.getContainerWithKeyObject()).getFKeysOnColumn(this.column);
            list = new ArrayList<Object>();
            Iterator iterator = object32.iterator();
            while (iterator.hasNext()) {
                object22 = (FKIndexAssociation)iterator.next();
                if (!"SET NULL".equals(((FKIndexAssociation)object22).getDeleteRule()) || ((FKIndexAssociation)object22).hasColumnWithAllowNulls()) continue;
                list.add(object22);
            }
            if (list.size() > 0) {
                object22 = Messages.getString("ColumnPropertiesDialogEx.DeleteRleWillChange");
                for (FKIndexAssociation fKIndexAssociation : list) {
                    object22 = (String)object22 + "\n" + fKIndexAssociation.getName();
                }
                int n = JOptionPane.showConfirmDialog(null, object22, Messages.getString("ColumnPropertiesDialogEx.FKDeleteRuleChange"), 2);
                if (n != 0) {
                    this.column.setNullsAllowed(true);
                    this.chAllowNulls.setSelected(true);
                } else {
                    for (Object object4 : list) {
                        ((FKIndexAssociation)object4).setDeleteRule("RESTRICT");
                    }
                }
            }
            for (Object object22 : this.column.getAllFKs()) {
                if (((FKIndexAssociation)object22).isMandatory()) continue;
                ((FKIndexAssociation)object22).setMandatory(true);
                ((FKIndexAssociation)object22).resetEdgeParams();
            }
        }
        this.column.setConstraintName(this.tfConstraintName.getText());
        this.column.setNotNullConstraintName(this.tfNotNullConstraintName.getText());
        this.column.setUsesDefaultValue(this.chUsesDefault.isSelected());
        this.column.setUseDomainConstraints(this.chUseDomainConstraints.isSelected());
        this.column.setSourceType(this.translate((String)this.cbSourceType.getSelectedItem(), ContainedObject.SOURCE_TYPE_STATES_DISPLAY, ContainedObject.SOURCE_TYPE_STATES_INTERNAL));
        this.column.setComputed(this.chComputed.isSelected());
        this.column.setFormulaDesc(this.tfFormulaDesc.getText());
        if (this.cbScope.getSelectedItem() == null) {
            this.column.setScopeId(null);
        } else {
            this.column.setScopeId(((ContainerObject)this.cbScope.getSelectedItem()).getObjectID());
        }
        object32 = (String)this.cbTypeSubstitution.getSelectedItem();
        if ("NONE".equals(object32)) {
            this.column.setAllowSubtypeSubstitution(false);
            this.column.setRestrictedTypeSubstitution(false);
        } else if ("ALL".equals(object32)) {
            this.column.setRestrictedTypeSubstitution(false);
            this.column.setAllowSubtypeSubstitution(true);
        } else {
            this.column.setRestrictedTypeSubstitution(true);
            this.column.setAllowSubtypeSubstitution(true);
        }
        if (this.column.getCheck() != null && this.column.getCheck().isEmpty()) {
            this.column.setCheck(null);
        }
        if (this.column.getValueList() != null && this.column.getValueList().isEmpty()) {
            this.column.setValueList(null);
        }
        if (this.column.getCheck() != null) {
            this.btnConstraint.setText(VIEW_EDIT);
        }
        list = this.column.getPermittedSubTypes();
        list.clear();
        list.addAll(this.permittedTypes);
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.column.setDefaultLabel(this.tfDefaultLabel.getText());
        this.column.setDefaultFormatMask(this.tfDefaultFormatMask.getText());
        object22 = this.tfDefaultFormDisplayWidth.getText();
        this.column.setDefaultFormDisplayWidth(StringUtilities.isNotEmpty((String)object22) ? Integer.valueOf(Integer.parseInt((String)object22)) : null);
        String string = this.tfDefaultFormMaximumWidth.getText();
        this.column.setDefaultFormMaximumWidth(StringUtilities.isNotEmpty(string) ? Integer.valueOf(Integer.parseInt(string)) : null);
        object4 = this.tfDefaultFormHeight.getText();
        this.column.setDefaultFormHeight(StringUtilities.isNotEmpty((String)object4) ? Integer.valueOf(Integer.parseInt((String)object4)) : null);
        this.column.setDefaultHelpText(this.taDefaultHelpText.getText());
        this.column.setDefaultReadOnly(this.chDefaultReadOnly.isSelected());
        this.column.setDefaultDisplayedOnReports(this.chDefaultDisplayedOnReports.isSelected());
        this.column.setDefaultDisplayedOnForms(this.chDefaultDisplayedOnForms.isSelected());
        this.column.setDefaultDisplayAs(this.translate((String)this.cbDefaultDisplayAs.getSelectedItem(), Column.DISPLAY_AS_DISPLAY, Column.DISPLAY_AS_INTERNAL));
        String string2 = (String)this.cbContainsPII.getSelectedItem();
        this.column.setContainsPII(YES.equals(string2) ? Boolean.TRUE : (NO.equals(string2) ? Boolean.FALSE : null));
        String string3 = (String)this.cbContainsSensitiveInformation.getSelectedItem();
        this.column.setContainsSensitiveInformation(YES.equals(string3) ? Boolean.TRUE : (NO.equals(string3) ? Boolean.FALSE : null));
        String string4 = (String)this.cbMaskData.getSelectedItem();
        this.column.setMaskData(YES.equals(string4) ? Boolean.TRUE : (NO.equals(string4) ? Boolean.FALSE : null));
        this.setAutoIncrementProperties();
        this.oldUseDomainConstraint = this.column.getUseDomainConstraints();
        this.checkNamingOptions();
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    private void setAutoIncrementProperties() {
        this.column.setAutoIncrementColumn(this.chAutoIncrementColumn.isSelected());
        this.column.setIdentityColumn(this.chIdentityColumn.isSelected());
        this.column.setAutoIncrementGenerateAlways(AUTO_INCREMENT_GENERATE_ALWAYS.equals(this.cbAutoIncrementGenerate.getSelectedItem()));
        try {
            int n = Integer.parseInt(this.ifAutoIncrementStartWith.getText());
            this.column.setAutoIncrementStartWith(this.ifAutoIncrementStartWith.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.column.setAutoIncrementStartWith("1");
        }
        try {
            this.column.setAutoIncrementIncrementBy(Integer.parseInt(this.ifAutoIncrementIncrementBy.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            this.column.setAutoIncrementIncrementBy(1);
        }
        try {
            int n = Integer.parseInt(this.ifAutoIncrementMinValue.getText());
            this.column.setAutoIncrementMinValue(this.ifAutoIncrementMinValue.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.column.setAutoIncrementMinValue(null);
        }
        try {
            int n = Integer.parseInt(this.ifAutoIncrementMaxValue.getText());
            this.column.setAutoIncrementMaxValue(this.ifAutoIncrementMaxValue.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.column.setAutoIncrementMaxValue(null);
        }
        this.column.setAutoIncrementCycle(YES.equals(this.cbAutoIncrementCycle.getSelectedItem()));
        this.column.setAutoIncrementDisableCache(YES.equals(this.cbAutoIncrementDisableCache.getSelectedItem()));
        try {
            this.column.setAutoIncrementCache(Integer.parseInt(this.ifAutoIncrementCache.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            this.column.setAutoIncrementCache(null);
        }
        this.column.setAutoIncrementOrder(YES.equals(this.cbAutoIncrementOrder.getSelectedItem()));
        this.column.setAutoIncrementSequenceName(this.tfAutoIncrementSequenceName.getText());
        this.column.setAutoIncrementTriggerName(this.tfAutoIncrementTriggerName.getText());
        this.column.setAutoIncrementGenerateTrigger(this.chAutoIncrementGenerateTrigger.isSelected());
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRColumnMaxNameLength(), this.column);
        this.checkDesignRule(new DRColumnCaseType(), this.column);
        this.checkDesignRule(new DRColumnValidCharacters(), this.column);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getConstraintPanel());
        this.addToTree(defaultMutableTreeNode, this.getAutoIncrementPanel());
        this.addToTree(defaultMutableTreeNode, this.getSecurityPanel());
        this.addToTree(defaultMutableTreeNode, this.getUIDefaultsPanel());
        this.addToTree(defaultMutableTreeNode, this.getPermittedSubtypesPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsInRDBMSPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getImpactAnalysisPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "COLUMN_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_TABLE);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfTable = new JTextField();
        this.tfTable.setPreferredSize(this.getDefaultSize());
        this.tfTable.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfTable));
        JLabel jLabel2 = new JLabel(ABBREVIATION);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfAbbreviation = new JTextField();
        this.tfAbbreviation.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfAbbreviation));
        JLabel jLabel3 = new JLabel(LB_ENGINEER);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.chEngineer = new JCheckBox();
        this.chEngineer.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.chEngineer));
        JLabel jLabel4 = new JLabel(LB_ALLOW_NULLS);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.chAllowNulls = new JCheckBox();
        this.chAllowNulls.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.chAllowNulls));
        JLabel jLabel5 = new JLabel(LB_DATA_TYPE);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.bnDataType = new JButton();
        this.bnDataType.setPreferredSize(new Dimension(FIELD_WIDTH + 80, 20));
        this.bnDataType.setHorizontalAlignment(2);
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.setToolTipText(Messages.getString("ColumnPropertiesDialogEx.ClickToEditDataType"));
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ColumnPropertiesDialogEx.this.datatypeDialog == null) {
                    ColumnPropertiesDialogEx.this.datatypeDialog = new DatatypeDialog(ColumnPropertiesDialogEx.this, ColumnPropertiesDialogEx.this.getAppView(), ColumnPropertiesDialogEx.this.column, ColumnPropertiesDialogEx.this.bnDataType);
                }
                ColumnPropertiesDialogEx.this.datatypeDialog.initProperties(ColumnPropertiesDialogEx.this.usePreferredList);
                ColumnPropertiesDialogEx.this.datatypeDialog.showDialog();
                if (ColumnPropertiesDialogEx.this.column.getDataType() instanceof StructuredType && !ColumnPropertiesDialogEx.this.column.isReference() && ColumnPropertiesDialogEx.this.column.getDataType() != ColumnPropertiesDialogEx.this.currentST) {
                    ColumnPropertiesDialogEx.this.currentST = (StructuredType)ColumnPropertiesDialogEx.this.column.getDataType();
                    ColumnPropertiesDialogEx.this.subTypes = ColumnPropertiesDialogEx.this.currentST.getAllInstantiableSubTypes(true);
                }
                ColumnPropertiesDialogEx.this.bnDataType.setText(ColumnPropertiesDialogEx.this.column.getDatatypeText());
            }
        });
        this.bnDataType.addChangeListener(new DatatypeListener());
        JPanel jPanel = this.createRow(jLabel5, this.bnDataType);
        JButton jButton = new JButton("...");
        jButton.setToolTipText(Messages.getString("ColumnPropertiesDialogEx.DatatypeProperties"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignObject designObject = null;
                if (ColumnPropertiesDialogEx.this.column.getUse() == 0) {
                    designObject = ColumnPropertiesDialogEx.this.column.getDomain();
                } else if (ColumnPropertiesDialogEx.this.column.getUse() == 2) {
                    designObject = ColumnPropertiesDialogEx.this.column.getDistinctType();
                } else if (ColumnPropertiesDialogEx.this.column.getUse() == 3) {
                    designObject = ColumnPropertiesDialogEx.this.column.getStructuredType();
                } else if (ColumnPropertiesDialogEx.this.column.getUse() == 4) {
                    designObject = ColumnPropertiesDialogEx.this.column.getCollectionType();
                }
                if (designObject != null) {
                    designObject.showModal = ((ColumnPropertiesDialogEx)ColumnPropertiesDialogEx.this).column.showModal;
                    designObject.showPropertyDialog();
                } else if (ColumnPropertiesDialogEx.this.column.getUse() == 1) {
                    LogicalTypeDialog logicalTypeDialog = !ColumnPropertiesDialogEx.this.isEditable() ? new LogicalTypeDialog(ColumnPropertiesDialogEx.this.getAppView(), ColumnPropertiesDialogEx.this.column, ColumnPropertiesDialogEx.this.column.getSelectedRDBMSType().getName(), ColumnPropertiesDialogEx.this.usePreferredList) : new LogicalTypeDialog(ColumnPropertiesDialogEx.this.getAppView(), ColumnPropertiesDialogEx.this.column, ColumnPropertiesDialogEx.this.bnDataType, ColumnPropertiesDialogEx.this.column.getSelectedRDBMSType().getName(), ColumnPropertiesDialogEx.this.usePreferredList);
                    logicalTypeDialog.setVisible(true);
                }
                ColumnPropertiesDialogEx.this.bnDataType.setText(ColumnPropertiesDialogEx.this.column.getDatatypeText());
            }
        });
        this.addRowToGeneralPanel(this.createRow(jPanel, jButton, true));
        JLabel jLabel6 = new JLabel(LB_TYPE);
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.cbSourceType = new JComboBox();
        this.cbSourceType.setPreferredSize(this.getDefaultSize());
        this.cbSourceType.setMaximumRowCount(8);
        this.cbSourceType.addActionListener(new ExpressionEnableListener());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.cbSourceType));
        JLabel jLabel7 = new JLabel(LB_COMPUTED);
        jLabel7.setPreferredSize(this.getDefaultSize());
        this.chComputed = new JCheckBox();
        this.chComputed.setPreferredSize(this.getDefaultSize());
        this.chComputed.addActionListener(new ExpressionEnableListener());
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.chComputed));
        JLabel jLabel8 = new JLabel(LB_COLUMN_EXPRESSION);
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.tfFormulaDesc = new JTextField();
        this.tfFormulaDesc.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.tfFormulaDesc));
        JLabel jLabel9 = new JLabel(LB_AUTO_INCREMENT);
        jLabel9.setPreferredSize(this.getDefaultSize());
        this.chAutoIncrementColumn = new JCheckBox();
        this.chIdentityColumn = new JCheckBox(LB_IDENTITY_COLUMN);
        this.chIdentityColumn.setHorizontalTextPosition(10);
        this.chIdentityColumn.setEnabled(false);
        this.chAutoIncrementColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnPropertiesDialogEx.this.updateIdentityColumnState();
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout(20, 0));
        jPanel2.add((Component)this.chAutoIncrementColumn, "West");
        jPanel2.add(this.chIdentityColumn);
        this.addRowToGeneralPanel(this.createRow(jLabel9, jPanel2));
        JLabel jLabel10 = new JLabel(LB_SCOPE);
        jLabel10.setPreferredSize(this.getDefaultSize());
        this.cbScope = new JComboBox();
        this.cbScope.setPreferredSize(this.getDefaultSize());
        this.cbScope.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(jLabel10, this.cbScope));
        JLabel jLabel11 = new JLabel(LB_SUBTYPE_SUBSTITUTION);
        jLabel11.setPreferredSize(this.getDefaultSize());
        this.cbTypeSubstitution = new JComboBox<String>(ContainedObjectWithDomain.SUBST_OPTIONS);
        this.cbTypeSubstitution.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel11, this.cbTypeSubstitution));
    }

    private void updateIdentityColumnState() {
        boolean bl = this.chAutoIncrementColumn.isSelected();
        if (!bl) {
            this.chIdentityColumn.setSelected(false);
        }
        this.chIdentityColumn.setEnabled(bl);
        this.enableAutoIncrement(bl);
    }

    private Dimension getLabelDefaultSize() {
        if (this.labelSize == null) {
            this.labelSize = new Dimension(200, 20);
        }
        return this.labelSize;
    }

    protected JPanel getConstraintPanel() {
        if (this.pnConstraint == null) {
            this.pnConstraint = this.createPage(Messages.getString("ColumnPropertiesDialogEx.DefaultAndConstraint"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(Messages.getString("ColumnPropertiesDialogEx.ConstraintName"));
            jLabel.setPreferredSize(this.getLabelDefaultSize());
            this.tfConstraintName = new JTextField();
            this.tfConstraintName.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel, this.tfConstraintName));
            JLabel jLabel2 = new JLabel(Messages.getString("ColumnPropertiesDialogEx.NotNullConstraintName"));
            jLabel2.setPreferredSize(this.getLabelDefaultSize());
            this.tfNotNullConstraintName = new JTextField();
            this.tfNotNullConstraintName.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel2, this.tfNotNullConstraintName));
            JLabel jLabel3 = new JLabel(LB_USES_DEFAULT);
            jLabel3.setPreferredSize(this.getLabelDefaultSize());
            this.chUsesDefault = new JCheckBox();
            this.chUsesDefault.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel3, this.chUsesDefault));
            JLabel jLabel4 = new JLabel(LB_DEFAULT_VALUE);
            jLabel4.setPreferredSize(this.getLabelDefaultSize());
            JPanel jPanel3 = new JPanel();
            OverlayLayout overlayLayout = new OverlayLayout(jPanel3);
            jPanel3.setLayout(overlayLayout);
            this.cbDefaultValue = new JComboBox();
            this.cbDefaultValue.setPreferredSize(this.getDefaultSize());
            this.cbDefaultValue.setVisible(false);
            jPanel3.add(this.cbDefaultValue);
            this.tfDefaultValue = new JTextField();
            this.tfDefaultValue.setPreferredSize(this.getDefaultSize());
            this.tfDefaultValue.setVisible(true);
            jPanel3.add(this.tfDefaultValue);
            jPanel2.add(this.createRow(jLabel4, jPanel3));
            JLabel jLabel5 = new JLabel(LB_USE_DOMAIN_CONSTRAINTS);
            jLabel5.setPreferredSize(this.getLabelDefaultSize());
            this.chUseDomainConstraints = new JCheckBox();
            this.chUseDomainConstraints.setPreferredSize(this.getDefaultSize());
            this.chUseDomainConstraints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnPropertiesDialogEx.this.btnConstraint.setEnabled(!ColumnPropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    ColumnPropertiesDialogEx.this.btnAVT.setEnabled(!ColumnPropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    ColumnPropertiesDialogEx.this.btnValueList.setEnabled(!ColumnPropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    if (ColumnPropertiesDialogEx.this.chUseDomainConstraints.isSelected()) {
                        ColumnPropertiesDialogEx.this.column.setCheck(null);
                    }
                }
            });
            jPanel2.add(this.createRow(jLabel5, this.chUseDomainConstraints));
            JLabel jLabel6 = new JLabel(LB_CONSTRAINT);
            jLabel6.setPreferredSize(this.getLabelDefaultSize());
            this.btnConstraint = new JButton();
            this.btnConstraint.setHorizontalAlignment(0);
            this.btnConstraint.setPreferredSize(this.getDefaultSize());
            this.btnConstraint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnPropertiesDialogEx.this.column.setUseDomainConstraints(false);
                    if (ColumnPropertiesDialogEx.this.column.getCheck() == null) {
                        CheckConstraint checkConstraint = new CheckConstraint();
                        ColumnPropertiesDialogEx.this.column.setCheck(checkConstraint);
                    }
                    if (ColumnPropertiesDialogEx.this.column.getCheck().getDesign() == null) {
                        ColumnPropertiesDialogEx.this.column.getCheck().setDesign(ColumnPropertiesDialogEx.this.column.getDesign());
                    }
                    if (ColumnPropertiesDialogEx.this.checkEditor == null) {
                        ColumnPropertiesDialogEx.this.checkEditor = new CECheckConstraint((Dialog)ColumnPropertiesDialogEx.this, ColumnPropertiesDialogEx.this.getAppView(), !ColumnPropertiesDialogEx.this.isEditable());
                    }
                    ColumnPropertiesDialogEx.this.checkEditor.configureEditComponentFor(ColumnPropertiesDialogEx.this.column.getCheck());
                    ColumnPropertiesDialogEx.this.checkEditor.doEditing(ColumnPropertiesDialogEx.this.column.getCheck());
                }
            });
            jPanel2.add(this.createRow(jLabel6, this.btnConstraint));
            JLabel jLabel7 = new JLabel(LB_RANGES);
            jLabel7.setPreferredSize(this.getLabelDefaultSize());
            this.btnAVT = new JButton(LB_VALUES);
            this.btnAVT.setPreferredSize(this.getDefaultSize());
            this.btnAVT.setHorizontalAlignment(0);
            this.btnAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnPropertiesDialogEx.this.column.setUseDomainConstraints(false);
                    AVTEditor aVTEditor = new AVTEditor((Dialog)ColumnPropertiesDialogEx.this, !ColumnPropertiesDialogEx.this.isEditable());
                    aVTEditor.configureEditComponentFor(ColumnPropertiesDialogEx.this.column, ColumnPropertiesDialogEx.this.column.getLogicalDatatype());
                    aVTEditor.doEditing(ColumnPropertiesDialogEx.this.column);
                }
            });
            jPanel2.add(this.createRow(jLabel7, this.btnAVT));
            JLabel jLabel8 = new JLabel(LB_VALUE_LIST);
            jLabel8.setPreferredSize(this.getLabelDefaultSize());
            this.btnValueList = new JButton(LB_VALUES);
            this.btnValueList.setPreferredSize(this.getDefaultSize());
            this.btnValueList.setHorizontalAlignment(0);
            this.btnValueList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnPropertiesDialogEx.this.column.setUseDomainConstraints(false);
                    if (ColumnPropertiesDialogEx.this.column.getValueList() == null) {
                        ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
                        ColumnPropertiesDialogEx.this.column.setValueList(constraintEnumeration);
                    }
                    if (ColumnPropertiesDialogEx.this.valuesEditor == null) {
                        ColumnPropertiesDialogEx.this.valuesEditor = new ValueListEditorEx((Dialog)ColumnPropertiesDialogEx.this, !ColumnPropertiesDialogEx.this.isEditable());
                    }
                    ColumnPropertiesDialogEx.this.valuesEditor.configureEditComponentFor(ColumnPropertiesDialogEx.this.column.getValueList());
                    ColumnPropertiesDialogEx.this.valuesEditor.doEditing(ColumnPropertiesDialogEx.this.column);
                }
            });
            jPanel2.add(this.createRow(jLabel8, this.btnValueList));
            jPanel.add((Component)jPanel2, "North");
            this.pnConstraint.add(jPanel);
        }
        return this.pnConstraint;
    }

    @Override
    protected void onApply() {
        super.onApply();
        this.setDefaultValueUI();
    }

    private void setDefaultValueUI() {
        Object[] objectArray = this.column.getValues().toArray();
        if (objectArray != null && objectArray.length > 0) {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            objectArray2[0] = EMPTY_VALUE;
            int n = 0;
            String string = this.column.getDefaultValue();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i + 1] = objectArray[i];
                if (string == null || !string.equals(objectArray[i].toString())) continue;
                n = i + 1;
            }
            this.cbDefaultValue.setModel(new DefaultComboBoxModel<Object>(objectArray2));
            this.cbDefaultValue.setSelectedIndex(n);
            this.cbDefaultValue.setVisible(true);
            this.tfDefaultValue.setVisible(false);
        } else {
            this.tfDefaultValue.setText(this.column.getDefaultValue());
            this.tfDefaultValue.setVisible(true);
            this.cbDefaultValue.setVisible(false);
        }
    }

    protected JPanel getAutoIncrementPanel() {
        if (this.pnAutoIncrement == null) {
            this.pnAutoIncrement = this.createPage(AUTO_INCREMENT_PANEL_CAPTION);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            this.cbAutoIncrementGenerate = new JComboBox<String>(AUTO_INCREMENT_GENERATE_OPTIONS);
            this.cbAutoIncrementGenerate.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_GENERATE, this.cbAutoIncrementGenerate);
            this.ifAutoIncrementStartWith = new JIntegerField();
            this.ifAutoIncrementStartWith.setColumns(28);
            this.ifAutoIncrementStartWith.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_START_WITH, this.ifAutoIncrementStartWith);
            this.ifAutoIncrementIncrementBy = new JIntegerField();
            this.ifAutoIncrementIncrementBy.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_INCREMENT_BY, this.ifAutoIncrementIncrementBy);
            this.ifAutoIncrementMinValue = new JIntegerField();
            this.ifAutoIncrementMinValue.setColumns(28);
            this.ifAutoIncrementMinValue.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_MIN_VALUE, this.ifAutoIncrementMinValue);
            this.ifAutoIncrementMaxValue = new JIntegerField();
            this.ifAutoIncrementMaxValue.setColumns(28);
            this.ifAutoIncrementMaxValue.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_MAX_VALUE, this.ifAutoIncrementMaxValue);
            this.cbAutoIncrementCycle = new JComboBox<String>(YES_NO);
            this.cbAutoIncrementCycle.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_CYCLE, this.cbAutoIncrementCycle);
            this.cbAutoIncrementDisableCache = new JComboBox<String>(YES_NO);
            this.cbAutoIncrementDisableCache.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_DISABLE_CACHE, this.cbAutoIncrementDisableCache);
            this.ifAutoIncrementCache = new JIntegerField();
            this.ifAutoIncrementCache.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_CACHE, this.ifAutoIncrementCache);
            this.cbAutoIncrementDisableCache.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = AbstractPropertiesDialog.YES.equals(ColumnPropertiesDialogEx.this.cbAutoIncrementDisableCache.getSelectedItem());
                    if (bl) {
                        ColumnPropertiesDialogEx.this.ifAutoIncrementCache.setValue(null);
                    } else {
                        ColumnPropertiesDialogEx.this.ifAutoIncrementCache.setValue(ColumnPropertiesDialogEx.this.column.getAutoIncrementCache());
                    }
                    ColumnPropertiesDialogEx.this.ifAutoIncrementCache.setEnabled(!bl);
                }
            });
            this.cbAutoIncrementOrder = new JComboBox<String>(YES_NO);
            this.cbAutoIncrementOrder.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_ORDER, this.cbAutoIncrementOrder);
            this.tfAutoIncrementSequenceName = new JTextField();
            this.tfAutoIncrementSequenceName.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_SEQUENCE_NAME, this.tfAutoIncrementSequenceName);
            this.tfAutoIncrementTriggerName = new JTextField();
            this.tfAutoIncrementTriggerName.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_TRIGGER_NAME, this.tfAutoIncrementTriggerName);
            this.chAutoIncrementGenerateTrigger = new JCheckBox();
            this.chAutoIncrementGenerateTrigger.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, AUTO_INCREMENT_GENERATE_TRIGGER, this.chAutoIncrementGenerateTrigger);
            JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
            jPanel2.add((Component)jPanel, "North");
            this.pnAutoIncrement.add((Component)jPanel2, "Center");
            this.enableAutoIncrement(false);
        }
        return this.pnAutoIncrement;
    }

    protected void enableAutoIncrement(boolean bl) {
        this.cbAutoIncrementGenerate.setEnabled(bl);
        this.ifAutoIncrementStartWith.setEnabled(bl);
        this.ifAutoIncrementIncrementBy.setEnabled(bl);
        this.ifAutoIncrementMinValue.setEnabled(bl);
        this.ifAutoIncrementMaxValue.setEnabled(bl);
        this.cbAutoIncrementCycle.setEnabled(bl);
        this.cbAutoIncrementDisableCache.setEnabled(bl);
        this.ifAutoIncrementCache.setEnabled(bl);
        this.cbAutoIncrementOrder.setEnabled(bl);
        this.tfAutoIncrementSequenceName.setEnabled(bl);
        this.tfAutoIncrementTriggerName.setEnabled(bl);
        this.chAutoIncrementGenerateTrigger.setEnabled(bl);
    }

    @Override
    protected void onCancel() {
        if (this.column.getCheck() != null && this.column.getCheck().isEmpty()) {
            this.column.setCheck(null);
        }
        if (this.column.getValueList() != null && this.column.getValueList().isEmpty()) {
            this.column.setValueList(null);
        }
        this.column.setUseDomainConstraints(this.oldUseDomainConstraint);
        super.onCancel();
    }

    protected JPanel getPermittedSubtypesPanel() {
        if (this.pnLevels == null) {
            this.pnLevels = this.createPage(Messages.getString("ColumnPropertiesDialogEx.PermittedSubtypes"));
            this.permittedTypes = new ArrayList();
            this.subTypes = new ArrayList();
            this.lTable = new JTable(new DataModel());
            this.lTable.setSelectionMode(0);
            this.lTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = ColumnPropertiesDialogEx.this.lTable.getSelectedRow();
                    if (n == -1) {
                        ColumnPropertiesDialogEx.this.btnProperties.setEnabled(false);
                    } else {
                        ColumnPropertiesDialogEx.this.btnProperties.setEnabled(true);
                    }
                }
            });
            this.lTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = ColumnPropertiesDialogEx.this.lTable.getSelectedRow()) != -1 && ColumnPropertiesDialogEx.this.subTypes.size() > 0 && n < ColumnPropertiesDialogEx.this.subTypes.size()) {
                        DesignObject designObject = (DesignObject)ColumnPropertiesDialogEx.this.subTypes.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.lTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setEnabled(false);
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ColumnPropertiesDialogEx.this.lTable.getSelectedRow();
                    if (n != -1 && ColumnPropertiesDialogEx.this.subTypes.size() > 0 && n < ColumnPropertiesDialogEx.this.subTypes.size()) {
                        DesignObject designObject = (DesignObject)ColumnPropertiesDialogEx.this.subTypes.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnProperties);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnLevels.add(jPanel2);
        }
        return this.pnLevels;
    }

    protected JPanel getUIDefaultsPanel() {
        if (this.pnUIDefaults == null) {
            this.pnUIDefaults = this.createPage(Messages.getString("ColumnPropertiesDialogEx.UIDefaults"));
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            this.tfDefaultLabel = new JTextField();
            this.tfDefaultLabel.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, LABEL, this.tfDefaultLabel);
            this.tfDefaultFormatMask = new JTextField();
            this.tfDefaultFormatMask.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, FORMAT_MASK, this.tfDefaultFormatMask);
            this.tfDefaultFormDisplayWidth = new JIntegerField();
            this.tfDefaultFormDisplayWidth.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, FORM_DISPLAY_WIDTH, this.tfDefaultFormDisplayWidth);
            this.tfDefaultFormMaximumWidth = new JIntegerField();
            this.tfDefaultFormMaximumWidth.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, FORM_MAXIMUM_WIDTH, this.tfDefaultFormMaximumWidth);
            this.cbDefaultDisplayAs = new JComboBox<String>(Column.DISPLAY_AS_DISPLAY);
            this.cbDefaultDisplayAs.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, DISPLAY_AS, this.cbDefaultDisplayAs);
            this.tfDefaultFormHeight = new JIntegerField();
            this.tfDefaultFormHeight.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, FORM_HEIGHT, this.tfDefaultFormHeight);
            this.chDefaultDisplayedOnForms = new JCheckBox();
            this.chDefaultDisplayedOnForms.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, DISPLAYED_ON_FORMS, this.chDefaultDisplayedOnForms);
            this.chDefaultDisplayedOnReports = new JCheckBox();
            this.chDefaultDisplayedOnReports.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, DISPLAYED_ON_REPORTS, this.chDefaultDisplayedOnReports);
            this.chDefaultReadOnly = new JCheckBox();
            this.chDefaultReadOnly.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, READ_ONLY, this.chDefaultReadOnly);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            this.taDefaultHelpText = new JTextArea();
            this.addRowToPanel(jPanel2, HELP_TEXT, new JScrollPane(this.taDefaultHelpText));
            JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
            jPanel3.add((Component)jPanel, "North");
            jPanel3.add((Component)jPanel2, "Center");
            this.pnUIDefaults.add((Component)jPanel3, "Center");
        }
        return this.pnUIDefaults;
    }

    protected JPanel getSecurityPanel() {
        if (this.pnSecurity == null) {
            this.pnSecurity = this.createPage(SECURITY);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            this.cbContainsPII = new JComboBox<String>(EMPTY_STRING_YES_NO);
            this.cbContainsPII.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, CONTAINS_PII_SHORT, this.cbContainsPII, CONTAINS_PII);
            this.cbContainsSensitiveInformation = new JComboBox<String>(EMPTY_STRING_YES_NO);
            this.cbContainsSensitiveInformation.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, CONTAINS_SENSITIVE_INFORMATION_SHORT, this.cbContainsSensitiveInformation, CONTAINS_SENSITIVE_INFORMATION);
            this.cbMaskData = new JComboBox<String>(EMPTY_STRING_YES_NO);
            this.cbMaskData.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(jPanel, MASK_DATA_SHORT, this.cbMaskData, MASK_DATA);
            JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
            jPanel2.add((Component)jPanel, "North");
            this.pnSecurity.add((Component)jPanel2, "Center");
        }
        return this.pnSecurity;
    }

    @Override
    protected void addRowToPanel(JPanel jPanel, String string, JComponent jComponent) {
        this.addRowToPanel(jPanel, string, jComponent, null);
    }

    @Override
    protected void addRowToPanel(JPanel jPanel, String string, JComponent jComponent, String string2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(this.getDefaultSize());
        if (string2 != null) {
            jLabel.setToolTipText(string2);
            jComponent.setToolTipText(string2);
        }
        jPanel.add((Component)this.createRow(jLabel, jComponent), "North");
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel jPanel = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                Object object;
                if (mouseEvent.getClickCount() == 2 && (object = (treePath = ColumnPropertiesDialogEx.this.tree.getClosestPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject modelIDObject = ((ModelIdObjectSelection)object).getObject();
                    if (modelIDObject != null) {
                        mouseEvent.consume();
                        modelIDObject.showPropertyDialog();
                    } else {
                        if (ColumnPropertiesDialogEx.this.tree.isCollapsed(treePath)) {
                            ColumnPropertiesDialogEx.this.tree.expandPath(treePath);
                        } else {
                            ColumnPropertiesDialogEx.this.tree.collapsePath(treePath);
                        }
                        mouseEvent.consume();
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign compareTreeNavigationDesign = new CompareTreeNavigationDesign(new ImpA_Column(this.getColumn_forIA(), null, true), false);
        ImpactTreeRenderer impactTreeRenderer = new ImpactTreeRenderer();
        this.tree.setModel(compareTreeNavigationDesign);
        this.tree.setCellRenderer(impactTreeRenderer);
        return this.tree;
    }

    @Override
    protected boolean canExit() {
        int n;
        if (this.column.isInOptionalFK() && !this.chAllowNulls.isSelected() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("ColumnPropertiesDialogEx.TheColumnBelongsToPptionalFK"), Messages.getString("ColumnPropertiesDialogEx.ColumnInOptionalFK"), 0)) != 0) {
            return false;
        }
        return this.containsInteger(this.tfDefaultFormDisplayWidth, FORM_DISPLAY_WIDTH) && this.containsInteger(this.tfDefaultFormMaximumWidth, FORM_MAXIMUM_WIDTH) && this.containsInteger(this.tfDefaultFormHeight, FORM_HEIGHT) && super.canExit();
    }

    protected boolean containsInteger(JTextField jTextField, String string) {
        String string2 = jTextField.getText();
        if (StringUtilities.isNotEmpty(string2) && !string2.matches("\\d+")) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("ColumnPropertiesDialogEx.InvalidInteger"), string));
            jTextField.requestFocus();
            return false;
        }
        return true;
    }

    private Column getColumn_forIA() {
        Column column = (Column)((RelationalDesign)this.column.getDesignPart()).getColumnSet().getObjectByID(this.column.getObjectID());
        if (column != null) {
            return column;
        }
        return this.column;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ColumnPropertiesDialogEx.this.subTypes.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ColumnPropertiesDialogEx.Permitted");
            }
            if (n == 1) {
                return Messages.getString("ColumnPropertiesDialogEx.Name");
            }
            return ColumnPropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!ColumnPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            StructuredType structuredType = (StructuredType)ColumnPropertiesDialogEx.this.subTypes.get(n);
            if (n2 == 1) {
                return structuredType.getName();
            }
            if (n2 == 0) {
                return ColumnPropertiesDialogEx.this.permittedTypes.contains(structuredType);
            }
            return ColumnPropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            StructuredType structuredType = (StructuredType)ColumnPropertiesDialogEx.this.subTypes.get(n);
            if (n2 == 0) {
                if (((Boolean)object).booleanValue()) {
                    if (!ColumnPropertiesDialogEx.this.permittedTypes.contains(structuredType)) {
                        ColumnPropertiesDialogEx.this.permittedTypes.add(structuredType);
                    }
                } else {
                    ColumnPropertiesDialogEx.this.permittedTypes.remove(structuredType);
                }
            }
        }
    }

    private class DatatypeListener
    implements ChangeListener {
        private DatatypeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ColumnPropertiesDialogEx.this.cbScope.setEnabled(ColumnPropertiesDialogEx.this.column.isReference());
            ColumnPropertiesDialogEx.this.cbScope.removeAllItems();
            if (ColumnPropertiesDialogEx.this.column.isReference()) {
                if (ColumnPropertiesDialogEx.this.column.getScope() != null) {
                    ColumnPropertiesDialogEx.this.cbScope.addItem(null);
                }
                StructuredType structuredType = ColumnPropertiesDialogEx.this.column.getStructuredType();
                Iterator iterator = ((RelationalDesign)ColumnPropertiesDialogEx.this.column.getDesignPart()).getTableSet().iterator();
                while (iterator.hasNext()) {
                    Table table = (Table)iterator.next();
                    if (!table.isBST() || !structuredType.isParentOf(table.getBasedOnStructuredType())) continue;
                    ColumnPropertiesDialogEx.this.cbScope.addItem(table);
                }
                ColumnPropertiesDialogEx.this.cbScope.setSelectedItem(ColumnPropertiesDialogEx.this.column.getScope());
            }
            ColumnPropertiesDialogEx.this.cbTypeSubstitution.setEnabled(ColumnPropertiesDialogEx.this.column.getDataType() instanceof StructuredType || ColumnPropertiesDialogEx.this.column.getDataType() instanceof CollectionType);
        }
    }

    private class ExpressionEnableListener
    implements ActionListener {
        private ExpressionEnableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)ColumnPropertiesDialogEx.this.cbSourceType.getSelectedItem();
            if (ColumnPropertiesDialogEx.this.chComputed.isSelected() || string != null && (string.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || string.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE))) {
                ColumnPropertiesDialogEx.this.tfFormulaDesc.setEnabled(true);
            } else {
                ColumnPropertiesDialogEx.this.tfFormulaDesc.setEnabled(false);
                ColumnPropertiesDialogEx.this.tfFormulaDesc.setText(ColumnPropertiesDialogEx.EMPTY_VALUE);
            }
        }
    }
}

