/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.editor.process.SelectSourceElementsDialog;

public class TransformationPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private JTextField tfFilterCondition;
    private JTextField tfJoinCondition;
    private JCheckBox chbPrimary;
    private Transformation process;
    private JPanel pnInfoStructures;
    private ArrayList isList;
    private JTable istable;
    private JPanel pnAttributes;
    private ArrayList attrList;
    private JTable attrTable;
    private JPanel pnEntity;
    private ArrayList entList;
    private JTable entTable;
    private JPanel pnSourceTargetMapping;
    private JTable tbTarget;
    private JTable sTable;
    private JButton btnProperties;
    private List sList;
    private JButton btnAdd;
    private List targets = new ArrayList();
    private JButton btnRemove;
    private JComboBox cbTransformationTypes;

    public TransformationPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
        JLabel jLabel2 = new JLabel(Messages.getString("TransformationPropertiesDialogEx.SourcesFilterCondition"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfFilterCondition = new JTextField();
        this.tfFilterCondition.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfFilterCondition));
        JLabel jLabel3 = new JLabel(Messages.getString("TransformationPropertiesDialogEx.SourcesJoinCondition"));
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.tfJoinCondition = new JTextField();
        this.tfJoinCondition.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.tfJoinCondition));
        JLabel jLabel4 = new JLabel(Messages.getString("TransformationPropertiesDialogEx.Primary"));
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.chbPrimary = new JCheckBox();
        this.chbPrimary.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.chbPrimary));
    }

    @Override
    public String getCaption() {
        return Messages.getString("TransformationPropertiesDialogEx.TransformationProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Transformation) {
            this.process = (Transformation)designObject;
            this.initDefaults(false);
            this.tfSynonym.setText(this.process.getSynonym());
            this.tfFilterCondition.setText(this.process.getFilterCondition());
            this.tfJoinCondition.setText(this.process.getJoinCondition());
            this.chbPrimary.setSelected(this.process.isPrimary());
            this.isList.addAll(this.process.getInfoStructures());
            this.attrList.addAll(this.process.getProcessedAttributes(false));
            this.entList.addAll(this.process.getProcessedEntities(false));
            this.initSourceTargetMapping();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.process.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.process.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.process.setName(this.tfName.getText());
        this.process.setNotes(this.taNotes.getText());
        this.process.setComment(this.taComments.getText());
        this.process.setSynonym(this.tfSynonym.getText());
        this.process.setFilterCondition(this.tfFilterCondition.getText());
        this.process.setJoinCondition(this.tfJoinCondition.getText());
        this.process.setPrimary(this.chbPrimary.isSelected());
        this.setSourceTargetInfo();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        TransformationPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.process.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.process.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    private void setSourceTargetInfo() {
        for (int i = 0; i < this.tbTarget.getRowCount(); ++i) {
            String string = (String)this.tbTarget.getModel().getValueAt(i, 2);
            String string2 = (String)this.tbTarget.getModel().getValueAt(i, 3);
            TargetElement targetElement = (TargetElement)this.targets.get(i);
            targetElement.setTransformationType(this.translate(string, Transformation.TRANSFORMATION_TYPES_DISPLAY, Transformation.TRANSFORMATION_TYPES));
            targetElement.setDescription(string2);
        }
        this.process.getTargetElements().clear();
        this.process.getTargetElements().addAll(this.targets);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getInfoStructuresPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getEntityPanel());
        this.addToTree(defaultMutableTreeNode, this.getSourceTargetMappingPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "TRANSFORMATION_PROPERTIES_DIALOG";
    }

    private JPanel getInfoStructuresPanel() {
        if (this.pnInfoStructures == null) {
            this.pnInfoStructures = this.createPage(Messages.getString("TransformationPropertiesDialogEx.InformationStructures"));
            this.isList = new ArrayList();
            this.istable = new JTable(new InfoStructuresModel());
            this.istable.setSelectionMode(0);
            this.istable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = TransformationPropertiesDialogEx.this.istable.getSelectedRow()) != -1 && TransformationPropertiesDialogEx.this.isList.size() > 0 && n < TransformationPropertiesDialogEx.this.isList.size()) {
                        InfoStructure infoStructure = (InfoStructure)TransformationPropertiesDialogEx.this.isList.get(n);
                        infoStructure.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.istable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("TransformationPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TransformationPropertiesDialogEx.this.istable.getSelectedRow();
                    if (n != -1 && TransformationPropertiesDialogEx.this.isList.size() > 0 && n < TransformationPropertiesDialogEx.this.isList.size()) {
                        InfoStructure infoStructure = (InfoStructure)TransformationPropertiesDialogEx.this.isList.get(n);
                        infoStructure.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnInfoStructures.add(jPanel2);
        }
        return this.pnInfoStructures;
    }

    private JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("TransformationPropertiesDialogEx.ProcessedAttributes"));
            this.attrList = new ArrayList();
            this.attrTable = new JTable(new AttributesModel());
            this.attrTable.setSelectionMode(0);
            TableColumn tableColumn = this.attrTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(200);
            this.attrTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = TransformationPropertiesDialogEx.this.attrTable.getSelectedRow()) != -1 && TransformationPropertiesDialogEx.this.attrList.size() > 0 && n < TransformationPropertiesDialogEx.this.attrList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)TransformationPropertiesDialogEx.this.attrList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.attrTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("TransformationPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TransformationPropertiesDialogEx.this.attrTable.getSelectedRow();
                    if (n != -1 && TransformationPropertiesDialogEx.this.attrList.size() > 0 && n < TransformationPropertiesDialogEx.this.attrList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)TransformationPropertiesDialogEx.this.attrList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnAttributes.add(jPanel2);
        }
        return this.pnAttributes;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("TransformationPropertiesDialogEx.ProcessedEntities"));
            this.entList = new ArrayList();
            this.entTable = new JTable(new EntityModel());
            this.entTable.setSelectionMode(0);
            TableColumn tableColumn = this.entTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(200);
            this.entTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = TransformationPropertiesDialogEx.this.entTable.getSelectedRow()) != -1 && TransformationPropertiesDialogEx.this.entList.size() > 0 && n < TransformationPropertiesDialogEx.this.entList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)TransformationPropertiesDialogEx.this.entList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.entTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("TransformationPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TransformationPropertiesDialogEx.this.entTable.getSelectedRow();
                    if (n != -1 && TransformationPropertiesDialogEx.this.entList.size() > 0 && n < TransformationPropertiesDialogEx.this.entList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)TransformationPropertiesDialogEx.this.entList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 320));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnEntity.add(jPanel2);
        }
        return this.pnEntity;
    }

    private JPanel getSourceTargetMappingPanel() {
        if (this.pnSourceTargetMapping == null) {
            this.pnSourceTargetMapping = this.createPage(Messages.getString("TransformationPropertiesDialogEx.SourceTargetMapping"));
            this.sList = new ArrayList();
            JPanel jPanel = new JPanel(new BorderLayout());
            this.sTable = new JTable(new SourceElementsModel());
            JScrollPane jScrollPane = new JScrollPane(this.sTable);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel2.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TransformationPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (n != -1 && TransformationPropertiesDialogEx.this.sList.size() > 0 && n < TransformationPropertiesDialogEx.this.sList.size()) {
                        DesignObject designObject = (DesignObject)TransformationPropertiesDialogEx.this.sList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectSourceElementsDialog selectSourceElementsDialog = new SelectSourceElementsDialog(TransformationPropertiesDialogEx.this.getAppView(), TransformationPropertiesDialogEx.this.process, TransformationPropertiesDialogEx.this.sList);
                        selectSourceElementsDialog.show();
                        TransformationPropertiesDialogEx.this.sTable.updateUI();
                        int n = TransformationPropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (n != -1 && !selectSourceElementsDialog.cancel && n != -1) {
                            TargetElement targetElement = (TargetElement)TransformationPropertiesDialogEx.this.targets.get(n);
                            targetElement.getSources().clear();
                            for (DesignObject designObject : TransformationPropertiesDialogEx.this.sList) {
                                targetElement.addSource(designObject);
                            }
                        }
                    }
                });
                this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = TransformationPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (n != -1 && TransformationPropertiesDialogEx.this.sList.size() > 0 && n < TransformationPropertiesDialogEx.this.sList.size()) {
                            TransformationPropertiesDialogEx.this.sList.remove(n);
                            TransformationPropertiesDialogEx.this.sTable.updateUI();
                            int n2 = TransformationPropertiesDialogEx.this.tbTarget.getSelectedRow();
                            if (n2 != -1) {
                                TargetElement targetElement = (TargetElement)TransformationPropertiesDialogEx.this.targets.get(n2);
                                targetElement.getSources().clear();
                                for (DesignObject designObject : TransformationPropertiesDialogEx.this.sList) {
                                    targetElement.addSource(designObject);
                                }
                            }
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAdd);
                jToolBar.add(this.btnRemove);
            }
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("TransformationPropertiesDialogEx.Targets")));
            jPanel.add((Component)jPanel3, "North");
            this.tbTarget = new JTable(new TargetTableModel());
            this.tbTarget.setPreferredScrollableViewportSize(new Dimension(325, 120));
            SelectionListener selectionListener = new SelectionListener(this.tbTarget);
            this.tbTarget.getSelectionModel().addListSelectionListener(selectionListener);
            TableColumn tableColumn = null;
            block6: for (int i = 0; i < 3; ++i) {
                tableColumn = this.tbTarget.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        tableColumn.setPreferredWidth(100);
                        continue block6;
                    }
                    case 1: {
                        tableColumn.setPreferredWidth(50);
                        continue block6;
                    }
                    case 2: {
                        tableColumn.setPreferredWidth(75);
                        continue block6;
                    }
                    case 3: {
                        tableColumn.setPreferredWidth(100);
                    }
                }
            }
            this.cbTransformationTypes = new JComboBox<String>(Transformation.TRANSFORMATION_TYPES_DISPLAY);
            this.tbTarget.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.cbTransformationTypes));
            JScrollPane jScrollPane2 = new JScrollPane(this.tbTarget);
            jPanel3.add(jScrollPane2);
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = TransformationPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && TransformationPropertiesDialogEx.this.sList.size() > 0 && n < TransformationPropertiesDialogEx.this.sList.size()) {
                        DesignObject designObject = (DesignObject)TransformationPropertiesDialogEx.this.sList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            this.enableButtons(false);
            jPanel2.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 130));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("TransformationPropertiesDialogEx.Sources")));
            jPanel4.add((Component)jPanel2, "North");
            jPanel4.add(jScrollPane);
            jPanel.add(jPanel4);
            this.pnSourceTargetMapping.add(jPanel);
        }
        return this.pnSourceTargetMapping;
    }

    private void updateSourceElements(TargetElement targetElement) {
        this.sList.clear();
        Iterator iterator = targetElement.getSources().iterator();
        while (iterator.hasNext()) {
            this.sList.add(iterator.next());
        }
        this.sTable.updateUI();
    }

    private void enableButtons(boolean bl) {
        if (this.isEditable()) {
            this.btnProperties.setEnabled(bl);
            this.btnAdd.setEnabled(bl);
            this.btnRemove.setEnabled(bl);
        }
    }

    private void initSourceTargetMapping() {
        this.process.updateTargetElements();
        List list = this.process.getTargetElements();
        for (TargetElement targetElement : list) {
            TargetElement targetElement2 = new TargetElement(targetElement);
            this.targets.add(targetElement2);
        }
        for (TargetElement targetElement : this.targets) {
            ((DefaultTableModel)this.tbTarget.getModel()).addRow(new Object[]{targetElement.getTarget().getLongName(), targetElement.getTarget().getObjectTypeName(), this.translate(targetElement.getTransformationType(), Transformation.TRANSFORMATION_TYPES, Transformation.TRANSFORMATION_TYPES_DISPLAY), targetElement.getDescription()});
        }
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = ((ListSelectionModel)listSelectionEvent.getSource()).getAnchorSelectionIndex();
            if (n != -1) {
                TargetElement targetElement = (TargetElement)TransformationPropertiesDialogEx.this.targets.get(n);
                TransformationPropertiesDialogEx.this.updateSourceElements(targetElement);
                TransformationPropertiesDialogEx.this.enableButtons(true);
            } else {
                TransformationPropertiesDialogEx.this.enableButtons(false);
            }
        }
    }

    private class SourceElementsModel
    extends AbstractTableModel {
        private SourceElementsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TransformationPropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TransformationPropertiesDialogEx.SourceElements");
            }
            if (n == 1) {
                return Messages.getString("TransformationPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)TransformationPropertiesDialogEx.this.sList.get(n);
            if (n2 == 0) {
                return designObject.getLongName();
            }
            if (n2 == 1) {
                return designObject.getObjectTypeName();
            }
            return new Integer(n * n2);
        }
    }

    class TargetTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("TransformationPropertiesDialogEx.TargetElement"), Messages.getString("TransformationPropertiesDialogEx.Type"), Messages.getString("TransformationPropertiesDialogEx.Transformation"), Messages.getString("TransformationPropertiesDialogEx.Description")};

        TargetTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!TransformationPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 > 1;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = this.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }
    }

    private class EntityModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return TransformationPropertiesDialogEx.this.entList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TransformationPropertiesDialogEx.Entity");
            }
            if (n == 1) {
                return Messages.getString("TransformationPropertiesDialogEx.Create");
            }
            if (n == 2) {
                return Messages.getString("TransformationPropertiesDialogEx.Read");
            }
            if (n == 3) {
                return Messages.getString("TransformationPropertiesDialogEx.Update");
            }
            if (n == 4) {
                return Messages.getString("TransformationPropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Transformation.ProcessedObject processedObject = (Transformation.ProcessedObject)TransformationPropertiesDialogEx.this.entList.get(n);
            if (n2 == 0) {
                return processedObject.getObject().getName();
            }
            if (n2 == 1) {
                return processedObject.isOpCreate();
            }
            if (n2 == 2) {
                return processedObject.isOpRead();
            }
            if (n2 == 3) {
                return processedObject.isOpUpdate();
            }
            if (n2 == 4) {
                return processedObject.isOpDelete();
            }
            return new Integer(n * n2);
        }
    }

    private class AttributesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return TransformationPropertiesDialogEx.this.attrList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TransformationPropertiesDialogEx.Attribute");
            }
            if (n == 1) {
                return Messages.getString("TransformationPropertiesDialogEx.Create");
            }
            if (n == 2) {
                return Messages.getString("TransformationPropertiesDialogEx.Read");
            }
            if (n == 3) {
                return Messages.getString("TransformationPropertiesDialogEx.Update");
            }
            if (n == 4) {
                return Messages.getString("TransformationPropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Transformation.ProcessedObject processedObject = (Transformation.ProcessedObject)TransformationPropertiesDialogEx.this.attrList.get(n);
            if (n2 == 0) {
                return processedObject.getObject().getName();
            }
            if (n2 == 1) {
                return processedObject.isOpCreate();
            }
            if (n2 == 2) {
                return processedObject.isOpRead();
            }
            if (n2 == 3) {
                return processedObject.isOpUpdate();
            }
            if (n2 == 4) {
                return processedObject.isOpDelete();
            }
            return new Integer(n * n2);
        }
    }

    private class InfoStructuresModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TransformationPropertiesDialogEx.this.isList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TransformationPropertiesDialogEx.InformationStructures");
            }
            if (n == 1) {
                return Messages.getString("TransformationPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InfoStructure infoStructure = (InfoStructure)TransformationPropertiesDialogEx.this.isList.get(n);
            if (n2 == 0) {
                return infoStructure.getName();
            }
            if (n2 == 1) {
                return infoStructure.getSynonym();
            }
            return new Integer(n * n2);
        }
    }
}

