/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectTransformationTaskDialog
extends JDialog
implements AbstractEditorConstants {
    private JList allProcessesList;
    private DefaultListModel allProcessesModel;
    protected JPanel generalPanel;
    TransformationTask transformationTask;
    Process process;

    public SelectTransformationTaskDialog(ApplicationView applicationView, TransformationTask transformationTask, Process process) {
        super(applicationView.getFrame());
        this.setModal(true);
        this.transformationTask = transformationTask;
        this.process = process;
        this.setTitle(Messages.getString("SelectTransformationTaskDialog.SelectTransformationTask"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SelectTransformationTaskDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allProcessesModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setPreferredSize(jButton2.getPreferredSize());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init() {
        this.initAllProcessesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator iterator = ((DataFlowDesign)this.process.getDesignPart()).getProcessModel().getAllTransformationTasks().iterator();
        while (iterator.hasNext()) {
            this.allProcessesModel.addElement(iterator.next());
        }
    }

    private void initAllProcessesList() {
        JPanel jPanel = new JPanel();
        this.allProcessesList = new JList(this.allProcessesModel);
        this.allProcessesList.setCellRenderer(new LongNameCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.allProcessesList);
        jScrollPane.setPreferredSize(new Dimension(420, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "West");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    public TransformationTask getTransformationTask() {
        return this.transformationTask;
    }

    class LongNameCellRenderer
    extends JLabel
    implements ListCellRenderer {
        LongNameCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            TransformationTask transformationTask = (TransformationTask)object;
            String string = transformationTask.getTransformationPackage().getName() + "." + transformationTask.getName();
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectTransformationTaskDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SelectTransformationTaskDialog.this.allProcessesList.getSelectedValue() != null) {
                SelectTransformationTaskDialog.this.transformationTask = (TransformationTask)SelectTransformationTaskDialog.this.allProcessesList.getSelectedValue();
            }
            SelectTransformationTaskDialog.this.dispose();
        }
    }
}

