/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectProcessesDialog
extends JDialog
implements AbstractEditorConstants {
    private ApplicationView view;
    private List pList;
    private JList selectedProcessesList;
    private JList allProcessesList;
    private DefaultListModel allProcessesModel;
    private DefaultListModel selectedProcessesModel;
    private JButton btnAddProcesses;
    private JButton btnRemoveProcesseses;
    protected JPanel generalPanel;

    public SelectProcessesDialog(ApplicationView applicationView, List list) {
        super(applicationView.getFrame());
        this.setModal(true);
        this.view = applicationView;
        this.pList = list;
        this.setTitle(Messages.getString("SelectProcessesDialog.SelectProcessesConnectedToInfoStore"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SelectProcessesDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allProcessesModel = new DefaultListModel();
        this.selectedProcessesModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setPreferredSize(jButton2.getPreferredSize());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init() {
        this.initAllProcessesList();
        this.initProcessesButtons();
        this.initSelectedProcessesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator iterator = this.pList.iterator();
        while (iterator.hasNext()) {
            this.selectedProcessesModel.addElement(iterator.next());
        }
        iterator = this.view.getCurrentDesign().getProcessModel().getDataFlowDesign().getProcessSet().iterator();
        while (iterator.hasNext()) {
            Process process = (Process)iterator.next();
            if (this.pList.contains(process) || process.isComposite() || !process.isConnectedToStore()) continue;
            this.allProcessesModel.addElement(process);
        }
    }

    private void initAllProcessesList() {
        JPanel jPanel = new JPanel();
        this.allProcessesList = new JList(this.allProcessesModel);
        ListSelectionModel listSelectionModel = this.allProcessesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllProcessListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allProcessesList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "West");
    }

    private void initSelectedProcessesList() {
        JPanel jPanel = new JPanel();
        this.selectedProcessesList = new JList(this.selectedProcessesModel);
        ListSelectionModel listSelectionModel = this.selectedProcessesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedProcessListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedProcessesList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initProcessesButtons() {
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddProcesses = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddProcesses.addActionListener(new AddProcessesActionListener());
        this.btnAddProcesses.setEnabled(false);
        this.btnAddProcesses.setToolTipText(Messages.getString("SelectProcessesDialog.Add"));
        this.btnRemoveProcesseses = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveProcesseses.setEnabled(false);
        this.btnRemoveProcesseses.addActionListener(new RemoveProcessesActionListener());
        this.btnRemoveProcesseses.setToolTipText(Messages.getString("SelectProcessesDialog.Remove"));
        jToolBar.add(this.btnAddProcesses);
        jToolBar.add(this.btnRemoveProcesseses);
        jPanel.add(jToolBar);
        jPanel.setPreferredSize(new Dimension(32, 300));
        this.generalPanel.add((Component)jPanel, "Center");
    }

    private class SelectedProcessListSelectionHandler
    implements ListSelectionListener {
        private SelectedProcessListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectProcessesDialog.this.selectedProcessesList.getSelectedIndex() == -1) {
                    SelectProcessesDialog.this.btnRemoveProcesseses.setEnabled(false);
                } else {
                    SelectProcessesDialog.this.btnRemoveProcesseses.setEnabled(true);
                }
            }
        }
    }

    private class AllProcessListSelectionHandler
    implements ListSelectionListener {
        private AllProcessListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectProcessesDialog.this.allProcessesList.getSelectedIndex() == -1) {
                    SelectProcessesDialog.this.btnAddProcesses.setEnabled(false);
                } else {
                    SelectProcessesDialog.this.btnAddProcesses.setEnabled(true);
                }
            }
        }
    }

    private class RemoveProcessesActionListener
    implements ActionListener {
        private RemoveProcessesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectProcessesDialog.this.selectedProcessesModel.isEmpty()) {
                Object[] objectArray = SelectProcessesDialog.this.selectedProcessesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SelectProcessesDialog.this.allProcessesModel.contains(object)) continue;
                    SelectProcessesDialog.this.allProcessesModel.addElement(object);
                    SelectProcessesDialog.this.selectedProcessesModel.removeElement(object);
                }
            }
        }
    }

    private class AddProcessesActionListener
    implements ActionListener {
        private AddProcessesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectProcessesDialog.this.allProcessesModel.isEmpty()) {
                Object[] objectArray = SelectProcessesDialog.this.allProcessesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SelectProcessesDialog.this.selectedProcessesModel.contains(object)) continue;
                    SelectProcessesDialog.this.selectedProcessesModel.addElement(object);
                    SelectProcessesDialog.this.allProcessesModel.removeElement(object);
                }
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectProcessesDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectProcessesDialog.this.pList.clear();
            for (int i = 0; i < SelectProcessesDialog.this.selectedProcessesModel.size(); ++i) {
                Process process = (Process)SelectProcessesDialog.this.selectedProcessesModel.getElementAt(i);
                SelectProcessesDialog.this.pList.add(process);
            }
            SelectProcessesDialog.this.dispose();
        }
    }
}

