/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.editor.process.SelectProcessesDialog;

public class RolePropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private JTextField tfDescription;
    private Role role;
    private List pList;
    private JPanel pnProcess;
    private JTable pTable;
    private List eList;
    private JTable eTable;
    private JPanel pnEntity;

    public RolePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RolePropertiesDialogEx.RoleProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Role) {
            this.role = (Role)designObject;
            this.initDefaults(false);
            this.pList.addAll(this.role.getProcesses());
            this.updateEntityList();
            this.tfSynonym.setText(this.role.getSynonym());
            this.tfDescription.setText(this.role.getDescription());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.role.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.role.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.role.setName(this.tfName.getText());
        this.role.setNotes(this.taNotes.getText());
        this.role.setComment(this.taComments.getText());
        this.role.setSynonym(this.tfSynonym.getText());
        this.role.setDescription(this.tfDescription.getText());
        this.role.setAllProcesses(this.pList);
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        RolePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.role.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.role.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getProcessPanel());
        this.addToTree(defaultMutableTreeNode, this.getEntityPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "ROLE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
        JLabel jLabel2 = new JLabel(LB_DESCRIPTION);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.tfDescription = new JTextField();
        this.tfDescription.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.tfDescription));
    }

    private JPanel getProcessPanel() {
        if (this.pnProcess == null) {
            JComponent jComponent;
            this.pnProcess = this.createPage(Messages.getString("RolePropertiesDialogEx.Processes"));
            this.pList = new ArrayList();
            this.pTable = new JTable(new ProcessTableModel());
            this.pTable.setSelectionMode(0);
            this.pTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = RolePropertiesDialogEx.this.pTable.getSelectedRow()) != -1 && RolePropertiesDialogEx.this.pList.size() > 0 && n < RolePropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)RolePropertiesDialogEx.this.pList.get(n);
                        process.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.pTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = RolePropertiesDialogEx.this.pTable.getSelectedRow();
                    if (n != -1 && RolePropertiesDialogEx.this.pList.size() > 0 && n < RolePropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)RolePropertiesDialogEx.this.pList.get(n);
                        process.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectProcessesDialog selectProcessesDialog = new SelectProcessesDialog(RolePropertiesDialogEx.this.getAppView(), RolePropertiesDialogEx.this.pList);
                        selectProcessesDialog.show();
                        RolePropertiesDialogEx.this.pTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = RolePropertiesDialogEx.this.pTable.getSelectedRow();
                        if (n != -1 && RolePropertiesDialogEx.this.pList.size() > 0 && n < RolePropertiesDialogEx.this.pList.size()) {
                            RolePropertiesDialogEx.this.pList.remove(n);
                            RolePropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 175));
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnProcess.add(jComponent);
        }
        return this.pnProcess;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("RolePropertiesDialogEx.Entities"));
            this.eList = new ArrayList();
            this.eTable = new JTable(new EntityModel());
            this.eTable.setSelectionMode(0);
            TableColumn tableColumn = this.eTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(200);
            this.eTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = RolePropertiesDialogEx.this.eTable.getSelectedRow()) != -1 && RolePropertiesDialogEx.this.eList.size() > 0 && n < RolePropertiesDialogEx.this.eList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)RolePropertiesDialogEx.this.eList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.eTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("RolePropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = RolePropertiesDialogEx.this.eTable.getSelectedRow();
                    if (n != -1 && RolePropertiesDialogEx.this.eList.size() > 0 && n < RolePropertiesDialogEx.this.eList.size()) {
                        Process.ProcessedObject processedObject = (Process.ProcessedObject)RolePropertiesDialogEx.this.eList.get(n);
                        processedObject.getObject().showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 175));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnEntity.add(jPanel2);
        }
        return this.pnEntity;
    }

    private void updateEntityList() {
        this.eList.clear();
        for (Process process : this.pList) {
            process.addProcessedEntitiesToList(this.eList, true);
        }
        this.eTable.updateUI();
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class EntityModel
    extends AbstractTableModel {
        private EntityModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return RolePropertiesDialogEx.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("RolePropertiesDialogEx.Entity");
            }
            if (n == 1) {
                return Messages.getString("RolePropertiesDialogEx.Create");
            }
            if (n == 2) {
                return Messages.getString("RolePropertiesDialogEx.Read");
            }
            if (n == 3) {
                return Messages.getString("RolePropertiesDialogEx.Update");
            }
            if (n == 4) {
                return Messages.getString("RolePropertiesDialogEx.Delete");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Process.ProcessedObject processedObject = (Process.ProcessedObject)RolePropertiesDialogEx.this.eList.get(n);
            if (n2 == 0) {
                return processedObject.getObject().getName();
            }
            if (n2 == 1) {
                return processedObject.isOpCreate();
            }
            if (n2 == 2) {
                return processedObject.isOpRead();
            }
            if (n2 == 3) {
                return processedObject.isOpUpdate();
            }
            if (n2 == 4) {
                return processedObject.isOpDelete();
            }
            return new Integer(n * n2);
        }
    }

    private class ProcessTableModel
    extends AbstractTableModel {
        private ProcessTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return RolePropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("RolePropertiesDialogEx.Processes");
            }
            if (n == 1) {
                return Messages.getString("RolePropertiesDialogEx.Synonym");
            }
            if (n == 2) {
                return Messages.getString("RolePropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Process process = (Process)RolePropertiesDialogEx.this.pList.get(n);
            if (n2 == 0) {
                DataFlowDesign dataFlowDesign = ((DataFlowDesign)process.getDesignPart()).getTopLevelDataFlowDesign();
                if (dataFlowDesign == null) {
                    return process.getProcessNumber() + " - " + process.getName();
                }
                return process.getProcessNumber() + " - " + process.getName() + "  @" + dataFlowDesign.getName();
            }
            if (n2 == 1) {
                return process.getSynonym();
            }
            if (n2 == 2) {
                return process.getProcessTypeName();
            }
            return new Integer(n * n2);
        }
    }
}

