/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class NewEventDialog
extends JDialog
implements AbstractEditorConstants {
    private DesignPart designPart;
    private List eList;
    private JPanel generalPanel;
    private JTextField tfName;
    private JRadioButton rbClock;
    private JRadioButton rbPerson;
    private JRadioButton rbStorage;
    private int type = 1;
    private String name = "No_Name";
    private List allList = new ArrayList();
    private JTable allTable;
    private JRadioButton rbNew;
    private JRadioButton rbAll;

    public NewEventDialog(ApplicationView applicationView, DesignPart designPart, List list) {
        super(applicationView.getFrame());
        this.setModal(true);
        this.designPart = designPart;
        this.eList = list;
        this.setTitle(Messages.getString("NewEventDialog.AddEvent"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewEventDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.SelectEvent")));
        RadioListener radioListener = new RadioListener();
        this.rbNew = new JRadioButton(Messages.getString("NewEventDialog.NewEvent"));
        this.rbNew.addActionListener(radioListener);
        this.rbNew.setMnemonic(78);
        this.rbAll = new JRadioButton(Messages.getString("NewEventDialog.AvailableEvent"));
        this.rbAll.addActionListener(radioListener);
        this.rbAll.setMnemonic(65);
        this.rbNew.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNew);
        buttonGroup.add(this.rbAll);
        jPanel.add(this.rbNew);
        jPanel.add(this.rbAll);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.NewEvent")));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.Name")));
        this.name = "Event_" + String.valueOf(designPart.getDesign().getProcessModel().getEventSet().size() + 1);
        this.tfName = new JTextField(this.name, 20);
        jPanel4.add(this.tfName);
        jPanel3.add((Component)jPanel4, "North");
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1));
        jPanel5.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.Type")));
        TypeListener typeListener = new TypeListener();
        this.rbClock = new JRadioButton(Messages.getString("NewEventDialog.ClockCalendar"));
        this.rbClock.addActionListener(typeListener);
        this.rbClock.setMnemonic(67);
        this.rbClock.setSelected(true);
        this.rbPerson = new JRadioButton(Messages.getString("NewEventDialog.Person"));
        this.rbPerson.addActionListener(typeListener);
        this.rbPerson.setMnemonic(80);
        this.rbStorage = new JRadioButton(Messages.getString("NewEventDialog.Storage"));
        this.rbStorage.addActionListener(typeListener);
        this.rbStorage.setMnemonic(83);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.rbClock);
        buttonGroup2.add(this.rbPerson);
        buttonGroup2.add(this.rbStorage);
        jPanel5.add(this.rbClock);
        jPanel5.add(this.rbPerson);
        jPanel5.add(this.rbStorage);
        jPanel3.add(jPanel5);
        jPanel2.add(jPanel3);
        this.generalPanel.add((Component)jPanel2, "North");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewEventDialog.AllEvents")));
        this.allList.addAll(this.getAllEvents());
        this.allTable = new JTable(new AllEventsModel());
        this.allTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.allTable);
        jScrollPane.setPreferredSize(new Dimension(240, 180));
        jPanel6.add(jScrollPane);
        this.generalPanel.add(jPanel6);
        this.getContentPane().add((Component)this.generalPanel, "Center");
        this.enableControls(this.rbNew.isSelected());
        JPanel jPanel7 = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setPreferredSize(jButton2.getPreferredSize());
        jPanel7.add(jButton);
        jPanel7.add(jButton2);
        this.getContentPane().add((Component)jPanel7, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void enableControls(boolean bl) {
        this.tfName.setEnabled(bl);
        this.rbClock.setEnabled(bl);
        this.rbPerson.setEnabled(bl);
        this.rbStorage.setEnabled(bl);
        this.allTable.setEnabled(!bl);
        this.allTable.clearSelection();
        if (bl) {
            this.allTable.setBackground(Color.LIGHT_GRAY);
        } else {
            this.allTable.setBackground(Color.WHITE);
        }
    }

    private List getAllEvents() {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        int n = ((DataFlowDesign)this.designPart).getProcessModel().getEventSet().size();
        for (int i = 0; i < n; ++i) {
            Event event = (Event)((DataFlowDesign)this.designPart).getProcessModel().getEventSet().getElement(i);
            if (event.getEventType() == 0 || this.eList.contains(event)) continue;
            arrayList.add(event);
        }
        return arrayList;
    }

    private String getEventType(int n) {
        switch (n) {
            case 1: {
                return Messages.getString("NewEventDialog.ClockCalendar");
            }
            case 2: {
                return Messages.getString("NewEventDialog.Person");
            }
            case 3: {
                return Messages.getString("NewEventDialog.Storage");
            }
        }
        return "";
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewEventDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NewEventDialog.this.rbNew.isSelected()) {
                Event event = NewEventDialog.this.designPart.getDesign().getProcessModel().getEventSet().createEvent(null, NewEventDialog.this.type);
                if (!"".equalsIgnoreCase(NewEventDialog.this.tfName.getText())) {
                    event.setName(NewEventDialog.this.tfName.getText());
                } else {
                    event.setName(NewEventDialog.this.name);
                }
                NewEventDialog.this.eList.add(event);
            } else {
                int n = NewEventDialog.this.allTable.getSelectedRow();
                if (n != -1 && NewEventDialog.this.allList.size() > 0 && n < NewEventDialog.this.allList.size()) {
                    Event event = (Event)NewEventDialog.this.allList.get(n);
                    NewEventDialog.this.eList.add(event);
                }
            }
            NewEventDialog.this.dispose();
        }
    }

    private class TypeListener
    implements ActionListener {
        private TypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == NewEventDialog.this.rbClock) {
                NewEventDialog.this.type = 1;
            } else if (jRadioButton == NewEventDialog.this.rbPerson) {
                NewEventDialog.this.type = 2;
            } else if (jRadioButton == NewEventDialog.this.rbStorage) {
                NewEventDialog.this.type = 3;
            } else {
                NewEventDialog.this.type = 1;
            }
        }
    }

    private class AllEventsModel
    extends AbstractTableModel {
        private AllEventsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return NewEventDialog.this.allList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("NewEventDialog.Event");
            }
            if (n == 1) {
                return Messages.getString("NewEventDialog.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Event event = (Event)NewEventDialog.this.allList.get(n);
            if (n2 == 0) {
                return event.getName();
            }
            if (n2 == 1) {
                return NewEventDialog.this.getEventType(event.getEventType());
            }
            return new Integer(n * n2);
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewEventDialog.this.enableControls(NewEventDialog.this.rbNew.isSelected());
        }
    }
}

