/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.AddStructureDialog;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.process.TVFlow;

public class FlowPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private JButton bnSource;
    private Flow flow;
    private JButton bnDestination;
    private JComboBox cbParent;
    private JButton bnParent;
    private JComboBox cbEvent;
    private JLabel lbLoggingFlow;
    private JCheckBox chbLoggingFlow;
    private JCheckBox chbCRUDCreate;
    private JCheckBox chbCRUDRead;
    private JCheckBox chbCRUDUpdate;
    private JCheckBox chbCRUDDelete;
    private List cfList;
    private JTable cftable;
    private JPanel pnComponentFlows;
    private List isList;
    private JTable istable;
    private JButton btnAdd;
    private JButton btnRemove;
    private JPanel pnInfoStructure;
    private JButton btnProperties;
    private List edList;
    private JTable edtable;
    private JPanel pnExternalData;
    private JButton btnExProperties;
    private JPanel pnSystemObjective;
    private JPanel pnGeneral;
    private JPanel pnGeneralGrid;
    private JTextArea taSystemObjective;
    private List newEvents = new ArrayList();

    public FlowPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
    }

    @Override
    public String getCaption() {
        return Messages.getString("FlowPropertiesDialogEx.FlowProperties");
    }

    @Override
    protected int getMinimumHeight() {
        return 420;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Flow) {
            this.flow = (Flow)designObject;
            this.newEvents.clear();
            this.initDefaults(false);
            this.tfSynonym.setText(this.flow.getSynonym());
            String string = this.flow.getSource() != null ? this.flow.getSource().getName() : Messages.getString("FlowPropertiesDialogEx.NONE");
            this.bnSource.setText(string);
            String string2 = this.flow.getDestination() != null ? this.flow.getDestination().getName() : Messages.getString("FlowPropertiesDialogEx.NONE");
            this.bnDestination.setText(string2);
            List list = this.flow.getPossibleParentFlows();
            this.fillComboItems(this.flow.getPossibleParentFlows().toArray(new Flow[0]), this.cbParent, false);
            Flow flow = (Flow)this.flow.getParentObject();
            if (flow == null && list.size() > 0) {
                flow = (Flow)list.get(0);
            }
            this.cbParent.setSelectedItem(flow);
            this.updateEvents();
            this.cbEvent.setSelectedItem(this.flow.getEvent());
            this.chbLoggingFlow.setSelected(this.flow.isLogging());
            this.chbCRUDCreate.setSelected(this.flow.isOpCreate());
            this.chbCRUDRead.setSelected(this.flow.isOpRead());
            this.chbCRUDUpdate.setSelected(this.flow.isOpUpdate());
            this.chbCRUDDelete.setSelected(this.flow.isOpDelete());
            if (this.flow.isConnecedTotCompositeProc() || !this.flow.isConnectedToInfoStore()) {
                this.disableCRUD();
            }
            if (this.flow.getTargetProcessObject() instanceof InfoStore) {
                this.chbCRUDRead.setEnabled(false);
            }
            if (this.flow.getSourceProcessObject() instanceof InfoStore) {
                this.chbCRUDCreate.setEnabled(false);
                this.chbCRUDUpdate.setEnabled(false);
                this.chbCRUDDelete.setEnabled(false);
                this.chbCRUDRead.setSelected(true);
                this.chbCRUDRead.setEnabled(false);
            }
            this.cfList = this.flow.getComponentFlows();
            this.isList.addAll(this.flow.getInfoStructures());
            this.edList.addAll(this.flow.getExternalData());
            if (!this.flow.getExternalData().isEmpty()) {
                this.enableComponents(true);
            } else {
                this.enableComponents(false);
            }
            this.taSystemObjective.setText(this.flow.getSystemObjective());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.bnParent.setEnabled(this.cbParent.getSelectedItem() != null);
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.flow.getPropertyNames();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = this.flow.getProperty(string3);
                DynamicProperty dynamicProperty = new DynamicProperty(string3, string4);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void onCancel() {
        Object[] objectArray = this.newEvents.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Event event = (Event)objectArray[i];
            event.remove();
        }
        super.onCancel();
    }

    @Override
    protected void setProperties() {
        this.flow.setName(this.tfName.getText());
        this.flow.setNotes(this.taNotes.getText());
        this.flow.setComment(this.taComments.getText());
        this.flow.setSynonym(this.tfSynonym.getText());
        Object object = this.cbEvent.getSelectedItem();
        if (object instanceof Event) {
            this.flow.setEvent((Event)object);
        } else {
            this.flow.setEvent(null);
        }
        this.flow.setLogging(this.chbLoggingFlow.isSelected());
        this.flow.setOpCreate(this.chbCRUDCreate.isSelected());
        this.flow.setOpRead(this.chbCRUDRead.isSelected());
        this.flow.setOpUpdate(this.chbCRUDUpdate.isSelected());
        this.flow.setOpDelete(this.chbCRUDDelete.isSelected());
        this.flow.setParentObject((AbstractProcessObject)this.cbParent.getSelectedItem());
        this.flow.setSystemObjective(this.taSystemObjective.getText());
        this.flow.getInfoStructures().clear();
        for (Object object2 : this.isList) {
            this.flow.addInfoStructure((InfoStructure)object2);
        }
        if (this.flow.getTopView() != null) {
            ((TVFlow)this.flow.getTopView()).displayLabels();
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        FlowPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.flow.clearProperties();
        for (Object object2 : this.dynamicPropertiesList) {
            this.flow.setProperty(((DynamicProperty)object2).getName(), ((DynamicProperty)object2).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getComponentFlowsPanel());
        this.addToTree(defaultMutableTreeNode, this.getInfoStructuresPanel());
        this.addToTree(defaultMutableTreeNode, this.getExternalDataPanel());
        this.addToTree(defaultMutableTreeNode, this.getSystemObjectivePanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "FLOW_PROPERTIES_DIALOG";
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("FlowPropertiesDialogEx.General"));
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_NAME);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(jLabel, this.tfName));
            JLabel jLabel2 = new JLabel(LB_SYNOMYM);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.tfSynonym = new JTextField();
            this.tfSynonym.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(jLabel2, this.tfSynonym));
            JLabel jLabel3 = new JLabel(LB_SOURCE);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.bnSource = new JButton();
            this.bnSource.setPreferredSize(this.getDefaultSize());
            this.bnSource.setFont(this.bnSource.getFont().deriveFont(0));
            this.bnSource.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (FlowPropertiesDialogEx.this.flow.getSource() != null) {
                        FlowPropertiesDialogEx.this.flow.getSource().showPropertyDialog();
                    }
                }
            });
            this.pnGeneralGrid.add(this.createRow(jLabel3, this.bnSource));
            JLabel jLabel4 = new JLabel(LB_DESTINATION);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.bnDestination = new JButton();
            this.bnDestination.setPreferredSize(this.getDefaultSize());
            this.bnDestination.setFont(this.bnDestination.getFont().deriveFont(0));
            this.bnDestination.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (FlowPropertiesDialogEx.this.flow.getDestination() != null) {
                        FlowPropertiesDialogEx.this.flow.getDestination().showPropertyDialog();
                    }
                }
            });
            this.pnGeneralGrid.add(this.createRow(jLabel4, this.bnDestination));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setPreferredSize(this.getDefaultSize());
            JLabel jLabel5 = new JLabel(LB_PARENT_FLOW);
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.cbParent = new JComboBox();
            this.cbParent.setFont(this.cbParent.getFont().deriveFont(0));
            this.cbParent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FlowPropertiesDialogEx.this.bnParent.setEnabled(FlowPropertiesDialogEx.this.cbParent.getSelectedItem() != null);
                }
            });
            this.bnParent = new JButton("...");
            this.bnParent.setPreferredSize(new Dimension(50, jLabel5.getHeight()));
            this.bnParent.setFont(this.bnParent.getFont().deriveFont(0));
            this.bnParent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (FlowPropertiesDialogEx.this.cbParent.getSelectedItem() != null) {
                        ((Flow)FlowPropertiesDialogEx.this.cbParent.getSelectedItem()).showPropertyDialog();
                    }
                }
            });
            jPanel2.add(this.cbParent);
            jPanel2.add((Component)this.bnParent, "East");
            this.pnGeneralGrid.add(this.createRow(jLabel5, jPanel2));
            this.lbLoggingFlow = new JLabel(Messages.getString("FlowPropertiesDialogEx.LoggingFlow"));
            this.lbLoggingFlow.setPreferredSize(this.getDefaultSize());
            this.chbLoggingFlow = new JCheckBox();
            this.chbLoggingFlow.setPreferredSize(this.getDefaultSize());
            this.pnGeneralGrid.add(this.createRow(this.lbLoggingFlow, this.chbLoggingFlow));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setPreferredSize(this.getDefaultSize());
            JLabel jLabel6 = new JLabel(LB_EVENT);
            jLabel6.setPreferredSize(this.getDefaultSize());
            this.cbEvent = new JComboBox();
            this.cbEvent.setFont(this.cbEvent.getFont().deriveFont(0));
            JButton jButton = new JButton(this.getAppView().getConfiguration().getIcon("EVENT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("FlowPropertiesDialogEx.New"));
            jButton.setPreferredSize(new Dimension(50, jLabel6.getHeight()));
            jButton.setEnabled(this.isEditable());
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Event event = FlowPropertiesDialogEx.this.flow.getDesign().getProcessModel().createEvent(0);
                    FlowPropertiesDialogEx.this.updateEvents();
                    FlowPropertiesDialogEx.this.cbEvent.setSelectedItem(event);
                    FlowPropertiesDialogEx.this.newEvents.add(event);
                }
            });
            jPanel3.add(this.cbEvent);
            jPanel3.add((Component)jButton, "East");
            this.pnGeneralGrid.add(this.createRow(jLabel6, jPanel3));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JPanel jPanel5 = new JPanel(new GridLayout(0, 2, 10, 10));
            jPanel5.setBorder(BorderFactory.createTitledBorder(Messages.getString("FlowPropertiesDialogEx.Operations")));
            this.chbCRUDCreate = new JCheckBox(Messages.getString("FlowPropertiesDialogEx.Create"));
            this.chbCRUDRead = new JCheckBox(Messages.getString("FlowPropertiesDialogEx.Read"));
            this.chbCRUDUpdate = new JCheckBox(Messages.getString("FlowPropertiesDialogEx.Update"));
            this.chbCRUDDelete = new JCheckBox(Messages.getString("FlowPropertiesDialogEx.Delete"));
            jPanel5.add(this.chbCRUDCreate);
            jPanel5.add(this.chbCRUDRead);
            jPanel5.add(this.chbCRUDUpdate);
            jPanel5.add(this.chbCRUDDelete);
            jPanel4.add((Component)jPanel5, "North");
            jPanel.add((Component)this.pnGeneralGrid, "North");
            jPanel.add((Component)jPanel4, "Center");
            this.pnGeneral.add((Component)jPanel, "Center");
        }
        return this.pnGeneral;
    }

    private JPanel getComponentFlowsPanel() {
        if (this.pnComponentFlows == null) {
            this.pnComponentFlows = this.createPage(Messages.getString("FlowPropertiesDialogEx.ComponentFlows"));
            this.cfList = new ArrayList();
            this.cftable = new JTable(new IncomingFlowsModel());
            this.cftable.setSelectionMode(0);
            this.cftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = FlowPropertiesDialogEx.this.cftable.getSelectedRow()) != -1 && FlowPropertiesDialogEx.this.cfList.size() > 0 && n < FlowPropertiesDialogEx.this.cfList.size()) {
                        Flow flow = (Flow)FlowPropertiesDialogEx.this.cfList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.cftable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("FlowPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = FlowPropertiesDialogEx.this.cftable.getSelectedRow();
                    if (n != -1 && FlowPropertiesDialogEx.this.cfList.size() > 0 && n < FlowPropertiesDialogEx.this.cfList.size()) {
                        Flow flow = (Flow)FlowPropertiesDialogEx.this.cfList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnComponentFlows.add(jPanel2);
        }
        return this.pnComponentFlows;
    }

    private JPanel getInfoStructuresPanel() {
        if (this.pnInfoStructure == null) {
            this.pnInfoStructure = this.createPage(Messages.getString("FlowPropertiesDialogEx.InformationStructures"));
            this.isList = new ArrayList();
            this.istable = new JTable(new InfoStructuresModel());
            this.istable.setSelectionMode(0);
            this.istable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = FlowPropertiesDialogEx.this.istable.getSelectedRow()) != -1 && FlowPropertiesDialogEx.this.isList.size() > 0 && n < FlowPropertiesDialogEx.this.isList.size()) {
                        InfoStructure infoStructure = (InfoStructure)FlowPropertiesDialogEx.this.isList.get(n);
                        infoStructure.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.istable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = FlowPropertiesDialogEx.this.istable.getSelectedRow();
                    if (n != -1 && FlowPropertiesDialogEx.this.isList.size() > 0 && n < FlowPropertiesDialogEx.this.isList.size()) {
                        InfoStructure infoStructure = (InfoStructure)FlowPropertiesDialogEx.this.isList.get(n);
                        infoStructure.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddStructureDialog addStructureDialog = new AddStructureDialog(FlowPropertiesDialogEx.this.getAppView(), FlowPropertiesDialogEx.this.flow.getDesignPart(), FlowPropertiesDialogEx.this.isList);
                        addStructureDialog.setVisible(true);
                        FlowPropertiesDialogEx.this.istable.updateUI();
                    }
                });
                this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = FlowPropertiesDialogEx.this.istable.getSelectedRow();
                        if (n != -1 && FlowPropertiesDialogEx.this.isList.size() > 0 && n < FlowPropertiesDialogEx.this.isList.size()) {
                            FlowPropertiesDialogEx.this.isList.remove(n);
                            FlowPropertiesDialogEx.this.istable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAdd);
                jToolBar.add(this.btnRemove);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnInfoStructure.add(jPanel2);
        }
        return this.pnInfoStructure;
    }

    private JPanel getExternalDataPanel() {
        if (this.pnExternalData == null) {
            this.pnExternalData = this.createPage(Messages.getString("FlowPropertiesDialogEx.ExternalData"));
            this.edList = new ArrayList();
            this.edtable = new JTable(new ExternalDataModel());
            this.edtable.setSelectionMode(0);
            this.edtable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = FlowPropertiesDialogEx.this.edtable.getSelectedRow()) != -1 && FlowPropertiesDialogEx.this.edList.size() > 0 && n < FlowPropertiesDialogEx.this.edList.size()) {
                        ExternalData externalData = (ExternalData)FlowPropertiesDialogEx.this.edList.get(n);
                        externalData.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.edtable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnExProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnExProperties.setToolTipText(Messages.getString("FlowPropertiesDialogEx.Properties"));
            this.btnExProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = FlowPropertiesDialogEx.this.edtable.getSelectedRow();
                    if (n != -1 && FlowPropertiesDialogEx.this.edList.size() > 0 && n < FlowPropertiesDialogEx.this.edList.size()) {
                        ExternalData externalData = (ExternalData)FlowPropertiesDialogEx.this.edList.get(n);
                        externalData.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnExProperties);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 305));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnExternalData.add(jPanel2);
        }
        return this.pnExternalData;
    }

    private JPanel getSystemObjectivePanel() {
        if (this.pnSystemObjective == null) {
            this.pnSystemObjective = this.createPage(Messages.getString("FlowPropertiesDialogEx.SystemObjective"));
            this.taSystemObjective = new JTextArea();
            this.pnSystemObjective.add(new JScrollPane(this.taSystemObjective));
        }
        return this.pnSystemObjective;
    }

    private void updateEvents() {
        this.cbEvent.removeAllItems();
        this.cbEvent.addItem(null);
        Iterator iterator = this.flow.getDesign().getProcessModel().getEventSet().iterator();
        while (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            if (event.getEventType() != 0) continue;
            this.cbEvent.addItem(event);
        }
    }

    private void disableCRUD() {
        this.chbCRUDCreate.setEnabled(false);
        this.chbCRUDRead.setEnabled(false);
        this.chbCRUDUpdate.setEnabled(false);
        this.chbCRUDDelete.setEnabled(false);
    }

    private void enableComponents(boolean bl) {
        if (this.isEditable()) {
            this.edtable.setEnabled(bl);
            this.btnExProperties.setEnabled(bl);
            this.istable.setEnabled(!bl);
            this.btnProperties.setEnabled(!bl);
            this.btnAdd.setEnabled(!bl);
            this.btnRemove.setEnabled(!bl);
        }
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return FlowPropertiesDialogEx.this.edList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("FlowPropertiesDialogEx.ExternalDatas");
            }
            if (n == 1) {
                return Messages.getString("FlowPropertiesDialogEx.Synonym");
            }
            if (n == 2) {
                return Messages.getString("FlowPropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ExternalData externalData = (ExternalData)FlowPropertiesDialogEx.this.edList.get(n);
            if (n2 == 0) {
                return externalData.getName();
            }
            if (n2 == 1) {
                return externalData.getSynonym();
            }
            if (n2 == 2) {
                return externalData.getType() != null ? externalData.getType().getName() : "";
            }
            return new Integer(n * n2);
        }
    }

    private class InfoStructuresModel
    extends AbstractTableModel {
        private InfoStructuresModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FlowPropertiesDialogEx.this.isList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("FlowPropertiesDialogEx.InformationStructures");
            }
            if (n == 1) {
                return Messages.getString("FlowPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InfoStructure infoStructure = (InfoStructure)FlowPropertiesDialogEx.this.isList.get(n);
            if (n2 == 0) {
                return infoStructure.getName();
            }
            if (n2 == 1) {
                return infoStructure.getSynonym();
            }
            return new Integer(n * n2);
        }
    }

    private class IncomingFlowsModel
    extends AbstractTableModel {
        private IncomingFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FlowPropertiesDialogEx.this.cfList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("FlowPropertiesDialogEx.ComponentFlows");
            }
            if (n == 1) {
                return Messages.getString("FlowPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Flow flow = (Flow)FlowPropertiesDialogEx.this.cfList.get(n);
            if (n2 == 0) {
                return flow.getName();
            }
            if (n2 == 1) {
                return flow.getSynonym();
            }
            return new Integer(n * n2);
        }
    }
}

