/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractFieldEditor;
import oracle.dbtools.crest.swingui.editor.process.AbstractProcessEditor;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ExternalDataPropertiesDialog
extends AbstractProcessEditor {
    private ExternalData extData;
    private JComboBox cbType;
    private JIntegerField ifStartingPos;
    private JTextField tfDescription;
    private JCheckBox chbStructured;
    private JComboBox cbRecStructure;

    public ExternalDataPropertiesDialog(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.setHeight(260);
        this.initGeneral();
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    @Override
    public String getCaption() {
        return Messages.getString("ExternalDataPropertiesDialog.ExternalDataProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof ExternalData) {
            this.extData = (ExternalData)designObject;
            this.tfName.setText(this.extData.getName());
            this.tfDescription.setText(this.extData.getDescription());
            this.btnComment.setText(this.extData.getComment());
            this.btnComment.setHorizontalAlignment(0);
            this.btnComment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractFieldEditor abstractFieldEditor = new AbstractFieldEditor(ExternalDataPropertiesDialog.this.getAppView(), ExternalDataPropertiesDialog.this.extData, 1, ExternalDataPropertiesDialog.this);
                    abstractFieldEditor.setModal(true);
                    abstractFieldEditor.setVisible(true);
                }
            });
            this.cbType.setSelectedItem(this.extData.getType());
            this.chbStructured.setSelected(this.extData.isStructured());
            this.cbRecStructure.setModel(new DefaultComboBoxModel<Object>(this.getRecordStructures()));
            this.cbRecStructure.setSelectedItem(this.extData.getRecordStructure());
            this.tfObjectID.setText(this.extData.getObjectID());
            this.ifStartingPos.setValue((long)this.extData.getStartingPos());
            this.tfCreationTime.setText(this.extData.getCreationTime());
            this.tfCreator.setText(this.extData.getCreator().getName());
            this.tfDesign.setText(this.extData.getOwnerDesignName());
            if (this.extData.getGenerator() != null) {
                this.tfGeneratorName.setText(this.extData.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.extData.getChanger().getName());
            this.tfLastChangedTime.setText(this.extData.getChangeTime());
            this.initCaption(this.extData.getName());
        }
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_LOGICAL_TYPE);
        jLabel.setPreferredSize(this.lbName.getPreferredSize());
        this.cbType = new JComboBox<Object>(this.getDesignObject().getDesign().getLogicalDatatypeSet().toArray());
        this.cbType.setMaximumRowCount(20);
        this.cbType.setFont(this.cbType.getFont().deriveFont(0));
        this.cbType.setPreferredSize(this.lbName.getPreferredSize());
        this.cbType.setEnabled(this.isEditable());
        JPanel jPanel = this.newRow(jLabel, this.cbType);
        this.generalPanel.add(jPanel);
        JLabel jLabel2 = new JLabel(LB_START_POSITION);
        jLabel2.setPreferredSize(this.lbName.getPreferredSize());
        this.ifStartingPos = new JIntegerField();
        this.ifStartingPos.setPreferredSize(this.lbName.getPreferredSize());
        this.ifStartingPos.setFont(this.ifStartingPos.getFont().deriveFont(0));
        this.ifStartingPos.setEnabled(this.isEditable());
        jPanel = this.newRow(jLabel2, this.ifStartingPos);
        this.generalPanel.add(jPanel);
        JLabel jLabel3 = new JLabel(LB_DESCRIPTION);
        jLabel3.setPreferredSize(this.lbName.getPreferredSize());
        this.tfDescription = new JTextField();
        this.tfDescription.setPreferredSize(this.lbName.getPreferredSize());
        this.tfDescription.setEnabled(this.isEditable());
        jPanel = this.newRow(jLabel3, this.tfDescription);
        this.generalPanel.add(jPanel);
        JLabel jLabel4 = new JLabel(LB_STRUCTURED);
        jLabel4.setPreferredSize(this.lbName.getPreferredSize());
        this.chbStructured = new JCheckBox();
        this.chbStructured.setEnabled(this.isEditable());
        this.chbStructured.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalDataPropertiesDialog.this.enableCtrls();
            }
        });
        this.chbStructured.setPreferredSize(this.lbName.getPreferredSize());
        jPanel = this.newRow(jLabel4, this.chbStructured);
        this.generalPanel.add(jPanel);
        JLabel jLabel5 = new JLabel(LB_REC_STRUCTURE);
        jLabel5.setPreferredSize(this.lbName.getPreferredSize());
        this.cbRecStructure = new JComboBox();
        this.cbRecStructure.setMaximumRowCount(20);
        this.cbRecStructure.setFont(this.cbType.getFont().deriveFont(0));
        this.cbRecStructure.setPreferredSize(this.lbName.getPreferredSize());
        this.cbRecStructure.setEnabled(this.isEditable());
        jPanel = this.newRow(jLabel5, this.cbRecStructure);
        this.generalPanel.add(jPanel);
        this.enableCtrls();
    }

    @Override
    protected String getHelpIndex() {
        return "EXTERNAL_DATA_PROPERTIES_DIALOG";
    }

    private Object[] getRecordStructures() {
        RecordStructure recordStructure = this.extData.getOwner();
        if (recordStructure == null) {
            return this.getDesignObject().getDesign().getProcessModel().getRecordStructureSet().toArray();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.getDesignObject().getDesign().getProcessModel().getRecordStructureSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == recordStructure) continue;
            arrayList.add(objectArray[i]);
        }
        return arrayList.toArray();
    }

    private void enableCtrls() {
        if (this.isEditable()) {
            boolean bl = this.chbStructured.isSelected();
            this.cbType.setEnabled(!bl);
            this.cbRecStructure.setEnabled(bl);
        }
    }

    @Override
    protected void setProperties() {
        this.extData.setName(this.tfName.getText());
        this.extData.setComment(this.getCommentField());
        this.extData.setStartingPos(this.ifStartingPos.getIntValue());
        this.extData.setDescription(this.tfDescription.getText());
        boolean bl = this.chbStructured.isSelected();
        this.extData.setStructured(bl);
        if (bl) {
            this.extData.setRecordStructure((RecordStructure)this.cbRecStructure.getSelectedItem());
        } else {
            this.extData.setType((LogicalDatatype)this.cbType.getSelectedItem());
        }
    }
}

