/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.JCharField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class AgentPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfSynonym;
    private JComboBox cbType;
    private List ifList;
    private JTable iftable;
    private JPanel pnIncomingFlows;
    private List ofList;
    private JPanel pnOutgoingFlows;
    private JTable oftable;
    private JPanel pnDataFile;
    private JPanel pnDataFileGrid;
    private JTextField tfOwner;
    private JTextField tfSource;
    private JTextField tfFileName;
    private JTextField tfLocation;
    private JComboBox cbFileType;
    private JCharField tfFieldSeparator;
    private JComboBox cbTransferType;
    private JCheckBox chSelfDescribing;
    private JIntegerField tfSkipRecords;
    private JCharField tfTextDelimiter;
    private JPanel pnDataElement;
    private ArrayList edList;
    private JTable edTable;
    private JButton btnDEProperties;
    private JButton btnDEAdd;
    private JButton btnDERemove;
    private ExternalAgent agent;
    private List newExtDatas;
    private List attrMWList = new ArrayList();
    private List edWList = new ArrayList();
    private List attributes;
    private static final String[] TYPES = new String[]{Messages.getString("AgentPropertiesDialogEx.OrganizationUnit"), Messages.getString("AgentPropertiesDialogEx.System"), Messages.getString("AgentPropertiesDialogEx.Role"), Messages.getString("AgentPropertiesDialogEx.Other")};

    public AgentPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_SYNOMYM);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.tfSynonym));
        JLabel jLabel2 = new JLabel(LB_TYPE);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox<String>(TYPES);
        this.cbType.setFont(this.cbType.getFont().deriveFont(0));
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.cbType));
    }

    @Override
    public String getCaption() {
        return Messages.getString("AgentPropertiesDialogEx.ExternalAgentProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof ExternalAgent) {
            this.agent = (ExternalAgent)designObject;
            this.initDefaults(false);
            this.tfSynonym.setText(this.agent.getSynonym());
            this.cbType.setSelectedIndex(this.agent.getType());
            this.tfObjectID.setText(this.agent.getObjectID());
            this.tfCreationTime.setText(this.agent.getCreationTime());
            this.tfCreator.setText(this.agent.getCreator().getName());
            this.tfDesign.setText(this.agent.getOwnerDesignName());
            if (this.agent.getGenerator() != null) {
                this.tfGeneratorName.setText(this.agent.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.agent.getChanger().getName());
            this.tfLastChangedTime.setText(this.agent.getChangeTime());
            this.ifList.addAll(this.agent.getIncomingFlows());
            this.ofList.addAll(this.agent.getOutgoingFlows());
            this.tfOwner.setText(this.agent.getOwner());
            this.tfSource.setText(this.agent.getSource());
            this.tfFileName.setText(this.agent.getFileName());
            this.tfLocation.setText(this.agent.getLocation());
            this.cbFileType.setSelectedItem(this.translate(this.agent.getFileType(), ExternalAgent.FILE_TYPES_INTERNAL, ExternalAgent.FILE_TYPES_DISPLAY));
            this.tfFieldSeparator.setText(this.agent.getFieldSeparator());
            this.cbTransferType.setSelectedItem(this.translate(this.agent.getTransferType(), ExternalAgent.TRANSFER_TYPES_INTERNAL, ExternalAgent.TRANSFER_TYPES_DISPLAY));
            this.chSelfDescribing.setSelected(this.agent.isSelfDescribing());
            this.tfSkipRecords.setValue((long)this.agent.getSkipRecords());
            this.tfTextDelimiter.setText(this.agent.getTextDelimiter());
            this.edList.addAll(this.agent.getExternalDatas());
            this.makeWrapperList();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.agent.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.agent.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.agent.setName(this.tfName.getText());
        this.agent.setComment(this.taComments.getText());
        this.agent.setSynonym(this.tfSynonym.getText());
        this.agent.setNotes(this.taNotes.getText());
        this.agent.setType(this.cbType.getSelectedIndex());
        this.agent.setOwner(this.tfOwner.getText());
        this.agent.setSource(this.tfSource.getText());
        this.agent.setFileName(this.tfFileName.getText());
        this.agent.setLocation(this.tfLocation.getText());
        this.agent.setFileType(this.translate((String)this.cbFileType.getSelectedItem(), ExternalAgent.FILE_TYPES_DISPLAY, ExternalAgent.FILE_TYPES_INTERNAL));
        this.agent.setFieldSeparator(this.tfFieldSeparator.getText());
        this.agent.setTransferType(this.translate((String)this.cbTransferType.getSelectedItem(), ExternalAgent.TRANSFER_TYPES_DISPLAY, ExternalAgent.TRANSFER_TYPES_INTERNAL));
        this.agent.setSelfDescribing(this.chSelfDescribing.isSelected());
        this.agent.setSkipRecords(this.tfSkipRecords.getIntValue());
        this.agent.setTextDelimiter(this.tfTextDelimiter.getText());
        for (Object object : this.agent.getExternalDatas()) {
            if (this.edList.contains(object)) continue;
            ((AbstractProcessObject)object).remove();
        }
        this.agent.getExternalDatas().clear();
        for (Object object : this.edList) {
            this.agent.addExternalData((ExternalData)object);
        }
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        AgentPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.agent.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.agent.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getIncomingFlowsPanel());
        this.addToTree(defaultMutableTreeNode, this.getOutgoingFlowsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDataFileSpecPanel());
        this.addToTree(defaultMutableTreeNode, this.getDataElementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasurementsPanel());
        this.addToTree(defaultMutableTreeNode, this.getChangeRequestsPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "EXTERNAL_AGENT_PROPERTIES_DIALOG";
    }

    private JPanel getIncomingFlowsPanel() {
        if (this.pnIncomingFlows == null) {
            this.pnIncomingFlows = this.createPage(Messages.getString("AgentPropertiesDialogEx.IncomingFlows"));
            this.ifList = new ArrayList();
            this.iftable = new JTable(new IncomingFlowsModel());
            this.iftable.setSelectionMode(0);
            this.iftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = AgentPropertiesDialogEx.this.iftable.getSelectedRow()) != -1 && AgentPropertiesDialogEx.this.ifList.size() > 0 && n < AgentPropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)AgentPropertiesDialogEx.this.ifList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.iftable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("AgentPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AgentPropertiesDialogEx.this.iftable.getSelectedRow();
                    if (n != -1 && AgentPropertiesDialogEx.this.ifList.size() > 0 && n < AgentPropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)AgentPropertiesDialogEx.this.ifList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnIncomingFlows.add(jPanel2);
        }
        return this.pnIncomingFlows;
    }

    private JPanel getOutgoingFlowsPanel() {
        if (this.pnOutgoingFlows == null) {
            this.pnOutgoingFlows = this.createPage(Messages.getString("AgentPropertiesDialogEx.OutgoingFlows"));
            this.ofList = new ArrayList();
            this.oftable = new JTable(new OutgoingFlowsModel());
            this.oftable.setSelectionMode(0);
            this.oftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = AgentPropertiesDialogEx.this.oftable.getSelectedRow()) != -1 && AgentPropertiesDialogEx.this.ofList.size() > 0 && n < AgentPropertiesDialogEx.this.ofList.size()) {
                        Flow flow = (Flow)AgentPropertiesDialogEx.this.ofList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.oftable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(Messages.getString("AgentPropertiesDialogEx.Properties"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AgentPropertiesDialogEx.this.oftable.getSelectedRow();
                    if (n != -1 && AgentPropertiesDialogEx.this.ofList.size() > 0 && n < AgentPropertiesDialogEx.this.ofList.size()) {
                        Flow flow = (Flow)AgentPropertiesDialogEx.this.ofList.get(n);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnOutgoingFlows.add(jPanel2);
        }
        return this.pnOutgoingFlows;
    }

    private JPanel getDataFileSpecPanel() {
        if (this.pnDataFile == null) {
            this.pnDataFile = this.createPage(Messages.getString("AgentPropertiesDialogEx.DataFileSpecification"));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.pnDataFileGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_OWNER);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfOwner = new JTextField();
            this.tfOwner.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel, this.tfOwner));
            JLabel jLabel2 = new JLabel(LB_SOURCE);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.tfSource = new JTextField();
            this.tfSource.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel2, this.tfSource));
            JLabel jLabel3 = new JLabel(LB_FILE_NAME);
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.tfFileName = new JTextField();
            this.tfFileName.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel3, this.tfFileName));
            JLabel jLabel4 = new JLabel(LB_LOCATION);
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.tfLocation = new JTextField();
            this.tfLocation.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel4, this.tfLocation));
            JLabel jLabel5 = new JLabel(LB_FILE_TYPE);
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.cbFileType = new JComboBox<String>(ExternalAgent.FILE_TYPES_DISPLAY);
            this.cbFileType.setFont(this.cbFileType.getFont().deriveFont(0));
            this.cbFileType.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel5, this.cbFileType));
            JLabel jLabel6 = new JLabel(LB_FIELD_SEPARATOR);
            jLabel6.setPreferredSize(this.getDefaultSize());
            this.tfFieldSeparator = new JCharField();
            this.tfFieldSeparator.setPreferredSize(new Dimension(20, 20));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setPreferredSize(new Dimension(30, 20));
            jPanel2.add((Component)this.tfFieldSeparator, "West");
            this.pnDataFileGrid.add(this.createRow(jLabel6, jPanel2));
            JLabel jLabel7 = new JLabel(LB_TRANSFER_TYPE);
            jLabel7.setPreferredSize(this.getDefaultSize());
            this.cbTransferType = new JComboBox<String>(ExternalAgent.TRANSFER_TYPES_DISPLAY);
            this.cbTransferType.setFont(this.cbTransferType.getFont().deriveFont(0));
            this.cbTransferType.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(jLabel7, this.cbTransferType));
            JLabel jLabel8 = new JLabel(LB_SELF_DESCRIBING);
            jLabel8.setPreferredSize(this.getDefaultSize());
            this.chSelfDescribing = new JCheckBox();
            this.pnDataFileGrid.add(this.createRow(jLabel8, this.chSelfDescribing));
            JLabel jLabel9 = new JLabel(LB_SKIP_RECORDS);
            jLabel9.setPreferredSize(this.getDefaultSize());
            this.tfSkipRecords = new JIntegerField();
            this.tfSkipRecords.setPreferredSize(new Dimension(20, 20));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setPreferredSize(new Dimension(30, 20));
            jPanel3.add((Component)this.tfSkipRecords, "West");
            this.pnDataFileGrid.add(this.createRow(jLabel9, jPanel3));
            JLabel jLabel10 = new JLabel(LB_TEXT_DELIMITER);
            jLabel10.setPreferredSize(this.getDefaultSize());
            this.tfTextDelimiter = new JCharField();
            this.tfTextDelimiter.setPreferredSize(new Dimension(20, 20));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setPreferredSize(new Dimension(20, 20));
            jPanel4.add((Component)this.tfTextDelimiter, "West");
            this.pnDataFileGrid.add(this.createRow(jLabel10, jPanel4));
            jPanel.add((Component)this.pnDataFileGrid, "North");
            this.pnDataFile.add((Component)jPanel, "Center");
        }
        return this.pnDataFile;
    }

    private JPanel getDataElementsPanel() {
        if (this.pnDataElement == null) {
            this.pnDataElement = this.createPage(Messages.getString("AgentPropertiesDialogEx.DataElements"));
            this.edList = new ArrayList();
            this.newExtDatas = new ArrayList();
            this.edTable = new JTable(new ExternalDataModel());
            this.edTable.setSelectionMode(0);
            this.edTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = AgentPropertiesDialogEx.this.edTable.getSelectedRow()) > -1 && AgentPropertiesDialogEx.this.edList.size() > 0 && n < AgentPropertiesDialogEx.this.edList.size()) {
                        ExternalData externalData = (ExternalData)AgentPropertiesDialogEx.this.edList.get(n);
                        externalData.showModal = ((AgentPropertiesDialogEx)AgentPropertiesDialogEx.this).agent.showModal || AgentPropertiesDialogEx.this.agent.showForFirstTime();
                        externalData.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.edTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnDEProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnDEProperties.setToolTipText(BTN_PROPERTIES);
            this.btnDEProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AgentPropertiesDialogEx.this.edTable.getSelectedRow();
                    if (n > -1 && AgentPropertiesDialogEx.this.edList.size() > 0 && n < AgentPropertiesDialogEx.this.edList.size()) {
                        ExternalData externalData = (ExternalData)AgentPropertiesDialogEx.this.edList.get(n);
                        externalData.showModal = ((AgentPropertiesDialogEx)AgentPropertiesDialogEx.this).agent.showModal || AgentPropertiesDialogEx.this.agent.showForFirstTime();
                        externalData.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnDEProperties);
            if (this.isEditable()) {
                this.btnDEAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnDEAdd.setToolTipText(BTN_ADD);
                this.btnDEAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExternalData externalData = AgentPropertiesDialogEx.this.agent.getDesign().getProcessModel().createExternalData();
                        externalData.setType(AgentPropertiesDialogEx.this.agent.getDesign().getDomainSet().getDefaultDomain().getLogicalDatatype());
                        AgentPropertiesDialogEx.this.newExtDatas.add(externalData);
                        AgentPropertiesDialogEx.this.edList.add(externalData);
                        AgentPropertiesDialogEx.this.edTable.updateUI();
                    }
                });
                this.btnDERemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnDERemove.setToolTipText(BTN_REMOVE);
                this.btnDERemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = AgentPropertiesDialogEx.this.edTable.getSelectedRow();
                        if (n != -1 && AgentPropertiesDialogEx.this.edList.size() > 0 && n < AgentPropertiesDialogEx.this.edList.size()) {
                            AgentPropertiesDialogEx.this.edList.remove(n);
                            AgentPropertiesDialogEx.this.edTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnDEAdd);
                jToolBar.add(this.btnDERemove);
            }
            jPanel.add(jToolBar);
            jScrollPane.setPreferredSize(new Dimension(325, 300));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnDataElement.add(jPanel2);
        }
        return this.pnDataElement;
    }

    private void makeWrapperList() {
        this.attrMWList.clear();
        this.edWList.clear();
        this.attributes = this.agent.getAttributes();
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            this.attrMWList.add(new DesignObjectWrapper((DesignObject)iterator.next()));
        }
        for (int i = 0; i < this.edList.size(); ++i) {
            ExternalData externalData = (ExternalData)this.edList.get(i);
            this.edWList.add(i, this.getWrapper(externalData, this.attrMWList));
        }
    }

    private DesignObjectWrapper getWrapper(ExternalData externalData, List list) {
        Iterator iterator = list.iterator();
        DesignObject designObject = externalData.getMappedDesignObject();
        while (iterator.hasNext()) {
            DesignObjectWrapper designObjectWrapper = (DesignObjectWrapper)iterator.next();
            if (designObject != designObjectWrapper.getDesignObject()) continue;
            return designObjectWrapper;
        }
        return null;
    }

    @Override
    protected int getMinimumHeight() {
        return 440;
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 200;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    public class DesignObjectWrapper {
        DesignObject dobject;

        public DesignObjectWrapper(DesignObject designObject) {
            this.dobject = designObject;
        }

        public DesignObject getDesignObject() {
            return this.dobject;
        }

        public String toString() {
            if (this.dobject != null) {
                return this.dobject.getLongName();
            }
            return "";
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return AgentPropertiesDialogEx.this.edList.size();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Messages.getString("AgentPropertiesDialogEx.ExternalDatas");
                }
                case 1: {
                    return Messages.getString("AgentPropertiesDialogEx.Type");
                }
                case 2: {
                    return Messages.getString("AgentPropertiesDialogEx.StartingPosition");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ExternalData externalData = (ExternalData)AgentPropertiesDialogEx.this.edList.get(n);
            switch (n2) {
                case 0: {
                    return externalData.getName();
                }
                case 1: {
                    if (externalData.isStructured()) {
                        return externalData.getRecordStructure() != null ? externalData.getRecordStructure().getName() : "";
                    }
                    return externalData.getType();
                }
                case 2: {
                    return Integer.toString(externalData.getStartingPos());
                }
            }
            return new Integer(n * n2);
        }
    }

    private class OutgoingFlowsModel
    extends AbstractTableModel {
        private OutgoingFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AgentPropertiesDialogEx.this.ofList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AgentPropertiesDialogEx.OutgoingFlows");
            }
            if (n == 1) {
                return Messages.getString("AgentPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Flow flow = (Flow)AgentPropertiesDialogEx.this.ofList.get(n);
            if (n2 == 0) {
                return flow.getName();
            }
            if (n2 == 1) {
                return flow.getSynonym();
            }
            return new Integer(n * n2);
        }
    }

    private class IncomingFlowsModel
    extends AbstractTableModel {
        private IncomingFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AgentPropertiesDialogEx.this.ifList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AgentPropertiesDialogEx.IncomingFlows");
            }
            if (n == 1) {
                return Messages.getString("AgentPropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Flow flow = (Flow)AgentPropertiesDialogEx.this.ifList.get(n);
            if (n2 == 0) {
                return flow.getName();
            }
            if (n2 == 1) {
                return flow.getSynonym();
            }
            return new Integer(n * n2);
        }
    }
}

