/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AddStructureDialog
extends JDialog
implements AbstractEditorConstants {
    private DesignPart designPart;
    private List sList;
    private JPanel generalPanel;
    private List allList = new ArrayList();
    private JTable allTable;
    private JRadioButton rbNew;
    private JRadioButton rbAll;

    public AddStructureDialog(ApplicationView applicationView, DesignPart designPart, List list) {
        super(applicationView.getFrame());
        this.setModal(true);
        this.designPart = designPart;
        this.sList = list;
        this.setTitle(Messages.getString("AddStructureDialog.AddInformationStructure"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddStructureDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddStructureDialog.SelectStructure")));
        RadioListener radioListener = new RadioListener();
        this.rbNew = new JRadioButton(Messages.getString("AddStructureDialog.NewInformationStructure"));
        this.rbNew.addActionListener(radioListener);
        this.rbNew.setMnemonic(78);
        this.rbAll = new JRadioButton(Messages.getString("AddStructureDialog.AvailableInformationStructure"));
        this.rbAll.addActionListener(radioListener);
        this.rbAll.setMnemonic(65);
        this.rbNew.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNew);
        buttonGroup.add(this.rbAll);
        jPanel.add(this.rbNew);
        jPanel.add(this.rbAll);
        this.generalPanel.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddStructureDialog.AllInformationStructures")));
        this.allList.addAll(this.getAllStructures());
        this.allTable = new JTable(new AllStructuresModel());
        this.allTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.allTable);
        jScrollPane.setPreferredSize(new Dimension(240, 220));
        jPanel2.add(jScrollPane);
        this.generalPanel.add(jPanel2);
        this.enableControls(!this.rbNew.isSelected());
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setPreferredSize(jButton2.getPreferredSize());
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void enableControls(boolean bl) {
        this.allTable.setEnabled(bl);
        this.allTable.clearSelection();
        if (!bl) {
            this.allTable.setBackground(Color.LIGHT_GRAY);
        } else {
            this.allTable.setBackground(Color.WHITE);
        }
    }

    private ProcessModel getProcessModel() {
        return this.designPart.getDesign().getProcessModel();
    }

    private List getAllStructures() {
        ArrayList<InfoStructure> arrayList = new ArrayList<InfoStructure>();
        int n = this.getProcessModel().getInfoStructureSet().size();
        for (int i = 0; i < n; ++i) {
            InfoStructure infoStructure = (InfoStructure)this.getProcessModel().getInfoStructureSet().getElement(i);
            if (this.sList.contains(infoStructure)) continue;
            arrayList.add(infoStructure);
        }
        return arrayList;
    }

    public void centerOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jDialog.setLocation(point);
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddStructureDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AddStructureDialog.this.rbNew.isSelected()) {
                InfoStructure infoStructure = AddStructureDialog.this.getProcessModel().createInfoStructure();
                AddStructureDialog.this.sList.add(infoStructure);
            } else {
                int n = AddStructureDialog.this.allTable.getSelectedRow();
                if (n != -1 && AddStructureDialog.this.allList.size() > 0 && n < AddStructureDialog.this.allList.size()) {
                    InfoStructure infoStructure = (InfoStructure)AddStructureDialog.this.allList.get(n);
                    AddStructureDialog.this.sList.add(infoStructure);
                }
            }
            AddStructureDialog.this.dispose();
        }
    }

    private class AllStructuresModel
    extends AbstractTableModel {
        private AllStructuresModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AddStructureDialog.this.allList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("AddStructureDialog.InformationStructures");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            InfoStructure infoStructure = (InfoStructure)AddStructureDialog.this.allList.get(n);
            if (n2 == 0) {
                return infoStructure.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddStructureDialog.this.enableControls(!AddStructureDialog.this.rbNew.isSelected());
        }
    }
}

