/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.PresummarizedLevelsDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;
import oracle.ide.Ide;

public class SlicePropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Slice slice;
    private JCheckBox chReadOnly;
    private JComboBox cbEntity;
    private JCheckBox chFullyRealized;
    private JTable levelsTable;
    private JTable attributesTable;
    private List levelsList;
    private JTable scTable;
    private List scList;
    private List selectedMeasureWrappers;
    private List allMeasureWrappers;
    private List selectedLevels;
    private List selectedAttributes;
    private List allDimensions;
    private ContainerObject newEntity;
    private List usedFactEntities;
    private List aggrEntities;
    private StringBuffer sb;
    private StringBuffer eb;
    private boolean error = false;
    private boolean quote = false;
    private boolean aggrFirst;
    private final String indent = "   ";
    private final String tpref = "T";
    private boolean usePrefix = true;
    String quoteStr = "";
    private JTextField tfEntityName;
    private JButton bnNewEntity;
    private JTable smTable;
    private List smList;
    private JComboBox cbTypes;
    private JTextArea selPane;
    private JTabbedPane tab;
    private JTextField tfSchema;
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private String schema = "";
    private RelationalDesign physDesign;
    private StorageDesign storDesign;
    private JCheckBox aggrCB;
    private JCheckBox quoteCB;
    List measureDependencies;
    boolean cyclicRef = false;
    private List sortedMeasures;
    private List tracedMeasures;
    private Map entMap;
    private List links;
    private List factPrefs;
    private List factRefs;
    private List factJoins;
    private List additonalTables;
    private List foreignKeys;
    private JPanel pnMeasures;
    private JButton btnProperties;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnSummaryLevels;
    private JButton btnAddSL;
    private JButton btnRemoveSL;
    private JTable sTable;
    private JPanel pnDimensions;
    private JPanel pnSelAttributes;
    private JPanel pnMapping;
    private JPanel pnQuery;
    private List rlist;
    private JPanel pnCriteria;
    private JPanel pnOracleAW;
    private List sqlList;
    private JTable sqlTable;
    private List newSQLList;

    public SlicePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public SlicePropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SlicePropertiesDialogEx.SliceProperties");
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_READ_ONLY);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.chReadOnly = new JCheckBox();
        this.chReadOnly.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.chReadOnly));
        JLabel jLabel2 = new JLabel(LB_FULLY_REALIZED);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chFullyRealized = new JCheckBox();
        this.chFullyRealized.setPreferredSize(this.getDefaultSize());
        this.chFullyRealized.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SlicePropertiesDialogEx.this.enableControls();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chFullyRealized));
        JLabel jLabel3 = new JLabel(LB_ENTITY);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbEntity = new JComboBox();
        this.cbEntity.setPreferredSize(this.getDefaultSize());
        this.cbEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SlicePropertiesDialogEx.this.enableSliceMappingsControls(SlicePropertiesDialogEx.this.cbEntity.getSelectedItem() == null);
                SlicePropertiesDialogEx.this.updateSliceMappings();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbEntity));
    }

    @Override
    protected String getHelpIndex() {
        return "SLICE_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Slice) {
            this.slice = (Slice)designObject;
            this.initDefaults(false);
            this.taDescription.setText(this.slice.getDescription());
            this.copySelectedLevels(this.slice.getSelectedLevels());
            this.makeSelectedAttributes();
            this.allDimensions.addAll(this.slice.getCube().getDimensions());
            this.chReadOnly.setSelected(this.slice.isReadOnlySlice());
            this.chFullyRealized.setSelected(this.slice.isFullyRealized());
            this.slice.verifyMeasureWrappers();
            this.selectedMeasureWrappers.addAll(this.slice.getSelectedMeasureWrappers());
            this.allMeasureWrappers.addAll(this.slice.getAllMeasureWrappers());
            this.fillComboItems(this.slice.getDesign().getLogicalDesign().getEntitySet().toArray(), this.cbEntity, true);
            this.cbEntity.setSelectedItem(this.slice.getEntity());
            this.levelsList.addAll(this.slice.getLevels());
            this.rlist = new ArrayList();
            this.slice.getDesign().getRelationalDesigns().addAllElementsTo(this.rlist);
            this.fillComboItems(this.rlist.toArray(), this.cbRelDes, true);
            if (this.rlist.size() > 0) {
                this.cbRelDes.setSelectedItem(this.rlist.get(0));
            }
            this.scList.addAll(this.slice.getSelectionCriterias());
            this.sqlList.addAll(this.slice.getSQLDefinitions());
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.makeQuery();
            this.enableControls();
            this.updateSliceMappings();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.slice.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.slice.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private List getMappings() {
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        for (Object object : this.selectedAttributes) {
            if (!((SelObject)object).selected) continue;
            arrayList.add(((SelObject)object).object);
        }
        for (Object object : this.selectedMeasureWrappers) {
            arrayList.add(((Slice.MeasureWrapper)object).getMeasure());
        }
        return arrayList;
    }

    private DesignObject getMapping(ContainedObject containedObject) {
        for (Slice.SliceMapping sliceMapping : this.slice.getSliceMappings()) {
            if (sliceMapping.getAttribute() != containedObject) continue;
            return sliceMapping.getMapping();
        }
        return null;
    }

    private void updateSliceMappings() {
        this.smList.clear();
        for (int i = ((DefaultTableModel)this.smTable.getModel()).getRowCount() - 1; i >= 0; --i) {
            ((DefaultTableModel)this.smTable.getModel()).removeRow(i);
        }
        if (this.cbEntity.getSelectedItem() != null) {
            ContainerObject containerObject = (ContainerObject)this.cbEntity.getSelectedItem();
            for (int i = 0; i < containerObject.getElements().length; ++i) {
                Attribute attribute = (Attribute)containerObject.getElement(i);
                DesignObject designObject = this.getMapping(attribute);
                Slice slice = this.slice;
                slice.getClass();
                this.smList.add(slice.new Slice.SliceMapping(attribute, designObject));
            }
        }
        for (Slice.SliceMapping sliceMapping : this.smList) {
            ((DefaultTableModel)this.smTable.getModel()).addRow(new Object[]{sliceMapping.getAttribute().getLongName(), sliceMapping.getMapping()});
        }
        this.smTable.updateUI();
    }

    private void enableControls() {
        this.enableSliceMappingsControls(this.cbEntity.getSelectedItem() == null);
    }

    private void enableSliceMappingsControls(boolean bl) {
        if (this.tfEntityName != null) {
            this.tfEntityName.setEnabled(this.isEditable() ? bl : false);
        }
        if (this.bnNewEntity != null) {
            this.bnNewEntity.setEnabled(this.isEditable() ? bl : false);
        }
    }

    private void sortMeasures(List list) {
        this.sortedMeasures.clear();
        this.tracedMeasures.clear();
        this.cyclicRef = false;
        this.measureDependencies = this.getMeasureDependencies(list);
        for (Measure measure : list) {
            this.addToSorted(measure);
            if (!this.cyclicRef) continue;
            return;
        }
    }

    private void addToSorted(Measure measure) {
        if (this.sortedMeasures.contains(measure)) {
            return;
        }
        MeasureDependence measureDependence = this.getMeasureDependence(measure, this.measureDependencies);
        if (measureDependence == null) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        if (measureDependence.dependOn.size() == 0) {
            this.sortedMeasures.add(measure);
            this.tracedMeasures.add(measure);
            return;
        }
        this.tracedMeasures.add(measure);
        for (Measure measure2 : measureDependence.dependOn) {
            if (this.tracedMeasures.contains(measure2) && !this.sortedMeasures.contains(measure2)) {
                this.cyclicRef = true;
                String string = "\"" + measure2.getCube().getName() + "\"" + "." + "\"" + measure2.getName() + "\"";
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.CyclicReferenceForMeasureP"), string), Messages.getString("SlicePropertiesDialogEx.ListOfMeasuresWillNotBeComplete"), 0, 0, null, new String[]{Messages.getString("SlicePropertiesDialogEx.Ok")}, Messages.getString("SlicePropertiesDialogEx.Ok"));
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.CyclicReferenceForMeasure")).append(string);
                return;
            }
            if (this.sortedMeasures.contains(measure2)) continue;
            this.addToSorted(measure2);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedMeasures.add(measure);
    }

    private MeasureDependence getMeasureDependence(Measure measure, List list) {
        for (MeasureDependence measureDependence : list) {
            if (measureDependence.measure != measure) continue;
            return measureDependence;
        }
        return null;
    }

    private List getMeasureDependencies(List list) {
        ArrayList<MeasureDependence> arrayList = new ArrayList<MeasureDependence>();
        for (Measure measure : list) {
            MeasureDependence measureDependence = new MeasureDependence(measure);
            if (!measure.isFormula()) {
                arrayList.add(measureDependence);
                continue;
            }
            String string = measure.getFormula();
            for (Measure measure2 : list) {
                String string2;
                if (measure2 == measure || string.indexOf(string2 = "\"" + measure2.getName().trim() + "\"") <= -1) continue;
                measureDependence.dependOn.add(measure2);
            }
            arrayList.add(measureDependence);
        }
        return arrayList;
    }

    private void makeQuery() {
        this.physDesign = (RelationalDesign)this.cbRelDes.getSelectedItem();
        this.storDesign = (StorageDesign)this.cbStorage.getSelectedItem();
        this.aggrFirst = this.aggrCB.isSelected();
        this.quote = this.quoteCB.isSelected();
        this.error = false;
        this.quoteStr = this.quote ? "\"" : "";
        this.schema = this.tfSchema.getText();
        this.sb.setLength(0);
        this.eb.setLength(0);
        this.sb.append("Select ");
        this.sortMeasures(this.slice.getCube().getMeasures());
        if (!this.cyclicRef) {
            this.checkMeasures();
            this.makeTablesMapAndLinks();
            this.processMeasures("   ", this.aggrFirst);
            this.processSelectedAttributes(true);
            this.sb.append("\nFrom");
            this.addTables();
            this.addWhereClause();
            this.sb.append("\nGroup By");
            this.processSelectedAttributes(false);
        }
        if (this.error) {
            this.selPane.setText(this.eb.toString());
        } else {
            this.selPane.setText(this.sb.toString());
        }
    }

    private int testForMeasure(ContainerObject containerObject, List list) {
        Iterator iterator = this.selectedMeasureWrappers.iterator();
        boolean bl = false;
        list.clear();
        while (iterator.hasNext()) {
            Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)iterator.next();
            List list2 = measureWrapper.getMeasure().getFactEntities();
            if (!list2.contains(containerObject)) continue;
            list.add(measureWrapper.getMeasure());
            if (list2.size() <= 1) continue;
            bl = true;
        }
        if (list.size() > 0) {
            if (bl) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ModelIDObject getCorrespondentObject(DesignObject designObject) {
        if (this.storDesign != null) {
            if (designObject instanceof Entity) {
                Table table = ((Entity)designObject).getEngTable(this.physDesign);
                if (table != null) return (TableProxy)this.storDesign.getTableProxySet().getProxy(table.getObjectID());
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingTableForEntity")).append(designObject.getName());
                return designObject;
            } else if (designObject instanceof EntityView) {
                TableView tableView = ((EntityView)designObject).getEngTableView(this.physDesign);
                if (this.tab != null) return (TableViewProxy)this.storDesign.getTableViewProxySet().getProxy(tableView.getObjectID());
                this.error = true;
                this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingTableViewForEntityView"), designObject.getName()));
                return designObject;
            } else if (designObject instanceof Attribute) {
                Column column = ((Attribute)designObject).getEngColumn(this.physDesign);
                if (column != null) return this.storDesign.getColumnProxySet().getProxy(column.getObjectID());
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingColumnForAttribute")).append(designObject.getLongName());
                return designObject;
            } else {
                if (!(designObject instanceof AttributeView)) return designObject;
                ColumnView columnView = ((AttributeView)designObject).getEngColumnView(this.physDesign);
                if (columnView != null) return columnView;
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingcolumnViewForAttributeView")).append(designObject.getLongName());
            }
            return designObject;
        } else {
            if (designObject instanceof Entity) {
                Table table = ((Entity)designObject).getEngTable(this.physDesign);
                if (table != null) return table;
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingTableForEntity")).append(designObject.getName());
                return designObject;
            }
            if (designObject instanceof EntityView) {
                TableView tableView = ((EntityView)designObject).getEngTableView(this.physDesign);
                if (tableView != null) return tableView;
                this.error = true;
                this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingTableViewForEntityView"), designObject.getName()));
                return designObject;
            }
            if (designObject instanceof Attribute) {
                Column column = ((Attribute)designObject).getEngColumn(this.physDesign);
                if (column != null) return column;
                this.error = true;
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingColumnForAttribute")).append(designObject.getLongName());
                return designObject;
            }
            if (!(designObject instanceof AttributeView)) return designObject;
            ColumnView columnView = ((AttributeView)designObject).getEngColumnView(this.physDesign);
            if (columnView != null) return columnView;
            this.error = true;
            this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoCorrespondingcolumnViewForAttributeView")).append(designObject.getLongName());
            return designObject;
        }
    }

    private String getSchema(ModelIDObject modelIDObject) {
        if (modelIDObject instanceof TableProxy) {
            TableProxy tableProxy = (TableProxy)modelIDObject;
            StorageObject storageObject = tableProxy.getUserSchema();
            if (storageObject != null) {
                return storageObject.getName();
            }
            String string = tableProxy.getSchemaImplementationName();
            if (!"".equals(string)) {
                return string;
            }
        }
        return this.schema;
    }

    private String factPref(ContainerObject containerObject) {
        Object v = this.entMap.get(containerObject.getName());
        if (v == null) {
            return "";
        }
        return (String)v;
    }

    private void processFactEntities() {
        this.aggrEntities.clear();
        this.usePrefix = false;
        if (!this.aggrFirst) {
            boolean bl = true;
            for (ContainerObject containerObject : this.slice.getCube().getFactEntities()) {
                ModelIDObject modelIDObject;
                ArrayList arrayList;
                int n = this.testForMeasure(containerObject, arrayList = new ArrayList());
                if (n <= -1 || (modelIDObject = this.getCorrespondentObject(containerObject)) == null) continue;
                String string = this.getSchema(modelIDObject);
                if (string != null && !"".equalsIgnoreCase(string)) {
                    if (bl) {
                        this.sb.append("\n   ").append(this.quoteStr + string + this.quoteStr + ".").append(this.quoteStr + modelIDObject.getName() + this.quoteStr).append(" " + this.factPref(containerObject));
                        bl = false;
                        continue;
                    }
                    this.sb.append(",\n   ").append(this.quoteStr + string + this.quoteStr + ".").append(this.quoteStr + modelIDObject.getName() + this.quoteStr).append(" " + this.factPref(containerObject));
                    continue;
                }
                if (bl) {
                    this.sb.append("\n   ").append(modelIDObject.getName()).append(" " + this.factPref(containerObject));
                    bl = false;
                    continue;
                }
                this.sb.append(",\n   ").append(modelIDObject.getName()).append(" " + this.factPref(containerObject));
            }
        } else {
            boolean bl = true;
            Iterator iterator = this.slice.getCube().getFactEntities().iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                ModelIDObject modelIDObject;
                ContainerObject containerObject = (ContainerObject)iterator.next();
                int n = this.testForMeasure(containerObject, arrayList);
                if (n == 1) {
                    ModelIDObject modelIDObject2 = this.getCorrespondentObject(containerObject);
                    if (modelIDObject2 == null) continue;
                    String string = this.getSchema(modelIDObject2);
                    if (string != null && !"".equalsIgnoreCase(string)) {
                        if (bl) {
                            this.sb.append("\n   ").append(this.quoteStr + string + this.quoteStr + ".").append(this.quoteStr + modelIDObject2.getName() + this.quoteStr).append(" " + this.factPref(containerObject));
                            bl = false;
                            continue;
                        }
                        this.sb.append(",\n   ").append(this.quoteStr + string + this.quoteStr + ".").append(this.quoteStr + modelIDObject2.getName() + this.quoteStr).append(" " + this.factPref(containerObject));
                        continue;
                    }
                    if (bl) {
                        this.sb.append("\n   ").append(modelIDObject2.getName()).append(" " + this.factPref(containerObject));
                        bl = false;
                        continue;
                    }
                    this.sb.append(",\n   ").append(modelIDObject2.getName()).append(" " + this.factPref(containerObject));
                    continue;
                }
                if (n != 0) continue;
                this.aggrEntities.add(containerObject);
                if (bl) {
                    this.sb.append("\n   (\n").append("   ").append("Select ");
                    bl = false;
                } else {
                    this.sb.append(",\n   (\n").append("   ").append("Select ");
                }
                this.processMeasures("      ", false, arrayList, containerObject);
                this.processLinksToDimensions("      ", this.factRefs, containerObject);
                if (containerObject != null && (modelIDObject = this.getCorrespondentObject(containerObject)) != null) {
                    String string = this.getSchema(modelIDObject);
                    if (string != null && !"".equalsIgnoreCase(string)) {
                        this.sb.append("\n").append("   ").append("From ").append(this.quoteStr + string + this.quoteStr + ".").append(this.quoteStr + modelIDObject.getName() + this.quoteStr);
                    } else {
                        this.sb.append("\n").append("   ").append("From ").append(this.quoteStr + modelIDObject.getName() + this.quoteStr);
                    }
                }
                this.sb.append("\n").append("   ").append("Group By ");
                boolean bl2 = true;
                for (int i = 0; i < this.factRefs.size(); ++i) {
                    ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator;
                    Object e = this.factRefs.get(i);
                    if (e instanceof Slice.MeasureWrapper) {
                        iD_ObjectPropertyTranslator = (Slice.MeasureWrapper)e;
                        String string = this.getMeasureExpression(((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure());
                        if (bl2) {
                            this.sb.append("\n").append("      ").append(string);
                            bl2 = false;
                            continue;
                        }
                        this.sb.append(",\n").append("      ").append(string);
                        continue;
                    }
                    iD_ObjectPropertyTranslator = this.getCorrespondentObject((DesignObject)e);
                    if (iD_ObjectPropertyTranslator == null) continue;
                    if (bl2) {
                        this.sb.append("\n").append("      ").append(this.quoteStr + ((ModelObject)((Object)iD_ObjectPropertyTranslator)).getName() + this.quoteStr);
                        bl2 = false;
                        continue;
                    }
                    this.sb.append(",\n").append("      ").append(this.quoteStr + ((ModelObject)((Object)iD_ObjectPropertyTranslator)).getName() + this.quoteStr);
                }
                this.sb.append("\n   ) " + this.factPref(containerObject));
            }
        }
        this.usePrefix = true;
    }

    private void processLinksToDimensions(String string, List list, ContainerObject containerObject) {
        Object object;
        Object object2;
        list.clear();
        boolean bl = true;
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : this.selectedMeasureWrappers) {
            if (!((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().isNonAdditive() || ((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().getFactEntity() != containerObject) continue;
            list.add(iD_ObjectPropertyTranslator);
            if (!bl) {
                this.sb.append(",");
            } else {
                bl = false;
            }
            object2 = this.getMeasureExpression(((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure());
            object2 = (String)object2 + " AS \"" + ((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().getName() + "\"";
            this.sb.append("\n").append(string).append((String)object2);
        }
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : this.selectedLevels) {
            if (((Slice.SelectedLevel)iD_ObjectPropertyTranslator).rollupLink != null) {
                if (containerObject != ((Slice.SelectedLevel)iD_ObjectPropertyTranslator).rollupLink.getFactEntity()) continue;
                list.addAll(((Slice.SelectedLevel)iD_ObjectPropertyTranslator).rollupLink.getChildToParentAttributes());
                continue;
            }
            object2 = ((Slice.SelectedLevel)iD_ObjectPropertyTranslator).getDimension();
            object = this.slice.getCube().getFirstLinkToTarget((AbstractMDObject)object2);
            if (object == null || containerObject != ((Link)object).getRollupLink().getFactEntity()) continue;
            list.addAll(((Link)object).getRollupLink().getChildToParentAttributes());
        }
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : this.factJoins) {
            boolean bl2 = false;
            object = null;
            if (((FactEntitiesJoin)iD_ObjectPropertyTranslator).getLeftEntity() == containerObject) {
                bl2 = true;
                object = ((FactEntitiesJoin)iD_ObjectPropertyTranslator).getLeftAttributes();
            } else if (((FactEntitiesJoin)iD_ObjectPropertyTranslator).getRightEntity() == containerObject) {
                bl2 = true;
                object = ((FactEntitiesJoin)iD_ObjectPropertyTranslator).getRightAttributes();
            }
            if (!bl2) continue;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DesignObject designObject = (DesignObject)iterator.next();
                if (list.contains(designObject)) continue;
                list.add(designObject);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            ModelIDObject modelIDObject;
            if (list.get(i) instanceof Slice.MeasureWrapper || (modelIDObject = this.getCorrespondentObject((DesignObject)list.get(i))) == null) continue;
            if (bl) {
                this.sb.append("\n").append(string).append(this.quoteStr + modelIDObject.getName() + this.quoteStr);
                bl = false;
                continue;
            }
            this.sb.append(",\n").append(string).append(this.quoteStr + modelIDObject.getName() + this.quoteStr);
        }
    }

    private void processMeasures(String string, boolean bl, List list, ContainerObject containerObject) {
        boolean bl2 = true;
        for (Slice.MeasureWrapper measureWrapper : this.selectedMeasureWrappers) {
            if (measureWrapper.getMeasure().isFactDimension() || !list.contains(measureWrapper.getMeasure())) continue;
            this.processMeasure(measureWrapper, bl, !bl2, string);
            bl2 = false;
        }
    }

    private String getMeasureExpression(Measure measure) {
        Cube cube = measure.getCube();
        String string = measure.getFormula();
        if (!measure.isFormula()) {
            if (measure.getMeasureFact() != null) {
                ContainedObject containedObject = measure.getMeasureFact();
                ModelIDObject modelIDObject = this.getCorrespondentObject(containedObject);
                ContainerObject containerObject = containedObject.getContainer();
                if (this.usePrefix) {
                    return this.factPref(containerObject) + "." + this.quoteStr + modelIDObject.getName() + this.quoteStr;
                }
                return this.quoteStr + modelIDObject.getName() + this.quoteStr;
            }
            this.error = true;
            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.FactAttributeNotAssignedForMeasure"), measure.getName()));
            return "";
        }
        if (cube.getFactEntities().size() > 0) {
            String string2;
            ModelIDObject modelIDObject;
            Object object;
            Object object2;
            Object object3;
            for (Object object4 : cube.getFactEntities()) {
                Object object5 = ((ContainerObject)object4).getElementsCollection();
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = (ContainedObject)object3.next();
                    object = "\"" + ((ContainedObject)object2).getLongName().trim() + "\"";
                    if (string.indexOf((String)object) > -1) {
                        modelIDObject = this.getCorrespondentObject((DesignObject)object2);
                        string2 = this.usePrefix ? this.factPref((ContainerObject)object4) + "." + this.quoteStr + modelIDObject.getName().trim() + this.quoteStr : this.quoteStr + modelIDObject.getName().trim() + this.quoteStr;
                        string = this.replace(string, (String)object, string2);
                        continue;
                    }
                    object = "\"" + ((ContainedObject)object2).getName().trim() + "\"";
                    if (string.indexOf((String)object) <= -1) continue;
                    modelIDObject = this.getCorrespondentObject((DesignObject)object2);
                    string2 = this.usePrefix ? this.factPref((ContainerObject)object4) + "." + this.quoteStr + modelIDObject.getName().trim() + this.quoteStr : this.quoteStr + modelIDObject.getName().trim() + this.quoteStr;
                    string = this.replace(string, (String)object, string2);
                }
            }
            for (Object object5 : cube.getMeasures()) {
                if (object5 == measure || string.indexOf((String)(object3 = "\"" + ((DesignObject)object5).getName().trim() + "\"")) <= -1) continue;
                if (!((Measure)object5).isFormula()) {
                    if (((Measure)object5).getMeasureFact() != null) {
                        object2 = ((Measure)object5).getMeasureFact();
                        object = ((ContainedObject)object2).getContainer();
                        modelIDObject = this.getCorrespondentObject((DesignObject)object2);
                        string2 = this.usePrefix ? this.factPref((ContainerObject)object) + "." + this.quoteStr + modelIDObject.getName().trim() + this.quoteStr : this.quoteStr + modelIDObject.getName().trim() + this.quoteStr;
                        string = this.replace(string, (String)object3, string2);
                        continue;
                    }
                    this.error = true;
                    this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.FactAttributeNotAssignedForMeasure"), measure.getName()));
                    continue;
                }
                object2 = "(" + this.getMeasureExpression((Measure)object5) + ")";
                string = this.replace(string, (String)object3, (String)object2);
            }
        } else {
            this.error = true;
            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.FactEntityNotAssignedForCube"), cube.getName()));
        }
        return string;
    }

    private String replace(String string, String string2, String string3) {
        String string4 = string2.trim();
        String string5 = string;
        int n = string5.indexOf(string4);
        int n2 = string4.length();
        while (n > -1) {
            String string6 = n == 0 ? "" : string5.substring(0, n);
            int n3 = string6.length() + string3.length();
            string5 = string6 + string3 + string5.substring(n + n2);
            n = string5.indexOf(string4, n3);
        }
        return string5;
    }

    private void processMeasure(Slice.MeasureWrapper measureWrapper, boolean bl, boolean bl2, String string) {
        String string2 = bl ? (this.usePrefix && measureWrapper.getMeasure().getFactEntity() != null ? this.factPref(measureWrapper.getMeasure().getFactEntity()) + ".\"" + measureWrapper.getMeasureAlias() + "\"" : "\"" + measureWrapper.getMeasureAlias() + "\"") : this.getMeasureExpression(measureWrapper.getMeasure());
        string2 = measureWrapper.getFunctionName() + "(" + string2 + ") AS " + "\"" + measureWrapper.getMeasureAlias() + "\" ,";
        this.sb.append("\n").append(string).append(string2);
    }

    private void addTables() {
        this.processFactEntities();
        TreeMap treeMap = new TreeMap();
        EntitySet entitySet = this.slice.getDesign().getLogicalDesign().getEntitySet();
        for (String string : this.entMap.keySet()) {
            treeMap.put(this.entMap.get(string), string);
        }
        for (String string : treeMap.keySet()) {
            ModelIDObject modelIDObject;
            ContainerObject containerObject;
            String string2 = (String)treeMap.get(string);
            if (this.factPrefs.contains(string) || (containerObject = (ContainerObject)entitySet.getByName(string2)) == null || (modelIDObject = this.getCorrespondentObject(containerObject)) == null) continue;
            String string3 = this.getSchema(modelIDObject);
            if (string3 != null && !"".equalsIgnoreCase(string3)) {
                this.sb.append(",\n   ").append(this.quoteStr + string3 + this.quoteStr + "." + this.quoteStr + modelIDObject.getName() + this.quoteStr + " " + string);
                continue;
            }
            this.sb.append(",\n   ").append(this.quoteStr + modelIDObject.getName() + this.quoteStr + " " + string);
        }
    }

    private String getTablePrefix(ContainerObject containerObject) {
        String string;
        if (containerObject != null && (string = (String)this.entMap.get(containerObject.getName())) != null) {
            return string + ".";
        }
        return "";
    }

    private void addWhereClause() {
        ModelIDObject modelIDObject;
        ModelIDObject modelIDObject2;
        String string;
        String string2;
        ModelIDObject modelIDObject3;
        ModelIDObject modelIDObject4;
        Object object;
        DesignObject designObject;
        DesignObject designObject2;
        Cube cube = this.slice.getCube();
        this.sb.append("\nWhere");
        boolean bl = true;
        for (Iterator iterator : this.factJoins) {
            for (int i = 0; i < ((FactEntitiesJoin)((Object)iterator)).getLeftAttributes().size(); ++i) {
                designObject2 = (ContainedObject)((FactEntitiesJoin)((Object)iterator)).getLeftAttributes().get(i);
                designObject = (ContainedObject)((FactEntitiesJoin)((Object)iterator)).getRightAttributes().get(i);
                object = this.getTablePrefix(((FactEntitiesJoin)((Object)iterator)).getLeftEntity());
                String string3 = this.getTablePrefix(((FactEntitiesJoin)((Object)iterator)).getRightEntity());
                modelIDObject4 = this.getCorrespondentObject(designObject2);
                modelIDObject3 = this.getCorrespondentObject(designObject);
                if (!bl) {
                    this.sb.append(" AND ");
                } else {
                    bl = false;
                }
                this.sb.append("\n   ").append((String)object + this.quoteStr + modelIDObject4.getName() + this.quoteStr + " = " + string3 + this.quoteStr + modelIDObject3.getName() + this.quoteStr);
            }
        }
        for (Slice.SelectedLevel selectedLevel : this.selectedLevels) {
            designObject2 = (Level)selectedLevel.getHierarchy().getLevels().get(0);
            designObject = cube.getFirstLinkToTarget(selectedLevel.getDimension());
            if (designObject == null) continue;
            object = ((Link)designObject).getRollupLink();
            if (selectedLevel.rollupLink != null) {
                object = selectedLevel.rollupLink;
            }
            if (((RollupLink)object).getChildToParentAttributes().size() == ((Level)designObject2).getLevelKey().size()) {
                for (int i = 0; i < ((RollupLink)object).getChildToParentAttributes().size(); ++i) {
                    modelIDObject4 = (ContainedObject)((RollupLink)object).getChildToParentAttributes().get(i);
                    modelIDObject3 = (ContainedObject)((Level)designObject2).getLevelKey().get(i);
                    string2 = this.getTablePrefix(((ContainedObject)modelIDObject4).getContainer());
                    string = this.getTablePrefix(((ContainedObject)modelIDObject3).getContainer());
                    modelIDObject2 = this.getCorrespondentObject((DesignObject)modelIDObject4);
                    modelIDObject = this.getCorrespondentObject((DesignObject)modelIDObject3);
                    if (!bl) {
                        this.sb.append(" AND ");
                    } else {
                        bl = false;
                    }
                    this.sb.append("\n   ").append(string2 + this.quoteStr + modelIDObject2.getName() + this.quoteStr + " = " + string + this.quoteStr + modelIDObject.getName() + this.quoteStr);
                }
                continue;
            }
            this.error = true;
            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NumberOfReferenceAttributesInCubeDiffer"), cube.getName(), designObject2.getName()));
        }
        for (Link link : this.links) {
            designObject2 = link.getRollupLink();
            designObject = (Level)link.getTargetMDObject();
            object = (Level)link.getSourceMDObject();
            if (((RollupLink)designObject2).getChildToParentAttributes().size() == ((Level)designObject).getLevelKey().size()) {
                for (int i = 0; i < ((RollupLink)designObject2).getChildToParentAttributes().size(); ++i) {
                    modelIDObject4 = (ContainedObject)((RollupLink)designObject2).getChildToParentAttributes().get(i);
                    modelIDObject3 = (ContainedObject)((Level)designObject).getLevelKey().get(i);
                    string2 = this.getTablePrefix(((ContainedObject)modelIDObject4).getContainer());
                    string = this.getTablePrefix(((ContainedObject)modelIDObject3).getContainer());
                    modelIDObject2 = this.getCorrespondentObject((DesignObject)modelIDObject4);
                    modelIDObject = this.getCorrespondentObject((DesignObject)modelIDObject3);
                    if (!bl) {
                        this.sb.append(" AND ");
                    } else {
                        bl = false;
                    }
                    this.sb.append("\n   ").append(string2 + this.quoteStr + modelIDObject2.getName() + this.quoteStr + " = " + string + this.quoteStr + modelIDObject.getName() + this.quoteStr);
                }
                continue;
            }
            this.error = true;
            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NumberOfReferenceAttributesInCubeDiffer"), ((DesignObject)object).getName(), designObject.getName()));
        }
    }

    private String getCAExpression(CalculatedAttribute calculatedAttribute) {
        Level level = calculatedAttribute.getLevel();
        String string = calculatedAttribute.getFunction();
        for (DesignObject designObject : level.getLevelEntity().getElementsCollection()) {
            ModelIDObject modelIDObject;
            String string2;
            if (designObject == calculatedAttribute || string.indexOf(string2 = "\"" + designObject.getName().trim() + "\"") <= -1 || (modelIDObject = this.getCorrespondentObject(designObject)) == null) continue;
            String string3 = this.getTablePrefix(level.getLevelEntity()) + this.quoteStr + modelIDObject.getName().trim() + this.quoteStr;
            string = this.replace(string, string2, string3);
        }
        return string;
    }

    private void processSelectedAttributes(boolean bl) {
        Object object;
        Object object2;
        boolean bl2 = true;
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : this.selectedMeasureWrappers) {
            if (!((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().isNonAdditive()) continue;
            if (!bl2) {
                this.sb.append(",");
            } else {
                bl2 = false;
            }
            object2 = ((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().getFactEntity();
            object = this.getMeasureExpression(((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure());
            if (bl) {
                if (this.aggrFirst && this.aggrEntities.contains(object2)) {
                    object = this.factPref(((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().getFactEntity()) + ".\"" + ((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().getName() + "\"";
                }
                object = (String)object + " AS \"" + ((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().getName() + "\"";
            } else if (this.aggrFirst && this.aggrEntities.contains(object2)) {
                object = this.factPref(((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().getFactEntity()) + ".\"" + ((Slice.MeasureWrapper)iD_ObjectPropertyTranslator).getMeasure().getName() + "\"";
            }
            this.sb.append("\n").append("   ").append((String)object);
        }
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : this.selectedLevels) {
            object2 = ((Slice.SelectedLevel)iD_ObjectPropertyTranslator).getSelectedAttributes().iterator();
            while (object2.hasNext()) {
                Object object3;
                if (!bl2) {
                    this.sb.append(",");
                } else {
                    bl2 = false;
                }
                object = (DesignObject)object2.next();
                if (object instanceof CalculatedAttribute) {
                    object3 = this.getCAExpression((CalculatedAttribute)object);
                    if (bl) {
                        this.sb.append("\n").append("   ").append((String)object3).append(" AS \"" + ((DesignObject)object).getName() + "\"");
                        continue;
                    }
                    this.sb.append("\n").append("   ").append((String)object3);
                    continue;
                }
                object3 = this.getCorrespondentObject((DesignObject)object);
                if (bl) {
                    this.sb.append("\n").append("   ").append(this.getTablePrefix(((Slice.SelectedLevel)iD_ObjectPropertyTranslator).getLevel().getLevelEntity())).append(this.quoteStr + ((ModelObject)object3).getName() + this.quoteStr);
                    continue;
                }
                this.sb.append("\n").append("   ").append(this.getTablePrefix(((Slice.SelectedLevel)iD_ObjectPropertyTranslator).getLevel().getLevelEntity())).append(this.quoteStr + ((ModelObject)object3).getName() + this.quoteStr);
            }
        }
    }

    private void processMeasures(String string, boolean bl) {
        boolean bl2 = true;
        for (Slice.MeasureWrapper measureWrapper : this.selectedMeasureWrappers) {
            if (measureWrapper.getMeasure().isNonAdditive()) continue;
            this.processMeasure(measureWrapper, bl, !bl2, string);
            bl2 = false;
        }
    }

    private void checkMeasures() {
        for (Slice.MeasureWrapper measureWrapper : this.selectedMeasureWrappers) {
            if (!measureWrapper.getMeasure().isSemiAdditive()) continue;
            Measure.AggregateFunction aggregateFunction = measureWrapper.getAggrFunction();
            for (Slice.SelectedLevel selectedLevel : this.selectedLevels) {
                if (aggregateFunction.isDefinedOnDimension(selectedLevel.getDimension())) continue;
                this.error = true;
                this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.SemiAdditiveMeasureNotDefined"), measureWrapper.getMeasure().getName(), selectedLevel.getDimension().getName()));
            }
        }
    }

    private List getUsedFactEntities() {
        Cube cube = this.slice.getCube();
        ArrayList<ContainerObject> arrayList = new ArrayList<ContainerObject>();
        Iterator iterator = cube.getFactEntities().iterator();
        ArrayList arrayList2 = new ArrayList();
        while (iterator.hasNext()) {
            ContainerObject containerObject = (ContainerObject)iterator.next();
            int n = this.testForMeasure(containerObject, arrayList2);
            if (n <= -1) continue;
            arrayList.add(containerObject);
        }
        return arrayList;
    }

    private void makeFactJoins() {
        this.factJoins.clear();
        this.additonalTables.clear();
        this.foreignKeys.clear();
        if (this.usedFactEntities.size() > 1) {
            List list = this.slice.getCube().getJoins();
            if (list.size() < this.usedFactEntities.size() - 1) {
                this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.JoinsNotEnough"), this.slice.getCube().getName()));
            } else {
                for (FactEntitiesJoin factEntitiesJoin : list) {
                    if (!this.usedFactEntities.contains(factEntitiesJoin.getLeftEntity()) || !this.usedFactEntities.contains(factEntitiesJoin.getRightEntity())) continue;
                    this.factJoins.add(factEntitiesJoin);
                }
            }
        }
    }

    private void makeTablesMapAndLinks() {
        this.usedFactEntities = this.getUsedFactEntities();
        this.makeFactJoins();
        if (this.usedFactEntities.size() == 0) {
            this.error = true;
            if (this.selectedMeasureWrappers.size() == 0) {
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoMeasuresSelected"));
            } else {
                this.eb.append(Messages.getString("SlicePropertiesDialogEx.NoAttributesUsageInSelectedMeasuresDefinition"));
            }
        }
        this.entMap.clear();
        this.links.clear();
        this.factPrefs.clear();
        Iterator iterator = this.usedFactEntities.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            ContainerObject containerObject = (ContainerObject)iterator.next();
            Object object = "T" + String.valueOf(n);
            this.factPrefs.add(object);
            this.entMap.put(containerObject.getName(), object);
            ++n;
        }
        block1: for (Object object : this.selectedLevels) {
            Level level;
            DesignObject designObject;
            if (((Slice.SelectedLevel)object).rollupLink != null && (designObject = ((Slice.SelectedLevel)object).rollupLink.getFactEntity()) != null && (level = this.entMap.get(designObject.getName())) == null) {
                String string = "T" + String.valueOf(n);
                this.entMap.put(designObject.getName(), string);
                ++n;
            }
            designObject = ((Slice.SelectedLevel)object).getLevel();
            level = (Level)((Slice.SelectedLevel)object).getHierarchy().getLevels().get(0);
            for (Level level2 : ((Slice.SelectedLevel)object).getHierarchy().getLevels()) {
                String string;
                Object object2;
                ContainerObject containerObject;
                if (level2 != designObject) {
                    containerObject = level2.getLevelEntity();
                    if (containerObject != null) {
                        object2 = this.entMap.get(containerObject.getName());
                        if (object2 == null) {
                            string = "T" + String.valueOf(n);
                            this.entMap.put(containerObject.getName(), string);
                            ++n;
                        }
                    } else {
                        this.error = true;
                        this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoLevelEntityForLevel"), level2.getName()));
                    }
                    if (level.getLevelEntity() != level2.getLevelEntity()) {
                        object2 = level.getFirstLinkToTarget(level2);
                        if (object2 != null) {
                            if (!this.links.contains(object2)) {
                                this.links.add(object2);
                            }
                        } else {
                            this.error = true;
                            this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoLinkBetweenLevel"), level.getName(), level2.getName()));
                        }
                    }
                    level = level2;
                    continue;
                }
                containerObject = level2.getLevelEntity();
                if (containerObject != null) {
                    object2 = this.entMap.get(containerObject.getName());
                    if (object2 == null) {
                        string = "T" + String.valueOf(n);
                        this.entMap.put(containerObject.getName(), string);
                        ++n;
                    }
                } else {
                    this.error = true;
                    this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoLevelEntityForLevel"), level2.getName()));
                }
                if (level.getLevelEntity() == level2.getLevelEntity()) continue block1;
                object2 = level.getFirstLinkToTarget(level2);
                if (object2 != null) {
                    if (this.links.contains(object2)) continue block1;
                    this.links.add(object2);
                    continue block1;
                }
                this.error = true;
                this.eb.append(MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.NoLinkBetweenLevel"), level.getName(), level2.getName()));
                continue block1;
            }
        }
    }

    private void copySelectedLevels(List list) {
        Iterator iterator = list.iterator();
        this.selectedLevels.clear();
        while (iterator.hasNext()) {
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)iterator.next();
            Slice slice = this.slice;
            slice.getClass();
            Slice.SelectedLevel selectedLevel2 = slice.new Slice.SelectedLevel(selectedLevel.getDimension(), selectedLevel.getHierarchy(), selectedLevel.getLevel(), this.slice);
            selectedLevel2.getSelectedAttributes().addAll(selectedLevel.getSelectedAttributes());
            selectedLevel2.rollupLink = selectedLevel.rollupLink;
            this.selectedLevels.add(selectedLevel2);
        }
    }

    private void makeSelectedAttributes() {
        this.selectedAttributes.clear();
        for (int i = 0; i < this.selectedLevels.size(); ++i) {
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)this.selectedLevels.get(i);
            SelObject selObject = new SelObject(selectedLevel.getLevel(), selectedLevel);
            this.selectedAttributes.add(selObject);
            for (DesignObject designObject : selectedLevel.getLevel().getAllAttributes()) {
                SelObject selObject2 = new SelObject(designObject, selectedLevel);
                if (selectedLevel.getSelectedAttributes().contains(designObject)) {
                    selObject2.selected = true;
                }
                this.selectedAttributes.add(selObject2);
            }
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.aggrEntities = new ArrayList();
        this.sb = new StringBuffer();
        this.eb = new StringBuffer();
        this.scList = new ArrayList();
        this.levelsList = new ArrayList();
        this.selectedMeasureWrappers = new ArrayList();
        this.allMeasureWrappers = new ArrayList();
        this.selectedLevels = new ArrayList();
        this.selectedAttributes = new ArrayList();
        this.allDimensions = new ArrayList();
        this.smList = new ArrayList();
        this.sortedMeasures = new ArrayList();
        this.tracedMeasures = new ArrayList();
        this.entMap = new HashMap();
        this.links = new ArrayList();
        this.factPrefs = new ArrayList();
        this.factRefs = new ArrayList();
        this.factJoins = new ArrayList();
        this.additonalTables = new ArrayList();
        this.foreignKeys = new ArrayList();
        this.sqlList = new ArrayList();
        this.newSQLList = new ArrayList();
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasuresPanel());
        this.addToTree(defaultMutableTreeNode, this.getDimensionsPanel());
        this.addToTree(defaultMutableTreeNode, this.getSelAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMappingPanel());
        this.addToTree(defaultMutableTreeNode, this.getQueryPanel());
        this.addToTree(defaultMutableTreeNode, this.getCriteriaPanel());
        this.addToTree(defaultMutableTreeNode, this.getOracleNamesPanel());
        this.addToTree(defaultMutableTreeNode, this.getOracleAWPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    private boolean containsWrapperFor(List list, Measure measure, String string) {
        for (Slice.MeasureWrapper measureWrapper : list) {
            if (measureWrapper.getMeasure() != measure || !measureWrapper.getAggrFunction().getObjectID().equals(string)) continue;
            return true;
        }
        return false;
    }

    private Slice.MeasureWrapper getMeasureWrapperFor(Measure measure) {
        for (Slice.MeasureWrapper measureWrapper : this.selectedMeasureWrappers) {
            if (measureWrapper.getMeasure() != measure) continue;
            return measureWrapper;
        }
        return null;
    }

    @Override
    protected void setProperties() {
        this.slice.setName(this.tfName.getText());
        this.slice.setComment(this.taComments.getText());
        this.slice.setNotes(this.taNotes.getText());
        this.slice.setDescription(this.taDescription.getText());
        this.slice.setReadOnlySlice(this.chReadOnly.isSelected());
        this.slice.setFullyRealized(this.chFullyRealized.isSelected());
        this.slice.setEntity((Entity)this.cbEntity.getSelectedItem());
        if (this.slice.getEntity() != null) {
            this.slice.getEntity().setTypeID(this.getDesignObject().getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_SUMMARY).getTypeID());
        }
        this.slice.getSelectionCriterias().clear();
        for (Object object : this.scList) {
            if (((SelectionCriteria)object).getMeasureWrapper() == null || !this.containsWrapperFor(this.selectedMeasureWrappers, ((SelectionCriteria)object).getMeasureWrapper().getMeasure(), ((SelectionCriteria)object).getMeasureWrapper().getAggrFunction().getObjectID())) continue;
            this.slice.addSelectionCriteria((SelectionCriteria)object);
        }
        this.slice.getSelectedMeasureWrappers().clear();
        this.slice.getSelectedMeasureWrappers().addAll(this.selectedMeasureWrappers);
        this.slice.getSelectedLevels().clear();
        this.slice.getSelectedLevels().addAll(this.selectedLevels);
        this.slice.getSliceMappings().clear();
        for (Object object : this.smList) {
            Measure measure;
            Slice.MeasureWrapper measureWrapper;
            this.slice.getSliceMappings().add(object);
            if (!(((Slice.SliceMapping)object).getMapping() instanceof Measure) || (measureWrapper = this.getMeasureWrapperFor(measure = (Measure)((Slice.SliceMapping)object).getMapping())) == null) continue;
            String string = measure.getMeasureExpression(measure);
            string = measureWrapper.getFunctionName() + "(" + string + ")";
            ((Slice.SliceMapping)object).getAttribute().setSourceType(Messages.getString("SlicePropertiesDialogEx.Aggregate"));
            ((Slice.SliceMapping)object).getAttribute().setFormulaDesc(string);
        }
        this.slice.getSQLDefinitions().clear();
        this.slice.getSQLDefinitions().addAll(this.sqlList);
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        SlicePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.slice.clearProperties();
        for (Object object : this.dynamicPropertiesList) {
            this.slice.setProperty(((DynamicProperty)object).getName(), ((DynamicProperty)object).getValue());
        }
    }

    private List makeSelectedDimensions() {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension> arrayList = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension>();
        for (Slice.SelectedLevel selectedLevel : this.selectedLevels) {
            arrayList.add(selectedLevel.getDimension());
        }
        return arrayList;
    }

    private void makeSelectionCriteria(List list, List list2) {
        for (Slice.MeasureWrapper measureWrapper : list2) {
            String string;
            if (list.indexOf(measureWrapper) != -1 || "".equals(string = measureWrapper.getMeasure().getWhereClause().trim()) || this.findSelectionCriteriaFor(measureWrapper) != null) continue;
            SelectionCriteria selectionCriteria = ((MultidimensionalDesign)this.slice.getDesignPart()).createSelectionCriteria();
            selectionCriteria.setSlice(this.slice);
            selectionCriteria.setMeasureWrapper(measureWrapper);
            selectionCriteria.setSelectionCriteria(string);
            this.scList.add(selectionCriteria);
            this.scTable.updateUI();
        }
    }

    private SelectionCriteria findSelectionCriteriaFor(Slice.MeasureWrapper measureWrapper) {
        for (SelectionCriteria selectionCriteria : this.scList) {
            if (selectionCriteria.getMeasureWrapper().getMeasure() != measureWrapper.getMeasure() || !selectionCriteria.getMeasureWrapper().getAggrFunction().getObjectID().equals(measureWrapper.getAggrFunction().getObjectID())) continue;
            return selectionCriteria;
        }
        return null;
    }

    protected JPanel getMeasuresPanel() {
        if (this.pnMeasures == null) {
            this.pnMeasures = this.createPage(Messages.getString("SlicePropertiesDialogEx.Measures"));
            this.sTable = new JTable(new MeasureWrappersModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = SlicePropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && SlicePropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < SlicePropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                        Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)SlicePropertiesDialogEx.this.selectedMeasureWrappers.get(n);
                        String string = MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.SummaryLevelsFor"), measureWrapper.getMeasureAlias());
                        PresummarizedLevelsDialog presummarizedLevelsDialog = new PresummarizedLevelsDialog(SlicePropertiesDialogEx.this.getAppView(), SlicePropertiesDialogEx.this.makeSelectedDimensions(), measureWrapper.levels, string);
                        presummarizedLevelsDialog.setVisible(true);
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.sTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SlicePropertiesDialogEx.this.sTable.getSelectedRow();
                    if (n != -1 && SlicePropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < SlicePropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                        Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)SlicePropertiesDialogEx.this.selectedMeasureWrappers.get(n);
                        Measure measure = (Measure)((MultidimensionalDesign)SlicePropertiesDialogEx.this.slice.getDesignPart()).getMeasureSet().getObjectByID(measureWrapper.getMeasure().getObjectID());
                        if (measure != null) {
                            measure.showPropertyDialog();
                        }
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ArrayList arrayList = new ArrayList();
                        arrayList.addAll(SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        SelectElementsDialog selectElementsDialog = new SelectElementsDialog(SlicePropertiesDialogEx.this.getAppView(), SlicePropertiesDialogEx.this.allMeasureWrappers, SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        selectElementsDialog.setVisible(true);
                        SlicePropertiesDialogEx.this.makeSelectionCriteria(arrayList, SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        SlicePropertiesDialogEx.this.sTable.updateUI();
                    }
                });
                this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = SlicePropertiesDialogEx.this.sTable.getSelectedRow();
                        if (n != -1 && SlicePropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < SlicePropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                            SlicePropertiesDialogEx.this.selectedMeasureWrappers.remove(n);
                            SlicePropertiesDialogEx.this.sTable.updateUI();
                        }
                    }
                });
                this.btnSummaryLevels = new JButton(gUIConfiguration.getIcon("LEVEL_ICON", this.getPreferredIconSize()));
                this.btnSummaryLevels.setToolTipText(Messages.getString("SlicePropertiesDialogEx.SetOracleAWPresummarizedLevels"));
                this.btnSummaryLevels.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = SlicePropertiesDialogEx.this.sTable.getSelectedRow();
                        if (n != -1 && SlicePropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < SlicePropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                            Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)SlicePropertiesDialogEx.this.selectedMeasureWrappers.get(n);
                            String string = MessageFormat.format(Messages.getString("SlicePropertiesDialogEx.SummaryLevelsFor"), measureWrapper.getMeasureAlias());
                            PresummarizedLevelsDialog presummarizedLevelsDialog = new PresummarizedLevelsDialog(SlicePropertiesDialogEx.this.getAppView(), SlicePropertiesDialogEx.this.makeSelectedDimensions(), measureWrapper.levels, string);
                            presummarizedLevelsDialog.setVisible(true);
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAdd);
                jToolBar.add(this.btnRemove);
                jToolBar.addSeparator();
                jToolBar.add(this.btnSummaryLevels);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnMeasures.add(jPanel2);
        }
        return this.pnMeasures;
    }

    private void updateSelectedAttributes() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.selectedAttributes);
        this.selectedAttributes.clear();
        for (int i = 0; i < this.selectedLevels.size(); ++i) {
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)this.selectedLevels.get(i);
            SelObject selObject = this.findSelObjectFor(arrayList, selectedLevel.getLevel());
            if (selObject == null) {
                selObject = new SelObject(selectedLevel.getLevel(), selectedLevel);
            }
            this.selectedAttributes.add(selObject);
            for (DesignObject designObject : selectedLevel.getLevel().getAllAttributes()) {
                SelObject selObject2 = this.findSelObjectFor(arrayList, designObject);
                if (selObject2 == null) {
                    selObject2 = new SelObject(designObject, selectedLevel);
                }
                this.selectedAttributes.add(selObject2);
            }
        }
    }

    private SelObject findSelObjectFor(List list, DesignObject designObject) {
        for (int i = 0; i < list.size(); ++i) {
            SelObject selObject = (SelObject)list.get(i);
            if (selObject.object != designObject) continue;
            return selObject;
        }
        return null;
    }

    private void updateSelectedLevels(List list) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.selectedLevels);
        this.selectedLevels.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator;
            boolean bl = false;
            Iterator iterator2 = arrayList.iterator();
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)iterator.next();
            while (iterator2.hasNext()) {
                iD_ObjectPropertyTranslator = (Slice.SelectedLevel)iterator2.next();
                if (((Slice.SelectedLevel)iD_ObjectPropertyTranslator).getDimension() != dimension) continue;
                this.selectedLevels.add(iD_ObjectPropertyTranslator);
                bl = true;
                break;
            }
            if (bl || dimension.getHierarchies().size() <= 0) continue;
            iD_ObjectPropertyTranslator = (Hierarchy)dimension.getHierarchies().getElement(0);
            Level level = (Level)((Hierarchy)iD_ObjectPropertyTranslator).getLevels().get(0);
            Slice slice = this.slice;
            slice.getClass();
            Slice.SelectedLevel selectedLevel = slice.new Slice.SelectedLevel(dimension, (Hierarchy)iD_ObjectPropertyTranslator, level, this.slice);
            this.selectedLevels.add(selectedLevel);
        }
    }

    protected JPanel getDimensionsPanel() {
        if (this.pnDimensions == null) {
            this.pnDimensions = this.createPage(Messages.getString("SlicePropertiesDialogEx.DimensionsLevels"));
            this.levelsTable = new JTable(new LevelTableModel());
            this.levelsTable.setSelectionMode(0);
            this.levelsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = SlicePropertiesDialogEx.this.levelsTable.getSelectedRow()) != -1 && SlicePropertiesDialogEx.this.selectedLevels.size() > 0 && n < SlicePropertiesDialogEx.this.selectedLevels.size()) {
                        Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(n);
                        selectedLevel.getLevel().showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.levelsTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SlicePropertiesDialogEx.this.levelsTable.getSelectedRow();
                    if (n != -1 && SlicePropertiesDialogEx.this.selectedLevels.size() > 0 && n < SlicePropertiesDialogEx.this.selectedLevels.size()) {
                        Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(n);
                        selectedLevel.getLevel().showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                this.btnAddSL = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAddSL.setToolTipText(BTN_ADD);
                this.btnAddSL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        List list = SlicePropertiesDialogEx.this.makeSelectedDimensions();
                        SelectElementsDialog selectElementsDialog = new SelectElementsDialog(SlicePropertiesDialogEx.this.getAppView(), SlicePropertiesDialogEx.this.allDimensions, list);
                        selectElementsDialog.setVisible(true);
                        SlicePropertiesDialogEx.this.updateSelectedLevels(list);
                        SlicePropertiesDialogEx.this.updateSelectedAttributes();
                        ((LevelTableModel)SlicePropertiesDialogEx.this.levelsTable.getModel()).dataChanged();
                        SlicePropertiesDialogEx.this.attributesTable.updateUI();
                    }
                });
                this.btnRemoveSL = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveSL.setToolTipText(BTN_REMOVE);
                this.btnRemoveSL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = SlicePropertiesDialogEx.this.levelsTable.getSelectedRow();
                        if (n != -1 && SlicePropertiesDialogEx.this.selectedLevels.size() > 0 && n < SlicePropertiesDialogEx.this.selectedLevels.size()) {
                            SlicePropertiesDialogEx.this.selectedLevels.remove(n);
                            SlicePropertiesDialogEx.this.updateSelectedAttributes();
                            SlicePropertiesDialogEx.this.levelsTable.updateUI();
                            SlicePropertiesDialogEx.this.attributesTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAddSL);
                jToolBar.add(this.btnRemoveSL);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnDimensions.add(jPanel2);
            TableColumn tableColumn = null;
            block5: for (int i = 0; i < 3; ++i) {
                tableColumn = this.levelsTable.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        tableColumn.setCellEditor(new ColumnHierLevelCB());
                        continue block5;
                    }
                    case 1: {
                        tableColumn.setCellEditor(new ColumnHierLevelCB());
                        continue block5;
                    }
                    case 2: {
                        tableColumn.setCellEditor(new ColumnHierLevelCB());
                    }
                }
            }
        }
        return this.pnDimensions;
    }

    private void updateComboMappings() {
        int n;
        this.cbTypes.removeAllItems();
        List list = this.getMappings();
        for (n = 0; n < list.size(); ++n) {
            this.cbTypes.addItem(list.get(n));
        }
        for (n = 0; n < this.smList.size(); ++n) {
            Slice.SliceMapping sliceMapping = (Slice.SliceMapping)this.smList.get(n);
            if (sliceMapping.getMapping() == null || list.contains(sliceMapping.getMapping())) continue;
            sliceMapping.setMapping(null);
            this.smTable.setValueAt(null, n, 1);
        }
        this.smTable.updateUI();
    }

    protected JPanel getSelAttributesPanel() {
        if (this.pnSelAttributes == null) {
            this.pnSelAttributes = this.createPage(Messages.getString("SlicePropertiesDialogEx.SelectedAttributes"));
            this.attributesTable = new JTable(new SelAttributesModel());
            this.attributesTable.setSelectionMode(0);
            this.attributesTable.setDefaultRenderer(Object.class, new SelAttributesRenderer());
            this.attributesTable.getTableHeader().setReorderingAllowed(false);
            this.attributesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = SlicePropertiesDialogEx.this.attributesTable.getSelectedRow()) != -1 && SlicePropertiesDialogEx.this.selectedAttributes.size() > 0 && n < SlicePropertiesDialogEx.this.selectedAttributes.size()) {
                        SelObject selObject = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(n);
                        selObject.object.showPropertyDialog();
                    }
                }
            });
            TableColumn tableColumn = null;
            tableColumn = this.attributesTable.getColumnModel().getColumn(0);
            tableColumn.setCellEditor(new SelAttributeEditor());
            tableColumn.setPreferredWidth(5);
            JScrollPane jScrollPane = new JScrollPane(this.attributesTable);
            this.pnSelAttributes.add(jScrollPane);
        }
        return this.pnSelAttributes;
    }

    private void newEntity() {
        this.newEntity = this.slice.getDesign().getLogicalDesign().createEntity();
        if (!"".equalsIgnoreCase(this.tfEntityName.getText())) {
            this.newEntity.setName(this.tfEntityName.getText());
        }
        this.cbEntity.addItem(this.newEntity);
        this.cbEntity.setSelectedItem(this.newEntity);
        for (Object object : this.getMappings()) {
            Attribute attribute = ((Entity)this.newEntity).createAttribute(((DesignObject)object).getName());
            Slice slice = this.slice;
            slice.getClass();
            this.smList.add(slice.new Slice.SliceMapping(attribute, (DesignObject)object));
        }
        for (Object object : this.smList) {
            ((DefaultTableModel)this.smTable.getModel()).addRow(new Object[]{((Slice.SliceMapping)object).getAttribute().getLongName(), ((Slice.SliceMapping)object).getMapping()});
        }
        this.smTable.updateUI();
    }

    protected JPanel getMappingPanel() {
        if (this.pnMapping == null) {
            this.pnMapping = this.createPage(Messages.getString("SlicePropertiesDialogEx.SliceToEntityMappings"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.setBorder(BorderFactory.createEtchedBorder());
            JLabel jLabel = new JLabel(Messages.getString("SlicePropertiesDialogEx.EntityName"));
            jPanel2.add(jLabel);
            this.tfEntityName = new JTextField(13);
            jPanel2.add(this.tfEntityName);
            this.bnNewEntity = new JButton(Messages.getString("SlicePropertiesDialogEx.NewEntity"));
            this.bnNewEntity.setEnabled(this.isEditable());
            this.bnNewEntity.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SlicePropertiesDialogEx.this.newEntity();
                }
            });
            jPanel2.add(this.bnNewEntity);
            jPanel.add((Component)jPanel2, "North");
            this.smTable = new JTable(new SliceMappingsTableModel());
            this.cbTypes = new JComboBox<Object>(this.getMappings().toArray());
            this.smTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.cbTypes));
            this.smTable.setSelectionMode(0);
            this.smTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = SlicePropertiesDialogEx.this.smTable.getSelectedRow()) > -1 && SlicePropertiesDialogEx.this.smList.size() > 0 && n < SlicePropertiesDialogEx.this.smList.size()) {
                        Slice.SliceMapping sliceMapping = (Slice.SliceMapping)SlicePropertiesDialogEx.this.smList.get(n);
                        sliceMapping.getAttribute().showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.smTable);
            jPanel.add((Component)jScrollPane, "Center");
            this.pnMapping.add(jPanel);
        }
        return this.pnMapping;
    }

    protected JPanel getQueryPanel() {
        if (this.pnQuery == null) {
            this.pnQuery = this.createPage(Messages.getString("SlicePropertiesDialogEx.QueryWizard"));
            this.tab = new JTabbedPane();
            JPanel jPanel = new JPanel(new BorderLayout());
            this.selPane = new JTextArea();
            this.selPane.setEditable(true);
            JScrollPane jScrollPane = new JScrollPane(this.selPane);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(simpleAttributeSet, 0);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jPanel.add((Component)jScrollPane, "Center");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(Messages.getString("SlicePropertiesDialogEx.DefaultSchema"));
            jLabel.setPreferredSize(this.getDefaultSize());
            this.tfSchema = new JTextField("");
            this.tfSchema.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel, this.tfSchema));
            JLabel jLabel2 = new JLabel(Messages.getString("SlicePropertiesDialogEx.RelationalModel"));
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.cbRelDes = new JComboBox();
            this.cbRelDes.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel2, this.cbRelDes));
            JLabel jLabel3 = new JLabel(Messages.getString("SlicePropertiesDialogEx.PhysicalModel"));
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.cbStorage = new JComboBox();
            this.cbStorage.setPreferredSize(this.getDefaultSize());
            this.cbRelDes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = SlicePropertiesDialogEx.this.cbRelDes.getSelectedItem();
                    if (object != null && object instanceof RelationalDesign) {
                        RelationalDesign relationalDesign = (RelationalDesign)object;
                        ArrayList<StorageDesign> arrayList = new ArrayList<StorageDesign>();
                        StorageDesign[] storageDesignArray = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
                        for (int i = 0; i < storageDesignArray.length; ++i) {
                            StorageDesign storageDesign = storageDesignArray[i];
                            arrayList.add(storageDesign);
                        }
                        SlicePropertiesDialogEx.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                    } else if (object == null) {
                        SlicePropertiesDialogEx.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                    }
                }
            });
            jPanel2.add(this.createRow(jLabel3, this.cbStorage));
            JLabel jLabel4 = new JLabel(Messages.getString("SlicePropertiesDialogEx.AggregateFactsFirst"));
            jLabel4.setPreferredSize(this.getDefaultSize());
            jLabel4.setToolTipText(Messages.getString("SlicePropertiesDialogEx.OptionForLargeDimensionTables"));
            this.aggrCB = new JCheckBox();
            this.aggrCB.setToolTipText(jLabel4.getToolTipText());
            this.aggrCB.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel4, this.aggrCB));
            JLabel jLabel5 = new JLabel(Messages.getString("SlicePropertiesDialogEx.UseQuotedNames"));
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.quoteCB = new JCheckBox();
            this.quoteCB.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel5, this.quoteCB));
            this.tab.addTab(Messages.getString("SlicePropertiesDialogEx.Query"), jPanel);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel2, "North");
            this.tab.addTab(Messages.getString("SlicePropertiesDialogEx.Options"), jPanel3);
            QueryGenerator queryGenerator = new QueryGenerator();
            this.tab.addChangeListener(queryGenerator);
            this.pnQuery.add(this.tab);
        }
        return this.pnQuery;
    }

    protected JPanel getCriteriaPanel() {
        if (this.pnCriteria == null) {
            JComponent jComponent;
            this.pnCriteria = this.createPage(Messages.getString("SlicePropertiesDialogEx.SelectionCriteria"));
            this.scTable = new JTable(new SelectionCriteriaTableModel());
            this.scTable.setSelectionMode(0);
            this.scTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = SlicePropertiesDialogEx.this.scTable.getSelectedRow()) > -1 && SlicePropertiesDialogEx.this.scList.size() > 0 && n < SlicePropertiesDialogEx.this.scList.size()) {
                        SelectionCriteria selectionCriteria = (SelectionCriteria)SlicePropertiesDialogEx.this.scList.get(n);
                        selectionCriteria.showModal = ((SlicePropertiesDialogEx)SlicePropertiesDialogEx.this).slice.showModal || SlicePropertiesDialogEx.this.slice.showForFirstTime();
                        selectionCriteria.setMeasureWrappersList(SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        selectionCriteria.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.scTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SlicePropertiesDialogEx.this.scTable.getSelectedRow();
                    if (n > -1 && SlicePropertiesDialogEx.this.scList.size() > 0 && n < SlicePropertiesDialogEx.this.scList.size()) {
                        SelectionCriteria selectionCriteria = (SelectionCriteria)SlicePropertiesDialogEx.this.scList.get(n);
                        selectionCriteria.showModal = ((SlicePropertiesDialogEx)SlicePropertiesDialogEx.this).slice.showModal || SlicePropertiesDialogEx.this.slice.showForFirstTime();
                        selectionCriteria.setMeasureWrappersList(SlicePropertiesDialogEx.this.selectedMeasureWrappers);
                        selectionCriteria.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectionCriteria selectionCriteria = ((MultidimensionalDesign)SlicePropertiesDialogEx.this.slice.getDesignPart()).createSelectionCriteria();
                        selectionCriteria.setSlice(SlicePropertiesDialogEx.this.slice);
                        SlicePropertiesDialogEx.this.scList.add(selectionCriteria);
                        SlicePropertiesDialogEx.this.scTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = SlicePropertiesDialogEx.this.scTable.getSelectedRow();
                        if (n != -1 && SlicePropertiesDialogEx.this.scList.size() > 0 && n < SlicePropertiesDialogEx.this.scList.size()) {
                            SlicePropertiesDialogEx.this.scList.remove(n);
                            SlicePropertiesDialogEx.this.scTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnCriteria.add(jComponent);
        }
        return this.pnCriteria;
    }

    protected JPanel getOracleAWPanel() {
        if (this.pnOracleAW == null) {
            JComponent jComponent;
            this.pnOracleAW = this.createPage(Messages.getString("SlicePropertiesDialogEx.SQLAccessToOracleAW"));
            this.sqlTable = new JTable(new SQLToAWTableModel());
            this.sqlTable.setSelectionMode(0);
            this.sqlTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = SlicePropertiesDialogEx.this.sqlTable.getSelectedRow()) > -1 && SlicePropertiesDialogEx.this.sqlList.size() > 0 && n < SlicePropertiesDialogEx.this.sqlList.size()) {
                        SQLAccessToAW sQLAccessToAW = (SQLAccessToAW)SlicePropertiesDialogEx.this.sqlList.get(n);
                        sQLAccessToAW.verifyDefinitions();
                        sQLAccessToAW.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.sqlTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SlicePropertiesDialogEx.this.sqlTable.getSelectedRow();
                    if (n > -1 && SlicePropertiesDialogEx.this.sqlList.size() > 0 && n < SlicePropertiesDialogEx.this.sqlList.size()) {
                        SQLAccessToAW sQLAccessToAW = (SQLAccessToAW)SlicePropertiesDialogEx.this.sqlList.get(n);
                        sQLAccessToAW.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SQLAccessToAW sQLAccessToAW = SlicePropertiesDialogEx.this.slice.getMultidimensionalDesign().createSQLAccessToAW();
                        sQLAccessToAW.setSlice(SlicePropertiesDialogEx.this.slice);
                        SlicePropertiesDialogEx.this.newSQLList.add(sQLAccessToAW);
                        SlicePropertiesDialogEx.this.sqlList.add(sQLAccessToAW);
                        SlicePropertiesDialogEx.this.sqlTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = SlicePropertiesDialogEx.this.sqlTable.getSelectedRow();
                        if (n != -1 && SlicePropertiesDialogEx.this.sqlList.size() > 0 && n < SlicePropertiesDialogEx.this.sqlList.size()) {
                            SlicePropertiesDialogEx.this.sqlList.remove(n);
                            SlicePropertiesDialogEx.this.sqlTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnOracleAW.add(jComponent);
        }
        return this.pnOracleAW;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class SQLToAWTableModel
    extends AbstractTableModel {
        private SQLToAWTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.sqlList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SlicePropertiesDialogEx.Name");
            }
            if (n == 1) {
                return Messages.getString("SlicePropertiesDialogEx.MeasureAlias");
            }
            if (n == 2) {
                return Messages.getString("SlicePropertiesDialogEx.WhereClause");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SQLAccessToAW sQLAccessToAW = (SQLAccessToAW)SlicePropertiesDialogEx.this.sqlList.get(n);
            if (n2 == 0) {
                return sQLAccessToAW.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class SelectionCriteriaTableModel
    extends AbstractTableModel {
        private SelectionCriteriaTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.scList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SlicePropertiesDialogEx.Name");
            }
            if (n == 1) {
                return Messages.getString("SlicePropertiesDialogEx.MeasureAlias");
            }
            if (n == 2) {
                return Messages.getString("SlicePropertiesDialogEx.WhereClause");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SelectionCriteria selectionCriteria = (SelectionCriteria)SlicePropertiesDialogEx.this.scList.get(n);
            if (n2 == 0) {
                return selectionCriteria.getName();
            }
            if (n2 == 1) {
                if (selectionCriteria.getMeasureWrapper() != null) {
                    return selectionCriteria.getMeasureWrapper().getMeasureAlias();
                }
                return "";
            }
            if (n2 == 2) {
                return selectionCriteria.getSelectionCriteria();
            }
            return new Integer(n * n2);
        }
    }

    class QueryGenerator
    implements ChangeListener {
        QueryGenerator() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == SlicePropertiesDialogEx.this.tab && SlicePropertiesDialogEx.this.tab.getSelectedIndex() == 0) {
                SlicePropertiesDialogEx.this.makeQuery();
            }
        }
    }

    private class SliceMappingsTableModel
    extends DefaultTableModel {
        private SliceMappingsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("SlicePropertiesDialogEx.Attributes");
            }
            if (n == 1) {
                return Messages.getString("SlicePropertiesDialogEx.Mappings");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!SlicePropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1 && object instanceof DesignObject) {
                Slice.SliceMapping sliceMapping = (Slice.SliceMapping)SlicePropertiesDialogEx.this.smList.get(n);
                sliceMapping.setMapping((DesignObject)object);
            }
            super.setValueAt(object, n, n2);
        }
    }

    class SelAttributeEditor
    extends DefaultCellEditor {
        JCheckBox cbox;

        SelAttributeEditor() {
            super(new JCheckBox());
            this.cbox = (JCheckBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            SelObject selObject = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(n);
            if (n2 == 0 && !(selObject.object instanceof Level) && selObject.editable) {
                this.cbox.setSelected(selObject.selected);
            }
            return this.cbox;
        }
    }

    public class SelAttributesRenderer
    extends DefaultTableCellRenderer {
        SelAttributesCBRenderer cbRenderer;

        public SelAttributesRenderer() {
            this.cbRenderer = new SelAttributesCBRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Color color2;
            SelObject selObject = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(n);
            Component component = !(selObject.object instanceof Level) && n2 == 0 ? this.cbRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!selObject.editable) {
                color2 = Color.LIGHT_GRAY;
                color = Color.WHITE;
            } else {
                color2 = Color.WHITE;
                color = Color.BLACK;
            }
            if (selObject.object instanceof Level) {
                color2 = Color.DARK_GRAY;
                color = Color.WHITE;
            }
            component.setBackground(color2);
            component.setForeground(color);
            return component;
        }
    }

    public class SelAttributesCBRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SelObject selObject = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(n);
            this.setSelected(selObject.selected);
            return this;
        }
    }

    private class SelAttributesModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SlicePropertiesDialogEx.Status"), Messages.getString("SlicePropertiesDialogEx.AttributesLevels")};

        private SelAttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.selectedAttributes.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!SlicePropertiesDialogEx.this.isEditable()) {
                return false;
            }
            if (n2 > 0) {
                return false;
            }
            SelObject selObject = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(n);
            return selObject.editable;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                SelObject selObject = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(n);
                if (selObject.editable && object instanceof Boolean) {
                    selObject.selected = (Boolean)object;
                    if (selObject.selected && !selObject.selAttrs.contains(selObject.object)) {
                        selObject.selAttrs.add(selObject.object);
                    } else {
                        selObject.selAttrs.remove(selObject.object);
                    }
                    SlicePropertiesDialogEx.this.updateComboMappings();
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SelObject selObject = (SelObject)SlicePropertiesDialogEx.this.selectedAttributes.get(n);
            if (n2 == 1) {
                return selObject.object.getName();
            }
            if (n2 == 0 && selObject.object instanceof Level) {
                return Messages.getString("SlicePropertiesDialogEx.LevelL");
            }
            if (n2 == 0) {
                return selObject.selected;
            }
            return new Integer(n * n2);
        }
    }

    class ColumnHierLevelCB
    extends DefaultCellEditor {
        JComboBox cbox;

        ColumnHierLevelCB() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator;
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(n);
            if (n2 == 0 && object instanceof RollupLink) {
                iD_ObjectPropertyTranslator = selectedLevel.getDimension();
                List list = SlicePropertiesDialogEx.this.slice.getCube().getAllRollupLinksToTarget((AbstractMDObject)iD_ObjectPropertyTranslator);
                this.cbox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
                this.cbox.setSelectedItem(selectedLevel.rollupLink);
            }
            if (n2 == 1 && object instanceof Hierarchy) {
                iD_ObjectPropertyTranslator = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(n);
                this.cbox.setModel(new DefaultComboBoxModel<Object>(selectedLevel.getDimension().getHierarchies().toArray()));
                this.cbox.setSelectedItem(((Slice.SelectedLevel)iD_ObjectPropertyTranslator).getHierarchy());
            }
            if (n2 == 2 && object instanceof Level) {
                iD_ObjectPropertyTranslator = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(n);
                this.cbox.setModel(new DefaultComboBoxModel<Object>(selectedLevel.getHierarchy().getLevels().toArray()));
                this.cbox.setSelectedItem(((Slice.SelectedLevel)iD_ObjectPropertyTranslator).getLevel());
            }
            return this.cbox;
        }
    }

    private class LevelTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SlicePropertiesDialogEx.Dimension"), Messages.getString("SlicePropertiesDialogEx.Hierarchy"), Messages.getString("SlicePropertiesDialogEx.Level")};

        private LevelTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.selectedLevels.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!SlicePropertiesDialogEx.this.isEditable()) {
                return false;
            }
            if (n2 > 0) {
                return true;
            }
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(n);
            List list = SlicePropertiesDialogEx.this.slice.getCube().getAllRollupLinksToTarget(selectedLevel.getDimension());
            return list.size() > 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(n);
            if (n2 == 0) {
                if (object instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                    if (selectedLevel.getDimension() != object) {
                        oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)object;
                        selectedLevel.setDimension(dimension);
                        this.fireTableDataChanged();
                    }
                } else if (object instanceof RollupLink) {
                    selectedLevel.rollupLink = (RollupLink)object;
                    this.fireTableDataChanged();
                }
            } else if (n2 == 1) {
                if (object instanceof Hierarchy && selectedLevel.getHierarchy() != object) {
                    Hierarchy hierarchy = (Hierarchy)object;
                    Level level = selectedLevel.getLevel();
                    selectedLevel.setHierarchy(hierarchy);
                    if (!hierarchy.getLevels().contains(level)) {
                        selectedLevel.setLevel((Level)hierarchy.getLevels().get(0));
                        SlicePropertiesDialogEx.this.updateSelectedAttributes();
                    }
                    this.fireTableDataChanged();
                }
            } else if (n2 == 2 && object instanceof Level && selectedLevel.getLevel() != object) {
                Level level = (Level)object;
                selectedLevel.setLevel(level);
                SlicePropertiesDialogEx.this.updateSelectedAttributes();
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Slice.SelectedLevel selectedLevel = (Slice.SelectedLevel)SlicePropertiesDialogEx.this.selectedLevels.get(n);
            if (n2 == 0) {
                List list = SlicePropertiesDialogEx.this.slice.getCube().getAllRollupLinksToTarget(selectedLevel.getDimension());
                if (list.size() > 1) {
                    if (selectedLevel.rollupLink == null) {
                        selectedLevel.rollupLink = (RollupLink)list.get(0);
                    }
                    return selectedLevel.rollupLink;
                }
                return selectedLevel.getDimension();
            }
            if (n2 == 1) {
                return selectedLevel.getHierarchy();
            }
            if (n2 == 2) {
                return selectedLevel.getLevel();
            }
            return new Integer(n * n2);
        }
    }

    private class MeasureWrappersModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SlicePropertiesDialogEx.Measure"), Messages.getString("SlicePropertiesDialogEx.AggregateFunction"), Messages.getString("SlicePropertiesDialogEx.MeasureAlias")};

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public int getRowCount() {
            return SlicePropertiesDialogEx.this.selectedMeasureWrappers.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)SlicePropertiesDialogEx.this.selectedMeasureWrappers.get(n);
            if (n2 == 0) {
                return measureWrapper.getMeasure().getName();
            }
            if (n2 == 1) {
                return measureWrapper.getAggrFunction().name;
            }
            if (n2 == 2) {
                return measureWrapper.getAggrFunction().measureAlias;
            }
            return "";
        }
    }

    class SelObject {
        boolean selected = false;
        boolean editable;
        DesignObject object;
        Level level;
        List selAttrs;

        SelObject(DesignObject designObject, Slice.SelectedLevel selectedLevel) {
            this.object = designObject;
            this.level = selectedLevel.getLevel();
            this.selAttrs = selectedLevel.getSelectedAttributes();
            if (!(designObject instanceof Level)) {
                if (this.selAttrs.contains(designObject)) {
                    this.selected = true;
                }
                if (this.level.getLevelKey().contains(designObject)) {
                    this.editable = false;
                    this.selected = true;
                    if (!this.selAttrs.contains(designObject)) {
                        this.selAttrs.add(designObject);
                    }
                } else {
                    this.editable = true;
                }
            } else {
                this.editable = false;
            }
        }

        void setSelected(boolean bl) {
            if (!this.selected && bl) {
                this.selAttrs.add(this.object);
            } else if (this.selected && !bl) {
                this.selAttrs.remove(this.object);
            }
            this.selected = bl;
        }
    }

    class MeasureDependence {
        Measure measure;
        List dependOn = new ArrayList();

        MeasureDependence(Measure measure) {
            this.measure = measure;
        }
    }
}

