/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectDescriptiveAttributesDialog
extends JDialog
implements AbstractEditorConstants {
    private List aList;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private DefaultListModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    protected JPanel generalPanel;
    private ContainerObject selectedEntity;
    private Level level;
    List copyList = new ArrayList();

    public SelectDescriptiveAttributesDialog(ApplicationView applicationView, List list, ContainerObject containerObject, Level level) {
        super(applicationView.getFrame());
        this.level = level;
        this.selectedEntity = containerObject;
        this.setModal(true);
        this.aList = list;
        this.setTitle(Messages.getString("SelectDescriptiveAttributesDialog.SelectDescriptiveAttributes"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SelectDescriptiveAttributesDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allAttributesModel = new DefaultListModel();
        this.selectedAttributesModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(BTN_OK);
        jButton.addActionListener(new OKAction());
        jButton.setMnemonic(79);
        JButton jButton2 = new JButton(BTN_CANCEL);
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new CancelAction());
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private SlowChangingAttribute getSCAforAttr(List list, ContainedObject containedObject) {
        for (SlowChangingAttribute slowChangingAttribute : list) {
            if (slowChangingAttribute.getAttribute() != containedObject) continue;
            return slowChangingAttribute;
        }
        return null;
    }

    private boolean containsAttribute(ContainedObject containedObject) {
        for (SlowChangingAttribute slowChangingAttribute : this.aList) {
            if (slowChangingAttribute.getAttribute() != containedObject) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.initAllAttributesList();
        this.initAttributesButtons();
        this.initSelectedAttributesList();
        this.fillLists();
    }

    private void fillLists() {
        Object object;
        Iterator iterator = this.aList.iterator();
        while (iterator.hasNext()) {
            object = (SlowChangingAttribute)iterator.next();
            this.selectedAttributesModel.addElement(new AttributeItem(((SlowChangingAttribute)object).getAttribute()));
        }
        object = null;
        if (this.selectedEntity != null) {
            if (this.selectedEntity instanceof Entity) {
                object = ((Entity)this.selectedEntity).getHierarchicalAttributes();
                iterator = object.iterator();
            } else {
                iterator = this.selectedEntity.getElementsCollection().iterator();
            }
        } else if (this.level != null) {
            iterator = this.level.getDesign().getLogicalDesign().getAttributeSet().iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                ContainedObject containedObject = (ContainedObject)iterator.next();
                if (this.containsAttribute(containedObject)) continue;
                this.allAttributesModel.addElement(new AttributeItem(containedObject));
            }
        }
    }

    private void initAllAttributesList() {
        JPanel jPanel = new JPanel();
        this.allAttributesList = new JList(this.allAttributesModel);
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allAttributesList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "West");
    }

    private void initSelectedAttributesList() {
        JPanel jPanel = new JPanel();
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedAttributesList);
        jScrollPane.setPreferredSize(new Dimension(220, 300));
        jPanel.add(jScrollPane);
        this.generalPanel.add((Component)jPanel, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initAttributesButtons() {
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(Messages.getString("SelectDescriptiveAttributesDialog.Add"));
        this.btnRemoveAttributes = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(Messages.getString("SelectDescriptiveAttributesDialog.Remove"));
        jToolBar.add(this.btnAddAttributes);
        jToolBar.add(this.btnRemoveAttributes);
        jPanel.add(jToolBar);
        jPanel.setPreferredSize(new Dimension(32, 300));
        this.generalPanel.add((Component)jPanel, "Center");
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectDescriptiveAttributesDialog.this.selectedAttributesList.getSelectedIndex() == -1) {
                    SelectDescriptiveAttributesDialog.this.btnRemoveAttributes.setEnabled(false);
                } else {
                    SelectDescriptiveAttributesDialog.this.btnRemoveAttributes.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (SelectDescriptiveAttributesDialog.this.allAttributesList.getSelectedIndex() == -1) {
                    SelectDescriptiveAttributesDialog.this.btnAddAttributes.setEnabled(false);
                } else {
                    SelectDescriptiveAttributesDialog.this.btnAddAttributes.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectDescriptiveAttributesDialog.this.selectedAttributesModel.isEmpty()) {
                Object[] objectArray = SelectDescriptiveAttributesDialog.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SelectDescriptiveAttributesDialog.this.allAttributesModel.contains(object)) continue;
                    SelectDescriptiveAttributesDialog.this.allAttributesModel.addElement(object);
                    SelectDescriptiveAttributesDialog.this.selectedAttributesModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SelectDescriptiveAttributesDialog.this.allAttributesModel.isEmpty()) {
                Object[] objectArray = SelectDescriptiveAttributesDialog.this.allAttributesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SelectDescriptiveAttributesDialog.this.selectedAttributesModel.contains(object)) continue;
                    SelectDescriptiveAttributesDialog.this.selectedAttributesModel.addElement(object);
                    SelectDescriptiveAttributesDialog.this.allAttributesModel.removeElement(object);
                }
            }
        }
    }

    private class AttributeItem {
        private ContainedObject attribute = null;

        public AttributeItem(ContainedObject containedObject) {
            this.attribute = containedObject;
        }

        public ContainedObject getAttribute() {
            return this.attribute;
        }

        public String toString() {
            if (this.attribute != null) {
                return this.attribute.getLongName();
            }
            return "";
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectDescriptiveAttributesDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SelectDescriptiveAttributesDialog.this.copyList.clear();
            SelectDescriptiveAttributesDialog.this.copyList.addAll(SelectDescriptiveAttributesDialog.this.aList);
            SelectDescriptiveAttributesDialog.this.aList.clear();
            for (int i = 0; i < SelectDescriptiveAttributesDialog.this.selectedAttributesModel.size(); ++i) {
                AttributeItem attributeItem = (AttributeItem)SelectDescriptiveAttributesDialog.this.selectedAttributesModel.getElementAt(i);
                SlowChangingAttribute slowChangingAttribute = SelectDescriptiveAttributesDialog.this.getSCAforAttr(SelectDescriptiveAttributesDialog.this.copyList, attributeItem.getAttribute());
                if (slowChangingAttribute == null) {
                    slowChangingAttribute = new SlowChangingAttribute(SelectDescriptiveAttributesDialog.this.level, attributeItem.getAttribute());
                }
                SelectDescriptiveAttributesDialog.this.aList.add(slowChangingAttribute);
            }
            SelectDescriptiveAttributesDialog.this.dispose();
        }
    }
}

