/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.util.MessageDialogs;

public class SQLStatementsDialog
extends JDialog {
    private SQLAccessToAW sqlAW;
    private JTabbedPane tabbedPane = new JTabbedPane();
    String BTN_OK = Messages.getString("SQLStatementsDialog.OK");
    String BTN_APPLY = Messages.getString("SQLStatementsDialog.Apply");
    String BTN_CANCEL = Messages.getString("SQLStatementsDialog.Cancel");
    private JButton bnCancel;
    String KEY_ESCAPE = "ESCAPE";
    private List dimList = new ArrayList();
    private boolean readOnly = false;
    private JTable dimTable;
    private JButton btnUp;
    private JButton btnDown;
    JTextArea selPane;
    JCheckBox chFormatted;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SQLStatementsDialog.this.bnCancel.doClick();
        }
    };

    public SQLStatementsDialog(ApplicationView applicationView, SQLAccessToAW sQLAccessToAW, boolean bl) {
        super(applicationView.getFrame());
        sQLAccessToAW.verifyDefinitions();
        this.sqlAW = sQLAccessToAW;
        this.readOnly = bl;
        this.setModal(true);
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.tabbedPane.setPreferredSize(new Dimension(650, 470));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel jPanel = new JPanel();
        if (!bl) {
            JButton jButton = new JButton(this.BTN_OK);
            jButton.addActionListener(new OKAction());
            jButton.setMnemonic(79);
            this.getRootPane().setDefaultButton(jButton);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jPanel.add(jButton);
        }
        this.bnCancel = new JButton(!bl ? this.BTN_CANCEL : Messages.getString("SQLStatementsDialog.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.bnCancel);
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke(this.KEY_ESCAPE), this.KEY_ESCAPE);
        jComponent.getActionMap().put(this.KEY_ESCAPE, this.escape);
        this.getContentPane().add((Component)jPanel, "South");
        this.initProperties();
        this.pack();
        this.centerOnScreen(this);
        this.setResizable(true);
        this.tabbedPane.addChangeListener(new QueryGenerator());
    }

    public void centerOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 3);
        jDialog.setLocation(point);
    }

    public String getCaption() {
        return MessageFormat.format(Messages.getString("SQLStatementsDialog.AttributesOrderSQLStatements"), this.sqlAW.getName());
    }

    private void initProperties() {
        this.initAttributes();
        this.initSQLTab();
    }

    private void initAttributes() {
        JComponent jComponent;
        this.dimList.addAll(this.sqlAW.getOutSQLAttributes());
        this.dimTable = new JTable(new DimensionTableModel());
        this.dimTable.setSelectionMode(1);
        this.dimTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() != 2 || (n = SQLStatementsDialog.this.dimTable.getSelectedRow()) != -1) {
                    // empty if block
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        if (!this.readOnly) {
            this.btnUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.btnUp.setToolTipText(Messages.getString("SQLStatementsDialog.MoveUp"));
            this.btnUp.addActionListener(new MoveUpAction2());
            this.btnDown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.btnDown.setToolTipText(Messages.getString("SQLStatementsDialog.MoveDown"));
            this.btnDown.addActionListener(new MoveDownAction2());
            jComponent = new JToolBar(0);
            ((JToolBar)jComponent).setFloatable(false);
            jComponent.add(this.btnUp);
            jComponent.add(this.btnDown);
            jPanel.add(jComponent);
        }
        jComponent = new JPanel(new BorderLayout());
        jComponent.add((Component)jPanel, "North");
        jComponent.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.dimTable, null);
        jScrollPane.setPreferredSize(new Dimension(630, 400));
        this.tabbedPane.addTab(Messages.getString("SQLStatementsDialog.AttributesOrder"), jComponent);
    }

    private void initSQLTab() {
        this.chFormatted = new JCheckBox(Messages.getString("SQLStatementsDialog.ShowFormattedLimitMap"));
        this.chFormatted.setSelected(true);
        this.chFormatted.setEnabled(!this.readOnly);
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(this.chFormatted);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.selPane = new JTextArea();
        this.selPane.setEditable(!this.readOnly);
        JScrollPane jScrollPane = new JScrollPane(this.selPane);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jPanel.add((Component)jToolBar, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.tabbedPane.addTab(Messages.getString("SQLStatementsDialog.SQLStatements"), jPanel);
        this.chFormatted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLStatementsDialog.this.makeQuery();
            }
        });
    }

    private void setProperties() {
        int n = this.dimTable.getEditingColumn();
        int n2 = this.dimTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            this.dimTable.getCellEditor(n2, n).stopCellEditing();
        }
        this.sqlAW.getOutSQLAttributes().clear();
        for (int i = 0; i < this.dimList.size(); ++i) {
            SQLAttribute sQLAttribute = (SQLAttribute)this.dimList.get(i);
            sQLAttribute.setOutPosition(i);
            this.sqlAW.getOutSQLAttributes().add(sQLAttribute);
        }
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    public boolean moveToIndex(Object object, int n) {
        if (this.dimList.contains(object) && this.dimList.size() > n && n >= 0) {
            this.dimList.remove(object);
            this.dimList.add(n, object);
            return true;
        }
        return false;
    }

    private void makeQuery() {
        boolean bl = this.chFormatted.isSelected();
        String string = this.sqlAW.getSQLText(bl, this.dimList);
        this.selPane.setText(string);
    }

    class QueryGenerator
    implements ChangeListener {
        QueryGenerator() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == SQLStatementsDialog.this.tabbedPane && SQLStatementsDialog.this.tabbedPane.getSelectedIndex() == 1) {
                SQLStatementsDialog.this.makeQuery();
            }
        }
    }

    private class MoveDownAction2
    implements ActionListener {
        private MoveDownAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = SQLStatementsDialog.this.dimTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[nArray.length - 1]) < SQLStatementsDialog.this.dimList.size() - 1) {
                for (int i = nArray.length - 1; i > -1; --i) {
                    n = nArray[i];
                    Object e = SQLStatementsDialog.this.dimList.get(n);
                    SQLStatementsDialog.this.moveToIndex(e, n + 1);
                    nArray[i] = n + 1;
                }
                SQLStatementsDialog.this.dimTable.getSelectionModel().setSelectionInterval(nArray[0], nArray[nArray.length - 1]);
                SQLStatementsDialog.this.dimTable.updateUI();
            }
        }
    }

    private class MoveUpAction2
    implements ActionListener {
        private MoveUpAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = SQLStatementsDialog.this.dimTable.getSelectedRows();
            if (nArray.length > 0 && (n = nArray[0]) > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    Object e = SQLStatementsDialog.this.dimList.get(n);
                    SQLStatementsDialog.this.moveToIndex(e, n - 1);
                    nArray[i] = n - 1;
                }
                SQLStatementsDialog.this.dimTable.getSelectionModel().setSelectionInterval(nArray[0], nArray[nArray.length - 1]);
                SQLStatementsDialog.this.dimTable.updateUI();
            }
        }
    }

    private class DimensionTableModel
    extends AbstractTableModel {
        String[] names = new String[]{Messages.getString("SQLStatementsDialog.Name"), Messages.getString("SQLStatementsDialog.Type"), Messages.getString("SQLStatementsDialog.AWName"), Messages.getString("SQLStatementsDialog.Dimension"), Messages.getString("SQLStatementsDialog.Level"), Messages.getString("SQLStatementsDialog.DataType")};

        private DimensionTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public int getRowCount() {
            return SQLStatementsDialog.this.dimList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.names[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (SQLStatementsDialog.this.readOnly) {
                return false;
            }
            if (n2 == 0) {
                SQLAttribute sQLAttribute = (SQLAttribute)SQLStatementsDialog.this.dimList.get(n);
                return sQLAttribute.isNameEditable();
            }
            return n2 == 5;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SQLAttribute sQLAttribute = (SQLAttribute)SQLStatementsDialog.this.dimList.get(n);
            if (n2 == 0) {
                sQLAttribute.setName((String)object);
            } else if (n2 == 5) {
                sQLAttribute.setDataType((String)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SQLAttribute sQLAttribute = (SQLAttribute)SQLStatementsDialog.this.dimList.get(n);
            if (n2 == 0) {
                return sQLAttribute.getName();
            }
            if (n2 == 1) {
                return sQLAttribute.getType();
            }
            if (n2 == 2) {
                return sQLAttribute.getSQLAWName();
            }
            if (n2 == 3) {
                return sQLAttribute.getDimensionName();
            }
            if (n2 == 4) {
                return sQLAttribute.getLevelName();
            }
            if (n2 == 5) {
                return sQLAttribute.getDataType();
            }
            return new Integer(n * n2);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SQLStatementsDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SQLStatementsDialog.this.setProperties();
            SQLStatementsDialog.this.dispose();
        }
    }
}

