/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.SelectAttributesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;

public class RollupLinkPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private RollupLink link;
    private JButton bnChildLevel;
    private JButton bnParentLevel;
    private JTable aTable;
    private List aList;
    private ContainerObject factEntity;
    private JComboBox cbFactEntity;
    private String chl;
    private String pl;
    private JCheckBox chRolePlaying;
    private JCheckBox chSparse;
    private JTextField tfAggrOperator;
    private JPanel pnAttributes;
    private JLabel lbChildLevel;
    private JLabel lbParentLevel;
    private static final Dimension defaultSize = new Dimension(210, 20);

    public RollupLinkPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    @Override
    protected int getMinimumWidth() {
        return 630;
    }

    private void initGeneral() {
        this.lbChildLevel = new JLabel(this.chl);
        this.lbChildLevel.setPreferredSize(this.getDefaultSize());
        this.bnChildLevel = new JButton();
        this.bnChildLevel.setPreferredSize(this.getDefaultSize());
        this.bnChildLevel.setHorizontalAlignment(0);
        this.bnChildLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RollupLinkPropertiesDialogEx.this.link.getChildLevel() != null) {
                    RollupLinkPropertiesDialogEx.this.link.getChildLevel().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(this.lbChildLevel, this.bnChildLevel));
        this.lbParentLevel = new JLabel(this.pl);
        this.lbParentLevel.setPreferredSize(this.getDefaultSize());
        this.bnParentLevel = new JButton();
        this.bnParentLevel.setPreferredSize(this.getDefaultSize());
        this.bnParentLevel.setHorizontalAlignment(0);
        this.bnParentLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RollupLinkPropertiesDialogEx.this.link.getParentLevel() != null) {
                    RollupLinkPropertiesDialogEx.this.link.getParentLevel().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(this.lbParentLevel, this.bnParentLevel));
        JLabel jLabel = new JLabel(Messages.getString("RollupLinkPropertiesDialogEx.RolePlaying"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.chRolePlaying = new JCheckBox();
        this.chRolePlaying.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.chRolePlaying));
        JLabel jLabel2 = new JLabel(Messages.getString("RollupLinkPropertiesDialogEx.FactEntity"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbFactEntity = new JComboBox();
        this.cbFactEntity.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.cbFactEntity));
        this.cbFactEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RollupLinkPropertiesDialogEx.this.aTable != null) {
                    RollupLinkPropertiesDialogEx.this.factEntity = (ContainerObject)RollupLinkPropertiesDialogEx.this.cbFactEntity.getSelectedItem();
                    RollupLinkPropertiesDialogEx.this.aList.clear();
                    RollupLinkPropertiesDialogEx.this.aTable.updateUI();
                }
            }
        });
        JLabel jLabel3 = new JLabel(Messages.getString("RollupLinkPropertiesDialogEx.SparseDimension"));
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.chSparse = new JCheckBox();
        this.chSparse.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.chSparse));
        JLabel jLabel4 = new JLabel(Messages.getString("RollupLinkPropertiesDialogEx.DefaultAggrOperator"));
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.tfAggrOperator = new JTextField();
        this.tfAggrOperator.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.tfAggrOperator));
    }

    @Override
    public String getCaption() {
        if (this.getDesignObject() != null && ((RollupLink)this.getDesignObject()).getChildLevel() instanceof Cube && ((RollupLink)this.getDesignObject()).getParentLevel() instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
            return Messages.getString("RollupLinkPropertiesDialogEx.DimensionUsage");
        }
        return Messages.getString("RollupLinkPropertiesDialogEx.RollupLinkProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "ROLLUP_LINK_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof RollupLink) {
            this.link = (RollupLink)designObject;
            this.initDefaults(false);
            this.taDescription.setText(this.link.getDescription());
            if (this.link != null && this.link.getChildLevel() instanceof Cube && this.link.getParentLevel() instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                this.chl = Messages.getString("RollupLinkPropertiesDialogEx.Cube");
                this.pl = Messages.getString("RollupLinkPropertiesDialogEx.Dimension");
            } else {
                this.chl = LB_CHILD_LEVEL;
                this.pl = LB_PARENT_LEVEL;
            }
            this.lbChildLevel.setText(this.chl);
            this.lbParentLevel.setText(this.pl);
            String string = this.link.getChildLevel() != null ? this.link.getChildLevel().getName() : Messages.getString("RollupLinkPropertiesDialogEx.NONE");
            this.bnChildLevel.setText(string);
            String string2 = this.link.getParentLevel() != null ? this.link.getParentLevel().getName() : Messages.getString("RollupLinkPropertiesDialogEx.NONE");
            this.bnParentLevel.setText(string2);
            this.chRolePlaying.setSelected(this.link.isRolePlaying());
            if (this.link.getChildLevel() instanceof Cube) {
                this.factEntity = this.link.getFactEntity();
                this.fillComboItems(((Cube)this.link.getChildLevel()).getFactEntities().toArray(), this.cbFactEntity, true);
                this.cbFactEntity.setSelectedItem(this.factEntity);
                this.aList.addAll(((RollupLink)this.getDesignObject()).getChildToParentAttributes());
                if (this.aTable != null) {
                    this.aTable.updateUI();
                }
                this.chSparse.setSelected(this.link.isSparseDimension());
                this.tfAggrOperator.setText(this.link.getDefaultAggregationOperator());
            } else {
                this.cbFactEntity.setEnabled(false);
                this.chSparse.setEnabled(false);
                this.tfAggrOperator.setEnabled(false);
                this.chRolePlaying.setEnabled(false);
            }
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.link.getPropertyNames();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = this.link.getProperty(string3);
                DynamicProperty dynamicProperty = new DynamicProperty(string3, string4);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private boolean checkChildToParent() {
        RollupLink rollupLink = (RollupLink)this.getDesignObject();
        if (rollupLink.getChildLevel() != null && rollupLink.getChildLevel() instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
            return false;
        }
        if (rollupLink.getChildLevel() != null && rollupLink.getParentLevel() != null) {
            if (rollupLink.getChildLevel() instanceof Level && ((Level)rollupLink.getChildLevel()).getLevelEntity() != null && rollupLink.getParentLevel() instanceof Level && ((Level)rollupLink.getChildLevel()).getLevelEntity() == ((Level)rollupLink.getParentLevel()).getLevelEntity()) {
                return false;
            }
            if (rollupLink.getChildLevel() instanceof Cube && ((Cube)rollupLink.getChildLevel()).getFactEntity() == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.aList = new ArrayList();
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        if (this.checkChildToParent()) {
            this.aList.addAll(((RollupLink)this.getDesignObject()).getChildToParentAttributes());
            this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        }
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        Object object2;
        Link link;
        ObjectListener objectListener2;
        this.link.setName(this.tfName.getText());
        this.link.setComment(this.taComments.getText());
        this.link.setNotes(this.taNotes.getText());
        this.link.setDescription(this.taDescription.getText());
        this.link.getChildToParentAttributes().clear();
        this.link.setFactEntity(this.factEntity);
        this.link.setRolePlaying(this.chRolePlaying.isSelected());
        if (this.link.getChildLevel() instanceof Cube) {
            this.link.setDefaultAggregationOperator(this.tfAggrOperator.getText());
            this.link.setSparseDimension(this.chSparse.isSelected());
        }
        for (ObjectListener objectListener2 : this.aList) {
            this.link.addChildToParentAttribute((ContainedObject)objectListener2);
        }
        this.setResponsibleParties();
        this.setDocuments();
        objectListener2 = this.link.getChildLevel().getTopView();
        if (objectListener2 != null && ((TopView)objectListener2).getCellView() != null && ((TopView)objectListener2).getCellView().getDiagram() != null) {
            ((TopView)objectListener2).getCellView().getDiagram().repaint();
        }
        if ((link = this.link.getLink()) != null && (object2 = (TVLink)link.getTopView()) != null) {
            Label label = ((TVConnector)object2).getLabel(1);
            if (label != null) {
                label.setText(this.tfName.getText());
            }
            ((TVLink)object2).displayLabels();
        }
        RollupLinkPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.link.clearProperties();
        for (Object object2 : this.dynamicPropertiesList) {
            this.link.setProperty(((DynamicProperty)object2).getName(), ((DynamicProperty)object2).getValue());
        }
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            JComponent jComponent;
            this.pnAttributes = this.createPage(Messages.getString("RollupLinkPropertiesDialogEx.ChildToParentAttributes"));
            this.aTable = new JTable(new AttributeModel());
            this.aTable.setSelectionMode(0);
            this.aTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = RollupLinkPropertiesDialogEx.this.aTable.getSelectedRow()) > -1 && RollupLinkPropertiesDialogEx.this.aList.size() > 0 && n < RollupLinkPropertiesDialogEx.this.aList.size()) {
                        ContainedObject containedObject = (ContainedObject)RollupLinkPropertiesDialogEx.this.aList.get(n);
                        containedObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.aTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = RollupLinkPropertiesDialogEx.this.aTable.getSelectedRow();
                    if (n > -1 && RollupLinkPropertiesDialogEx.this.aList.size() > 0 && n < RollupLinkPropertiesDialogEx.this.aList.size()) {
                        ContainedObject containedObject = (ContainedObject)RollupLinkPropertiesDialogEx.this.aList.get(n);
                        containedObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ContainerObject containerObject = null;
                        if (RollupLinkPropertiesDialogEx.this.link.getChildLevel() instanceof Cube) {
                            containerObject = RollupLinkPropertiesDialogEx.this.factEntity;
                        } else if (RollupLinkPropertiesDialogEx.this.link.getChildLevel() instanceof Level) {
                            containerObject = ((Level)RollupLinkPropertiesDialogEx.this.link.getChildLevel()).getLevelEntity();
                        }
                        SelectAttributesDialog selectAttributesDialog = new SelectAttributesDialog(RollupLinkPropertiesDialogEx.this.getAppView(), RollupLinkPropertiesDialogEx.this.aList, containerObject);
                        selectAttributesDialog.setVisible(true);
                        RollupLinkPropertiesDialogEx.this.aTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = RollupLinkPropertiesDialogEx.this.aTable.getSelectedRow();
                        if (n != -1 && RollupLinkPropertiesDialogEx.this.aList.size() > 0 && n < RollupLinkPropertiesDialogEx.this.aList.size()) {
                            RollupLinkPropertiesDialogEx.this.aList.remove(n);
                            RollupLinkPropertiesDialogEx.this.aTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnAttributes.add(jComponent);
        }
        return this.pnAttributes;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class AttributeModel
    extends AbstractTableModel {
        private AttributeModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return RollupLinkPropertiesDialogEx.this.aList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("RollupLinkPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ContainedObject containedObject = (ContainedObject)RollupLinkPropertiesDialogEx.this.aList.get(n);
            if (n2 == 0) {
                return containedObject.getLongName();
            }
            return new Integer(n * n2);
        }
    }
}

