/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.SelectAttributesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.ide.Ide;

public class RaggedHLinkPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private RaggedHLink link;
    private JButton bnChildLevel;
    private JButton bnParentLevel;
    private JTable aTable;
    private List aList;
    private JPanel pnAttributes;

    public RaggedHLinkPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_CHILD_LEVEL);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.bnChildLevel = new JButton();
        this.bnChildLevel.setPreferredSize(this.getDefaultSize());
        this.bnChildLevel.setHorizontalAlignment(0);
        this.bnChildLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RaggedHLinkPropertiesDialogEx.this.link.getChildLevel() != null) {
                    RaggedHLinkPropertiesDialogEx.this.link.getChildLevel().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel, this.bnChildLevel));
        JLabel jLabel2 = new JLabel(LB_PARENT_LEVEL);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.bnParentLevel = new JButton();
        this.bnParentLevel.setPreferredSize(this.getDefaultSize());
        this.bnParentLevel.setHorizontalAlignment(0);
        this.bnParentLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RaggedHLinkPropertiesDialogEx.this.link.getParentLevel() != null) {
                    RaggedHLinkPropertiesDialogEx.this.link.getParentLevel().showPropertyDialog();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.bnParentLevel));
    }

    @Override
    public String getCaption() {
        return Messages.getString("RaggedHLinkPropertiesDialogEx.RaggedLinkProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "RAGGED_LINK_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof RaggedHLink) {
            this.link = (RaggedHLink)designObject;
            this.initDefaults(false);
            this.taDescription.setText(this.link.getDescription());
            String string = this.link.getChildLevel() != null ? this.link.getChildLevel().getName() : Messages.getString("RaggedHLinkPropertiesDialogEx.NONE");
            this.bnChildLevel.setText(string);
            String string2 = this.link.getParentLevel() != null ? this.link.getParentLevel().getName() : Messages.getString("RaggedHLinkPropertiesDialogEx.NONE");
            this.bnParentLevel.setText(string2);
            this.aList.addAll(this.link.getChildToParentAttributes());
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.link.getPropertyNames();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = this.link.getProperty(string3);
                DynamicProperty dynamicProperty = new DynamicProperty(string3, string4);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.aList = new ArrayList();
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        ObjectListener objectListener2;
        this.link.setName(this.tfName.getText());
        this.link.setComment(this.taComments.getText());
        this.link.setNotes(this.taNotes.getText());
        this.link.setDescription(this.taDescription.getText());
        this.link.getChildToParentAttributes().clear();
        for (ObjectListener objectListener2 : this.aList) {
            this.link.addChildToParentAttribute((Attribute)objectListener2);
        }
        objectListener2 = this.link.getChildLevel().getTopView();
        if (objectListener2 != null && ((TopView)objectListener2).getCellView() != null && ((TopView)objectListener2).getCellView().getDiagram() != null) {
            ((TopView)objectListener2).getCellView().getDiagram().repaint();
        }
        this.setResponsibleParties();
        this.setDocuments();
        RaggedHLinkPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.link.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.link.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            JComponent jComponent;
            this.pnAttributes = this.createPage(Messages.getString("RaggedHLinkPropertiesDialogEx.ChildToParentAttributes"));
            this.aTable = new JTable(new AttributeModel());
            this.aTable.setSelectionMode(0);
            this.aTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = RaggedHLinkPropertiesDialogEx.this.aTable.getSelectedRow()) > -1 && RaggedHLinkPropertiesDialogEx.this.aList.size() > 0 && n < RaggedHLinkPropertiesDialogEx.this.aList.size()) {
                        Attribute attribute = (Attribute)RaggedHLinkPropertiesDialogEx.this.aList.get(n);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.aTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = RaggedHLinkPropertiesDialogEx.this.aTable.getSelectedRow();
                    if (n > -1 && RaggedHLinkPropertiesDialogEx.this.aList.size() > 0 && n < RaggedHLinkPropertiesDialogEx.this.aList.size()) {
                        Attribute attribute = (Attribute)RaggedHLinkPropertiesDialogEx.this.aList.get(n);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ContainerObject containerObject = RaggedHLinkPropertiesDialogEx.this.link.getChildLevel().getLevelEntity();
                        if (containerObject == null) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("RaggedHLinkPropertiesDialogEx.LevelEntityNotSetForChildLevel") + RaggedHLinkPropertiesDialogEx.this.link.getChildLevel().getName(), RaggedHLinkPropertiesDialogEx.this.link.getName(), 0);
                            return;
                        }
                        if (RaggedHLinkPropertiesDialogEx.this.link.getParentLevel().getLevelEntity() == null) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("RaggedHLinkPropertiesDialogEx.LevelEntityNotSetForParentLevel") + RaggedHLinkPropertiesDialogEx.this.link.getParentLevel().getName(), RaggedHLinkPropertiesDialogEx.this.link.getName(), 0);
                            return;
                        }
                        if (RaggedHLinkPropertiesDialogEx.this.link.getChildLevel().getLevelEntity() == RaggedHLinkPropertiesDialogEx.this.link.getParentLevel().getLevelEntity()) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("RaggedHLinkPropertiesDialogEx.ChildParentLevelsDefinedSameEntity"), RaggedHLinkPropertiesDialogEx.this.link.getName(), 0);
                            return;
                        }
                        SelectAttributesDialog selectAttributesDialog = new SelectAttributesDialog(RaggedHLinkPropertiesDialogEx.this.getAppView(), RaggedHLinkPropertiesDialogEx.this.aList, containerObject);
                        selectAttributesDialog.show();
                        RaggedHLinkPropertiesDialogEx.this.aTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = RaggedHLinkPropertiesDialogEx.this.aTable.getSelectedRow();
                        if (n != -1 && RaggedHLinkPropertiesDialogEx.this.aList.size() > 0 && n < RaggedHLinkPropertiesDialogEx.this.aList.size()) {
                            RaggedHLinkPropertiesDialogEx.this.aList.remove(n);
                            RaggedHLinkPropertiesDialogEx.this.aTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnAttributes.add(jComponent);
        }
        return this.pnAttributes;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class AttributeModel
    extends AbstractTableModel {
        private AttributeModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return RaggedHLinkPropertiesDialogEx.this.aList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("RaggedHLinkPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Attribute attribute = (Attribute)RaggedHLinkPropertiesDialogEx.this.aList.get(n);
            if (n2 == 0) {
                return attribute.getLongName();
            }
            return new Integer(n * n2);
        }
    }
}

