/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.PresummarizedLevelsDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;

public class MeasurePropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Measure measure;
    private JCheckBox chFormula;
    private JCheckBox chFactDimension;
    private JCheckBox chCustFormula;
    private JComboBox cbAggregations;
    private JButton btnWhere;
    private JComboBox cbAdditivity;
    private JComboBox cbFormulaType;
    private JLNComboBox cbFact;
    private List functions;
    private List cubeDimensions;
    private JButton btnFormula;
    private JPanel pnAggrFunctions;
    private JTable tbTarget;
    private JButton btnProperties;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnAddF;
    private JButton btnRemoveF;
    private JButton btnSummaryLevels;
    private JTable sTable;
    private List sList;
    private JPanel pnOlap;
    private JPanel pnOlapMeasure;
    private JComboBox cbOperator;
    private JComboBox cbOlapDimension;
    private JComboBox cbOlapHierarchy;
    private JComboBox cbOlapLevel;
    private JComboBox cbMeasure;
    private JComboBox cbPD_Operation;
    private JComboBox cbRankDirection;
    private JIntegerField ifOffset;
    private JIntegerField ifStart;
    private JIntegerField ifStop;
    private JIntegerField ifStep;
    private oracle.dbtools.crest.model.design.multidimensional.Dimension curDimension;
    private Hierarchy curHierarchy;
    private static final Dimension defaultSize = new Dimension(210, 20);

    public MeasurePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    public MeasurePropertiesDialogEx(Dialog dialog, ApplicationView applicationView, DesignObject designObject) {
        super(dialog, applicationView, designObject);
        this.initGeneral();
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    @Override
    protected int getMinimumWidth() {
        return 630;
    }

    @Override
    protected int getMinimumHeight() {
        return 480;
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_IS_FORMULA);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.chFormula = new JCheckBox();
        this.chFormula.setPreferredSize(this.getDefaultSize());
        this.chFormula.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasurePropertiesDialogEx.this.enableOLAPMeasureTab();
                MeasurePropertiesDialogEx.this.btnFormula.setEnabled(MeasurePropertiesDialogEx.this.chFormula.isSelected());
                MeasurePropertiesDialogEx.this.cbFact.setEnabled(!MeasurePropertiesDialogEx.this.chFormula.isSelected());
                MeasurePropertiesDialogEx.this.cbFormulaType.setEnabled(MeasurePropertiesDialogEx.this.chFormula.isSelected());
                MeasurePropertiesDialogEx.this.chCustFormula.setEnabled(MeasurePropertiesDialogEx.this.chFormula.isSelected());
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel, this.chFormula));
        JLabel jLabel2 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.CustomFormula"));
        jLabel2.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.CustomOLAPFormulasNotParsed"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chCustFormula = new JCheckBox();
        this.chCustFormula.setToolTipText(jLabel2.getToolTipText());
        this.chCustFormula.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chCustFormula));
        JLabel jLabel3 = new JLabel(LB_FORMULA);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.btnFormula = new JButton();
        this.btnFormula.setPreferredSize(this.getDefaultSize());
        this.btnFormula.setHorizontalAlignment(0);
        this.btnFormula.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringEditor stringEditor = new StringEditor(MeasurePropertiesDialogEx.this.getAppView(), MeasurePropertiesDialogEx.this.btnFormula.getText(), Messages.getString("MeasurePropertiesDialogEx.FormulaEditor"));
                stringEditor.setModal(true);
                stringEditor.show();
                if (!stringEditor.cancel) {
                    MeasurePropertiesDialogEx.this.btnFormula.setText(stringEditor.getText());
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.btnFormula));
        JLabel jLabel4 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.FormulaType"));
        jLabel4.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.CustomOLAPFormulasNotParsed"));
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.cbFormulaType = new JComboBox<String>(Measure.AW_FORMULA_TYPES);
        this.cbFormulaType.setToolTipText(jLabel4.getToolTipText());
        this.cbFormulaType.setPreferredSize(this.getDefaultSize());
        this.cbFormulaType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasurePropertiesDialogEx.this.enableOLAPMeasureTab();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.cbFormulaType));
        JLabel jLabel5 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.BasedOnFact"));
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.cbFact = new JLNComboBox();
        this.cbFact.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.cbFact));
        JLabel jLabel6 = new JLabel(LB_ADDITIVITY);
        jLabel6.setPreferredSize(this.getDefaultSize());
        this.cbAdditivity = new JComboBox<String>(Measure.ADDITIVITY_TYPES);
        this.cbAdditivity.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.cbAdditivity));
        JLabel jLabel7 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.FactDimension"));
        jLabel7.setPreferredSize(this.getDefaultSize());
        this.chFactDimension = new JCheckBox();
        this.chFactDimension.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.chFactDimension));
        JLabel jLabel8 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.AggregationFunctionL"));
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.cbAggregations = new JComboBox();
        this.cbAggregations.setPreferredSize(this.getDefaultSize());
        this.cbAggregations.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.FunctionUsedToAggregateOnCube"));
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.cbAggregations));
        JLabel jLabel9 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.WhereClause"));
        jLabel9.setPreferredSize(this.getDefaultSize());
        this.btnWhere = new JButton();
        this.btnWhere.setPreferredSize(this.getDefaultSize());
        this.btnWhere.setHorizontalAlignment(0);
        this.btnWhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringEditor stringEditor = new StringEditor(MeasurePropertiesDialogEx.this.getAppView(), MeasurePropertiesDialogEx.this.btnWhere.getText(), Messages.getString("MeasurePropertiesDialogEx.WhereClauseRestriction"), !MeasurePropertiesDialogEx.this.isEditable());
                stringEditor.setModal(true);
                stringEditor.show();
                if (!stringEditor.cancel) {
                    MeasurePropertiesDialogEx.this.btnWhere.setText(stringEditor.getText());
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel9, this.btnWhere));
    }

    private void enableOLAPMeasureTab() {
        String string = (String)this.cbFormulaType.getSelectedItem();
        if (this.chFormula.isSelected() && string.equalsIgnoreCase(Measure.AW_OLAP_FORMULA)) {
            this.enableOLAPMeasure(true);
            this.enableAggregationFunctions(false);
        } else {
            this.enableOLAPMeasure(false);
            this.enableAggregationFunctions(true);
        }
    }

    @Override
    public String getCaption() {
        return Messages.getString("MeasurePropertiesDialogEx.MeasureProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "MEASURE_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Measure) {
            this.measure = (Measure)designObject;
            this.initDefaults(false);
            this.taDescription.setText(this.measure.getDescription());
            this.functions.addAll(this.measure.getAggregateFunctions());
            this.cubeDimensions.addAll(this.measure.getCube().getDimensions());
            this.chCustFormula.setSelected(this.measure.isCustomFormula());
            this.chFormula.setSelected(this.measure.isFormula());
            this.btnFormula.setEnabled(this.chFormula.isSelected());
            this.cbFact.setEnabled(!this.chFormula.isSelected());
            this.cbFormulaType.setEnabled(this.chFormula.isSelected());
            this.chCustFormula.setEnabled(this.chFormula.isSelected());
            this.btnFormula.setText(this.measure.getFormula());
            this.cbFormulaType.setSelectedItem(this.measure.getOracleAWFormulaType());
            if (this.measure.getCube().getFactEntities().size() <= 1) {
                this.cbFact.setStandardType(true);
            }
            this.fillComboItems(this.measure.getCandidateFactsAndNull().toArray(), this.cbFact, true);
            this.cbFact.setSelectedItem(this.measure.getMeasureFact());
            if (this.measure.getMeasureFact() != null) {
                this.cbFact.setToolTipText(this.measure.getMeasureFact().getLongName());
            }
            this.cbAdditivity.setSelectedItem(this.measure.getAdditivity());
            if (this.measure.getAdditivity().equalsIgnoreCase(Measure.NON_ADDITIVE)) {
                this.chFactDimension.setSelected(this.measure.isActAsFactDimension());
            } else {
                this.chFactDimension.setEnabled(false);
            }
            this.fillComboItems(this.functions.toArray(), this.cbAggregations, false);
            this.cbAggregations.setSelectedItem(this.measure.getDefaultAggregationFunction());
            this.btnWhere.setText(this.measure.getWhereClause());
            this.fillComboItems(this.getMeasures(), this.cbMeasure, false);
            this.cbMeasure.setSelectedItem(this.measure.getUsedOLAPMeasure());
            this.cbOperator.setSelectedItem(this.measure.getOLAPOperator());
            this.curDimension = this.measure.getOLAPDimension();
            this.cbOlapDimension.setSelectedItem(this.curDimension);
            if (this.measure.getOLAPDimension() != null) {
                this.fillComboItems(this.measure.getOLAPDimension().getHierarchies().toArray(), this.cbOlapHierarchy, true);
            }
            this.cbOlapHierarchy.setSelectedItem(this.measure.getOLAPHierarchy());
            if (this.measure.getOLAPHierarchy() != null) {
                this.fillComboItems(this.measure.getOLAPHierarchy().getLevels().toArray(), this.cbOlapLevel, true);
            }
            this.cbOlapLevel.setSelectedItem(this.measure.getOLAPLevel());
            this.presetControls();
            this.ifOffset.setValue((long)this.measure.getOLAPOffset());
            this.ifStart.setValue((long)this.measure.getOLAPStart());
            this.ifStop.setValue((long)this.measure.getOLAPStop());
            this.ifStep.setValue((long)this.measure.getOLAPStep());
            this.cbPD_Operation.setSelectedItem(this.measure.getOLAPPeriodToDateOperation());
            this.cbRankDirection.setSelectedItem(this.measure.getRankDirectionName());
            this.cbOlapDimension.setSelectedItem(this.curDimension);
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.measure.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.measure.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private Object[] getMeasures() {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : this.measure.getCube().getMeasures()) {
            if (measure == this.measure || measure.isFactDimension()) continue;
            arrayList.add(measure);
        }
        return arrayList.toArray();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.functions = new ArrayList();
        this.cubeDimensions = new ArrayList();
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getAggregationFunctionsPanel());
        this.addToTree(defaultMutableTreeNode, this.getOlapPanel());
        this.addToTree(defaultMutableTreeNode, this.getOracleNamesPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        Object object;
        int n = this.tbTarget.getEditingColumn();
        int n2 = this.tbTarget.getEditingRow();
        if (n2 >= 0 && n >= 0) {
            this.tbTarget.getCellEditor(n2, n).stopCellEditing();
        }
        this.measure.setName(this.tfName.getText());
        this.measure.setComment(this.taComments.getText());
        this.measure.setNotes(this.taNotes.getText());
        this.measure.setDescription(this.taDescription.getText());
        this.measure.setFormula(this.chFormula.isSelected());
        this.measure.setFormula(this.btnFormula.getText());
        if (this.measure.isFormula()) {
            this.measure.setCustomFormula(this.chCustFormula.isSelected());
        } else {
            this.measure.setCustomFormula(false);
        }
        this.measure.setMeasureFact((ContainedObject)this.cbFact.getSelectedItem());
        this.measure.setDefaultAggregationFunction((Measure.AggregateFunction)this.cbAggregations.getSelectedItem());
        this.measure.getAttributes().clear();
        List list = this.measure.getAggregateFunctions();
        list.clear();
        list.addAll(this.functions);
        this.measure.setAdditivity((String)this.cbAdditivity.getSelectedItem());
        this.measure.setOracleAWFormulaType((String)this.cbFormulaType.getSelectedItem());
        this.measure.setActAsFactDimension(this.chFactDimension.isSelected());
        if (this.chFormula.isSelected() && ((String)(object = (String)this.cbFormulaType.getSelectedItem())).equalsIgnoreCase(Measure.AW_OLAP_FORMULA)) {
            this.setOLAPProperties();
        }
        this.measure.setWhereClause(this.btnWhere.getText().trim());
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        MeasurePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.measure.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.measure.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    private void setOLAPProperties() {
        String string = (String)this.cbOperator.getSelectedItem();
        this.measure.setOLAPOperator(string);
        this.measure.setUsedOLAPMeasure((Measure)this.cbMeasure.getSelectedItem());
        string = this.getObjectID(string);
        this.measure.setOLAPDimension((oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbOlapDimension.getSelectedItem());
        if (string.indexOf("PRIOR_PERIOD") > -1 || string.indexOf("FUTURE_PERIOD") > -1 || string.indexOf("PERIOD_TO_DATE") > -1 || string.indexOf("SAME_PERIOD_ANCESTORS") > -1 || string.indexOf("SHARE_TO") > -1 || string.indexOf("RANK_") > -1 || string.indexOf("CUMULATIVE_TOTAL") > -1) {
            this.measure.setOLAPHierarchy((Hierarchy)this.cbOlapHierarchy.getSelectedItem());
        } else {
            this.measure.setOLAPHierarchy(null);
        }
        if (string.indexOf("PERIOD_TO_DATE") > -1 || string.indexOf("SHARE_TO_LEVEL") > -1) {
            this.measure.setOLAPLevel((Level)this.cbOlapLevel.getSelectedItem());
        } else {
            this.measure.setOLAPLevel(null);
        }
        if (string.indexOf("LEAD") > -1 || string.indexOf("LAG") > -1 || string.indexOf("PRIOR_PERIOD") > -1 || string.indexOf("FUTURE_PERIOD") > -1 || string.indexOf("SAME_PERIOD_ANCESTORS") > -1) {
            this.measure.setOLAPOffset(this.ifOffset.getIntValue());
        } else {
            this.measure.setOLAPOffset(0);
        }
        if (string.indexOf("MOVING") > -1) {
            this.measure.setOLAPStart(this.ifStart.getIntValue());
            this.measure.setOLAPStop(this.ifStop.getIntValue());
            this.measure.setOLAPStep(this.ifStep.getIntValue());
        } else {
            this.measure.setOLAPStart(0);
            this.measure.setOLAPStop(1);
            this.measure.setOLAPStep(1);
        }
        if (string.indexOf("PERIOD_TO_DATE") > -1) {
            this.measure.setOLAPPeriodToDateOperation((String)this.cbPD_Operation.getSelectedItem());
        }
        if (string.indexOf("RANK_") > -1) {
            this.measure.setRankDirectionName((String)this.cbRankDirection.getSelectedItem());
        }
    }

    private void updateAggrFunctionCBModel() {
        Object object = this.cbAggregations.getSelectedItem();
        this.cbAggregations.setModel(new DefaultComboBoxModel<Object>(this.functions.toArray()));
        if (this.functions.contains(object)) {
            this.cbAggregations.setSelectedItem(object);
        }
    }

    private List makeSelecteDimensions() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.measure.getCube().getDimensions());
        return arrayList;
    }

    private void updateSourceElements(Measure.AggregateFunction aggregateFunction) {
        this.sList.clear();
        Iterator iterator = aggregateFunction.dimensions.iterator();
        while (iterator.hasNext()) {
            this.sList.add(iterator.next());
        }
        this.sTable.updateUI();
    }

    private void resetDimButtons() {
        if (this.isEditable()) {
            String string = (String)this.cbAdditivity.getSelectedItem();
            if (Measure.FULLY_ADDITIVE.equalsIgnoreCase(string)) {
                this.btnAdd.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnProperties.setEnabled(false);
            } else if (Measure.SEMI_ADDITIVE.equalsIgnoreCase(string)) {
                this.btnAdd.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.btnProperties.setEnabled(true);
            } else if (Measure.NON_ADDITIVE.equalsIgnoreCase(string)) {
                this.btnAdd.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnProperties.setEnabled(false);
            }
        }
    }

    private void enableButtons(boolean bl) {
        if (this.isEditable()) {
            this.btnProperties.setEnabled(bl);
            this.btnAdd.setEnabled(bl);
            this.btnRemove.setEnabled(bl);
        }
    }

    protected JPanel getAggregationFunctionsPanel() {
        if (this.pnAggrFunctions == null) {
            Object object;
            this.pnAggrFunctions = this.createPage(Messages.getString("MeasurePropertiesDialogEx.AggregationFunctions"));
            this.sList = new ArrayList();
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("MeasurePropertiesDialogEx.Functions")));
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                this.btnAddF = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAddF.setToolTipText(BTN_ADD);
                this.btnAddF.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Measure.AggregateFunction aggregateFunction = MeasurePropertiesDialogEx.this.measure.createAggregateFunction();
                        MeasurePropertiesDialogEx.this.functions.add(aggregateFunction);
                        MeasurePropertiesDialogEx.this.tbTarget.updateUI();
                        MeasurePropertiesDialogEx.this.updateAggrFunctionCBModel();
                    }
                });
                this.btnRemoveF = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveF.setToolTipText(BTN_REMOVE);
                this.btnRemoveF.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (n != -1 && MeasurePropertiesDialogEx.this.functions.size() > 0 && n < MeasurePropertiesDialogEx.this.functions.size()) {
                            int n2 = MeasurePropertiesDialogEx.this.tbTarget.getEditingColumn();
                            int n3 = MeasurePropertiesDialogEx.this.tbTarget.getEditingRow();
                            if (n3 >= 0 && n2 >= 0) {
                                MeasurePropertiesDialogEx.this.tbTarget.getCellEditor(n3, n2).stopCellEditing();
                            }
                            if (n == MeasurePropertiesDialogEx.this.functions.size() - 1) {
                                MeasurePropertiesDialogEx.this.tbTarget.clearSelection();
                            }
                            MeasurePropertiesDialogEx.this.functions.remove(n);
                            ((TargetTableModel)MeasurePropertiesDialogEx.this.tbTarget.getModel()).dataChanged();
                            n3 = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                            MeasurePropertiesDialogEx.this.sList.clear();
                            if (n3 != -1) {
                                Measure.AggregateFunction aggregateFunction = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(n3);
                                MeasurePropertiesDialogEx.this.sList.addAll(aggregateFunction.dimensions);
                            }
                            MeasurePropertiesDialogEx.this.sTable.updateUI();
                            MeasurePropertiesDialogEx.this.updateAggrFunctionCBModel();
                        }
                    }
                });
                this.btnSummaryLevels = new JButton(gUIConfiguration.getIcon("LEVEL_ICON", this.getPreferredIconSize()));
                this.btnSummaryLevels.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.SetOracleAWPresummarizedLevels"));
                this.btnSummaryLevels.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (n != -1 && MeasurePropertiesDialogEx.this.functions.size() > 0 && n < MeasurePropertiesDialogEx.this.functions.size()) {
                            Measure.AggregateFunction aggregateFunction = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(n);
                            String string = MessageFormat.format(Messages.getString("MeasurePropertiesDialogEx.SummaryLevelsFor"), aggregateFunction.measureAlias);
                            PresummarizedLevelsDialog presummarizedLevelsDialog = new PresummarizedLevelsDialog(MeasurePropertiesDialogEx.this.getAppView(), MeasurePropertiesDialogEx.this.makeSelecteDimensions(), aggregateFunction.levels, string);
                            presummarizedLevelsDialog.setVisible(true);
                        }
                    }
                });
                object = new JToolBar(0);
                ((JToolBar)object).setFloatable(false);
                ((Container)object).add(this.btnAddF);
                ((Container)object).add(this.btnRemoveF);
                ((JToolBar)object).addSeparator();
                ((Container)object).add(this.btnSummaryLevels);
                jPanel3.add((Component)object);
            }
            this.tbTarget = new JTable(new TargetTableModel());
            this.tbTarget.setPreferredScrollableViewportSize(new Dimension(325, 120));
            this.tbTarget.setSelectionMode(0);
            object = new SelectionListener(this.tbTarget);
            this.tbTarget.getSelectionModel().addListSelectionListener((ListSelectionListener)object);
            JScrollPane jScrollPane = new JScrollPane(this.tbTarget);
            jPanel2.add((Component)jPanel3, "North");
            jScrollPane.setPreferredSize(new Dimension(325, 160));
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel.add((Component)jPanel2, "North");
            this.sTable = new JTable(new SourceElementsModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = MeasurePropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && MeasurePropertiesDialogEx.this.sList.size() > 0 && n < MeasurePropertiesDialogEx.this.sList.size()) {
                        DesignObject designObject = (DesignObject)MeasurePropertiesDialogEx.this.sList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane2 = new JScrollPane(this.sTable);
            JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
            this.btnProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = MeasurePropertiesDialogEx.this.sTable.getSelectedRow();
                    if (n != -1 && MeasurePropertiesDialogEx.this.sList.size() > 0 && n < MeasurePropertiesDialogEx.this.sList.size()) {
                        DesignObject designObject = (DesignObject)MeasurePropertiesDialogEx.this.sList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SelectElementsDialog selectElementsDialog = new SelectElementsDialog(MeasurePropertiesDialogEx.this.getAppView(), MeasurePropertiesDialogEx.this.cubeDimensions, MeasurePropertiesDialogEx.this.sList);
                        selectElementsDialog.setVisible(true);
                        MeasurePropertiesDialogEx.this.sTable.updateUI();
                        int n = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                        if (n != -1 && !selectElementsDialog.cancel && n != -1) {
                            Measure.AggregateFunction aggregateFunction = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(n);
                            aggregateFunction.dimensions.clear();
                            for (DesignObject designObject : MeasurePropertiesDialogEx.this.sList) {
                                aggregateFunction.dimensions.add(designObject);
                            }
                        }
                    }
                });
                this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = MeasurePropertiesDialogEx.this.sTable.getSelectedRow();
                        if (n != -1 && MeasurePropertiesDialogEx.this.sList.size() > 0 && n < MeasurePropertiesDialogEx.this.sList.size()) {
                            MeasurePropertiesDialogEx.this.sList.remove(n);
                            MeasurePropertiesDialogEx.this.sTable.updateUI();
                            int n2 = MeasurePropertiesDialogEx.this.tbTarget.getSelectedRow();
                            if (n2 != -1) {
                                Measure.AggregateFunction aggregateFunction = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(n2);
                                aggregateFunction.dimensions.clear();
                                for (DesignObject designObject : MeasurePropertiesDialogEx.this.sList) {
                                    aggregateFunction.dimensions.add(designObject);
                                }
                            }
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAdd);
                jToolBar.add(this.btnRemove);
                this.enableButtons(false);
            }
            jPanel4.add(jToolBar);
            JPanel jPanel5 = new JPanel(new BorderLayout());
            jPanel5.setBorder(BorderFactory.createTitledBorder(Messages.getString("MeasurePropertiesDialogEx.Dimensions")));
            jPanel5.add((Component)jPanel4, "North");
            jPanel5.add((Component)jScrollPane2, "Center");
            jPanel.add(jPanel5);
            this.pnAggrFunctions.add(jPanel);
        }
        return this.pnAggrFunctions;
    }

    private String getObjectID(String string) {
        String string2 = "[^A-Z0-9_]";
        String string3 = string.toUpperCase();
        string3 = string3.replaceAll(string2, "_");
        return string3;
    }

    private Object[] getTimeDimensions() {
        ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension> arrayList = new ArrayList<oracle.dbtools.crest.model.design.multidimensional.Dimension>();
        for (oracle.dbtools.crest.model.design.multidimensional.Dimension dimension : this.measure.getCube().getDimensions()) {
            if (!dimension.isTimeDimension()) continue;
            arrayList.add(dimension);
        }
        return arrayList.toArray();
    }

    private void presetControls() {
        oracle.dbtools.crest.model.design.multidimensional.Dimension dimension;
        String string = (String)this.cbOperator.getSelectedItem();
        if ((string = this.getObjectID(string)).indexOf("SHARE_TO") > -1 || string.indexOf("RANK_") > -1) {
            dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbOlapDimension.getSelectedItem();
            this.cbOlapDimension.setModel(new DefaultComboBoxModel<Object>(this.measure.getCube().getDimensions().toArray()));
            this.cbOlapDimension.setSelectedItem(dimension);
        } else {
            dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbOlapDimension.getSelectedItem();
            this.cbOlapDimension.setModel(new DefaultComboBoxModel<Object>(this.getTimeDimensions()));
            this.cbOlapDimension.setSelectedItem(dimension);
        }
        dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbOlapDimension.getSelectedItem();
        if (dimension != null && dimension != this.curDimension) {
            this.curDimension = dimension;
            this.cbOlapHierarchy.setModel(new DefaultComboBoxModel<Object>(dimension.getHierarchies().toArray()));
            if (dimension.getHierarchies().size() > 0) {
                Hierarchy hierarchy = (Hierarchy)dimension.getHierarchies().getElement(0);
                this.cbOlapHierarchy.setSelectedItem(hierarchy);
                this.cbOlapLevel.setModel(new DefaultComboBoxModel<Object>(hierarchy.getLevels().toArray()));
                if (hierarchy.getLevels().size() > 0) {
                    this.cbOlapHierarchy.setSelectedItem(hierarchy.getLevels().get(0));
                }
            }
        }
        if (string.indexOf("PRIOR_PERIOD") > -1 || string.indexOf("FUTURE_PERIOD") > -1 || string.indexOf("PERIOD_TO_DATE") > -1 || string.indexOf("SAME_PERIOD_ANCESTORS") > -1 || string.indexOf("SHARE_TO") > -1 || string.indexOf("RANK_") > -1 || string.indexOf("CUMULATIVE_TOTAL") > -1) {
            this.cbOlapHierarchy.setEnabled(true);
        } else {
            this.cbOlapHierarchy.setEnabled(false);
        }
        if (string.indexOf("PERIOD_TO_DATE") > -1 || string.indexOf("SHARE_TO_LEVEL") > -1) {
            this.cbOlapLevel.setEnabled(true);
        } else {
            this.cbOlapLevel.setEnabled(false);
        }
        if (string.indexOf("LEAD") > -1 || string.indexOf("LAG") > -1 || string.indexOf("PRIOR_PERIOD") > -1 || string.indexOf("FUTURE_PERIOD") > -1 || string.indexOf("SAME_PERIOD_ANCESTORS") > -1) {
            this.ifOffset.setEnabled(true);
        } else {
            this.ifOffset.setEnabled(false);
        }
        if (string.indexOf("MOVING") > -1) {
            this.ifStart.setEnabled(true);
            this.ifStop.setEnabled(true);
            this.ifStep.setEnabled(true);
        } else {
            this.ifStart.setEnabled(false);
            this.ifStop.setEnabled(false);
            this.ifStep.setEnabled(false);
        }
        if (string.indexOf("PERIOD_TO_DATE") > -1) {
            this.cbPD_Operation.setEnabled(true);
        } else {
            this.cbPD_Operation.setEnabled(false);
        }
        if (string.indexOf("RANK_") > -1) {
            this.cbRankDirection.setEnabled(true);
        } else {
            this.cbRankDirection.setEnabled(false);
        }
    }

    protected JPanel getOlapPanel() {
        if (this.pnOlap == null) {
            this.pnOlap = this.createPage(Messages.getString("MeasurePropertiesDialogEx.OracleOLAPMeasure"));
            this.pnOlapMeasure = new JPanel(new BorderLayout());
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(Messages.getString("MeasurePropertiesDialogEx.OLAPOperator"));
            jLabel.setPreferredSize(this.getDefaultSize());
            this.cbOperator = new JComboBox<String>(Measure.OLAP_OPERATORS);
            this.cbOperator.setMaximumRowCount(20);
            this.cbOperator.setPreferredSize(this.getDefaultSize());
            this.cbOperator.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MeasurePropertiesDialogEx.this.presetControls();
                }
            });
            jPanel.add(this.createRow(jLabel, this.cbOperator));
            JLabel jLabel2 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Measure"));
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.cbMeasure = new JComboBox();
            this.cbMeasure.setPreferredSize(this.getDefaultSize());
            jPanel.add(this.createRow(jLabel2, this.cbMeasure));
            JLabel jLabel3 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Dimension"));
            jLabel3.setPreferredSize(this.getDefaultSize());
            this.cbOlapDimension = new JComboBox();
            this.cbOlapDimension.setPreferredSize(this.getDefaultSize());
            jPanel.add(this.createRow(jLabel3, this.cbOlapDimension));
            JLabel jLabel4 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Hierarchy"));
            jLabel4.setPreferredSize(this.getDefaultSize());
            this.cbOlapHierarchy = new JComboBox();
            this.cbOlapHierarchy.setPreferredSize(this.getDefaultSize());
            jPanel.add(this.createRow(jLabel4, this.cbOlapHierarchy));
            JLabel jLabel5 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Level"));
            jLabel5.setPreferredSize(this.getDefaultSize());
            this.cbOlapLevel = new JComboBox();
            this.cbOlapLevel.setPreferredSize(this.getDefaultSize());
            jPanel.add(this.createRow(jLabel5, this.cbOlapLevel));
            this.addIntParams(jPanel);
            this.addOtherParamsCB(jPanel);
            this.pnOlapMeasure.add((Component)jPanel, "North");
            this.cbOlapDimension.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)MeasurePropertiesDialogEx.this.cbOlapDimension.getSelectedItem();
                    if (dimension != null && dimension != MeasurePropertiesDialogEx.this.curDimension) {
                        MeasurePropertiesDialogEx.this.curDimension = dimension;
                        MeasurePropertiesDialogEx.this.cbOlapHierarchy.setModel(new DefaultComboBoxModel<Object>(dimension.getHierarchies().toArray()));
                        if (dimension.getHierarchies().size() > 0) {
                            Hierarchy hierarchy = (Hierarchy)dimension.getHierarchies().getElement(0);
                            MeasurePropertiesDialogEx.this.cbOlapHierarchy.setSelectedItem(hierarchy);
                            MeasurePropertiesDialogEx.this.cbOlapLevel.setModel(new DefaultComboBoxModel<Object>(hierarchy.getLevels().toArray()));
                            if (hierarchy.getLevels().size() > 0) {
                                MeasurePropertiesDialogEx.this.cbOlapHierarchy.setSelectedItem(hierarchy.getLevels().get(0));
                            }
                        }
                    }
                }
            });
            this.cbOlapHierarchy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Hierarchy hierarchy = (Hierarchy)MeasurePropertiesDialogEx.this.cbOlapHierarchy.getSelectedItem();
                    if (hierarchy != MeasurePropertiesDialogEx.this.curHierarchy) {
                        MeasurePropertiesDialogEx.this.curHierarchy = hierarchy;
                        MeasurePropertiesDialogEx.this.cbOlapLevel.setModel(new DefaultComboBoxModel<Object>(hierarchy.getLevels().toArray()));
                        if (hierarchy.getLevels().size() > 0) {
                            MeasurePropertiesDialogEx.this.cbOlapHierarchy.setSelectedItem(hierarchy.getLevels().get(0));
                        }
                    }
                }
            });
            this.pnOlap.add(this.pnOlapMeasure);
        }
        return this.pnOlap;
    }

    private void addIntParams(JPanel jPanel) {
        JLabel jLabel = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Offset"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.ifOffset = new JIntegerField();
        this.ifOffset.setPreferredSize(this.getDefaultSize());
        jPanel.add(this.createRow(jLabel, this.ifOffset));
        JLabel jLabel2 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Start"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.ifStart = new JIntegerField();
        this.ifStart.setPreferredSize(this.getDefaultSize());
        this.ifStart.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInMovingAverageMovingMaxMovingMin"));
        jLabel2.setToolTipText(this.ifStart.getToolTipText());
        jPanel.add(this.createRow(jLabel2, this.ifStart));
        JLabel jLabel3 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Stop"));
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.ifStop = new JIntegerField();
        this.ifStop.setPreferredSize(this.getDefaultSize());
        this.ifStop.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInMovingAverageMovingMaxMovingMin"));
        jLabel3.setToolTipText(this.ifStop.getToolTipText());
        jPanel.add(this.createRow(jLabel3, this.ifStop));
        JLabel jLabel4 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.Step"));
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.ifStep = new JIntegerField();
        this.ifStep.setPreferredSize(this.getDefaultSize());
        this.ifStep.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInMovingAverageMovingMaxMovingMin"));
        jLabel4.setToolTipText(this.ifStep.getToolTipText());
        jPanel.add(this.createRow(jLabel4, this.ifStep));
    }

    private void addOtherParamsCB(JPanel jPanel) {
        JLabel jLabel = new JLabel(Messages.getString("MeasurePropertiesDialogEx.PeriodToDateOperation"));
        jLabel.setPreferredSize(this.getDefaultSize());
        this.cbPD_Operation = new JComboBox<String>(Measure.PERIOD_TO_DATE_OPERATIONS);
        this.cbPD_Operation.setPreferredSize(this.getDefaultSize());
        this.cbPD_Operation.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInPeriodToDate"));
        jLabel.setToolTipText(this.cbPD_Operation.getToolTipText());
        jPanel.add(this.createRow(jLabel, this.cbPD_Operation));
        JLabel jLabel2 = new JLabel(Messages.getString("MeasurePropertiesDialogEx.RankDirection"));
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.cbRankDirection = new JComboBox<String>(Measure.rankDirectionNames);
        this.cbRankDirection.setPreferredSize(this.getDefaultSize());
        this.cbRankDirection.setToolTipText(Messages.getString("MeasurePropertiesDialogEx.UsedInRankOperator"));
        jLabel2.setToolTipText(this.cbRankDirection.getToolTipText());
        jPanel.add(this.createRow(jLabel2, this.cbRankDirection));
    }

    private void enableAggregationFunctions(boolean bl) {
        if (this.isEditable()) {
            this.btnAddF.setEnabled(bl);
            this.btnRemoveF.setEnabled(bl);
            this.btnSummaryLevels.setEnabled(bl);
            this.tbTarget.setEnabled(bl);
            this.sTable.setEnabled(bl);
            this.enableButtons(false);
        }
    }

    private void enableOLAPMeasure(boolean bl) {
        this.cbOperator.setEnabled(bl);
        this.cbOlapDimension.setEnabled(bl);
        this.cbOlapHierarchy.setEnabled(bl);
        this.cbOlapLevel.setEnabled(bl);
        this.cbMeasure.setEnabled(bl);
        this.cbPD_Operation.setEnabled(bl);
        this.cbRankDirection.setEnabled(bl);
        this.ifOffset.setEnabled(bl);
        this.ifStart.setEnabled(bl);
        this.ifStop.setEnabled(bl);
        this.ifStep.setEnabled(bl);
        if (bl) {
            this.presetControls();
        }
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = ((ListSelectionModel)listSelectionEvent.getSource()).getAnchorSelectionIndex();
            if (n != -1) {
                Measure.AggregateFunction aggregateFunction = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(n);
                MeasurePropertiesDialogEx.this.updateSourceElements(aggregateFunction);
                MeasurePropertiesDialogEx.this.resetDimButtons();
            } else {
                MeasurePropertiesDialogEx.this.enableButtons(false);
            }
        }
    }

    class TargetTableModel
    extends AbstractTableModel {
        String[] cNames = new String[]{Messages.getString("MeasurePropertiesDialogEx.AggregationFunction"), Messages.getString("MeasurePropertiesDialogEx.MeasureAlias")};

        TargetTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            return MeasurePropertiesDialogEx.this.functions.size();
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return MeasurePropertiesDialogEx.this.isEditable();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Measure.AggregateFunction aggregateFunction = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(n);
            if (n2 == 0) {
                return aggregateFunction.name;
            }
            return aggregateFunction.measureAlias;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Measure.AggregateFunction aggregateFunction = (Measure.AggregateFunction)MeasurePropertiesDialogEx.this.functions.get(n);
            if (n2 == 0) {
                aggregateFunction.name = (String)object;
            } else {
                aggregateFunction.measureAlias = (String)object;
            }
        }
    }

    private class SourceElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return MeasurePropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("MeasurePropertiesDialogEx.Dimensions");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)MeasurePropertiesDialogEx.this.sList.get(n);
            if (n2 == 0) {
                return designObject.getName();
            }
            return "";
        }
    }
}

