/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.CubeSet;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;

public class MeasureFolderPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private MeasureFolder measureFolder;
    private JTable sTable;
    private List selectedMeasureWrappers;
    private JButton btnProperties;
    private JButton btnAdd;
    private JButton btnRemove;
    private List allMeasures;
    private JPanel pnMeasures;

    public MeasureFolderPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
    }

    @Override
    public String getCaption() {
        return Messages.getString("MeasureFolderPropertiesDialogEx.MeasureFolderProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "MEASUREFOLDER_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof MeasureFolder) {
            this.measureFolder = (MeasureFolder)designObject;
            this.initDefaults(false);
            this.taDescription.setText(this.measureFolder.getDescription());
            this.selectedMeasureWrappers.addAll(this.measureFolder.getMeasures());
            this.initOracleNames();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.measureFolder.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.measureFolder.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.selectedMeasureWrappers = new ArrayList();
        this.allMeasures = new ArrayList();
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getMeasuresPanel());
        this.addToTree(defaultMutableTreeNode, this.getOracleNamesPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.measureFolder.setName(this.tfName.getText());
        this.measureFolder.setComment(this.taComments.getText());
        this.measureFolder.setNotes(this.taNotes.getText());
        this.measureFolder.setDescription(this.taDescription.getText());
        this.measureFolder.removeMeasures();
        this.measureFolder.getMeasures().addAll(this.selectedMeasureWrappers);
        this.setOracleNames();
        MeasureFolderPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.measureFolder.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.measureFolder.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    private void getAllMeasures(MeasureFolder measureFolder) {
        CubeSet cubeSet = ((MultidimensionalDesign)measureFolder.getDesignPart()).getCubeSet();
        Iterator iterator = cubeSet.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object22;
            Cube cube = (Cube)iterator.next();
            for (Object object22 : cube.getMeasures()) {
                MeasureFolder measureFolder2 = measureFolder;
                measureFolder2.getClass();
                object = measureFolder2.new MeasureFolder.MFElement(cube, object22);
                if (this.isSelected((MeasureFolder.MFElement)object)) continue;
                this.allMeasures.add(object);
            }
            object22 = cube.getPrecalculatedSlices().iterator();
            while (object22.hasNext()) {
                object = (Slice)object22.next();
                for (Slice.MeasureWrapper measureWrapper : ((Slice)object).getSelectedMeasureWrappers()) {
                    MeasureFolder measureFolder3 = measureFolder;
                    measureFolder3.getClass();
                    MeasureFolder.MFElement mFElement = measureFolder3.new MeasureFolder.MFElement((DesignObject)object, measureWrapper);
                    if (this.isSelected(mFElement)) continue;
                    this.allMeasures.add(mFElement);
                }
            }
        }
    }

    private boolean isSelected(MeasureFolder.MFElement mFElement) {
        for (MeasureFolder.MFElement mFElement2 : this.selectedMeasureWrappers) {
            if (!mFElement2.toString().equals(mFElement.toString())) continue;
            return true;
        }
        return false;
    }

    protected JPanel getMeasuresPanel() {
        if (this.pnMeasures == null) {
            this.pnMeasures = this.createPage(Messages.getString("MeasureFolderPropertiesDialogEx.Measures"));
            this.sTable = new JTable(new MeasureWrappersModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    MeasureFolder.MFElement mFElement;
                    Measure measure;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = MeasureFolderPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() && (measure = (Measure)((MultidimensionalDesign)(mFElement = (MeasureFolder.MFElement)MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.get(n)).getParent().getDesignPart()).getMeasureSet().getObjectByID(mFElement.getMeasureObjectID())) != null) {
                        measure.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.sTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MeasureFolder.MFElement mFElement;
                    Measure measure;
                    int n = MeasureFolderPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (n != -1 && MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() && (measure = (Measure)((MultidimensionalDesign)(mFElement = (MeasureFolder.MFElement)MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.get(n)).getParent().getDesignPart()).getMeasureSet().getObjectByID(mFElement.getMeasureObjectID())) != null) {
                        measure.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MeasureFolderPropertiesDialogEx.this.allMeasures.clear();
                        MeasureFolderPropertiesDialogEx.this.getAllMeasures(MeasureFolderPropertiesDialogEx.this.measureFolder);
                        SelectElementsDialog selectElementsDialog = new SelectElementsDialog(MeasureFolderPropertiesDialogEx.this.getAppView(), MeasureFolderPropertiesDialogEx.this.allMeasures, MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers);
                        selectElementsDialog.show();
                        MeasureFolderPropertiesDialogEx.this.sTable.updateUI();
                    }
                });
                this.btnRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = MeasureFolderPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (n != -1 && MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && n < MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                            MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.remove(n);
                            MeasureFolderPropertiesDialogEx.this.sTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.btnAdd);
                jToolBar.add(this.btnRemove);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnMeasures.add(jPanel2);
        }
        return this.pnMeasures;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class MeasureWrappersModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("MeasureFolderPropertiesDialogEx.MeasureName")};

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public int getRowCount() {
            return MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MeasureFolder.MFElement mFElement = (MeasureFolder.MFElement)MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.get(n);
            if (n2 == 0) {
                return mFElement;
            }
            return "";
        }
    }
}

