/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.SelectAttributesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectDescriptiveAttributesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;
import oracle.ide.Ide;

public class LevelPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Level level;
    private JComboBox cbLevelEntity;
    private JPanel pnSelectionCriteria;
    private JTextArea taSelectetionCriteria;
    private JPanel pnSelectionCriteriaDesc;
    private JTextArea taSelectetionCriteriaDesc;
    private JCheckBox chValueBasegHierarchy;
    private JComboBox cbRootIdent;
    private JTextField tfIdentValue;
    private JComboBox cbDefaultAttribute;
    private ContainerObject curEntity;
    private JPanel lkPanel;
    private JTable lkTable;
    private List lkList;
    private JPanel daPanel;
    private JTable daTable;
    private List daList;
    private Level.OraAWAttributes currentOraAWAttr;
    private JComboBox cbDescAttr;
    private JTable hTable;
    private List hList;
    private JButton bnHProperties;
    private JButton bnHAdd;
    private JButton bnHRemove;
    private List descAlist;
    private JTable pkTable;
    private List pkList;
    private JPanel pkPanel;
    private List calcAttrList;
    private JTable caTable;
    private JPanel caPanel;
    private JTable oraAWTable;
    private JPanel oraAWPanel;
    private List olapAttribues;
    private JPanel olapPanel;
    private JComboBox cbNameColumn;
    private JComboBox cbValueColumn;
    private JButton bnPKAdd;
    private JButton bnPKRemove;
    private JButton bnPKProperties;

    public LevelPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    protected int getMinimumWidth() {
        return 660;
    }

    @Override
    protected int getMinimumHeight() {
        return 550;
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_LEVEL_ENTITY);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.cbLevelEntity = new JComboBox();
        this.cbLevelEntity.setPreferredSize(this.getDefaultSize());
        this.cbLevelEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContainerObject containerObject = (ContainerObject)LevelPropertiesDialogEx.this.cbLevelEntity.getSelectedItem();
                if (containerObject != LevelPropertiesDialogEx.this.curEntity) {
                    LevelPropertiesDialogEx.this.curEntity = containerObject;
                    LevelPropertiesDialogEx.this.lkList.clear();
                    LevelPropertiesDialogEx.this.lkTable.updateUI();
                    LevelPropertiesDialogEx.this.daList.clear();
                    LevelPropertiesDialogEx.this.daTable.updateUI();
                    LevelPropertiesDialogEx.this.setCBDescAttr();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel, this.cbLevelEntity));
        JLabel jLabel2 = new JLabel(LB_VALUE_BASED);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chValueBasegHierarchy = new JCheckBox();
        this.chValueBasegHierarchy.setPreferredSize(this.getDefaultSize());
        this.chValueBasegHierarchy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelPropertiesDialogEx.this.enableControls();
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chValueBasegHierarchy));
        JLabel jLabel3 = new JLabel(LB_ROOT_IDENTIFICATION);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbRootIdent = new JComboBox<String>(Level.ROOT_IDENTS);
        this.cbRootIdent.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbRootIdent));
        JLabel jLabel4 = new JLabel(LB_IDENTIFICATION_VALUE);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.tfIdentValue = new JTextField();
        this.tfIdentValue.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.tfIdentValue));
        JLabel jLabel5 = new JLabel(LB_DEFAULT_ATTRIBUTE);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.cbDefaultAttribute = new JComboBox();
        this.cbDefaultAttribute.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.cbDefaultAttribute));
    }

    private void enableControls() {
        if (this.isEditable()) {
            boolean bl = this.chValueBasegHierarchy.isSelected();
            this.cbRootIdent.setEnabled(bl);
            this.tfIdentValue.setEnabled(bl);
            this.pkTable.setEnabled(bl);
            this.bnPKProperties.setEnabled(bl);
            this.bnPKAdd.setEnabled(bl);
            this.bnPKRemove.setEnabled(bl);
        }
    }

    private void setCBDescAttr() {
        List list = this.copySCAtt_to_NormalAttr(this.daList);
        this.validateAWAttributes(this.currentOraAWAttr, list);
        list.add(0, null);
        this.cbDescAttr.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
    }

    public void validateAWAttributes(Level.OraAWAttributes oraAWAttributes, List list) {
        int n;
        if (oraAWAttributes.shortDesc != null && (n = list.indexOf(oraAWAttributes.shortDesc)) < 0) {
            oraAWAttributes.shortDesc = null;
        }
        if (oraAWAttributes.longDesc != null && (n = list.indexOf(oraAWAttributes.longDesc)) < 0) {
            oraAWAttributes.longDesc = null;
        }
        if (oraAWAttributes.timeEnd != null && (n = list.indexOf(oraAWAttributes.timeEnd)) < 0) {
            oraAWAttributes.timeEnd = null;
        }
        if (oraAWAttributes.timeSpan != null && (n = list.indexOf(oraAWAttributes.timeSpan)) < 0) {
            oraAWAttributes.timeSpan = null;
        }
    }

    List copySCAtt_to_NormalAttr(List list) {
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        for (SlowChangingAttribute slowChangingAttribute : list) {
            arrayList.add(slowChangingAttribute.getAttribute());
        }
        return arrayList;
    }

    @Override
    public String getCaption() {
        return Messages.getString("LevelPropertiesDialogEx.LevelProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "LEVEL_PROPERTIES_DIALOG";
    }

    private List getDescriptiveAttributes() {
        ArrayList<SlowChangingAttribute> arrayList = new ArrayList<SlowChangingAttribute>();
        Iterator iterator = this.level.getSlowChangingAttributes().iterator();
        while (iterator.hasNext()) {
            SlowChangingAttribute slowChangingAttribute = new SlowChangingAttribute(this.level, (SlowChangingAttribute)iterator.next());
            arrayList.add(slowChangingAttribute);
        }
        return arrayList;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Level) {
            this.level = (Level)designObject;
            this.initDefaults(false);
            Level level = this.level;
            level.getClass();
            this.currentOraAWAttr = level.new Level.OraAWAttributes(this.level);
            this.taSelectetionCriteria.setText(this.level.getSelectionCriteria());
            this.taSelectetionCriteriaDesc.setText(this.level.getSelectionCriteriaDescription());
            this.taDescription.setText(this.level.getDescription());
            this.fillComboItems(this.getLevelEntities().toArray(), this.cbLevelEntity, true);
            this.fillComboItems(this.level.getDefaultAttributeCandidates().toArray(), this.cbDefaultAttribute, true);
            this.cbLevelEntity.setSelectedItem(this.level.getLevelEntity());
            this.cbDefaultAttribute.setSelectedItem(this.level.getDefaultAttribute());
            this.fillComboItems(this.getOlapAttributes().toArray(), this.cbNameColumn, false);
            this.fillComboItems(this.getOlapAttributes().toArray(), this.cbValueColumn, false);
            this.cbNameColumn.setSelectedItem(this.level.getNameColumn());
            this.cbValueColumn.setSelectedItem(this.level.getValueColumn());
            this.chValueBasegHierarchy.setSelected(this.level.isValueBasedHierarchy());
            this.cbRootIdent.setSelectedItem(this.level.getRootIdentification());
            this.tfIdentValue.setText(this.level.getIdentificationValue());
            this.lkList.addAll(this.level.getLevelKey());
            this.lkTable.updateUI();
            this.daList.addAll(this.getDescriptiveAttributes());
            this.daTable.updateUI();
            this.pkList.addAll(this.level.getParentKey());
            this.pkTable.updateUI();
            this.calcAttrList.addAll(this.level.getCalculatedAttributes());
            this.caTable.updateUI();
            this.copyAWAttr(this.level.getOraAWAttributes(), this.currentOraAWAttr);
            this.level.validateAWAttributes(this.currentOraAWAttr, true);
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.enableControls();
            this.setCBDescAttr();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.level.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.level.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    private void copyAWAttr(Level.OraAWAttributes oraAWAttributes, Level.OraAWAttributes oraAWAttributes2) {
        oraAWAttributes2.level = oraAWAttributes.level;
        oraAWAttributes2.shortDesc = oraAWAttributes.shortDesc;
        oraAWAttributes2.longDesc = oraAWAttributes.longDesc;
        oraAWAttributes2.timeSpan = oraAWAttributes.timeSpan;
        oraAWAttributes2.timeEnd = oraAWAttributes.timeEnd;
    }

    private List getLevelEntities() {
        ArrayList arrayList = new ArrayList();
        this.level.getDesign().getLogicalDesign().getEntitySet().addAllElementsTo(arrayList);
        this.level.getDesign().getLogicalDesign().getEntityViewSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getSelectionCriteriaPanel());
        this.addToTree(defaultMutableTreeNode, this.getSelectionCriteriaDescPanel());
        this.addToTree(defaultMutableTreeNode, this.getLevelKeyPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptiveAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getParentKeyPanel());
        this.addToTree(defaultMutableTreeNode, this.getCalcAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getOracleAWAttributesPanel());
        this.addToTree(defaultMutableTreeNode, this.getOracleNamesPanel());
        this.addToTree(defaultMutableTreeNode, this.getMSOlapPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    protected JPanel getSelectionCriteriaPanel() {
        if (this.pnSelectionCriteria == null) {
            this.pnSelectionCriteria = this.createPage(Messages.getString("LevelPropertiesDialogEx.SelectionCriteria"));
            this.taSelectetionCriteria = new JTextArea();
            this.pnSelectionCriteria.add(new JScrollPane(this.taSelectetionCriteria));
        }
        return this.pnSelectionCriteria;
    }

    protected JPanel getSelectionCriteriaDescPanel() {
        if (this.pnSelectionCriteriaDesc == null) {
            this.pnSelectionCriteriaDesc = this.createPage(Messages.getString("LevelPropertiesDialogEx.Sel.CriteriaDescription"));
            this.taSelectetionCriteriaDesc = new JTextArea();
            this.pnSelectionCriteriaDesc.add(new JScrollPane(this.taSelectetionCriteriaDesc));
        }
        return this.pnSelectionCriteriaDesc;
    }

    @Override
    protected void setProperties() {
        Object object2;
        int n = this.caTable.getEditingColumn();
        int n2 = this.caTable.getEditingRow();
        if (n2 >= 0 && n >= 0) {
            this.caTable.getCellEditor(n2, n).stopCellEditing();
        }
        n = this.daTable.getEditingColumn();
        n2 = this.daTable.getEditingRow();
        if (n2 >= 0 && n >= 0) {
            this.daTable.getCellEditor(n2, n).stopCellEditing();
        }
        this.level.setName(this.tfName.getText());
        this.level.setComment(this.taComments.getText());
        this.level.setNotes(this.taNotes.getText());
        this.level.setDescription(this.taDescription.getText());
        this.level.setLevelEntity((ContainerObject)this.cbLevelEntity.getSelectedItem());
        this.level.setSelectionCriteria(this.taSelectetionCriteria.getText());
        this.level.setSelectionCriteriaDescription(this.taSelectetionCriteriaDesc.getText());
        boolean bl = this.chValueBasegHierarchy.isSelected();
        this.level.setValueBasedHierarchy(bl);
        this.level.getLevelKey().clear();
        for (Object object2 : this.lkList) {
            this.level.addToLevelKey((ContainedObject)object2);
        }
        this.level.getSlowChangingAttributes().clear();
        for (Object object2 : this.daList) {
            this.level.addDescriptiveAttribute((SlowChangingAttribute)object2);
        }
        if (bl) {
            this.level.setRootIdentification((String)this.cbRootIdent.getSelectedItem());
            this.level.setIdentificationValue(this.tfIdentValue.getText());
            this.level.getParentKey().clear();
            for (Object object2 : this.pkList) {
                this.level.addToParentKey((ContainedObject)object2);
            }
        }
        this.level.getCalculatedAttributes().clear();
        Iterator iterator = this.calcAttrList.iterator();
        while (iterator.hasNext()) {
            this.level.addCalculatedAttribute((CalculatedAttribute)iterator.next());
        }
        this.level.setDefaultAttribute((DesignObject)this.cbDefaultAttribute.getSelectedItem());
        object2 = this.copySCAtt_to_NormalAttr(this.daList);
        this.validateAWAttributes(this.currentOraAWAttr, (List)object2);
        this.copyAWAttr(this.currentOraAWAttr, this.level.getOraAWAttributes());
        this.level.setNameColumn((ContainedObject)this.cbNameColumn.getSelectedItem());
        this.level.setValueColumn((ContainedObject)this.cbValueColumn.getSelectedItem());
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        LevelPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.level.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.level.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    protected JPanel getLevelKeyPanel() {
        if (this.lkPanel == null) {
            JComponent jComponent;
            this.lkPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.LevelKey"));
            this.lkList = new ArrayList();
            this.lkTable = new JTable(new LevelKeyModel());
            this.lkTable.setSelectionMode(0);
            this.lkTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = LevelPropertiesDialogEx.this.lkTable.getSelectedRow()) > -1 && LevelPropertiesDialogEx.this.lkList.size() > 0 && n < LevelPropertiesDialogEx.this.lkList.size()) {
                        ContainedObject containedObject = (ContainedObject)LevelPropertiesDialogEx.this.lkList.get(n);
                        containedObject.showModal = ((LevelPropertiesDialogEx)LevelPropertiesDialogEx.this).level.showModal || LevelPropertiesDialogEx.this.level.showForFirstTime();
                        containedObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.lkTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = LevelPropertiesDialogEx.this.lkTable.getSelectedRow();
                    if (n > -1 && LevelPropertiesDialogEx.this.lkList.size() > 0 && n < LevelPropertiesDialogEx.this.lkList.size()) {
                        ContainedObject containedObject = (ContainedObject)LevelPropertiesDialogEx.this.lkList.get(n);
                        containedObject.showModal = ((LevelPropertiesDialogEx)LevelPropertiesDialogEx.this).level.showModal || LevelPropertiesDialogEx.this.level.showForFirstTime();
                        containedObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ContainerObject containerObject = (ContainerObject)LevelPropertiesDialogEx.this.cbLevelEntity.getSelectedItem();
                        if (containerObject == null) {
                            JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), Messages.getString("LevelPropertiesDialogEx.SetLevelEntityFirst"), Messages.getString("LevelPropertiesDialogEx.LevelEntityNotSet"), 0, 0, null, new String[]{Messages.getString("LevelPropertiesDialogEx.Ok")}, Messages.getString("LevelPropertiesDialogEx.Ok"));
                        } else {
                            SelectAttributesDialog selectAttributesDialog = new SelectAttributesDialog(LevelPropertiesDialogEx.this.getAppView(), LevelPropertiesDialogEx.this.lkList, containerObject);
                            selectAttributesDialog.setVisible(true);
                            LevelPropertiesDialogEx.this.lkTable.updateUI();
                        }
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = LevelPropertiesDialogEx.this.lkTable.getSelectedRow();
                        if (n != -1 && LevelPropertiesDialogEx.this.lkList.size() > 0 && n < LevelPropertiesDialogEx.this.lkList.size()) {
                            LevelPropertiesDialogEx.this.lkList.remove(n);
                            LevelPropertiesDialogEx.this.lkTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.lkPanel.add(jComponent);
        }
        return this.lkPanel;
    }

    private void updateHistoryElements(SlowChangingAttribute slowChangingAttribute) {
        this.hList.clear();
        Iterator iterator = slowChangingAttribute.getHistoryAttributes().iterator();
        while (iterator.hasNext()) {
            this.hList.add(iterator.next());
        }
        this.hTable.updateUI();
    }

    protected JPanel getDescriptiveAttributesPanel() {
        if (this.daPanel == null) {
            JComponent jComponent;
            JComponent jComponent2;
            this.daPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.DescriptiveAttributes"));
            this.daList = new ArrayList();
            this.daTable = new JTable(new DescriptiveAttributesModel());
            JComboBox<String> jComboBox = new JComboBox<String>(SlowChangingAttribute.TYPES);
            this.daTable.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(jComboBox));
            this.daTable.setSelectionMode(0);
            this.daTable.getSelectionModel().addListSelectionListener(new SelectionListener());
            this.daTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = LevelPropertiesDialogEx.this.daTable.getSelectedRow()) > -1 && LevelPropertiesDialogEx.this.daList.size() > 0 && n < LevelPropertiesDialogEx.this.daList.size()) {
                        SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(n);
                        slowChangingAttribute.getAttribute().showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.daTable);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = LevelPropertiesDialogEx.this.daTable.getSelectedRow();
                    if (n > -1 && LevelPropertiesDialogEx.this.daList.size() > 0 && n < LevelPropertiesDialogEx.this.daList.size()) {
                        SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(n);
                        slowChangingAttribute.getAttribute().showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent2.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ContainerObject containerObject = (ContainerObject)LevelPropertiesDialogEx.this.cbLevelEntity.getSelectedItem();
                        if (containerObject == null) {
                            JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), Messages.getString("LevelPropertiesDialogEx.SetLevelEntityFirst"), Messages.getString("LevelPropertiesDialogEx.LevelEntityNotSet"), 0, 0, null, new String[]{Messages.getString("LevelPropertiesDialogEx.Ok")}, Messages.getString("LevelPropertiesDialogEx.Ok"));
                        } else {
                            SelectDescriptiveAttributesDialog selectDescriptiveAttributesDialog = new SelectDescriptiveAttributesDialog(LevelPropertiesDialogEx.this.getAppView(), LevelPropertiesDialogEx.this.daList, containerObject, LevelPropertiesDialogEx.this.level);
                            selectDescriptiveAttributesDialog.show();
                            LevelPropertiesDialogEx.this.daTable.updateUI();
                            LevelPropertiesDialogEx.this.setCBDescAttr();
                        }
                    }
                });
                jComponent = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_REMOVE);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = LevelPropertiesDialogEx.this.daTable.getSelectedRow();
                        if (n != -1 && LevelPropertiesDialogEx.this.daList.size() > 0 && n < LevelPropertiesDialogEx.this.daList.size()) {
                            LevelPropertiesDialogEx.this.daList.remove(n);
                            LevelPropertiesDialogEx.this.daTable.updateUI();
                            LevelPropertiesDialogEx.this.setCBDescAttr();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent2);
                jToolBar.add(jComponent);
            }
            jScrollPane.setPreferredSize(new Dimension(325, 165));
            jComponent2 = new JPanel(new BorderLayout());
            jComponent = new JPanel(new BorderLayout());
            jComponent.setBorder(BorderFactory.createTitledBorder(Messages.getString("LevelPropertiesDialogEx.Attributes")));
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel2.add(jToolBar);
            jComponent.add((Component)jPanel2, "North");
            jComponent.add(jScrollPane);
            this.hList = new ArrayList();
            this.descAlist = new ArrayList();
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("LevelPropertiesDialogEx.HistoryAttributes")));
            this.hTable = new JTable(new HistoryElementsModel());
            this.hTable.setSelectionMode(0);
            this.hTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = LevelPropertiesDialogEx.this.hTable.getSelectedRow()) != -1 && LevelPropertiesDialogEx.this.hList.size() > 0 && n < LevelPropertiesDialogEx.this.hList.size()) {
                        DesignObject designObject = (DesignObject)LevelPropertiesDialogEx.this.hList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane2 = new JScrollPane(this.hTable);
            jScrollPane2.setPreferredSize(new Dimension(325, 100));
            JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
            jPanel4.setPreferredSize(new Dimension(325, 35));
            this.bnHProperties = new JButton(gUIConfiguration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
            this.bnHProperties.setToolTipText(Messages.getString("LevelPropertiesDialogEx.Properties"));
            this.bnHProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = LevelPropertiesDialogEx.this.hTable.getSelectedRow();
                    if (n != -1 && LevelPropertiesDialogEx.this.hList.size() > 0 && n < LevelPropertiesDialogEx.this.hList.size()) {
                        DesignObject designObject = (DesignObject)LevelPropertiesDialogEx.this.hList.get(n);
                        designObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar2 = new JToolBar(0);
            jToolBar2.setFloatable(false);
            jToolBar2.add(this.bnHProperties);
            if (this.isEditable()) {
                this.bnHAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.bnHAdd.setToolTipText(Messages.getString("LevelPropertiesDialogEx.Add"));
                this.bnHAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LevelPropertiesDialogEx.this.descAlist = LevelPropertiesDialogEx.this.copySCAtt_to_NormalAttr(LevelPropertiesDialogEx.this.daList);
                        SelectElementsDialog selectElementsDialog = new SelectElementsDialog(LevelPropertiesDialogEx.this.getAppView(), LevelPropertiesDialogEx.this.descAlist, LevelPropertiesDialogEx.this.hList);
                        selectElementsDialog.show();
                        LevelPropertiesDialogEx.this.hTable.updateUI();
                        int n = LevelPropertiesDialogEx.this.daTable.getSelectedRow();
                        if (n != -1 && !selectElementsDialog.cancel) {
                            SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(n);
                            slowChangingAttribute.getHistoryAttributes().clear();
                            for (ContainedObject containedObject : LevelPropertiesDialogEx.this.hList) {
                                slowChangingAttribute.addHistoryAttribute(containedObject);
                            }
                        }
                    }
                });
                this.bnHRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.bnHRemove.setToolTipText(Messages.getString("LevelPropertiesDialogEx.Remove"));
                this.bnHRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = LevelPropertiesDialogEx.this.hTable.getSelectedRow();
                        if (n != -1 && LevelPropertiesDialogEx.this.hList.size() > 0 && n < LevelPropertiesDialogEx.this.hList.size()) {
                            LevelPropertiesDialogEx.this.hList.remove(n);
                            LevelPropertiesDialogEx.this.hTable.updateUI();
                            int n2 = LevelPropertiesDialogEx.this.daTable.getSelectedRow();
                            if (n2 != -1) {
                                SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(n2);
                                slowChangingAttribute.getHistoryAttributes().clear();
                                for (ContainedObject containedObject : LevelPropertiesDialogEx.this.hList) {
                                    slowChangingAttribute.addHistoryAttribute(containedObject);
                                }
                            }
                        }
                    }
                });
                jToolBar2.addSeparator();
                jToolBar2.add(this.bnHAdd);
                jToolBar2.add(this.bnHRemove);
            }
            this.enableButtons(false);
            jPanel4.add(jToolBar2);
            jPanel3.add((Component)jPanel4, "North");
            jPanel3.add(jScrollPane2);
            jPanel.add((Component)jComponent, "North");
            jPanel.add(jPanel3);
            jComponent2.add(jPanel);
            this.daPanel.add(jComponent2);
        }
        return this.daPanel;
    }

    private void enableButtons(boolean bl) {
        if (this.isEditable()) {
            this.bnHProperties.setEnabled(bl);
            this.bnHAdd.setEnabled(bl);
            this.bnHRemove.setEnabled(bl);
        }
    }

    protected JPanel getParentKeyPanel() {
        if (this.pkPanel == null) {
            this.pkPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.ParentKey"));
            this.pkList = new ArrayList();
            this.pkTable = new JTable(new ParentKeyModel());
            this.pkTable.setSelectionMode(0);
            this.pkTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = LevelPropertiesDialogEx.this.pkTable.getSelectedRow()) > -1 && LevelPropertiesDialogEx.this.pkList.size() > 0 && n < LevelPropertiesDialogEx.this.pkList.size()) {
                        ContainedObject containedObject = (ContainedObject)LevelPropertiesDialogEx.this.pkList.get(n);
                        containedObject.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.pkTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.bnPKProperties = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.bnPKProperties.setToolTipText(BTN_PROPERTIES);
            this.bnPKProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = LevelPropertiesDialogEx.this.pkTable.getSelectedRow();
                    if (n > -1 && LevelPropertiesDialogEx.this.pkList.size() > 0 && n < LevelPropertiesDialogEx.this.pkList.size()) {
                        ContainedObject containedObject = (ContainedObject)LevelPropertiesDialogEx.this.pkList.get(n);
                        containedObject.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.bnPKProperties);
            if (this.isEditable()) {
                this.bnPKAdd = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.bnPKAdd.setToolTipText(BTN_ADD);
                this.bnPKAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ContainerObject containerObject = LevelPropertiesDialogEx.this.level.getLevelEntity();
                        SelectAttributesDialog selectAttributesDialog = new SelectAttributesDialog(LevelPropertiesDialogEx.this.getAppView(), LevelPropertiesDialogEx.this.pkList, containerObject);
                        selectAttributesDialog.show();
                        LevelPropertiesDialogEx.this.pkTable.updateUI();
                    }
                });
                this.bnPKRemove = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.bnPKRemove.setToolTipText(BTN_REMOVE);
                this.bnPKRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = LevelPropertiesDialogEx.this.pkTable.getSelectedRow();
                        if (n != -1 && LevelPropertiesDialogEx.this.pkList.size() > 0 && n < LevelPropertiesDialogEx.this.pkList.size()) {
                            LevelPropertiesDialogEx.this.pkList.remove(n);
                            LevelPropertiesDialogEx.this.pkTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(this.bnPKAdd);
                jToolBar.add(this.bnPKRemove);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pkPanel.add(jPanel2);
        }
        return this.pkPanel;
    }

    protected JPanel getCalcAttributesPanel() {
        if (this.caPanel == null) {
            JComponent jComponent;
            this.caPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.CalculatedAttributes"));
            this.calcAttrList = new ArrayList();
            this.caTable = new JTable(new ParametersModel());
            this.caTable.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.caTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CalculatedAttribute calculatedAttribute = LevelPropertiesDialogEx.this.level.createCalculatedAttribute();
                        LevelPropertiesDialogEx.this.calcAttrList.add(calculatedAttribute);
                        LevelPropertiesDialogEx.this.caTable.updateUI();
                    }
                });
                JButton jButton = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton.setToolTipText(BTN_REMOVE);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = LevelPropertiesDialogEx.this.caTable.getSelectedRow();
                        if (n != -1 && LevelPropertiesDialogEx.this.calcAttrList.size() > 0 && n < LevelPropertiesDialogEx.this.calcAttrList.size()) {
                            LevelPropertiesDialogEx.this.calcAttrList.remove(n);
                            LevelPropertiesDialogEx.this.caTable.updateUI();
                        }
                    }
                });
                JToolBar jToolBar = new JToolBar(0);
                jToolBar.setFloatable(false);
                jToolBar.add(jComponent);
                jToolBar.add(jButton);
                jPanel.add(jToolBar);
            }
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.caPanel.add(jComponent);
        }
        return this.caPanel;
    }

    protected JPanel getOracleAWAttributesPanel() {
        if (this.oraAWPanel == null) {
            this.oraAWPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.OracleAWAttributes"));
            this.cbDescAttr = new JComboBox();
            this.oraAWTable = new JTable(new AWAttributesModel());
            this.oraAWTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.cbDescAttr));
            this.oraAWTable.setSelectionMode(0);
            this.oraAWTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Attribute attribute;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = LevelPropertiesDialogEx.this.oraAWTable.getSelectedRow()) > -1 && LevelPropertiesDialogEx.this.daList.size() > 0 && n < LevelPropertiesDialogEx.this.daList.size() && (attribute = (Attribute)LevelPropertiesDialogEx.this.oraAWTable.getModel().getValueAt(n, 1)) != null) {
                        attribute.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.oraAWTable);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jScrollPane);
            this.oraAWPanel.add(jPanel);
        }
        return this.oraAWPanel;
    }

    protected JPanel getMSOlapPanel() {
        if (this.olapPanel == null) {
            this.olapPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.MSOlap"));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel jLabel = new JLabel(LB_NAME_COLUMN);
            jLabel.setPreferredSize(this.getDefaultSize());
            this.cbNameColumn = new JLNComboBox();
            this.cbNameColumn.setMaximumRowCount(20);
            this.cbNameColumn.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel, this.cbNameColumn));
            JLabel jLabel2 = new JLabel(LB_VALUE_COLUMN);
            jLabel2.setPreferredSize(this.getDefaultSize());
            this.cbValueColumn = new JLNComboBox();
            this.cbValueColumn.setMaximumRowCount(20);
            this.cbValueColumn.setPreferredSize(this.getDefaultSize());
            jPanel2.add(this.createRow(jLabel2, this.cbValueColumn));
            jPanel.add((Component)jPanel2, "North");
            this.olapPanel.add(jPanel);
        }
        return this.olapPanel;
    }

    private List getOlapAttributes() {
        if (this.olapAttribues == null) {
            this.olapAttribues = new ArrayList();
            this.olapAttribues.add(null);
            this.level.getDesign().getLogicalDesign().getAttributeSet().addAllElementsTo(this.olapAttribues);
            this.level.getDesign().getLogicalDesign().getAttributeViewSet().addAllElementsTo(this.olapAttribues);
        }
        return this.olapAttribues;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    class AWAttributesModel
    extends AbstractTableModel {
        String[] cNames = new String[]{Messages.getString("LevelPropertiesDialogEx.AWAttribute"), Messages.getString("LevelPropertiesDialogEx.EntityAttribute")};

        AWAttributesModel() {
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            return 4;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!LevelPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 == 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Level.OraAWAttributes oraAWAttributes = LevelPropertiesDialogEx.this.currentOraAWAttr;
            if (n2 == 0) {
                switch (n) {
                    case 0: {
                        return Messages.getString("LevelPropertiesDialogEx.ShortDescription");
                    }
                    case 1: {
                        return Messages.getString("LevelPropertiesDialogEx.LongDescription");
                    }
                    case 2: {
                        return Messages.getString("LevelPropertiesDialogEx.TimeSpan");
                    }
                    case 3: {
                        return Messages.getString("LevelPropertiesDialogEx.TimeEnd");
                    }
                }
                return "";
            }
            switch (n) {
                case 0: {
                    return oraAWAttributes.shortDesc;
                }
                case 1: {
                    return oraAWAttributes.longDesc;
                }
                case 2: {
                    return oraAWAttributes.timeSpan;
                }
                case 3: {
                    return oraAWAttributes.timeEnd;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object != null && !(object instanceof Attribute)) {
                return;
            }
            Level.OraAWAttributes oraAWAttributes = LevelPropertiesDialogEx.this.currentOraAWAttr;
            if (n2 == 1) {
                switch (n) {
                    case 0: {
                        oraAWAttributes.shortDesc = (Attribute)object;
                        break;
                    }
                    case 1: {
                        oraAWAttributes.longDesc = (Attribute)object;
                        break;
                    }
                    case 2: {
                        oraAWAttributes.timeSpan = (Attribute)object;
                        break;
                    }
                    case 3: {
                        oraAWAttributes.timeEnd = (Attribute)object;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    private class ParametersModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.calcAttrList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("LevelPropertiesDialogEx.CalculatedAttribute");
            }
            return Messages.getString("LevelPropertiesDialogEx.Expression");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return LevelPropertiesDialogEx.this.isEditable();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CalculatedAttribute calculatedAttribute = (CalculatedAttribute)LevelPropertiesDialogEx.this.calcAttrList.get(n);
            if (n2 == 0) {
                return calculatedAttribute.getName();
            }
            return calculatedAttribute.getFunction();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            CalculatedAttribute calculatedAttribute = (CalculatedAttribute)LevelPropertiesDialogEx.this.calcAttrList.get(n);
            if (n2 == 0) {
                calculatedAttribute.setName((String)object);
            } else if (n2 == 1) {
                calculatedAttribute.setFunction((String)object);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }

    private class ParentKeyModel
    extends AbstractTableModel {
        private ParentKeyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.pkList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("LevelPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ContainedObject containedObject = (ContainedObject)LevelPropertiesDialogEx.this.pkList.get(n);
            if (n2 == 0) {
                return containedObject.getLongName();
            }
            return new Integer(n * n2);
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = ((ListSelectionModel)listSelectionEvent.getSource()).getAnchorSelectionIndex();
            if (n != -1) {
                SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(n);
                if (slowChangingAttribute.getType().equalsIgnoreCase(SlowChangingAttribute.TYPES[3])) {
                    LevelPropertiesDialogEx.this.updateHistoryElements(slowChangingAttribute);
                    LevelPropertiesDialogEx.this.enableButtons(true);
                } else {
                    slowChangingAttribute.getHistoryAttributes().clear();
                    LevelPropertiesDialogEx.this.hList.clear();
                    LevelPropertiesDialogEx.this.hTable.updateUI();
                    LevelPropertiesDialogEx.this.enableButtons(false);
                }
            } else {
                LevelPropertiesDialogEx.this.enableButtons(false);
            }
        }
    }

    private class HistoryElementsModel
    extends AbstractTableModel {
        private HistoryElementsModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.hList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("LevelPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignObject designObject = (DesignObject)LevelPropertiesDialogEx.this.hList.get(n);
            if (n2 == 0) {
                return designObject.getLongName();
            }
            return new Integer(n * n2);
        }
    }

    private class DescriptiveAttributesModel
    extends AbstractTableModel {
        private DescriptiveAttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.daList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 1) {
                return Messages.getString("LevelPropertiesDialogEx.Attribute");
            }
            if (n == 0) {
                return Messages.getString("LevelPropertiesDialogEx.Name");
            }
            if (n == 2) {
                return Messages.getString("LevelPropertiesDialogEx.Indexed");
            }
            if (n == 3) {
                return Messages.getString("LevelPropertiesDialogEx.SlowChanging");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!LevelPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 != 1;
        }

        public Class getColumnClass(int n) {
            if (n == 2) {
                return Boolean.class;
            }
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && object instanceof String) {
                SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(n);
                slowChangingAttribute.setName((String)object);
            } else if (n2 == 3) {
                SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(n);
                slowChangingAttribute.setType(String.valueOf(object));
                if (slowChangingAttribute.getType().equalsIgnoreCase(SlowChangingAttribute.TYPES[3])) {
                    LevelPropertiesDialogEx.this.updateHistoryElements(slowChangingAttribute);
                    LevelPropertiesDialogEx.this.enableButtons(true);
                } else {
                    slowChangingAttribute.getHistoryAttributes().clear();
                    LevelPropertiesDialogEx.this.hList.clear();
                    LevelPropertiesDialogEx.this.hTable.updateUI();
                    LevelPropertiesDialogEx.this.enableButtons(false);
                }
            } else if (n2 == 2 && object instanceof Boolean) {
                SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(n);
                slowChangingAttribute.setIndexed((Boolean)object);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(n);
            if (n2 == 1) {
                return slowChangingAttribute.getAttribute().getLongName();
            }
            if (n2 == 0) {
                return slowChangingAttribute.getName();
            }
            if (n2 == 3) {
                return slowChangingAttribute.getType();
            }
            return new Boolean(slowChangingAttribute.isIndexed());
        }
    }

    private class LevelKeyModel
    extends AbstractTableModel {
        private LevelKeyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.lkList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("LevelPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ContainedObject containedObject = (ContainedObject)LevelPropertiesDialogEx.this.lkList.get(n);
            if (n2 == 0) {
                return containedObject.getLongName();
            }
            return new Integer(n * n2);
        }
    }
}

