/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;

public class DimensionPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Dimension dimension;
    private JCheckBox chNatKeys;
    private JCheckBox chTimeDimension;
    private JPanel pnHierarchies;
    private JTable hTable;
    private List hList;
    private JPanel pnLevels;
    private JTable lTable;
    private List lList;
    private JPanel pnSCA;
    private JTable sTable;
    private List sList;
    private JPanel pnCalcMembers;
    private JTable pcmTable;
    private List permanentCMList;

    public DimensionPropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DimensionPropertiesDialogEx.DimensionProperties");
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Dimension) {
            this.dimension = (Dimension)designObject;
            this.initDefaults(false);
            this.taDescription.setText(this.dimension.getDescription());
            this.chNatKeys.setSelected(this.dimension.isUseNaturalKeys());
            this.chTimeDimension.setSelected(this.dimension.isTimeDimension());
            Iterator iterator = this.dimension.getHierarchies().iterator();
            while (iterator.hasNext()) {
                this.hList.add(iterator.next());
            }
            this.lList.addAll(this.dimension.getAllLevels());
            this.updateList();
            this.permanentCMList.addAll(this.dimension.getPermanentCalcMembers());
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.dynamicPropertiesList.clear();
            iterator = this.dimension.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.dimension.getProperty(string);
                DynamicProperty dynamicProperty = new DynamicProperty(string, string2);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        int n = this.pcmTable.getEditingColumn();
        int n2 = this.pcmTable.getEditingRow();
        if (n2 >= 0 && n >= 0) {
            this.pcmTable.getCellEditor(n2, n).stopCellEditing();
        }
        this.dimension.setName(this.tfName.getText());
        this.dimension.setComment(this.taComments.getText());
        this.dimension.setNotes(this.taNotes.getText());
        this.dimension.setDescription(this.taDescription.getText());
        this.dimension.setTimeDimension(this.chTimeDimension.isSelected());
        this.dimension.setUseNaturalKeys(this.chNatKeys.isSelected());
        this.dimension.getPermanentCalcMembers().clear();
        this.dimension.getPermanentCalcMembers().addAll(this.permanentCMList);
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        this.updateList();
        DimensionPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.dimension.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.dimension.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getHierarchiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getLevelsPanel());
        this.addToTree(defaultMutableTreeNode, this.getSCAPanel());
        this.addToTree(defaultMutableTreeNode, this.getCalcMembersPanel());
        this.addToTree(defaultMutableTreeNode, this.getOracleNamesPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "DIMENSION_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_USE_NATURAL_KEYS);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.chNatKeys = new JCheckBox();
        this.chNatKeys.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.chNatKeys));
        JLabel jLabel2 = new JLabel(LB_TIME_DIMENSION);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chTimeDimension = new JCheckBox();
        this.chTimeDimension.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chTimeDimension));
    }

    protected JPanel getHierarchiesPanel() {
        if (this.pnHierarchies == null) {
            this.pnHierarchies = this.createPage(Messages.getString("DimensionPropertiesDialogEx.Hierarchies"));
            this.hList = new ArrayList();
            this.hTable = new JTable(new HierarchyTableModel());
            this.hTable.setSelectionMode(0);
            this.hTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = DimensionPropertiesDialogEx.this.hTable.getSelectedRow()) != -1 && DimensionPropertiesDialogEx.this.hList.size() > 0 && n < DimensionPropertiesDialogEx.this.hList.size()) {
                        Hierarchy hierarchy = (Hierarchy)DimensionPropertiesDialogEx.this.hList.get(n);
                        hierarchy.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.hTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = DimensionPropertiesDialogEx.this.hTable.getSelectedRow();
                    if (n != -1 && DimensionPropertiesDialogEx.this.hList.size() > 0 && n < DimensionPropertiesDialogEx.this.hList.size()) {
                        Hierarchy hierarchy = (Hierarchy)DimensionPropertiesDialogEx.this.hList.get(n);
                        hierarchy.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnHierarchies.add(jPanel2);
        }
        return this.pnHierarchies;
    }

    protected JPanel getLevelsPanel() {
        if (this.pnLevels == null) {
            this.pnLevels = this.createPage(Messages.getString("DimensionPropertiesDialogEx.Levels"));
            this.lList = new ArrayList();
            this.lTable = new JTable(new LevelTableModel());
            this.lTable.setSelectionMode(0);
            this.lTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = DimensionPropertiesDialogEx.this.lTable.getSelectedRow()) != -1 && DimensionPropertiesDialogEx.this.lList.size() > 0 && n < DimensionPropertiesDialogEx.this.lList.size()) {
                        Level level = (Level)DimensionPropertiesDialogEx.this.lList.get(n);
                        level.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.lTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = DimensionPropertiesDialogEx.this.lTable.getSelectedRow();
                    if (n != -1 && DimensionPropertiesDialogEx.this.lList.size() > 0 && n < DimensionPropertiesDialogEx.this.lList.size()) {
                        Level level = (Level)DimensionPropertiesDialogEx.this.lList.get(n);
                        level.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnLevels.add(jPanel2);
        }
        return this.pnLevels;
    }

    private void updateList() {
        this.sList.clear();
        this.sList.addAll(this.getSCHAElements());
        this.sTable.updateUI();
    }

    private List getSCHAElements() {
        ArrayList<SCHAElement> arrayList = new ArrayList<SCHAElement>();
        for (Level level : this.dimension.getAllLevels()) {
            for (int i = 0; i < level.getSlowChangingAttributes().size(); ++i) {
                SlowChangingAttribute slowChangingAttribute = (SlowChangingAttribute)level.getSlowChangingAttributes().get(i);
                if (SlowChangingAttribute.TYPES[0].equalsIgnoreCase(slowChangingAttribute.getType())) continue;
                arrayList.add(new SCHAElement(level, slowChangingAttribute));
            }
        }
        return arrayList;
    }

    protected JPanel getSCAPanel() {
        if (this.pnSCA == null) {
            this.pnSCA = this.createPage(Messages.getString("DimensionPropertiesDialogEx.SlowChangingAttributes"));
            this.sList = new ArrayList();
            this.sTable = new JTable(new SCATableModel());
            this.sTable.setSelectionMode(0);
            this.sTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = DimensionPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && DimensionPropertiesDialogEx.this.sList.size() > 0 && n < DimensionPropertiesDialogEx.this.sList.size()) {
                        SCHAElement sCHAElement = (SCHAElement)DimensionPropertiesDialogEx.this.sList.get(n);
                        sCHAElement.getLevel().showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.sTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = DimensionPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (n != -1 && DimensionPropertiesDialogEx.this.sList.size() > 0 && n < DimensionPropertiesDialogEx.this.sList.size()) {
                        SCHAElement sCHAElement = (SCHAElement)DimensionPropertiesDialogEx.this.sList.get(n);
                        sCHAElement.getLevel().showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnSCA.add(jPanel2);
        }
        return this.pnSCA;
    }

    protected JPanel getCalcMembersPanel() {
        if (this.pnCalcMembers == null) {
            JComponent jComponent;
            this.pnCalcMembers = this.createPage(Messages.getString("DimensionPropertiesDialogEx.CalculatedMembers"));
            this.permanentCMList = new ArrayList();
            this.pcmTable = new JTable(new PermanentCalcMemberTableModel());
            this.pcmTable.setSelectionMode(0);
            this.pcmTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() != 2 || (n = DimensionPropertiesDialogEx.this.pcmTable.getSelectedRow()) <= -1 || DimensionPropertiesDialogEx.this.permanentCMList.size() <= 0 || n < DimensionPropertiesDialogEx.this.permanentCMList.size()) {
                        // empty if block
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.pcmTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = DimensionPropertiesDialogEx.this.generatePCMName("PCM_", DimensionPropertiesDialogEx.this.permanentCMList);
                        Dimension dimension = DimensionPropertiesDialogEx.this.dimension;
                        dimension.getClass();
                        Dimension.PermanentCalcMember permanentCalcMember = dimension.new Dimension.PermanentCalcMember(string);
                        DimensionPropertiesDialogEx.this.permanentCMList.add(permanentCalcMember);
                        DimensionPropertiesDialogEx.this.pcmTable.updateUI();
                    }
                });
                JButton jButton = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton.setToolTipText(BTN_REMOVE);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = DimensionPropertiesDialogEx.this.pcmTable.getSelectedRow();
                        if (n != -1 && DimensionPropertiesDialogEx.this.permanentCMList.size() > 0 && n < DimensionPropertiesDialogEx.this.permanentCMList.size()) {
                            DimensionPropertiesDialogEx.this.permanentCMList.remove(n);
                            DimensionPropertiesDialogEx.this.pcmTable.updateUI();
                        }
                    }
                });
                JToolBar jToolBar = new JToolBar(0);
                jToolBar.setFloatable(false);
                jToolBar.add(jComponent);
                jToolBar.add(jButton);
                jPanel.add(jToolBar);
            }
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnCalcMembers.add(jComponent);
        }
        return this.pnCalcMembers;
    }

    private String generatePCMName(String string, List list) {
        int n = list.size();
        String string2 = string + String.valueOf(n);
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < list.size(); ++i) {
                Dimension.PermanentCalcMember permanentCalcMember;
                string2 = string + String.valueOf(n);
                if (!string2.equalsIgnoreCase((permanentCalcMember = (Dimension.PermanentCalcMember)list.get(i)).getName())) continue;
                bl = true;
                break;
            }
            ++n;
        }
        return string2;
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class PermanentCalcMemberTableModel
    extends AbstractTableModel {
        private PermanentCalcMemberTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DimensionPropertiesDialogEx.this.permanentCMList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DimensionPropertiesDialogEx.Name");
            }
            if (n == 1) {
                return Messages.getString("DimensionPropertiesDialogEx.Expression");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return DimensionPropertiesDialogEx.this.isEditable();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Dimension.PermanentCalcMember permanentCalcMember = (Dimension.PermanentCalcMember)DimensionPropertiesDialogEx.this.permanentCMList.get(n);
            if (n2 == 0) {
                return permanentCalcMember.getName();
            }
            if (n2 == 1) {
                return permanentCalcMember.getExpression();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Dimension.PermanentCalcMember permanentCalcMember = (Dimension.PermanentCalcMember)DimensionPropertiesDialogEx.this.permanentCMList.get(n);
            if (n2 == 0) {
                permanentCalcMember.setName((String)object);
            } else if (n2 == 1) {
                permanentCalcMember.setExpression((String)object);
            }
        }
    }

    class SCHAElement {
        private Level level;
        private SlowChangingAttribute scha;

        public SCHAElement(Level level, SlowChangingAttribute slowChangingAttribute) {
            this.level = level;
            this.scha = slowChangingAttribute;
        }

        public Level getLevel() {
            return this.level;
        }

        public SlowChangingAttribute getSlowChangingAttribute() {
            return this.scha;
        }
    }

    private class SCATableModel
    extends AbstractTableModel {
        private SCATableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DimensionPropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Messages.getString("DimensionPropertiesDialogEx.Level");
                }
                case 1: {
                    return Messages.getString("DimensionPropertiesDialogEx.Attribute");
                }
                case 2: {
                    return Messages.getString("DimensionPropertiesDialogEx.Type");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SCHAElement sCHAElement = (SCHAElement)DimensionPropertiesDialogEx.this.sList.get(n);
            switch (n2) {
                case 0: {
                    return sCHAElement.getLevel().getName();
                }
                case 1: {
                    return sCHAElement.getSlowChangingAttribute().getAttribute().getLongName();
                }
                case 2: {
                    return sCHAElement.getSlowChangingAttribute().getType();
                }
            }
            return new Integer(n * n2);
        }
    }

    private class LevelTableModel
    extends AbstractTableModel {
        private LevelTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DimensionPropertiesDialogEx.this.lList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DimensionPropertiesDialogEx.Levels");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Level level = (Level)DimensionPropertiesDialogEx.this.lList.get(n);
            if (n2 == 0) {
                return level.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class HierarchyTableModel
    extends AbstractTableModel {
        private HierarchyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DimensionPropertiesDialogEx.this.hList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("DimensionPropertiesDialogEx.Hierarchies");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Hierarchy hierarchy = (Hierarchy)DimensionPropertiesDialogEx.this.hList.get(n);
            if (n2 == 0) {
                return hierarchy.getName();
            }
            return new Integer(n * n2);
        }
    }
}

