/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.FEJoinPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.multidimensional.MeasurePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SlicePropertiesDialogEx;

public class CubePropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Cube cube;
    private JCheckBox chVirtual;
    private JCheckBox chPartitioned;
    private JComboBox cbPartDimension;
    private oracle.dbtools.crest.model.design.multidimensional.Dimension curDimension;
    private Hierarchy curHierarchy;
    private JComboBox cbFullCubeMaterialization;
    private JComboBox cbPartHierarchy;
    private JComboBox cbPartLevel;
    private JPanel pnPartDescription;
    private JTextArea taPartDescription;
    private JCheckBox chGlobalComp;
    private JCheckBox chCompressedComposites;
    private JPanel pnEntities;
    private JList selectedEntList;
    private JList allEntList;
    private DefaultListModel allEntModel;
    private DefaultListModel selectedEntModel;
    private JButton btnAddEnt;
    private JButton btnRemoveEnt;
    private JCheckBox chbUseFactEnt;
    private List selEntList;
    private List allEntities;
    private JPanel pnJoins;
    private JTable scTable;
    private List joins;
    private JPanel pnDimensions;
    private JTable dimTable;
    private List dimList;
    private Map linkMap;
    JButton btnUp;
    JButton btnDown;
    private JPanel pnCubeMeasures;
    private JTable mTable;
    private List mList;
    private List newMeasures;
    private List deletedMeasures;
    private JPanel pnSlices;
    private JTable sTable;
    private List sList;
    private List newSlices;
    private List deletedSlices;
    private JPanel pnSQLAccess2OracleAW;
    private List sqlList;
    private JTable sqlTable;
    private List newSQLList;
    private static final Dimension defaultSize = new Dimension(240, 20);

    public CubePropertiesDialogEx(ApplicationView applicationView, DesignObject designObject) {
        super(applicationView, designObject);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("CubePropertiesDialogEx.CubeProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return 700;
    }

    @Override
    protected int getMinimumHeight() {
        return 440;
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    @Override
    public void initProperties(DesignObject designObject) {
        if (designObject instanceof Cube) {
            Object object;
            this.cube = (Cube)designObject;
            this.initDefaults(false);
            this.cube.getDesign().getLogicalDesign().getEntitySet().addAllElementsTo(this.allEntities);
            this.cube.getDesign().getLogicalDesign().getEntityViewSet().addAllElementsTo(this.allEntities);
            this.selEntList.addAll(this.cube.getFactEntities());
            this.joins.addAll(this.cube.getJoins());
            this.chVirtual.setSelected(this.cube.isVirtual());
            this.chPartitioned.setSelected(this.cube.isPartitioned());
            this.curDimension = this.cube.getPartDimension();
            this.fillComboItems(this.cube.getDimensions().toArray(), this.cbPartDimension, false);
            this.cbPartDimension.setSelectedItem(this.cube.getPartDimension());
            this.cbPartDimension.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.cbPartDimension.getSelectedItem();
                    if (dimension != CubePropertiesDialogEx.this.curDimension) {
                        CubePropertiesDialogEx.this.curDimension = dimension;
                        CubePropertiesDialogEx.this.fillComboItems(dimension.getHierarchies().toArray(), CubePropertiesDialogEx.this.cbPartHierarchy, false);
                        if (dimension.getHierarchies().size() > 0) {
                            Hierarchy hierarchy = (Hierarchy)dimension.getHierarchies().getElement(0);
                            CubePropertiesDialogEx.this.cbPartHierarchy.setSelectedItem(hierarchy);
                            CubePropertiesDialogEx.this.fillComboItems(hierarchy.getLevels().toArray(), CubePropertiesDialogEx.this.cbPartLevel, false);
                            if (hierarchy.getLevels().size() > 0) {
                                CubePropertiesDialogEx.this.cbPartLevel.setSelectedItem(hierarchy.getLevels().get(0));
                            }
                        }
                    }
                }
            });
            if (this.cube.isPartitioned() && this.cube.getPartDimension() != null) {
                this.fillComboItems(this.cube.getPartDimension().getHierarchies().toArray(), this.cbPartHierarchy, false);
                this.cbPartHierarchy.setSelectedItem(this.cube.getPartHierarchy());
                this.curHierarchy = this.cube.getPartHierarchy();
            }
            if (this.cube.isPartitioned() && this.cube.getPartDimension() != null && this.cube.getPartHierarchy() != null) {
                this.fillComboItems(this.cube.getPartHierarchy().getLevels().toArray(), this.cbPartLevel, false);
                this.cbPartLevel.setSelectedItem(this.cube.getPartLevel());
            }
            this.chGlobalComp.setSelected(this.cube.isUseGlobalComposites());
            this.chCompressedComposites.setSelected(this.cube.isCompressedComposites());
            this.dimList.addAll(this.cube.getDimensions());
            for (Object object2 : this.cube.getDimensions()) {
                object = this.cube.getRollUpLink((oracle.dbtools.crest.model.design.multidimensional.Dimension)object2);
                this.linkMap.put(((ModelIDObject)object2).getObjectID(), object);
            }
            this.mList.addAll(this.cube.getMeasures());
            this.sList.addAll(this.cube.getPrecalculatedSlices());
            this.sqlList.addAll(this.cube.getSQLDefinitions());
            this.taDescription.setText(this.cube.getDescription());
            this.taPartDescription.setText(this.cube.getPartitioningDescription());
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.updateSlicesCombo();
            this.fillEntLists();
            this.dynamicPropertiesList.clear();
            Iterator iterator = this.cube.getPropertyNames();
            while (iterator.hasNext()) {
                Object object2;
                object2 = (String)iterator.next();
                object = this.cube.getProperty((String)object2);
                DynamicProperty dynamicProperty = new DynamicProperty((String)object2, (String)object);
                this.dynamicPropertiesList.add(dynamicProperty);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        int n;
        int n2 = this.dimTable.getEditingColumn();
        int n3 = this.dimTable.getEditingRow();
        if (n3 >= 0 && n2 >= 0) {
            this.dimTable.getCellEditor(n3, n2).stopCellEditing();
        }
        this.cube.setName(this.tfName.getText());
        this.cube.setComment(this.taComments.getText());
        this.cube.setNotes(this.taNotes.getText());
        this.cube.setDescription(this.taDescription.getText());
        this.cube.setVirtual(this.chVirtual.isSelected());
        this.cube.setPartitioned(this.chPartitioned.isSelected());
        this.cube.setPartitioningDescription(this.taPartDescription.getText());
        this.cube.setPartDimension((oracle.dbtools.crest.model.design.multidimensional.Dimension)this.cbPartDimension.getSelectedItem());
        this.cube.setPartHierarchy((Hierarchy)this.cbPartHierarchy.getSelectedItem());
        this.cube.setPartLevel((Level)this.cbPartLevel.getSelectedItem());
        this.cube.setFullCubeMaterialization((Slice)this.cbFullCubeMaterialization.getSelectedItem());
        this.cube.getMeasures().clear();
        this.cube.setUseGlobalComposites(this.chGlobalComp.isSelected());
        this.cube.setCompressedComposites(this.chCompressedComposites.isSelected());
        for (AbstractMDObject abstractMDObject : this.mList) {
            ((Measure)abstractMDObject).setCube(this.cube);
            this.cube.addMeasure((Measure)abstractMDObject);
        }
        for (AbstractMDObject abstractMDObject : this.deletedMeasures) {
            abstractMDObject.remove();
        }
        this.cube.getPrecalculatedSlices().clear();
        for (AbstractMDObject abstractMDObject : this.sList) {
            this.cube.addPrecalculatedSlice((Slice)abstractMDObject);
        }
        for (AbstractMDObject abstractMDObject : this.deletedSlices) {
            abstractMDObject.remove();
        }
        int n4 = this.selectedEntModel.size();
        this.cube.getFactEntities().clear();
        for (n = 0; n < n4; ++n) {
            this.cube.addFactEntity((ContainerObject)this.selectedEntModel.getElementAt(n));
        }
        this.cube.getJoins().clear();
        for (n = 0; n < this.joins.size(); ++n) {
            this.cube.addFactEntitiesJoin((FactEntitiesJoin)this.joins.get(n));
        }
        for (n = 0; n < this.dimList.size(); ++n) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.dimList.get(n);
            this.cube.moveToIndex(dimension, n);
        }
        this.updateSlicesCombo();
        this.cube.getSQLDefinitions().clear();
        this.cube.getSQLDefinitions().addAll(this.sqlList);
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        this.newMeasures.clear();
        this.newSlices.clear();
        CubePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.cube.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.cube.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addToTree(defaultMutableTreeNode, this.getGeneralPanel());
        this.addToTree(defaultMutableTreeNode, this.getEntitiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getJoinsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDimensionsPanel());
        this.addToTree(defaultMutableTreeNode, this.getCubeMeasuresPanel());
        this.addToTree(defaultMutableTreeNode, this.getSlicesPanel());
        this.addToTree(defaultMutableTreeNode, this.getOracleNamesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSQLAccess2OracleAWPanel());
        this.addToTree(defaultMutableTreeNode, this.getCommentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getNotesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getPartDescriptionPanel());
        this.addToTree(defaultMutableTreeNode, this.getResPartiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getDocumentsPanel());
        this.addToTree(defaultMutableTreeNode, this.getDynamicPropertiesPanel());
        this.addToTree(defaultMutableTreeNode, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "CUBE_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel jLabel = new JLabel(LB_VIRTUAL);
        jLabel.setPreferredSize(this.getDefaultSize());
        this.chVirtual = new JCheckBox();
        this.chVirtual.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel, this.chVirtual));
        JLabel jLabel2 = new JLabel(LB_PARTITIONED);
        jLabel2.setPreferredSize(this.getDefaultSize());
        this.chPartitioned = new JCheckBox();
        this.chPartitioned.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel2, this.chPartitioned));
        JLabel jLabel3 = new JLabel(LB_PART_DIMENSION);
        jLabel3.setPreferredSize(this.getDefaultSize());
        this.cbPartDimension = new JComboBox();
        this.cbPartDimension.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel3, this.cbPartDimension));
        JLabel jLabel4 = new JLabel(LB_PART_HIERARCHY);
        jLabel4.setPreferredSize(this.getDefaultSize());
        this.cbPartHierarchy = new JComboBox();
        this.cbPartHierarchy.setPreferredSize(this.getDefaultSize());
        this.cbPartHierarchy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Hierarchy hierarchy = (Hierarchy)CubePropertiesDialogEx.this.cbPartHierarchy.getSelectedItem();
                    if (hierarchy != CubePropertiesDialogEx.this.curHierarchy) {
                        CubePropertiesDialogEx.this.curHierarchy = hierarchy;
                        CubePropertiesDialogEx.this.fillComboItems(hierarchy.getLevels().toArray(), CubePropertiesDialogEx.this.cbPartLevel, false);
                        if (hierarchy.getLevels().size() > 0) {
                            CubePropertiesDialogEx.this.cbPartLevel.setSelectedItem(hierarchy.getLevels().get(0));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(jLabel4, this.cbPartHierarchy));
        JLabel jLabel5 = new JLabel(LB_PART_LEVEL);
        jLabel5.setPreferredSize(this.getDefaultSize());
        this.cbPartLevel = new JComboBox();
        this.cbPartLevel.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel5, this.cbPartLevel));
        JLabel jLabel6 = new JLabel(LB_GLOBAL_COMPOSITES);
        jLabel6.setPreferredSize(this.getDefaultSize());
        jLabel6.setToolTipText(Messages.getString("CubePropertiesDialogEx.OracleAWCubeGlobalComposites"));
        this.chGlobalComp = new JCheckBox();
        this.chGlobalComp.setPreferredSize(this.getDefaultSize());
        this.chGlobalComp.setToolTipText(jLabel6.getToolTipText());
        this.addRowToGeneralPanel(this.createRow(jLabel6, this.chGlobalComp));
        JLabel jLabel7 = new JLabel(LB_COMPRESSED_COMPOSITES);
        jLabel7.setPreferredSize(this.getDefaultSize());
        jLabel7.setToolTipText(Messages.getString("CubePropertiesDialogEx.OracleCubeCompressedComposites"));
        this.chCompressedComposites = new JCheckBox();
        this.chCompressedComposites.setPreferredSize(this.getDefaultSize());
        this.chCompressedComposites.setToolTipText(jLabel7.getToolTipText());
        this.addRowToGeneralPanel(this.createRow(jLabel7, this.chCompressedComposites));
        JLabel jLabel8 = new JLabel(LB_MATERIALIZATION);
        jLabel8.setPreferredSize(this.getDefaultSize());
        this.cbFullCubeMaterialization = new JComboBox();
        this.cbFullCubeMaterialization.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(jLabel8, this.cbFullCubeMaterialization));
    }

    private void updateSlicesCombo() {
        this.cbFullCubeMaterialization.removeAllItems();
        this.cbFullCubeMaterialization.addItem(null);
        for (int i = 0; i < this.sList.size(); ++i) {
            this.cbFullCubeMaterialization.addItem(this.sList.get(i));
        }
        this.cbFullCubeMaterialization.setSelectedItem(this.cube.getFullCubeMaterialization());
    }

    protected JPanel getPartDescriptionPanel() {
        if (this.pnPartDescription == null) {
            this.pnPartDescription = this.createPage(Messages.getString("CubePropertiesDialogEx.PartitioningDescription"));
            this.taPartDescription = new JTextArea();
            this.pnPartDescription.add(new JScrollPane(this.taPartDescription));
        }
        return this.pnPartDescription;
    }

    protected JPanel getEntitiesPanel() {
        if (this.pnEntities == null) {
            this.pnEntities = this.createPage(Messages.getString("CubePropertiesDialogEx.Entities"));
            this.selEntList = new ArrayList();
            this.allEntities = new ArrayList();
            JPanel jPanel = new JPanel();
            BoxLayout boxLayout = new BoxLayout(jPanel, 2);
            jPanel.setLayout(boxLayout);
            this.pnEntities.add((Component)jPanel, "Center");
            this.initAllEntitiesList(jPanel);
            this.initEntitiesButtons(jPanel);
            this.initSelectedEntitiesList(jPanel);
            this.chbUseFactEnt = new JCheckBox(Messages.getString("CubePropertiesDialogEx.ListFactEntitiesOnly"));
            this.chbUseFactEnt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CubePropertiesDialogEx.this.updateEntLists();
                }
            });
            this.pnEntities.add((Component)this.chbUseFactEnt, "South");
        }
        return this.pnEntities;
    }

    private void updateEntLists() {
        this.selEntList.clear();
        for (int i = 0; i < this.selectedEntModel.size(); ++i) {
            ContainerObject containerObject = (ContainerObject)this.selectedEntModel.getElementAt(i);
            if (!this.chbUseFactEnt.isSelected()) {
                this.selEntList.add(containerObject);
                continue;
            }
            if (!(containerObject instanceof Entity) || !this.getDesignObject().getDesign().getDLSettings().getClassificationTypeNameByID(((Entity)containerObject).getTypeID()).equalsIgnoreCase(ContainerObject.TYPE_FACT)) continue;
            this.selEntList.add(containerObject);
        }
        this.allEntModel.clear();
        this.selectedEntModel.clear();
        this.fillEntLists();
    }

    private void fillEntLists() {
        for (ContainerObject containerObject : this.allEntities) {
            if (!this.chbUseFactEnt.isSelected()) {
                if (!this.selEntList.contains(containerObject)) {
                    this.allEntModel.addElement(containerObject);
                    continue;
                }
                this.selectedEntModel.addElement(containerObject);
                continue;
            }
            if (!(containerObject instanceof Entity) || !this.getDesignObject().getDesign().getDLSettings().getClassificationTypeNameByID(((Entity)containerObject).getTypeID()).equalsIgnoreCase(ContainerObject.TYPE_FACT)) continue;
            if (!this.selEntList.contains(containerObject)) {
                this.allEntModel.addElement(containerObject);
                continue;
            }
            this.selectedEntModel.addElement(containerObject);
        }
    }

    private void initAllEntitiesList(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.allEntModel = new DefaultListModel();
        this.allEntList = new JList(this.allEntModel);
        ListSelectionModel listSelectionModel = this.allEntList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllEntitiesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allEntList);
        jScrollPane.setPreferredSize(new Dimension(145, 220));
        jPanel2.add(jScrollPane);
        jPanel.add(jPanel2);
    }

    private void initSelectedEntitiesList(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.selectedEntModel = new DefaultListModel();
        this.selectedEntList = new JList(this.selectedEntModel);
        ListSelectionModel listSelectionModel = this.selectedEntList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedEntitiesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedEntList);
        jScrollPane.setPreferredSize(new Dimension(145, 220));
        jPanel2.add(jScrollPane);
        jPanel.add(jPanel2);
    }

    private void initEntitiesButtons(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        this.btnAddEnt = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddEnt.addActionListener(new AddEntitiesActionListener());
        this.btnAddEnt.setEnabled(false);
        this.btnAddEnt.setToolTipText(BTN_ADD);
        this.btnRemoveEnt = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveEnt.setEnabled(false);
        this.btnRemoveEnt.addActionListener(new RemoveEntitiesActionListener());
        this.btnRemoveEnt.setToolTipText(BTN_REMOVE);
        jToolBar.add(this.btnAddEnt);
        jToolBar.add(this.btnRemoveEnt);
        jPanel2.add(jToolBar);
        jPanel.add(jPanel2);
    }

    private List getSelectedEntities() {
        ArrayList arrayList = new ArrayList();
        int n = this.selectedEntModel.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.selectedEntModel.getElementAt(i));
        }
        return arrayList;
    }

    protected JPanel getJoinsPanel() {
        if (this.pnJoins == null) {
            JComponent jComponent;
            this.pnJoins = this.createPage(Messages.getString("CubePropertiesDialogEx.Joins"));
            this.joins = new ArrayList();
            this.scTable = new JTable(new JoinsTableModel());
            this.scTable.setSelectionMode(0);
            this.scTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = CubePropertiesDialogEx.this.scTable.getSelectedRow()) > -1 && CubePropertiesDialogEx.this.joins.size() > 0 && n < CubePropertiesDialogEx.this.joins.size()) {
                        FactEntitiesJoin factEntitiesJoin = (FactEntitiesJoin)CubePropertiesDialogEx.this.joins.get(n);
                        FEJoinPropertiesDialogEx fEJoinPropertiesDialogEx = new FEJoinPropertiesDialogEx(CubePropertiesDialogEx.this.getAppView(), factEntitiesJoin, CubePropertiesDialogEx.this.getSelectedEntities());
                        fEJoinPropertiesDialogEx.initProperties(factEntitiesJoin);
                        fEJoinPropertiesDialogEx.setModal(true);
                        fEJoinPropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.scTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CubePropertiesDialogEx.this.scTable.getSelectedRow();
                    if (n > -1 && CubePropertiesDialogEx.this.joins.size() > 0 && n < CubePropertiesDialogEx.this.joins.size()) {
                        FactEntitiesJoin factEntitiesJoin = (FactEntitiesJoin)CubePropertiesDialogEx.this.joins.get(n);
                        FEJoinPropertiesDialogEx fEJoinPropertiesDialogEx = new FEJoinPropertiesDialogEx(CubePropertiesDialogEx.this.getAppView(), factEntitiesJoin, CubePropertiesDialogEx.this.getSelectedEntities());
                        fEJoinPropertiesDialogEx.initProperties(factEntitiesJoin);
                        fEJoinPropertiesDialogEx.setModal(true);
                        fEJoinPropertiesDialogEx.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(Messages.getString("CubePropertiesDialogEx.AddJoinsNumberEntities"));
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FactEntitiesJoin factEntitiesJoin = ((MultidimensionalDesign)CubePropertiesDialogEx.this.cube.getDesignPart()).createFactEntitiesJoin();
                        FEJoinPropertiesDialogEx fEJoinPropertiesDialogEx = new FEJoinPropertiesDialogEx(CubePropertiesDialogEx.this.getAppView(), factEntitiesJoin, CubePropertiesDialogEx.this.getSelectedEntities());
                        fEJoinPropertiesDialogEx.initProperties(factEntitiesJoin);
                        fEJoinPropertiesDialogEx.setModal(true);
                        fEJoinPropertiesDialogEx.show();
                        if (fEJoinPropertiesDialogEx.isApplied) {
                            CubePropertiesDialogEx.this.joins.add(factEntitiesJoin);
                            CubePropertiesDialogEx.this.scTable.updateUI();
                        } else {
                            factEntitiesJoin.remove();
                        }
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = CubePropertiesDialogEx.this.scTable.getSelectedRow();
                        if (n != -1 && CubePropertiesDialogEx.this.joins.size() > 0 && n < CubePropertiesDialogEx.this.joins.size()) {
                            CubePropertiesDialogEx.this.joins.remove(n);
                            CubePropertiesDialogEx.this.scTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnJoins.add(jComponent);
        }
        return this.pnJoins;
    }

    protected JPanel getDimensionsPanel() {
        if (this.pnDimensions == null) {
            this.pnDimensions = this.createPage(Messages.getString("CubePropertiesDialogEx.Dimensions"));
            this.dimList = new ArrayList();
            this.linkMap = new TreeMap();
            this.dimTable = new JTable(new DimensionTableModel());
            this.dimTable.setSelectionMode(0);
            this.dimTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    oracle.dbtools.crest.model.design.multidimensional.Dimension dimension;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = CubePropertiesDialogEx.this.dimTable.getSelectedRow()) != -1 && CubePropertiesDialogEx.this.dimList.size() > 0 && n < CubePropertiesDialogEx.this.dimList.size() && !(dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(n)).isDialogVisible()) {
                        dimension.showModal = true;
                        dimension.showPropertyDialog();
                        CubePropertiesDialogEx.this.dimTable.updateUI();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.dimTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    oracle.dbtools.crest.model.design.multidimensional.Dimension dimension;
                    int n = CubePropertiesDialogEx.this.dimTable.getSelectedRow();
                    if (n != -1 && CubePropertiesDialogEx.this.dimList.size() > 0 && n < CubePropertiesDialogEx.this.dimList.size() && !(dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(n)).isDialogVisible()) {
                        dimension.showModal = true;
                        dimension.showPropertyDialog();
                        CubePropertiesDialogEx.this.dimTable.updateUI();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                this.btnUp = new JButton(gUIConfiguration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
                this.btnUp.setToolTipText(BTN_MOVE_UP);
                this.btnUp.addActionListener(new MoveUpAction());
                this.btnDown = new JButton(gUIConfiguration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
                this.btnDown.setToolTipText(BTN_MOVE_DOWN);
                this.btnDown.addActionListener(new MoveDownAction());
                jToolBar.addSeparator();
                jToolBar.add(this.btnUp);
                jToolBar.add(this.btnDown);
            }
            jPanel.add(jToolBar);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add(jScrollPane);
            this.pnDimensions.add(jPanel2);
        }
        return this.pnDimensions;
    }

    public boolean moveToIndex(Object object, int n) {
        if (this.dimList.contains(object) && this.dimList.size() > n && n >= 0) {
            this.dimList.remove(object);
            this.dimList.add(n, object);
            return true;
        }
        return false;
    }

    protected JPanel getCubeMeasuresPanel() {
        if (this.pnCubeMeasures == null) {
            JComponent jComponent;
            this.pnCubeMeasures = this.createPage(Messages.getString("CubePropertiesDialogEx.Measures"));
            this.mList = new ArrayList();
            this.newMeasures = new ArrayList();
            this.deletedMeasures = new ArrayList();
            this.mTable = new JTable(new MeasureTableModel());
            this.mTable.setSelectionMode(0);
            this.mTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Measure measure;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = CubePropertiesDialogEx.this.mTable.getSelectedRow()) != -1 && CubePropertiesDialogEx.this.mList.size() > 0 && n < CubePropertiesDialogEx.this.mList.size() && !(measure = (Measure)CubePropertiesDialogEx.this.mList.get(n)).isDialogVisible()) {
                        measure.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        MeasurePropertiesDialogEx measurePropertiesDialogEx = new MeasurePropertiesDialogEx((Dialog)CubePropertiesDialogEx.this, CubePropertiesDialogEx.this.getAppView(), measure);
                        measurePropertiesDialogEx.initProperties(measure);
                        measurePropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.mTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Measure measure;
                    int n = CubePropertiesDialogEx.this.mTable.getSelectedRow();
                    if (n != -1 && CubePropertiesDialogEx.this.mList.size() > 0 && n < CubePropertiesDialogEx.this.mList.size() && !(measure = (Measure)CubePropertiesDialogEx.this.mList.get(n)).isDialogVisible()) {
                        measure.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        MeasurePropertiesDialogEx measurePropertiesDialogEx = new MeasurePropertiesDialogEx((Dialog)CubePropertiesDialogEx.this, CubePropertiesDialogEx.this.getAppView(), measure);
                        measurePropertiesDialogEx.initProperties(measure);
                        measurePropertiesDialogEx.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Measure measure = ((MultidimensionalDesign)CubePropertiesDialogEx.this.cube.getDesignPart()).createMeasure();
                        measure.setCube(CubePropertiesDialogEx.this.cube);
                        CubePropertiesDialogEx.this.mList.add(measure);
                        CubePropertiesDialogEx.this.newMeasures.add(measure);
                        CubePropertiesDialogEx.this.mTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = CubePropertiesDialogEx.this.mTable.getSelectedRow();
                        if (n != -1 && CubePropertiesDialogEx.this.mList.size() > 0 && n < CubePropertiesDialogEx.this.mList.size()) {
                            CubePropertiesDialogEx.this.deletedMeasures.add(CubePropertiesDialogEx.this.mList.get(n));
                            CubePropertiesDialogEx.this.mList.remove(n);
                            CubePropertiesDialogEx.this.mTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnCubeMeasures.add(jComponent);
        }
        return this.pnCubeMeasures;
    }

    protected JPanel getSlicesPanel() {
        if (this.pnSlices == null) {
            JComponent jComponent;
            this.pnSlices = this.createPage(Messages.getString("CubePropertiesDialogEx.PrecalculatedSlices"));
            this.sList = new ArrayList();
            this.newSlices = new ArrayList();
            this.deletedSlices = new ArrayList();
            this.sTable = new JTable(new SliceTableModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Slice slice;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = CubePropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && CubePropertiesDialogEx.this.sList.size() > 0 && n < CubePropertiesDialogEx.this.sList.size() && !(slice = (Slice)CubePropertiesDialogEx.this.sList.get(n)).isDialogVisible()) {
                        slice.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        SlicePropertiesDialogEx slicePropertiesDialogEx = new SlicePropertiesDialogEx((Dialog)CubePropertiesDialogEx.this, CubePropertiesDialogEx.this.getAppView(), slice);
                        slicePropertiesDialogEx.initProperties(slice);
                        slicePropertiesDialogEx.show();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.sTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Slice slice;
                    int n = CubePropertiesDialogEx.this.sTable.getSelectedRow();
                    if (n != -1 && CubePropertiesDialogEx.this.sList.size() > 0 && n < CubePropertiesDialogEx.this.sList.size() && !(slice = (Slice)CubePropertiesDialogEx.this.sList.get(n)).isDialogVisible()) {
                        slice.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        SlicePropertiesDialogEx slicePropertiesDialogEx = new SlicePropertiesDialogEx((Dialog)CubePropertiesDialogEx.this, CubePropertiesDialogEx.this.getAppView(), slice);
                        slicePropertiesDialogEx.initProperties(slice);
                        slicePropertiesDialogEx.show();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Slice slice = ((MultidimensionalDesign)CubePropertiesDialogEx.this.cube.getDesignPart()).createSlice();
                        slice.setCube(CubePropertiesDialogEx.this.cube);
                        CubePropertiesDialogEx.this.newSlices.add(slice);
                        CubePropertiesDialogEx.this.sList.add(slice);
                        CubePropertiesDialogEx.this.sTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = CubePropertiesDialogEx.this.sTable.getSelectedRow();
                        if (n != -1 && CubePropertiesDialogEx.this.sList.size() > 0 && n < CubePropertiesDialogEx.this.sList.size()) {
                            CubePropertiesDialogEx.this.deletedSlices.add(CubePropertiesDialogEx.this.sList.get(n));
                            CubePropertiesDialogEx.this.sList.remove(n);
                            CubePropertiesDialogEx.this.sTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnSlices.add(jComponent);
        }
        return this.pnSlices;
    }

    protected JPanel getSQLAccess2OracleAWPanel() {
        if (this.pnSQLAccess2OracleAW == null) {
            JComponent jComponent;
            this.pnSQLAccess2OracleAW = this.createPage(Messages.getString("CubePropertiesDialogEx.SQLAccessOracleAW"));
            this.sqlList = new ArrayList();
            this.newSQLList = new ArrayList();
            this.sqlTable = new JTable(new SQLToAWTableModel());
            this.sqlTable.setSelectionMode(0);
            this.sqlTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    SQLAccessToAW sQLAccessToAW;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = CubePropertiesDialogEx.this.sqlTable.getSelectedRow()) > -1 && CubePropertiesDialogEx.this.sqlList.size() > 0 && n < CubePropertiesDialogEx.this.sqlList.size() && !(sQLAccessToAW = (SQLAccessToAW)CubePropertiesDialogEx.this.sqlList.get(n)).isDialogVisible()) {
                        sQLAccessToAW.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        sQLAccessToAW.showPropertyDialog();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.sqlTable);
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            jButton.setToolTipText(BTN_PROPERTIES);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SQLAccessToAW sQLAccessToAW;
                    int n = CubePropertiesDialogEx.this.sqlTable.getSelectedRow();
                    if (n > -1 && CubePropertiesDialogEx.this.sqlList.size() > 0 && n < CubePropertiesDialogEx.this.sqlList.size() && !(sQLAccessToAW = (SQLAccessToAW)CubePropertiesDialogEx.this.sqlList.get(n)).isDialogVisible()) {
                        sQLAccessToAW.showModal = ((CubePropertiesDialogEx)CubePropertiesDialogEx.this).cube.showModal || CubePropertiesDialogEx.this.cube.showForFirstTime();
                        sQLAccessToAW.showPropertyDialog();
                    }
                }
            });
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(jButton);
            if (this.isEditable()) {
                jComponent = new JButton(gUIConfiguration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                jComponent.setToolTipText(BTN_ADD);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SQLAccessToAW sQLAccessToAW = CubePropertiesDialogEx.this.cube.getMultidimensionalDesign().createSQLAccessToAW();
                        sQLAccessToAW.setCube(CubePropertiesDialogEx.this.cube);
                        CubePropertiesDialogEx.this.newSQLList.add(sQLAccessToAW);
                        CubePropertiesDialogEx.this.sqlList.add(sQLAccessToAW);
                        CubePropertiesDialogEx.this.sqlTable.updateUI();
                    }
                });
                JButton jButton2 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                jButton2.setToolTipText(BTN_REMOVE);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = CubePropertiesDialogEx.this.sqlTable.getSelectedRow();
                        if (n != -1 && CubePropertiesDialogEx.this.sqlList.size() > 0 && n < CubePropertiesDialogEx.this.sqlList.size()) {
                            CubePropertiesDialogEx.this.sqlList.remove(n);
                            CubePropertiesDialogEx.this.sqlTable.updateUI();
                        }
                    }
                });
                jToolBar.addSeparator();
                jToolBar.add(jComponent);
                jToolBar.add(jButton2);
            }
            jPanel.add(jToolBar);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add(jScrollPane);
            this.pnSQLAccess2OracleAW.add(jComponent);
        }
        return this.pnSQLAccess2OracleAW;
    }

    @Override
    protected void onCancel() {
        for (AbstractMDObject abstractMDObject : this.newSlices) {
            abstractMDObject.remove();
        }
        for (AbstractMDObject abstractMDObject : this.newMeasures) {
            abstractMDObject.remove();
        }
        for (AbstractMDObject abstractMDObject : this.newSQLList) {
            abstractMDObject.remove();
        }
        super.onCancel();
    }

    private static void stopCellEditing(JTable jTable) {
        int n = jTable.getEditingColumn();
        int n2 = jTable.getEditingRow();
        if (n > -1 && n2 > -1) {
            jTable.getCellEditor(n2, n).stopCellEditing();
        }
    }

    private class SQLToAWTableModel
    extends AbstractTableModel {
        private SQLToAWTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.sqlList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CubePropertiesDialogEx.Name");
            }
            if (n == 1) {
                return Messages.getString("CubePropertiesDialogEx.MeasureAlias");
            }
            if (n == 2) {
                return Messages.getString("CubePropertiesDialogEx.WhereClause");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SQLAccessToAW sQLAccessToAW = (SQLAccessToAW)CubePropertiesDialogEx.this.sqlList.get(n);
            if (n2 == 0) {
                return sQLAccessToAW.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class SliceTableModel
    extends AbstractTableModel {
        private SliceTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.sList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CubePropertiesDialogEx.PrecalculatedSlices");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Slice slice = (Slice)CubePropertiesDialogEx.this.sList.get(n);
            if (n2 == 0) {
                return slice.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class MeasureTableModel
    extends AbstractTableModel {
        private MeasureTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.mList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CubePropertiesDialogEx.Measures");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Measure measure = (Measure)CubePropertiesDialogEx.this.mList.get(n);
            if (n2 == 0) {
                return measure.getName();
            }
            return new Integer(n * n2);
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = CubePropertiesDialogEx.this.dimTable.getSelectedRow();
            if (n < CubePropertiesDialogEx.this.dimList.size() - 1) {
                oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(n);
                CubePropertiesDialogEx.this.moveToIndex(dimension, n + 1);
                CubePropertiesDialogEx.this.dimTable.changeSelection(n + 1, 0, false, false);
                CubePropertiesDialogEx.this.dimTable.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = CubePropertiesDialogEx.this.dimTable.getSelectedRow();
            if (n > 0) {
                oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(n);
                CubePropertiesDialogEx.this.moveToIndex(dimension, n - 1);
                CubePropertiesDialogEx.this.dimTable.changeSelection(n - 1, 0, false, false);
                CubePropertiesDialogEx.this.dimTable.updateUI();
            }
        }
    }

    private class DimensionTableModel
    extends AbstractTableModel {
        String[] names = new String[]{Messages.getString("CubePropertiesDialogEx.Dimension"), Messages.getString("CubePropertiesDialogEx.DefaultOperator"), Messages.getString("CubePropertiesDialogEx.IsSparse")};

        private DimensionTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.dimList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.names[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!CubePropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Class getColumnClass(int n) {
            if (n == 0 || n == 1) {
                return String.class;
            }
            return Boolean.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(n);
            if (n2 == 1) {
                RollupLink rollupLink = (RollupLink)CubePropertiesDialogEx.this.linkMap.get(dimension.getObjectID());
                if (object instanceof String) {
                    rollupLink.setDefaultAggregationOperator((String)object);
                }
            } else if (n2 == 2) {
                RollupLink rollupLink = (RollupLink)CubePropertiesDialogEx.this.linkMap.get(dimension.getObjectID());
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    rollupLink.setSparseDimension(bl);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)CubePropertiesDialogEx.this.dimList.get(n);
            if (n2 == 0) {
                return dimension.getName();
            }
            if (n2 == 1) {
                RollupLink rollupLink = (RollupLink)CubePropertiesDialogEx.this.linkMap.get(dimension.getObjectID());
                return rollupLink.getDefaultAggregationOperator();
            }
            if (n2 == 2) {
                RollupLink rollupLink = (RollupLink)CubePropertiesDialogEx.this.linkMap.get(dimension.getObjectID());
                return new Boolean(rollupLink.isSparseDimension());
            }
            return new Integer(n * n2);
        }
    }

    private class JoinsTableModel
    extends AbstractTableModel {
        private JoinsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return CubePropertiesDialogEx.this.joins.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CubePropertiesDialogEx.JoinName");
            }
            if (n == 1) {
                return Messages.getString("CubePropertiesDialogEx.LeftEntity");
            }
            if (n == 2) {
                return Messages.getString("CubePropertiesDialogEx.RightEntity");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            FactEntitiesJoin factEntitiesJoin = (FactEntitiesJoin)CubePropertiesDialogEx.this.joins.get(n);
            if (n2 == 0) {
                return factEntitiesJoin.getName();
            }
            if (n2 == 1) {
                if (factEntitiesJoin.getLeftEntity() != null) {
                    return factEntitiesJoin.getLeftEntity().getName();
                }
                return "";
            }
            if (n2 == 2) {
                if (factEntitiesJoin.getRightEntity() != null) {
                    return factEntitiesJoin.getRightEntity().getName();
                }
                return "";
            }
            return new Integer(n * n2);
        }
    }

    private class RemoveEntitiesActionListener
    implements ActionListener {
        private RemoveEntitiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CubePropertiesDialogEx.this.selectedEntModel.isEmpty()) {
                Object[] objectArray = CubePropertiesDialogEx.this.selectedEntList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (CubePropertiesDialogEx.this.allEntModel.contains(object)) continue;
                    CubePropertiesDialogEx.this.allEntModel.addElement(object);
                    CubePropertiesDialogEx.this.selectedEntModel.removeElement(object);
                }
            }
        }
    }

    private class AddEntitiesActionListener
    implements ActionListener {
        private AddEntitiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CubePropertiesDialogEx.this.allEntModel.isEmpty()) {
                Object[] objectArray = CubePropertiesDialogEx.this.allEntList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (CubePropertiesDialogEx.this.selectedEntModel.contains(object)) continue;
                    CubePropertiesDialogEx.this.selectedEntModel.addElement(object);
                    CubePropertiesDialogEx.this.allEntModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedEntitiesListSelectionHandler
    implements ListSelectionListener {
        private SelectedEntitiesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (CubePropertiesDialogEx.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (CubePropertiesDialogEx.this.selectedEntList.getSelectedIndex() == -1) {
                    CubePropertiesDialogEx.this.btnRemoveEnt.setEnabled(false);
                } else {
                    CubePropertiesDialogEx.this.btnRemoveEnt.setEnabled(true);
                }
            }
        }
    }

    private class AllEntitiesListSelectionHandler
    implements ListSelectionListener {
        private AllEntitiesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (CubePropertiesDialogEx.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (CubePropertiesDialogEx.this.allEntList.getSelectedIndex() == -1) {
                    CubePropertiesDialogEx.this.btnAddEnt.setEnabled(false);
                } else {
                    CubePropertiesDialogEx.this.btnAddEnt.setEnabled(true);
                }
            }
        }
    }
}

